/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.desktop.steam;

import com.codedisaster.steamworks.SteamNativeHandle;
import com.codedisaster.steamworks.SteamPublishedFileID;
import com.codedisaster.steamworks.SteamRemoteStorage;
import com.codedisaster.steamworks.SteamResult;
import com.codedisaster.steamworks.SteamUGC;
import com.codedisaster.steamworks.SteamUGCCallback;
import com.codedisaster.steamworks.SteamUGCDetails;
import com.codedisaster.steamworks.SteamUGCQuery;
import com.codedisaster.steamworks.SteamUGCUpdateHandle;
import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.function.BiConsumer;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.scene.ui.TextArea;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.Strings;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.desktop.steam.SAchievement;
import io.anuke.mindustry.desktop.steam.SVars;
import io.anuke.mindustry.game.Schematic;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.maps.Map;
import io.anuke.mindustry.mod.Mods;
import io.anuke.mindustry.type.Publishable;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;

public class SWorkshop
implements SteamUGCCallback {
    public final SteamUGC ugc = new SteamUGC(this);
    private ObjectMap<Class<? extends Publishable>, Array<FileHandle>> workshopFiles = new ObjectMap();
    private ObjectMap<SteamUGCQuery, BiConsumer<Array<SteamUGCDetails>, SteamResult>> detailHandlers = new ObjectMap();
    private Array<Consumer<SteamPublishedFileID>> itemHandlers = new Array();
    private ObjectMap<SteamPublishedFileID, Runnable> updatedHandlers = new ObjectMap();

    public SWorkshop() {
        int items = this.ugc.getNumSubscribedItems();
        SteamPublishedFileID[] ids = new SteamPublishedFileID[items];
        SteamUGC.ItemInstallInfo info = new SteamUGC.ItemInstallInfo();
        this.ugc.getSubscribedItems(ids);
        Array<FileHandle> folders = Array.with(ids).map(f -> {
            this.ugc.getItemInstallInfo((SteamPublishedFileID)f, info);
            return new FileHandle(info.getFolder());
        }).select(f -> f != null && f.list().length > 0);
        this.workshopFiles.put(Map.class, folders.select(f -> f.list().length == 1 && f.list()[0].extension().equals("msav")).map(f -> f.list()[0]));
        this.workshopFiles.put(Schematic.class, folders.select(f -> f.list().length == 1 && f.list()[0].extension().equals("msch")).map(f -> f.list()[0]));
        this.workshopFiles.put(Mods.LoadedMod.class, folders.select(f -> f.child("mod.json").exists()));
        if (!this.workshopFiles.get(Map.class).isEmpty()) {
            SAchievement.downloadMapWorkshop.complete();
        }
        this.workshopFiles.each((type, list) -> Log.info("Fetched content ({0}): {1}", type.getSimpleName(), list.size));
    }

    public Array<FileHandle> getWorkshopFiles(Class<? extends Publishable> type) {
        return this.workshopFiles.getOr(type, () -> new Array(0));
    }

    public void publish(Publishable p) {
        Log.info("publish(): " + p.steamTitle());
        if (p.hasSteamID()) {
            Log.info("Content already published, redirecting to ID.");
            this.viewListing(p);
            return;
        }
        if (!p.prePublish()) {
            Log.info("Rejecting due to pre-publish.");
            return;
        }
        this.showPublish(id -> this.update(p, (SteamPublishedFileID)id, null));
    }

    public void updateItem(Publishable p, String changelog) {
        String id = p.getSteamID();
        long handle = Strings.parseLong(id, -1L);
        SteamPublishedFileID fid = new SteamPublishedFileID(handle);
        this.update(p, fid, changelog);
    }

    public void viewListing(final Publishable p) {
        long handle = Strings.parseLong(p.getSteamID(), -1L);
        SteamPublishedFileID id = new SteamPublishedFileID(handle);
        Vars.ui.loadfrag.show();
        this.query(this.ugc.createQueryUGCDetailsRequest(id), (detailsList, result) -> {
            Vars.ui.loadfrag.hide();
            if (result == SteamResult.OK) {
                SteamUGCDetails details = (SteamUGCDetails)detailsList.first();
                if (details.getResult() == SteamResult.OK) {
                    if (details.getOwnerID().equals(SVars.user.user.getSteamID())) {
                        final FloatingDialog dialog = new FloatingDialog("$workshop.info");
                        dialog.setFillParent(false);
                        dialog.cont.add("$workshop.menu").pad(20.0f);
                        dialog.addCloseButton();
                        dialog.buttons.addImageTextButton("$view.workshop", Icon.linkSmall, () -> {
                            this.viewListingID(id);
                            dialog.hide();
                        }).size(210.0f, 64.0f);
                        dialog.buttons.addImageTextButton("$workshop.update", Icon.upgradeSmall, () -> new FloatingDialog("$workshop.update"){
                            {
                                super(x0);
                                this.setFillParent(false);
                                this.cont.margin(10.0f).add("$changelog").padRight(6.0f);
                                this.cont.row();
                                TextArea field = this.cont.addArea("", t -> {}).size(500.0f, 160.0f).get();
                                field.setMaxLength(400);
                                this.buttons.defaults().size(120.0f, 54.0f).pad(4.0f);
                                this.buttons.addButton("$ok", () -> {
                                    Vars.ui.loadfrag.show("$publishing");
                                    SWorkshop.this.updateItem(p, field.getText().replace("\r", "\n"));
                                    dialog.hide();
                                    this.hide();
                                });
                                this.buttons.addButton("$cancel", this::hide);
                            }
                        }.show()).size(210.0f, 64.0f);
                        dialog.show();
                    } else {
                        SVars.net.friends.activateGameOverlayToWebPage("steam://url/CommunityFilePage/" + SteamNativeHandle.getNativeHandle(details.getPublishedFileID()));
                    }
                } else if (details.getResult() == SteamResult.FileNotFound) {
                    p.removeSteamID();
                    Vars.ui.showErrorMessage("$missing");
                } else {
                    Vars.ui.showErrorMessage(Core.bundle.format("workshop.error", details.getResult().name()));
                }
            } else {
                Vars.ui.showErrorMessage(Core.bundle.format("workshop.error", result.name()));
            }
        });
    }

    void viewListingID(SteamPublishedFileID id) {
        SVars.net.friends.activateGameOverlayToWebPage("steam://url/CommunityFilePage/" + SteamNativeHandle.getNativeHandle(id));
    }

    void update(Publishable p, SteamPublishedFileID id, String changelog) {
        Log.info("Calling update({0})", p.steamTitle());
        String sid = SteamNativeHandle.getNativeHandle(id) + "";
        this.updateItem(id, h -> {
            if (p.steamDescription() != null) {
                this.ugc.setItemDescription((SteamUGCUpdateHandle)h, p.steamDescription());
            }
            Array<String> tags = p.extraTags();
            tags.add(p.steamTag());
            this.ugc.setItemTitle((SteamUGCUpdateHandle)h, p.steamTitle());
            this.ugc.setItemTags((SteamUGCUpdateHandle)h, (String[])tags.toArray(String.class));
            this.ugc.setItemPreview((SteamUGCUpdateHandle)h, p.createSteamPreview(sid).absolutePath());
            this.ugc.setItemContent((SteamUGCUpdateHandle)h, p.createSteamFolder(sid).absolutePath());
            if (changelog == null) {
                this.ugc.setItemVisibility((SteamUGCUpdateHandle)h, SteamRemoteStorage.PublishedFileVisibility.Private);
            }
            this.ugc.submitItemUpdate((SteamUGCUpdateHandle)h, changelog == null ? "<Created>" : changelog);
        }, () -> p.addSteamID(sid));
    }

    void showPublish(Consumer<SteamPublishedFileID> published) {
        FloatingDialog dialog = new FloatingDialog("$confirm");
        dialog.setFillParent(false);
        dialog.cont.add("$publish.confirm").width(600.0f).wrap();
        dialog.addCloseButton();
        dialog.buttons.addImageTextButton("$eula", Icon.linkSmall, () -> SVars.net.friends.activateGameOverlayToWebPage("https://steamcommunity.com/sharedfiles/workshoplegalagreement")).size(210.0f, 64.0f);
        dialog.buttons.addImageTextButton("$ok", Icon.checkSmall, () -> {
            Log.info("Accepted, publishing item...");
            this.itemHandlers.add(published);
            this.ugc.createItem(1127400, SteamRemoteStorage.WorkshopFileType.Community);
            Vars.ui.loadfrag.show("$publishing");
            dialog.hide();
        }).size(170.0f, 64.0f);
        dialog.show();
    }

    void query(SteamUGCQuery query, BiConsumer<Array<SteamUGCDetails>, SteamResult> handler) {
        Log.info("POST QUERY " + query);
        this.detailHandlers.put(query, handler);
        this.ugc.sendQueryUGCRequest(query);
    }

    void updateItem(SteamPublishedFileID publishedFileID, Consumer<SteamUGCUpdateHandle> tagger, Runnable updated) {
        try {
            SteamUGCUpdateHandle h = this.ugc.startItemUpdate(1127400, publishedFileID);
            Log.info("begin updateItem({0})", publishedFileID.toString());
            tagger.accept(h);
            Log.info("Tagged.");
            SteamUGC.ItemUpdateInfo info = new SteamUGC.ItemUpdateInfo();
            Vars.ui.loadfrag.setProgress(() -> {
                SteamUGC.ItemUpdateStatus status = this.ugc.getItemUpdateProgress(h, info);
                Vars.ui.loadfrag.setText("$" + status.name().toLowerCase());
                if (status == SteamUGC.ItemUpdateStatus.Invalid) {
                    Vars.ui.loadfrag.setText("$done");
                    return 1.0f;
                }
                return (float)status.ordinal() / (float)SteamUGC.ItemUpdateStatus.values().length;
            });
            this.updatedHandlers.put(publishedFileID, updated);
        }
        catch (Throwable t) {
            Vars.ui.loadfrag.hide();
            Log.err(t);
        }
    }

    @Override
    public void onRequestUGCDetails(SteamUGCDetails details, SteamResult result) {
    }

    @Override
    public void onUGCQueryCompleted(SteamUGCQuery query, int numResultsReturned, int totalMatchingResults, boolean isCachedData, SteamResult result) {
        Log.info("GET QUERY " + query);
        if (this.detailHandlers.containsKey(query)) {
            Log.info("Query being handled...");
            if (numResultsReturned > 0) {
                Log.info("{0} q results", numResultsReturned);
                Array<SteamUGCDetails> details = new Array<SteamUGCDetails>();
                for (int i = 0; i < numResultsReturned; ++i) {
                    details.add(new SteamUGCDetails());
                    this.ugc.getQueryUGCResult(query, i, (SteamUGCDetails)details.get(i));
                }
                this.detailHandlers.get(query).accept(details, result);
            } else {
                Log.info("Nothing found.");
                this.detailHandlers.get(query).accept(new Array(), SteamResult.FileNotFound);
            }
            this.detailHandlers.remove(query);
        } else {
            Log.info("Query not handled.");
        }
    }

    @Override
    public void onSubscribeItem(SteamPublishedFileID publishedFileID, SteamResult result) {
        SteamUGC.ItemInstallInfo info = new SteamUGC.ItemInstallInfo();
        this.ugc.getItemInstallInfo(publishedFileID, info);
        Log.info("Item subscribed from {0}", info.getFolder());
        SAchievement.downloadMapWorkshop.complete();
    }

    @Override
    public void onUnsubscribeItem(SteamPublishedFileID publishedFileID, SteamResult result) {
        SteamUGC.ItemInstallInfo info = new SteamUGC.ItemInstallInfo();
        this.ugc.getItemInstallInfo(publishedFileID, info);
        Log.info("Item unsubscribed from {0}", info.getFolder());
    }

    @Override
    public void onCreateItem(SteamPublishedFileID publishedFileID, boolean needsToAcceptWLA, SteamResult result) {
        Log.info("onCreateItem(" + (Object)((Object)result) + ")");
        if (!this.itemHandlers.isEmpty()) {
            if (result == SteamResult.OK) {
                Log.info("Passing to first handler.");
                this.itemHandlers.first().accept(publishedFileID);
            } else {
                Vars.ui.showErrorMessage(Core.bundle.format("publish.error ", result.name()));
            }
            this.itemHandlers.remove(0);
        } else {
            Log.err("No handlers for createItem()", new Object[0]);
        }
    }

    @Override
    public void onSubmitItemUpdate(SteamPublishedFileID publishedFileID, boolean needsToAcceptWLA, SteamResult result) {
        Vars.ui.loadfrag.hide();
        Log.info("onsubmititemupdate {0} {1} {2}", new Object[]{publishedFileID, needsToAcceptWLA, result});
        if (result == SteamResult.OK) {
            SVars.net.friends.activateGameOverlayToWebPage("steam://url/CommunityFilePage/" + SteamNativeHandle.getNativeHandle(publishedFileID));
            if (needsToAcceptWLA) {
                SVars.net.friends.activateGameOverlayToWebPage("https://steamcommunity.com/sharedfiles/workshoplegalagreement");
            }
            if (this.updatedHandlers.containsKey(publishedFileID)) {
                this.updatedHandlers.get(publishedFileID).run();
            }
        } else {
            Vars.ui.showErrorMessage(Core.bundle.format("publish.error ", result.name()));
        }
    }

    @Override
    public void onDownloadItemResult(int appID, SteamPublishedFileID publishedFileID, SteamResult result) {
        SAchievement.downloadMapWorkshop.complete();
        SteamUGC.ItemInstallInfo info = new SteamUGC.ItemInstallInfo();
        this.ugc.getItemInstallInfo(publishedFileID, info);
        Log.info("Item downloaded to {0}", info.getFolder());
    }

    @Override
    public void onUserFavoriteItemsListChanged(SteamPublishedFileID publishedFileID, boolean wasAddRequest, SteamResult result) {
    }

    @Override
    public void onSetUserItemVote(SteamPublishedFileID publishedFileID, boolean voteUp, SteamResult result) {
    }

    @Override
    public void onGetUserItemVote(SteamPublishedFileID publishedFileID, boolean votedUp, boolean votedDown, boolean voteSkipped, SteamResult result) {
    }

    @Override
    public void onStartPlaytimeTracking(SteamResult result) {
    }

    @Override
    public void onStopPlaytimeTracking(SteamResult result) {
    }

    @Override
    public void onStopPlaytimeTrackingForAllItems(SteamResult result) {
    }

    @Override
    public void onDeleteItem(SteamPublishedFileID publishedFileID, SteamResult result) {
        SteamUGC.ItemInstallInfo info = new SteamUGC.ItemInstallInfo();
        this.ugc.getItemInstallInfo(publishedFileID, info);
        Log.info("Item removed from {0}", info.getFolder());
    }
}

