/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.desktop.steam;

import com.codedisaster.steamworks.SteamID;
import com.codedisaster.steamworks.SteamLeaderboardEntriesHandle;
import com.codedisaster.steamworks.SteamLeaderboardHandle;
import com.codedisaster.steamworks.SteamResult;
import com.codedisaster.steamworks.SteamUserStats;
import com.codedisaster.steamworks.SteamUserStatsCallback;
import io.anuke.arc.ApplicationListener;
import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.ObjectSet;
import io.anuke.arc.function.Predicate;
import io.anuke.arc.util.Interval;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.Timer;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.content.Items;
import io.anuke.mindustry.content.TechTree;
import io.anuke.mindustry.content.UnitTypes;
import io.anuke.mindustry.ctype.UnlockableContent;
import io.anuke.mindustry.desktop.steam.SAchievement;
import io.anuke.mindustry.desktop.steam.SStat;
import io.anuke.mindustry.entities.type.BaseUnit;
import io.anuke.mindustry.entities.units.UnitCommand;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Stats;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemType;
import io.anuke.mindustry.type.Zone;
import io.anuke.mindustry.world.Tile;

public class SStats
implements SteamUserStatsCallback {
    public final SteamUserStats stats = new SteamUserStats(this);
    private boolean updated = false;
    private ObjectSet<String> mechs = new ObjectSet();
    private int statSavePeriod = 4;

    public SStats() {
        this.stats.requestCurrentStats();
        Events.on(EventType.ClientLoadEvent.class, e -> {
            this.mechs = Core.settings.getObject("mechs", ObjectSet.class, ObjectSet::new);
            Core.app.addListener(new ApplicationListener(){
                Interval i = new Interval();

                @Override
                public void update() {
                    if (this.i.get(15.0f)) {
                        SStats.this.checkUpdate();
                    }
                }
            });
            Timer.schedule(() -> {
                if (this.updated) {
                    this.stats.storeStats();
                }
            }, (float)(this.statSavePeriod * 60), (float)(this.statSavePeriod * 60));
        });
    }

    public void onUpdate() {
        this.updated = true;
    }

    private void checkUpdate() {
        if (this.campaign()) {
            SStat.maxUnitActive.max(Vars.unitGroups[Vars.player.getTeam().ordinal()].size());
            if (Vars.unitGroups[Vars.player.getTeam().ordinal()].count(u -> u.getType() == UnitTypes.phantom) >= 10) {
                SAchievement.active10Phantoms.complete();
            }
            if (Vars.unitGroups[Vars.player.getTeam().ordinal()].count(u -> u.getType() == UnitTypes.crawler) >= 50) {
                SAchievement.active50Crawlers.complete();
            }
            for (Tile tile : Vars.state.teams.get((Team)Vars.player.getTeam()).cores) {
                if (Vars.content.items().contains((Item)((Object)((Predicate<Item>)i -> i.type == ItemType.material && tile.entity.items.get((Item)i) < tile.block().itemCapacity)))) continue;
                SAchievement.fillCoreAllCampaign.complete();
                break;
            }
        }
    }

    private void registerEvents() {
        Events.on(EventType.UnitDestroyEvent.class, e -> {
            if (this.ncustom() && e.unit.getTeam() != Vars.player.getTeam()) {
                SStat.unitsDestroyed.add();
                if (e.unit instanceof BaseUnit && ((BaseUnit)e.unit).isBoss()) {
                    SStat.bossesDefeated.add();
                }
            }
        });
        Events.on(EventType.ZoneConfigureCompleteEvent.class, e -> {
            if (!Vars.content.zones().contains((Zone)((Object)((Predicate<Zone>)z -> !z.canConfigure())))) {
                SAchievement.configAllZones.complete();
            }
        });
        Events.on((Object)EventType.Trigger.newGame, () -> Core.app.post(() -> {
            if (this.campaign() && Vars.player.getClosestCore() != null && Vars.player.getClosestCore().items.total() >= 10000) {
                SAchievement.drop10kitems.complete();
            }
        }));
        Events.on(EventType.CommandIssueEvent.class, e -> {
            if (this.campaign() && e.command == UnitCommand.attack) {
                SAchievement.issueAttackCommand.complete();
            }
        });
        Events.on(EventType.BlockBuildEndEvent.class, e -> {
            if (this.campaign() && e.player == Vars.player && !e.breaking) {
                SStat.blocksBuilt.add();
                if (e.tile.block() == Blocks.router && e.tile.entity.proximity().contains((Tile)((Object)((Predicate<Tile>)t -> t.block() == Blocks.router)))) {
                    SAchievement.chainRouters.complete();
                }
                if (e.tile.block() == Blocks.daggerFactory) {
                    SAchievement.buildDaggerFactory.complete();
                }
                if (e.tile.block() == Blocks.meltdown || e.tile.block() == Blocks.spectre) {
                    if (e.tile.block() == Blocks.meltdown && !Core.settings.getBool("meltdownp", false)) {
                        Core.settings.putSave("meltdownp", true);
                    }
                    if (e.tile.block() == Blocks.spectre && !Core.settings.getBool("spectrep", false)) {
                        Core.settings.putSave("spectrep", true);
                    }
                    if (Core.settings.getBool("meltdownp", false) && Core.settings.getBool("spectrep", false)) {
                        SAchievement.buildMeltdownSpectre.complete();
                    }
                }
            }
        });
        Events.on(EventType.BlockDestroyEvent.class, e -> {
            if (this.campaign() && e.tile.getTeam() != Vars.player.getTeam()) {
                SStat.blocksDestroyed.add();
            }
        });
        Events.on(EventType.MapMakeEvent.class, e -> SStat.mapsMade.add());
        Events.on(EventType.MapPublishEvent.class, e -> SStat.mapsPublished.add());
        Events.on(EventType.UnlockEvent.class, e -> {
            if (e.content == Items.thorium) {
                SAchievement.obtainThorium.complete();
            }
            if (e.content == Items.titanium) {
                SAchievement.obtainTitanium.complete();
            }
            if (!Vars.content.zones().contains((Zone)((Object)((Predicate<Zone>)UnlockableContent::locked)))) {
                SAchievement.unlockAllZones.complete();
            }
        });
        Events.on((Object)EventType.Trigger.openWiki, SAchievement.openWiki::complete);
        Events.on((Object)EventType.Trigger.exclusionDeath, SAchievement.dieExclusion::complete);
        Events.on((Object)EventType.Trigger.drown, SAchievement.drown::complete);
        this.trigger(EventType.Trigger.impactPower, SAchievement.powerupImpactReactor);
        this.trigger(EventType.Trigger.flameAmmo, SAchievement.useFlameAmmo);
        this.trigger(EventType.Trigger.turretCool, SAchievement.coolTurret);
        this.trigger(EventType.Trigger.suicideBomb, SAchievement.suicideBomb);
        Events.on((Object)EventType.Trigger.enablePixelation, SAchievement.enablePixelation::complete);
        Events.on((Object)EventType.Trigger.thoriumReactorOverheat, () -> {
            if (this.campaign()) {
                SStat.reactorsOverheated.add();
            }
        });
        this.trigger(EventType.Trigger.shock, SAchievement.shockWetEnemy);
        this.trigger(EventType.Trigger.phaseDeflectHit, SAchievement.killEnemyPhaseWall);
        this.trigger(EventType.Trigger.itemLaunch, SAchievement.launchItemPad);
        Events.on(EventType.UnitCreateEvent.class, e -> {
            if (this.campaign() && e.unit.getTeam() == Vars.player.getTeam()) {
                SStat.unitsBuilt.add();
            }
        });
        Events.on(EventType.LoseEvent.class, e -> {
            if (this.campaign() && Vars.world.getZone().metCondition() && (Vars.state.wave - Vars.world.getZone().conditionWave) / Vars.world.getZone().launchPeriod >= 1) {
                SAchievement.skipLaunching2Death.complete();
            }
        });
        Events.on(EventType.LaunchEvent.class, e -> {
            int total = 0;
            for (Item item : Vars.content.items()) {
                total += Vars.state.stats.itemsDelivered.get(item, 0);
            }
            if (Vars.state.rules.tutorial) {
                SAchievement.completeTutorial.complete();
            }
            SStat.timesLaunched.add();
            SStat.itemsLaunched.add(total);
        });
        Events.on(EventType.WaveEvent.class, e -> {
            if (this.ncustom()) {
                SStat.maxWavesSurvived.max(Vars.state.wave);
                if (Vars.state.stats.buildingsBuilt == 0 && Vars.state.wave >= 10) {
                    SAchievement.survive10WavesNoBlocks.complete();
                }
            }
        });
        Events.on(EventType.PlayerJoin.class, e -> {
            if (Vars.net.server()) {
                SStat.maxPlayersServer.max(Vars.playerGroup.size());
            }
        });
        Events.on(EventType.ResearchEvent.class, e -> {
            if (e.content == Blocks.router) {
                SAchievement.researchRouter.complete();
            }
            if (!TechTree.all.contains((TechTree.TechNode)((Object)((Predicate<TechTree.TechNode>)t -> t.block.locked())))) {
                SAchievement.researchAll.complete();
            }
        });
        Events.on(EventType.WinEvent.class, e -> {
            if (this.campaign()) {
                if (Vars.state.wave <= 5 && Vars.state.rules.attackMode) {
                    SAchievement.defeatAttack5Waves.complete();
                }
                if (Vars.state.rules.attackMode) {
                    SStat.attacksWon.add();
                }
                Stats.RankResult result = Vars.state.stats.calculateRank(Vars.world.getZone(), Vars.state.launched);
                if (result.rank == Stats.Rank.S) {
                    SAchievement.earnSRank.complete();
                }
                if (result.rank == Stats.Rank.SS) {
                    SAchievement.earnSSRank.complete();
                }
            }
            if (Vars.state.rules.pvp) {
                SStat.pvpsWon.add();
            }
        });
        Events.on(EventType.MechChangeEvent.class, e -> {
            if (this.campaign() && this.mechs.add(e.mech.name)) {
                SStat.zoneMechsUsed.max(this.mechs.size);
                Core.settings.putObject("mechs", this.mechs);
                Core.settings.save();
            }
        });
    }

    private void trigger(EventType.Trigger trigger, SAchievement ach) {
        Events.on((Object)trigger, () -> {
            if (this.campaign()) {
                ach.complete();
            }
        });
    }

    private boolean ncustom() {
        return this.campaign();
    }

    private boolean campaign() {
        return Vars.world.isZone();
    }

    @Override
    public void onUserStatsReceived(long gameID, SteamID steamID, SteamResult result) {
        this.registerEvents();
        if (result != SteamResult.OK) {
            Log.err("Failed to recieve steam stats: {0}", new Object[]{result});
        } else {
            Log.err("Recieved steam stats.", new Object[0]);
        }
    }

    @Override
    public void onUserStatsStored(long gameID, SteamResult result) {
        Log.info("Stored stats: {0}", new Object[]{result});
        if (result == SteamResult.OK) {
            this.updated = true;
        }
    }

    @Override
    public void onUserStatsUnloaded(SteamID steamID) {
    }

    @Override
    public void onUserAchievementStored(long l, boolean b, String s, int i, int i1) {
    }

    @Override
    public void onLeaderboardFindResult(SteamLeaderboardHandle steamLeaderboardHandle, boolean b) {
    }

    @Override
    public void onLeaderboardScoresDownloaded(SteamLeaderboardHandle steamLeaderboardHandle, SteamLeaderboardEntriesHandle steamLeaderboardEntriesHandle, int i) {
    }

    @Override
    public void onLeaderboardScoreUploaded(boolean b, SteamLeaderboardHandle steamLeaderboardHandle, int i, boolean b1, int i1, int i2) {
    }

    @Override
    public void onGlobalStatsReceived(long l, SteamResult steamResult) {
    }
}

