/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.desktop;

import club.minnced.discord.rpc.DiscordEventHandlers;
import club.minnced.discord.rpc.DiscordRPC;
import club.minnced.discord.rpc.DiscordRichPresence;
import com.codedisaster.steamworks.SteamAPI;
import io.anuke.arc.ApplicationListener;
import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.Files;
import io.anuke.arc.backends.sdl.SdlApplication;
import io.anuke.arc.backends.sdl.SdlConfig;
import io.anuke.arc.backends.sdl.jni.SDL;
import io.anuke.arc.collection.Array;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.math.RandomXS128;
import io.anuke.arc.scene.event.Touchable;
import io.anuke.arc.scene.ui.Label;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.OS;
import io.anuke.arc.util.Strings;
import io.anuke.arc.util.io.Streams;
import io.anuke.arc.util.serialization.Base64Coder;
import io.anuke.mindustry.ClientLauncher;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.core.Version;
import io.anuke.mindustry.desktop.steam.SNet;
import io.anuke.mindustry.desktop.steam.SStats;
import io.anuke.mindustry.desktop.steam.SUser;
import io.anuke.mindustry.desktop.steam.SVars;
import io.anuke.mindustry.desktop.steam.SWorkshop;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.mod.Mods;
import io.anuke.mindustry.net.ArcNetImpl;
import io.anuke.mindustry.net.CrashSender;
import io.anuke.mindustry.net.Net;
import io.anuke.mindustry.type.Publishable;
import io.anuke.mindustry.ui.Styles;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.NetworkInterface;
import java.nio.charset.Charset;
import java.util.Enumeration;

public class DesktopLauncher
extends ClientLauncher {
    public static final String discordID = "610508934456934412";
    boolean useDiscord = OS.is64Bit;
    boolean showConsole = OS.getPropertyNotNull("user.name").equals("anuke");

    public static void main(String[] arg) {
        try {
            new SdlApplication(new DesktopLauncher(arg), new SdlConfig(){
                {
                    this.title = "Mindustry";
                    this.maximized = true;
                    this.depth = 0;
                    this.stencil = 0;
                    this.width = 900;
                    this.height = 700;
                    this.setWindowIcon(Files.FileType.Internal, "icons/icon_64.png");
                }
            });
        }
        catch (Throwable e) {
            DesktopLauncher.handleCrash(e);
        }
    }

    public DesktopLauncher(String[] args) {
        Log.setUseColors(false);
        Version.init();
        boolean useSteam = Version.modifier.contains("steam");
        Vars.testMobile = Array.with(args).contains("-testMobile");
        if (this.useDiscord) {
            try {
                DiscordEventHandlers handlers = new DiscordEventHandlers();
                DiscordRPC.INSTANCE.Discord_Initialize(discordID, handlers, true, "1127400");
                Log.info("Initialized Discord rich presence.");
                Runtime.getRuntime().addShutdownHook(new Thread(DiscordRPC.INSTANCE::Discord_Shutdown));
            }
            catch (Throwable t) {
                this.useDiscord = false;
                Log.err("Failed to initialize discord.", t);
            }
        }
        if (useSteam) {
            FileHandle file = new FileHandle(".");
            for (FileHandle other : file.parent().list()) {
                if (!other.name().contains("steam") || !other.extension().equals("dll") && !other.extension().equals("so") && !other.extension().equals("dylib")) continue;
                other.delete();
            }
            if (this.showConsole) {
                final StringBuilder base = new StringBuilder();
                Log.setLogger(new Log.LogHandler(){

                    @Override
                    public void print(String text, Object ... args) {
                        String out = Log.format(text, false, args);
                        base.append(out).append("\n");
                    }
                });
                Events.on(EventType.ClientLoadEvent.class, event -> {
                    final Label[] label = new Label[]{null};
                    boolean[] visible = new boolean[]{false};
                    Core.scene.table(t -> {
                        t.touchable(Touchable.disabled);
                        t.top().left();
                        t.update(() -> {
                            if (Core.input.keyTap(KeyCode.BACKTICK)) {
                                visible[0] = !visible[0];
                            }
                            t.toFront();
                        });
                        t.table(Styles.black3, f -> {
                            label[0] = f.add("").get();
                        }).visible(() -> visible[0]);
                        label[0].getText().append((CharSequence)base);
                    });
                    Log.setLogger(new Log.LogHandler(){

                        @Override
                        public void print(String text, Object ... args) {
                            super.print(text, args);
                            String out = Log.format(text, false, args);
                            int maxlen = 2048;
                            if (label[0].getText().length() > maxlen) {
                                label[0].setText(label[0].getText().substring(label[0].getText().length() - maxlen));
                            }
                            label[0].getText().append(out).append("\n");
                            label[0].invalidateHierarchy();
                        }
                    });
                });
            }
            try {
                try {
                    SteamAPI.loadLibraries();
                }
                catch (Throwable t) {
                    this.logSteamError(t);
                    this.fallbackSteam();
                }
                if (!SteamAPI.init()) {
                    Log.err("Steam client not running.", new Object[0]);
                } else {
                    this.initSteam(args);
                    Vars.steam = true;
                }
            }
            catch (Throwable e) {
                Vars.steam = false;
                Log.err("Failed to load Steam native libraries.", new Object[0]);
                this.logSteamError(e);
            }
        }
    }

    void logSteamError(Throwable e) {
        Log.err(e);
        try (FileOutputStream s = new FileOutputStream(new File("steam-error-log-" + System.nanoTime() + ".txt"));){
            String log = Strings.parseException(e, true);
            ((OutputStream)s).write(log.getBytes());
        }
        catch (Exception e2) {
            Log.err(e2);
        }
    }

    void fallbackSteam() {
        try {
            String name = "steam_api";
            if (OS.isMac || OS.isLinux) {
                name = "lib" + name;
            }
            if (OS.isWindows && OS.is64Bit) {
                name = name + "64";
            }
            name = name + (OS.isLinux ? ".so" : (OS.isMac ? ".dylib" : ".dll"));
            Streams.copyStream(this.getClass().getResourceAsStream(name), new FileOutputStream(name));
            System.loadLibrary(new File(name).getAbsolutePath());
        }
        catch (Throwable e) {
            this.logSteamError(e);
        }
    }

    void initSteam(String[] args) {
        SVars.net = new SNet(new ArcNetImpl());
        SVars.stats = new SStats();
        SVars.workshop = new SWorkshop();
        SVars.user = new SUser();
        boolean[] isShutdown = new boolean[]{false};
        Events.on(EventType.ClientLoadEvent.class, event -> {
            Vars.player.name = SVars.net.friends.getPersonaName();
            Core.settings.defaults("name", SVars.net.friends.getPersonaName());
            Core.settings.put("name", Vars.player.name);
            Core.settings.save();
            Core.app.addListener(new ApplicationListener(){

                @Override
                public void update() {
                    if (SteamAPI.isSteamRunning()) {
                        SteamAPI.runCallbacks();
                    }
                }
            });
            Core.app.post(() -> {
                if (args.length >= 2 && args[0].equals("+connect_lobby")) {
                    try {
                        long id = Long.parseLong(args[1]);
                        Vars.ui.join.connect("steam:" + id, 6567);
                    }
                    catch (Exception e) {
                        Log.err("Failed to parse steam lobby ID: {0}", e.getMessage());
                        e.printStackTrace();
                    }
                }
            });
        });
        Events.on(EventType.DisposeEvent.class, event -> {
            SteamAPI.shutdown();
            isShutdown[0] = true;
        });
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (!isShutdown[0]) {
                SteamAPI.shutdown();
            }
        }));
    }

    static void handleCrash(Throwable e) {
        Consumer<Runnable> dialog = Runnable::run;
        boolean badGPU = false;
        if (e.getMessage() != null && (e.getMessage().contains("Couldn't create window") || e.getMessage().contains("OpenGL 2.0 or higher"))) {
            dialog.accept(() -> DesktopLauncher.message(e.getMessage().contains("Couldn't create window") ? "A graphics initialization error has occured! Try to update your graphics drivers:\n" + e.getMessage() : "Your graphics card does not support OpenGL 2.0!\nTry to update your graphics drivers.\n\n(If that doesn't work, your computer just doesn't support Mindustry.)"));
            badGPU = true;
        }
        boolean fbgp = badGPU;
        CrashSender.send(e, file -> {
            Array<Throwable> causes = Strings.getCauses(e);
            Throwable fc = causes.find(t -> t instanceof Mods.ModLoadException);
            if (fc == null) {
                fc = Strings.getFinalCause(e);
            }
            Throwable cause = fc;
            if (!fbgp) {
                dialog.accept(() -> DesktopLauncher.message("A crash has occured. It has been saved in:\n" + file.getAbsolutePath() + "\n" + cause.getClass().getSimpleName().replace("Exception", "") + (cause.getMessage() == null ? "" : ":\n" + cause.getMessage())));
            }
        });
    }

    @Override
    public Array<FileHandle> getWorkshopContent(Class<? extends Publishable> type) {
        return !Vars.steam ? super.getWorkshopContent(type) : SVars.workshop.getWorkshopFiles(type);
    }

    @Override
    public void viewListing(Publishable pub) {
        SVars.workshop.viewListing(pub);
    }

    @Override
    public void viewListingID(String id) {
        SVars.net.friends.activateGameOverlayToWebPage("steam://url/CommunityFilePage/" + id);
    }

    @Override
    public Net.NetProvider getNet() {
        return Vars.steam ? SVars.net : new ArcNetImpl();
    }

    @Override
    public void openWorkshop() {
        SVars.net.friends.activateGameOverlayToWebPage("https://steamcommunity.com/app/1127400/workshop/");
    }

    @Override
    public void publish(Publishable pub) {
        SVars.workshop.publish(pub);
    }

    @Override
    public void inviteFriends() {
        SVars.net.showFriendInvites();
    }

    @Override
    public void updateLobby() {
        SVars.net.updateLobby();
    }

    @Override
    public void updateRPC() {
        if (!this.useDiscord) {
            return;
        }
        DiscordRichPresence presence = new DiscordRichPresence();
        if (!Vars.state.is(GameState.State.menu)) {
            String map;
            String string = Vars.world.getMap() == null ? "Unknown Map" : (map = Vars.world.isZone() ? Vars.world.getZone().localizedName : Strings.capitalize(Vars.world.getMap().name()));
            String mode = Vars.state.rules.pvp ? "PvP" : (Vars.state.rules.attackMode ? "Attack" : "Survival");
            String players = Vars.net.active() && Vars.playerGroup.size() > 1 ? " | " + Vars.playerGroup.size() + " Players" : "";
            presence.state = mode + players;
            if (!Vars.state.rules.waves) {
                presence.details = map;
            } else {
                presence.details = map + " | Wave " + Vars.state.wave;
                presence.largeImageText = "Wave " + Vars.state.wave;
            }
        } else {
            presence.state = Vars.ui.editor != null && Vars.ui.editor.isShown() ? "In Editor" : (Vars.ui.deploy != null && Vars.ui.deploy.isShown() ? "In Launch Selection" : "In Menu");
        }
        presence.largeImageKey = "logo";
        DiscordRPC.INSTANCE.Discord_UpdatePresence(presence);
    }

    @Override
    public String getUUID() {
        if (Vars.steam) {
            try {
                byte[] result = new byte[8];
                new RandomXS128(SVars.user.user.getSteamID().getAccountID()).nextBytes(result);
                return new String(Base64Coder.encode(result));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            NetworkInterface out = e.nextElement();
            while ((out.getHardwareAddress() == null || !this.validAddress(out.getHardwareAddress())) && e.hasMoreElements()) {
                out = e.nextElement();
            }
            byte[] bytes = out.getHardwareAddress();
            byte[] result = new byte[8];
            System.arraycopy(bytes, 0, result, 0, bytes.length);
            String str = new String(Base64Coder.encode(result));
            if (str.equals("AAAAAAAAAOA=") || str.equals("AAAAAAAAAAA=")) {
                throw new RuntimeException("Bad UUID.");
            }
            return str;
        }
        catch (Exception e) {
            return super.getUUID();
        }
    }

    private static void message(String message) {
        SDL.SDL_ShowSimpleMessageBox(16, "oh no", message);
    }

    private boolean validAddress(byte[] bytes) {
        if (bytes == null) {
            return false;
        }
        byte[] result = new byte[8];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        return !new String(Base64Coder.encode(result)).equals("AAAAAAAAAOA=") && !new String(Base64Coder.encode(result)).equals("AAAAAAAAAAA=");
    }

    static {
        if (!Charset.forName("US-ASCII").newEncoder().canEncode(System.getProperty("user.name", ""))) {
            System.setProperty("com.codedisaster.steamworks.SharedLibraryExtractPath", new File("").getAbsolutePath());
        }
    }
}

