/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.core;

import io.anuke.arc.ApplicationListener;
import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.Graphics;
import io.anuke.arc.Input;
import io.anuke.arc.assets.AssetDescriptor;
import io.anuke.arc.assets.AssetManager;
import io.anuke.arc.assets.Loadable;
import io.anuke.arc.assets.loaders.resolvers.InternalFileHandleResolver;
import io.anuke.arc.collection.Array;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.freetype.FreeTypeFontGenerator;
import io.anuke.arc.freetype.FreeTypeFontGeneratorLoader;
import io.anuke.arc.freetype.FreetypeFontLoader;
import io.anuke.arc.function.BooleanProvider;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Colors;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.g2d.BitmapFont;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.math.Interpolation;
import io.anuke.arc.scene.Action;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.Group;
import io.anuke.arc.scene.Scene;
import io.anuke.arc.scene.actions.Actions;
import io.anuke.arc.scene.event.ClickListener;
import io.anuke.arc.scene.event.Touchable;
import io.anuke.arc.scene.ui.Dialog;
import io.anuke.arc.scene.ui.TextField;
import io.anuke.arc.scene.ui.Tooltip;
import io.anuke.arc.scene.ui.layout.Collapser;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.scene.ui.layout.WidgetGroup;
import io.anuke.arc.util.Strings;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.core.Control;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.editor.MapEditorDialog;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.ui.Fonts;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.ui.dialogs.AboutDialog;
import io.anuke.mindustry.ui.dialogs.AdminsDialog;
import io.anuke.mindustry.ui.dialogs.BansDialog;
import io.anuke.mindustry.ui.dialogs.ContentInfoDialog;
import io.anuke.mindustry.ui.dialogs.ControlsDialog;
import io.anuke.mindustry.ui.dialogs.CustomGameDialog;
import io.anuke.mindustry.ui.dialogs.DatabaseDialog;
import io.anuke.mindustry.ui.dialogs.DeployDialog;
import io.anuke.mindustry.ui.dialogs.DiscordDialog;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;
import io.anuke.mindustry.ui.dialogs.GameOverDialog;
import io.anuke.mindustry.ui.dialogs.HostDialog;
import io.anuke.mindustry.ui.dialogs.JoinDialog;
import io.anuke.mindustry.ui.dialogs.LanguageDialog;
import io.anuke.mindustry.ui.dialogs.LoadDialog;
import io.anuke.mindustry.ui.dialogs.MapsDialog;
import io.anuke.mindustry.ui.dialogs.MinimapDialog;
import io.anuke.mindustry.ui.dialogs.ModsDialog;
import io.anuke.mindustry.ui.dialogs.PausedDialog;
import io.anuke.mindustry.ui.dialogs.SchematicsDialog;
import io.anuke.mindustry.ui.dialogs.SettingsMenuDialog;
import io.anuke.mindustry.ui.dialogs.TechTreeDialog;
import io.anuke.mindustry.ui.dialogs.TraceDialog;
import io.anuke.mindustry.ui.fragments.ChatFragment;
import io.anuke.mindustry.ui.fragments.FadeInFragment;
import io.anuke.mindustry.ui.fragments.HudFragment;
import io.anuke.mindustry.ui.fragments.LoadingFragment;
import io.anuke.mindustry.ui.fragments.MenuFragment;
import io.anuke.mindustry.ui.fragments.PlayerListFragment;

public class UI
implements ApplicationListener,
Loadable {
    public MenuFragment menufrag;
    public HudFragment hudfrag;
    public ChatFragment chatfrag;
    public PlayerListFragment listfrag;
    public LoadingFragment loadfrag;
    public WidgetGroup menuGroup;
    public WidgetGroup hudGroup;
    public AboutDialog about;
    public GameOverDialog restart;
    public CustomGameDialog custom;
    public MapsDialog maps;
    public LoadDialog load;
    public DiscordDialog discord;
    public JoinDialog join;
    public HostDialog host;
    public PausedDialog paused;
    public SettingsMenuDialog settings;
    public ControlsDialog controls;
    public MapEditorDialog editor;
    public LanguageDialog language;
    public BansDialog bans;
    public AdminsDialog admins;
    public TraceDialog traces;
    public DatabaseDialog database;
    public ContentInfoDialog content;
    public DeployDialog deploy;
    public TechTreeDialog tech;
    public MinimapDialog minimap;
    public SchematicsDialog schematics;
    public ModsDialog mods;
    public Graphics.Cursor drillCursor;
    public Graphics.Cursor unloadCursor;

    public UI() {
        this.setupFonts();
    }

    @Override
    public void loadAsync() {
    }

    @Override
    public void loadSync() {
        Fonts.outline.getData().markupEnabled = true;
        Fonts.def.getData().markupEnabled = true;
        Fonts.def.setOwnsTexture(false);
        Core.assets.getAll(BitmapFont.class, new Array()).each(font -> font.setUseIntegerPositions(true));
        Core.scene = new Scene();
        Core.input.addProcessor(Core.scene);
        Tex.load();
        Icon.load();
        Styles.load();
        Tex.loadStyles();
        Dialog.setShowAction(() -> Actions.sequence((Action)Actions.alpha(0.0f), (Action)Actions.fadeIn(0.1f)));
        Dialog.setHideAction(() -> Actions.sequence((Action)Actions.fadeOut(0.1f)));
        Tooltip.Tooltips.getInstance().animations = false;
        Core.settings.setErrorHandler(e -> {
            e.printStackTrace();
            Core.app.post(() -> this.showErrorMessage("Failed to access local storage.\nSettings will not be saved."));
        });
        ClickListener.clicked = () -> Sounds.press.play();
        Colors.put("accent", Pal.accent);
        Colors.put("unlaunched", Color.valueOf("8982ed"));
        Colors.put("highlight", Pal.accent.cpy().lerp(Color.white, 0.3f));
        Colors.put("stat", Pal.stat);
        this.loadExtraCursors();
    }

    @Override
    public Array<AssetDescriptor> getDependencies() {
        return Array.with(new AssetDescriptor<Control>(Control.class), new AssetDescriptor<BitmapFont>("outline", BitmapFont.class), new AssetDescriptor<BitmapFont>("default", BitmapFont.class), new AssetDescriptor<BitmapFont>("chat", BitmapFont.class));
    }

    public static void loadSystemCursors() {
        Graphics.Cursor.SystemCursor.arrow.set(Core.graphics.newCursor("cursor"));
        Graphics.Cursor.SystemCursor.hand.set(Core.graphics.newCursor("hand"));
        Graphics.Cursor.SystemCursor.ibeam.set(Core.graphics.newCursor("ibeam"));
        Core.graphics.restoreCursor();
    }

    public static void loadDefaultFont() {
        InternalFileHandleResolver resolver = new InternalFileHandleResolver();
        Core.assets.setLoader(FreeTypeFontGenerator.class, new FreeTypeFontGeneratorLoader(resolver));
        Core.assets.setLoader(BitmapFont.class, null, new FreetypeFontLoader(resolver){

            @Override
            public BitmapFont loadSync(AssetManager manager, String fileName, FileHandle file, FreetypeFontLoader.FreeTypeFontLoaderParameter parameter) {
                if (fileName.equals("outline")) {
                    parameter.fontParameters.borderWidth = Scl.scl(2.0f);
                    parameter.fontParameters.spaceX = (int)((float)parameter.fontParameters.spaceX - parameter.fontParameters.borderWidth);
                }
                parameter.fontParameters.magFilter = Texture.TextureFilter.Linear;
                parameter.fontParameters.minFilter = Texture.TextureFilter.Linear;
                parameter.fontParameters.size = UI.fontParameter().size;
                return super.loadSync(manager, fileName, file, parameter);
            }
        });
        FreeTypeFontGenerator.FreeTypeFontParameter param = new FreeTypeFontGenerator.FreeTypeFontParameter(){
            {
                this.borderColor = Color.darkGray;
                this.incremental = true;
            }
        };
        Core.assets.load((String)"outline", BitmapFont.class, new FreetypeFontLoader.FreeTypeFontLoaderParameter((String)"fonts/font.ttf", (FreeTypeFontGenerator.FreeTypeFontParameter)param)).loaded = t -> {
            Fonts.outline = (BitmapFont)t;
        };
    }

    void loadExtraCursors() {
        this.drillCursor = Core.graphics.newCursor("drill");
        this.unloadCursor = Core.graphics.newCursor("unload");
    }

    public void setupFonts() {
        String fontName = "fonts/font.ttf";
        FreeTypeFontGenerator.FreeTypeFontParameter param = UI.fontParameter();
        Core.assets.load((String)"default", BitmapFont.class, new FreetypeFontLoader.FreeTypeFontLoaderParameter((String)fontName, (FreeTypeFontGenerator.FreeTypeFontParameter)param)).loaded = f -> {
            Fonts.def = (BitmapFont)f;
        };
        Core.assets.load((String)"chat", BitmapFont.class, new FreetypeFontLoader.FreeTypeFontLoaderParameter((String)fontName, (FreeTypeFontGenerator.FreeTypeFontParameter)param)).loaded = f -> {
            Fonts.chat = (BitmapFont)f;
        };
    }

    static FreeTypeFontGenerator.FreeTypeFontParameter fontParameter() {
        return new FreeTypeFontGenerator.FreeTypeFontParameter(){
            {
                this.size = (int)Scl.scl(18.0f);
                this.shadowColor = Color.darkGray;
                this.shadowOffsetY = 2;
                this.incremental = true;
            }
        };
    }

    @Override
    public void update() {
        Element e;
        if (Vars.disableUI || Core.scene == null) {
            return;
        }
        Core.scene.act();
        Core.scene.draw();
        if (Core.input.keyTap(KeyCode.MOUSE_LEFT) && Core.scene.getKeyboardFocus() instanceof TextField && !((e = Core.scene.hit(Core.input.mouseX(), Core.input.mouseY(), true)) instanceof TextField)) {
            Core.scene.setKeyboardFocus(null);
        }
        if (Vars.state.rules.tutorial) {
            Vars.control.tutorial.draw();
            Draw.flush();
        }
    }

    @Override
    public void init() {
        this.menuGroup = new WidgetGroup();
        this.hudGroup = new WidgetGroup();
        this.menufrag = new MenuFragment();
        this.hudfrag = new HudFragment();
        this.chatfrag = new ChatFragment();
        this.listfrag = new PlayerListFragment();
        this.loadfrag = new LoadingFragment();
        this.editor = new MapEditorDialog();
        this.controls = new ControlsDialog();
        this.restart = new GameOverDialog();
        this.join = new JoinDialog();
        this.discord = new DiscordDialog();
        this.load = new LoadDialog();
        this.custom = new CustomGameDialog();
        this.language = new LanguageDialog();
        this.database = new DatabaseDialog();
        this.settings = new SettingsMenuDialog();
        this.host = new HostDialog();
        this.paused = new PausedDialog();
        this.about = new AboutDialog();
        this.bans = new BansDialog();
        this.admins = new AdminsDialog();
        this.traces = new TraceDialog();
        this.maps = new MapsDialog();
        this.content = new ContentInfoDialog();
        this.deploy = new DeployDialog();
        this.tech = new TechTreeDialog();
        this.minimap = new MinimapDialog();
        this.mods = new ModsDialog();
        this.schematics = new SchematicsDialog();
        Group group = Core.scene.root;
        this.menuGroup.setFillParent(true);
        this.menuGroup.touchable(Touchable.childrenOnly);
        this.menuGroup.visible(() -> Vars.state.is(GameState.State.menu));
        this.hudGroup.setFillParent(true);
        this.hudGroup.touchable(Touchable.childrenOnly);
        this.hudGroup.visible(() -> !Vars.state.is(GameState.State.menu));
        Core.scene.add(this.menuGroup);
        Core.scene.add(this.hudGroup);
        this.hudfrag.build(this.hudGroup);
        this.menufrag.build(this.menuGroup);
        this.chatfrag.container().build(this.hudGroup);
        this.listfrag.build(this.hudGroup);
        this.loadfrag.build(group);
        new FadeInFragment().build(group);
    }

    @Override
    public void resize(int width, int height) {
        if (Core.scene == null) {
            return;
        }
        Core.scene.resize(width, height);
        Events.fire(new EventType.ResizeEvent());
    }

    @Override
    public void dispose() {
    }

    public void loadAnd(Runnable call) {
        this.loadAnd("$loading", call);
    }

    public void loadAnd(String text, Runnable call) {
        this.loadfrag.show(text);
        Time.runTask(7.0f, () -> {
            call.run();
            this.loadfrag.hide();
        });
    }

    public void showTextInput(final String titleText, final String dtext, final int textLength, final String def, final boolean inumeric, final Consumer<String> confirmed) {
        if (Vars.mobile) {
            Core.input.getTextInput(new Input.TextInput(){
                {
                    this.title = titleText.startsWith("$") ? Core.bundle.get(titleText.substring(1)) : titleText;
                    this.text = def;
                    this.numeric = inumeric;
                    this.maxLength = textLength;
                    this.accepted = confirmed;
                }
            });
        } else {
            new Dialog(titleText){
                {
                    super(x0);
                    this.cont.margin(30.0f).add(dtext).padRight(6.0f);
                    TextField.TextFieldFilter filter = inumeric ? TextField.TextFieldFilter.digitsOnly : (f, c) -> true;
                    TextField field = this.cont.addField(def, t -> {}).size(330.0f, 50.0f).get();
                    field.setFilter((f, c) -> field.getText().length() < textLength && filter.acceptChar(f, c));
                    this.buttons.defaults().size(120.0f, 54.0f).pad(4.0f);
                    this.buttons.addButton("$ok", () -> {
                        confirmed.accept(field.getText());
                        this.hide();
                    }).disabled(b -> field.getText().isEmpty());
                    this.buttons.addButton("$cancel", this::hide);
                }
            }.show();
        }
    }

    public void showTextInput(String title, String text, String def, Consumer<String> confirmed) {
        this.showTextInput(title, text, 32, def, confirmed);
    }

    public void showTextInput(String titleText, String text, int textLength, String def, Consumer<String> confirmed) {
        this.showTextInput(titleText, text, textLength, def, false, confirmed);
    }

    public void showInfoFade(String info) {
        Table table = new Table();
        table.setFillParent(true);
        table.actions(Actions.fadeOut(7.0f, Interpolation.fade), Actions.remove());
        table.top().add(info).style(Styles.outlineLabel).padTop(10.0f);
        Core.scene.add(table);
    }

    public void showInfo(final String info) {
        new Dialog(""){
            {
                super(x0);
                this.getCell(this.cont).growX();
                this.cont.margin(15.0f).add(info).width(400.0f).wrap().get().setAlignment(1, 1);
                this.buttons.addButton("$ok", this::hide).size(90.0f, 50.0f).pad(4.0f);
            }
        }.show();
    }

    public void showErrorMessage(final String text) {
        new Dialog(""){
            {
                super(x0);
                this.setFillParent(true);
                this.cont.margin(15.0f);
                this.cont.add("$error.title");
                this.cont.row();
                this.cont.addImage().width(300.0f).pad(2.0f).height(4.0f).color(Color.scarlet);
                this.cont.row();
                this.cont.add(text).pad(2.0f).growX().wrap().get().setAlignment(1);
                this.cont.row();
                this.cont.addButton("$ok", this::hide).size(120.0f, 50.0f).pad(4.0f);
            }
        }.show();
    }

    public void showException(Throwable t) {
        this.showException("", t);
    }

    public void showException(final String text, final Throwable exc) {
        this.loadfrag.hide();
        new Dialog(""){
            {
                super(x0);
                String message = Strings.getFinalMesage(exc);
                this.setFillParent(true);
                this.cont.margin(15.0f);
                this.cont.add("$error.title").colspan(2);
                this.cont.row();
                this.cont.addImage().width(300.0f).pad(2.0f).colspan(2).height(4.0f).color(Color.scarlet);
                this.cont.row();
                this.cont.add((text.startsWith("$") ? Core.bundle.get(text.substring(1)) : text) + (message == null ? "" : "\n[lightgray](" + message + ")")).colspan(2).wrap().growX().center().get().setAlignment(1);
                this.cont.row();
                Collapser col = new Collapser(base -> base.pane((Table t) -> t.margin(14.0f).add(Strings.parseException(exc, true)).color(Color.lightGray).left()), true);
                this.cont.addButton("$details", Styles.togglet, col::toggle).size(180.0f, 50.0f).checked(b -> !col.isCollapsed()).fillX().right();
                this.cont.addButton("$ok", this::hide).size(100.0f, 50.0f).fillX().left();
                this.cont.row();
                this.cont.add(col).colspan(2).pad(2.0f);
            }
        }.show();
    }

    public void showText(String titleText, String text) {
        this.showText(titleText, text, 1);
    }

    public void showText(String titleText, final String text, final int align) {
        new Dialog(titleText){
            {
                super(x0);
                this.cont.row();
                this.cont.addImage().width(400.0f).pad(2.0f).colspan(2).height(4.0f).color(Pal.accent);
                this.cont.row();
                this.cont.add(text).width(400.0f).wrap().get().setAlignment(align, align);
                this.cont.row();
                this.buttons.addButton("$ok", this::hide).size(90.0f, 50.0f).pad(4.0f);
            }
        }.show();
    }

    public void showInfoText(String titleText, final String text) {
        new Dialog(titleText){
            {
                super(x0);
                this.cont.margin(15.0f).add(text).width(400.0f).wrap().left().get().setAlignment(8, 8);
                this.buttons.addButton("$ok", this::hide).size(90.0f, 50.0f).pad(4.0f);
            }
        }.show();
    }

    public void showSmall(String titleText, final String text) {
        new Dialog(titleText){
            {
                super(x0);
                this.cont.margin(10.0f).add(text);
                this.titleTable.row();
                this.titleTable.addImage().color(Pal.accent).height(3.0f).growX().pad(2.0f);
                this.buttons.addButton("$ok", this::hide).size(90.0f, 50.0f).pad(4.0f);
            }
        }.show();
    }

    public void showConfirm(String title, String text, Runnable confirmed) {
        this.showConfirm(title, text, null, confirmed);
    }

    public void showConfirm(String title, String text, BooleanProvider hide, Runnable confirmed) {
        FloatingDialog dialog = new FloatingDialog(title);
        dialog.cont.add(text).width(Vars.mobile ? 400.0f : 500.0f).wrap().pad(4.0f).get().setAlignment(1, 1);
        dialog.buttons.defaults().size(200.0f, 54.0f).pad(2.0f);
        dialog.setFillParent(false);
        dialog.buttons.addButton("$cancel", dialog::hide);
        dialog.buttons.addButton("$ok", () -> {
            dialog.hide();
            confirmed.run();
        });
        if (hide != null) {
            dialog.update(() -> {
                if (hide.get()) {
                    dialog.hide();
                }
            });
        }
        dialog.keyDown(KeyCode.ESCAPE, dialog::hide);
        dialog.keyDown(KeyCode.BACK, dialog::hide);
        dialog.show();
    }

    public void showCustomConfirm(String title, String text, String yes, String no, Runnable confirmed) {
        FloatingDialog dialog = new FloatingDialog(title);
        dialog.cont.add(text).width(Vars.mobile ? 400.0f : 500.0f).wrap().pad(4.0f).get().setAlignment(1, 1);
        dialog.buttons.defaults().size(200.0f, 54.0f).pad(2.0f);
        dialog.setFillParent(false);
        dialog.buttons.addButton(no, dialog::hide);
        dialog.buttons.addButton(yes, () -> {
            dialog.hide();
            confirmed.run();
        });
        dialog.keyDown(KeyCode.ESCAPE, dialog::hide);
        dialog.keyDown(KeyCode.BACK, dialog::hide);
        dialog.show();
    }

    public void showOkText(String title, String text, Runnable confirmed) {
        FloatingDialog dialog = new FloatingDialog(title);
        dialog.cont.add(text).width(500.0f).wrap().pad(4.0f).get().setAlignment(1, 1);
        dialog.buttons.defaults().size(200.0f, 54.0f).pad(2.0f);
        dialog.setFillParent(false);
        dialog.buttons.addButton("$ok", () -> {
            dialog.hide();
            confirmed.run();
        });
        dialog.show();
    }

    public String formatAmount(int number) {
        if (number >= 1000000) {
            return Strings.fixed((float)number / 1000000.0f, 1) + "[gray]mil[]";
        }
        if (number >= 10000) {
            return number / 1000 + "[gray]k[]";
        }
        if (number >= 1000) {
            return Strings.fixed((float)number / 1000.0f, 1) + "[gray]k[]";
        }
        return number + "";
    }
}

