/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.core;

import io.anuke.arc.Core;
import io.anuke.arc.Input;
import io.anuke.arc.collection.Array;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.math.RandomXS128;
import io.anuke.arc.scene.ui.TextField;
import io.anuke.arc.util.serialization.Base64Coder;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.net.ArcNetImpl;
import io.anuke.mindustry.net.Net;
import io.anuke.mindustry.type.Publishable;
import io.anuke.mindustry.ui.dialogs.FileChooser;

public interface Platform {
    default public void updateLobby() {
    }

    default public void inviteFriends() {
    }

    default public void publish(Publishable pub) {
    }

    default public void viewListing(Publishable pub) {
    }

    default public void viewListingID(String mapid) {
    }

    default public Array<FileHandle> getWorkshopContent(Class<? extends Publishable> type) {
        return new Array<FileHandle>(0);
    }

    default public void openWorkshop() {
    }

    default public Net.NetProvider getNet() {
        return new ArcNetImpl();
    }

    default public void addDialog(TextField field) {
        this.addDialog(field, 16);
    }

    default public void addDialog(TextField field, int maxLength) {
        if (!Vars.mobile) {
            return;
        }
        field.tapped(() -> {
            Input.TextInput input = new Input.TextInput();
            input.text = field.getText();
            input.maxLength = maxLength;
            input.accepted = text -> {
                field.clearText();
                field.appendText((String)text);
                field.change();
                Core.input.setOnscreenKeyboardVisible(false);
            };
            Core.input.getTextInput(input);
        });
    }

    default public void updateRPC() {
    }

    default public String getUUID() {
        String uuid = Core.settings.getString("uuid", "");
        if (uuid.isEmpty()) {
            byte[] result = new byte[8];
            new RandomXS128().nextBytes(result);
            uuid = new String(Base64Coder.encode(result));
            Core.settings.put("uuid", uuid);
            Core.settings.save();
            return uuid;
        }
        return uuid;
    }

    default public void shareFile(FileHandle file) {
    }

    default public void showFileChooser(boolean open, String extension, Consumer<FileHandle> cons) {
        new FileChooser(open ? "$open" : "$save", file -> file.extension().toLowerCase().equals(extension), open, file -> {
            if (!open) {
                cons.accept(file.parent().child(file.nameWithoutExtension() + "." + extension));
            } else {
                cons.accept((FileHandle)file);
            }
        }).show();
    }

    default public void hide() {
    }

    default public void beginForceLandscape() {
    }

    default public void endForceLandscape() {
    }
}

