/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.core;

import io.anuke.arc.ApplicationListener;
import io.anuke.arc.Events;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.ObjectSet;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Colors;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.util.CommandHandler;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.Strings;
import io.anuke.arc.util.Structs;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.Timekeeper;
import io.anuke.arc.util.Timer;
import io.anuke.arc.util.io.ByteBufferOutput;
import io.anuke.arc.util.io.FastDeflaterOutputStream;
import io.anuke.arc.util.io.ReusableByteOutStream;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.core.NetClient;
import io.anuke.mindustry.core.Version;
import io.anuke.mindustry.entities.EntityGroup;
import io.anuke.mindustry.entities.traits.BuilderTrait;
import io.anuke.mindustry.entities.traits.Entity;
import io.anuke.mindustry.entities.traits.SyncTrait;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.gen.RemoteReadServer;
import io.anuke.mindustry.net.Administration;
import io.anuke.mindustry.net.NetConnection;
import io.anuke.mindustry.net.NetworkIO;
import io.anuke.mindustry.net.Packets;
import io.anuke.mindustry.world.Tile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class NetServer
implements ApplicationListener {
    public static final int maxSnapshotSize = 430;
    private static final float serverSyncTime = 12.0f;
    private static final float kickDuration = 30000.0f;
    private static final Vector2 vector = new Vector2();
    private static final Rectangle viewport = new Rectangle();
    private static final float correctDist = 16.0f;
    public final Administration admins = new Administration();
    public final CommandHandler clientCommands = new CommandHandler("/");
    private boolean closing = false;
    private ByteBuffer writeBuffer = ByteBuffer.allocate(127);
    private ByteBufferOutput outputBuffer = new ByteBufferOutput(this.writeBuffer);
    private ReusableByteOutStream syncStream = new ReusableByteOutStream();
    private DataOutputStream dataStream = new DataOutputStream(this.syncStream);

    public NetServer() {
        Vars.net.handleServer(Packets.Connect.class, (con, connect) -> {
            if (this.admins.isIPBanned(connect.addressTCP)) {
                con.kick(Packets.KickReason.banned);
            }
        });
        Vars.net.handleServer(Packets.Disconnect.class, (con, packet) -> {
            if (con.player != null) {
                NetServer.onDisconnect(con.player, packet.reason);
            }
        });
        Vars.net.handleServer(Packets.ConnectPacket.class, (con, packet) -> {
            Player player2;
            boolean preventDuplicates;
            String uuid = packet.uuid;
            if (this.admins.isIPBanned(con.address)) {
                return;
            }
            if (con.hasBegunConnecting) {
                con.kick(Packets.KickReason.idInUse);
                return;
            }
            Administration.PlayerInfo info = this.admins.getInfo(uuid);
            con.hasBegunConnecting = true;
            con.mobile = packet.mobile;
            if (packet.uuid == null || packet.usid == null) {
                con.kick(Packets.KickReason.idInUse);
                return;
            }
            if (this.admins.isIDBanned(uuid)) {
                con.kick(Packets.KickReason.banned);
                return;
            }
            if ((float)(Time.millis() - info.lastKicked) < 30000.0f) {
                con.kick(Packets.KickReason.recentKick);
                return;
            }
            if (this.admins.getPlayerLimit() > 0 && Vars.playerGroup.size() >= this.admins.getPlayerLimit()) {
                con.kick(Packets.KickReason.playerLimit);
                return;
            }
            Array<String> extraMods = packet.mods.copy();
            Array<String> missingMods = Vars.mods.getIncompatibility(extraMods);
            if (!extraMods.isEmpty() || !missingMods.isEmpty()) {
                StringBuilder result = new StringBuilder("[accent]Incompatible mods![]\n\n");
                if (!missingMods.isEmpty()) {
                    result.append("Missing:[lightgray]\n").append("> ").append(missingMods.toString("\n> "));
                    result.append("[]\n");
                }
                if (!extraMods.isEmpty()) {
                    result.append("Unnecessary mods:[lightgray]\n").append("> ").append(extraMods.toString("\n> "));
                }
                con.kick(result.toString());
            }
            if (!this.admins.isWhitelisted(packet.uuid, packet.usid)) {
                info.adminUsid = packet.usid;
                info.lastName = packet.name;
                info.id = packet.uuid;
                this.admins.save();
                Call.onInfoMessage(con, "You are not whitelisted here.");
                Log.info("&lcDo &lywhitelist-add {0}&lc to whitelist the player &lb'{1}'", packet.uuid, packet.name);
                con.kick(Packets.KickReason.whitelist);
                return;
            }
            if (packet.versionType == null || (packet.version == -1 || !packet.versionType.equals(Version.type)) && Version.build != -1 && !this.admins.allowsCustomClients()) {
                con.kick(!Version.type.equals(packet.versionType) ? Packets.KickReason.typeMismatch : Packets.KickReason.customClient);
                return;
            }
            boolean bl = preventDuplicates = Vars.headless && Vars.netServer.admins.getStrict();
            if (preventDuplicates) {
                for (Player player2 : Vars.playerGroup.all()) {
                    if (player2.name.trim().equalsIgnoreCase(packet.name.trim())) {
                        con.kick(Packets.KickReason.nameInUse);
                        return;
                    }
                    if (player2.uuid == null || player2.usid == null || !player2.uuid.equals(packet.uuid) && !player2.usid.equals(packet.usid)) continue;
                    con.kick(Packets.KickReason.idInUse);
                    return;
                }
            }
            packet.name = this.fixName(packet.name);
            if (packet.name.trim().length() <= 0) {
                con.kick(Packets.KickReason.nameEmpty);
                return;
            }
            String ip = con.address;
            this.admins.updatePlayerJoined(uuid, ip, packet.name);
            if (packet.version != Version.build && Version.build != -1 && packet.version != -1) {
                con.kick(packet.version > Version.build ? Packets.KickReason.serverOutdated : Packets.KickReason.clientOutdated);
                return;
            }
            if (packet.version == -1) {
                con.modclient = true;
            }
            player2 = new Player();
            player2.isAdmin = this.admins.isAdmin(uuid, packet.usid);
            player2.con = con;
            player2.usid = packet.usid;
            player2.name = packet.name;
            player2.uuid = uuid;
            player2.isMobile = packet.mobile;
            player2.dead = true;
            player2.setNet(player2.x, player2.y);
            player2.color.set(packet.color);
            player2.color.a = 1.0f;
            try {
                this.writeBuffer.position(0);
                player2.write(this.outputBuffer);
            }
            catch (Throwable t) {
                t.printStackTrace();
                con.kick(Packets.KickReason.nameEmpty);
                return;
            }
            con.player = player2;
            if (Vars.state.rules.pvp) {
                player2.setTeam(this.assignTeam(player2, Vars.playerGroup.all()));
                Log.info("Auto-assigned player {0} to team {1}.", new Object[]{player2.name, player2.getTeam()});
            }
            this.sendWorldData(player2);
            Vars.platform.updateRPC();
            Events.fire(new EventType.PlayerConnect(player2));
        });
        Vars.net.handleServer(Packets.InvokePacket.class, (con, packet) -> {
            if (con.player == null) {
                return;
            }
            RemoteReadServer.readPacket(packet.writeBuffer, packet.type, con.player);
        });
        this.registerCommands();
    }

    @Override
    public void init() {
        Vars.mods.each(mod -> mod.registerClientCommands(this.clientCommands));
    }

    private void registerCommands() {
        this.clientCommands.register("help", "[page]", "Lists all commands.", (args, player) -> {
            if (args.length > 0 && !Strings.canParseInt(args[0])) {
                player.sendMessage("[scarlet]'page' must be a number.");
                return;
            }
            int commandsPerPage = 6;
            int page = args.length > 0 ? Strings.parseInt(args[0]) : 1;
            int pages = Mathf.ceil((float)this.clientCommands.getCommandList().size / (float)commandsPerPage);
            if (--page > pages || page < 0) {
                player.sendMessage("[scarlet]'page' must be a number between[orange] 1[] and[orange] " + pages + "[scarlet].");
                return;
            }
            StringBuilder result = new StringBuilder();
            result.append(Strings.format("[orange]-- Commands Page[lightgray] {0}[gray]/[lightgray]{1}[orange] --\n\n", page + 1, pages));
            for (int i = commandsPerPage * page; i < Math.min(commandsPerPage * (page + 1), this.clientCommands.getCommandList().size); ++i) {
                CommandHandler.Command command = this.clientCommands.getCommandList().get(i);
                result.append("[orange] /").append(command.text).append("[white] ").append(command.paramText).append("[lightgray] - ").append(command.description).append("\n");
            }
            player.sendMessage(result.toString());
        });
        this.clientCommands.register("t", "<message...>", "Send a message only to your teammates.", (args, player) -> Vars.playerGroup.all().each(p -> p.getTeam() == player.getTeam(), o -> o.sendMessage(args[0], (Player)player, "[#" + player.getTeam().color.toString() + "]<T>" + NetClient.colorizeName(player.id, player.name))));
        final int kickDuration = 900;
        int voteTime = 300;
        Timekeeper vtime = new Timekeeper(voteTime);
        class VoteSession {
            Player target;
            ObjectSet<String> voted = new ObjectSet();
            VoteSession[] map;
            Timer.Task task;
            int votes;

            public VoteSession(VoteSession[] map, Player target) {
                this.target = target;
                this.map = map;
                this.task = Timer.schedule(() -> {
                    if (!this.checkPass()) {
                        Call.sendMessage(Strings.format("[lightgray]Vote failed. Not enough votes to kick[orange] {0}[lightgray].", target.name));
                        map[0] = null;
                        this.task.cancel();
                    }
                }, 60.0f);
            }

            void vote(Player player, int d) {
                this.votes += d;
                this.voted.addAll((String[])new String[]{player.uuid, NetServer.this.admins.getInfo((String)player.uuid).lastIP});
                Call.sendMessage(Strings.format("[orange]{0}[lightgray] has voted to kick[orange] {1}[].[accent] ({2}/{3})\n[lightgray]Type[orange] /vote <y/n>[] to agree.", player.name, this.target.name, this.votes, NetServer.this.votesRequired()));
            }

            boolean checkPass() {
                if (this.votes >= NetServer.this.votesRequired()) {
                    Call.sendMessage(Strings.format("[orange]Vote passed.[scarlet] {0}[orange] will be banned from the server for {1} minutes.", this.target.name, kickDuration / 60));
                    this.target.getInfo().lastKicked = Time.millis() + (long)(kickDuration * 1000);
                    Vars.playerGroup.all().each(p -> p.uuid != null && p.uuid.equals(this.target.uuid), p -> p.con.kick(Packets.KickReason.vote));
                    this.map[0] = null;
                    this.task.cancel();
                    return true;
                }
                return false;
            }
        }
        VoteSession[] currentlyKicking = new VoteSession[]{null};
        this.clientCommands.register("votekick", "[player...]", "Vote to kick a player, with a cooldown.", (args, player) -> {
            if (Vars.playerGroup.size() < 3) {
                player.sendMessage("[scarlet]At least 3 players are needed to start a votekick.");
                return;
            }
            if (player.isLocal) {
                player.sendMessage("[scarlet]Just kick them yourself if you're the host.");
                return;
            }
            if (args.length == 0) {
                StringBuilder builder = new StringBuilder();
                builder.append("[orange]Players to kick: \n");
                for (Player p2 : Vars.playerGroup.all()) {
                    if (p2.isAdmin || p2.con == null || p2 == player) continue;
                    builder.append("[lightgray] ").append(p2.name).append("[accent] (#").append(p2.id).append(")\n");
                }
                player.sendMessage(builder.toString());
            } else {
                Player found;
                if (args[0].length() > 1 && args[0].startsWith("#") && Strings.canParseInt(args[0].substring(1))) {
                    int id = Strings.parseInt(args[0].substring(1));
                    found = Vars.playerGroup.find(p -> p.id == id);
                } else {
                    found = Vars.playerGroup.find(p -> p.name.equalsIgnoreCase(args[0]));
                }
                if (found != null) {
                    if (found.isAdmin) {
                        player.sendMessage("[scarlet]Did you really expect to be able to kick an admin?");
                    } else if (found.isLocal) {
                        player.sendMessage("[scarlet]Local players cannot be kicked.");
                    } else {
                        if (!vtime.get()) {
                            player.sendMessage("[scarlet]You must wait " + voteTime / 60 + " minutes between votekicks.");
                            return;
                        }
                        VoteSession session = new VoteSession(currentlyKicking, found);
                        session.vote((Player)player, 1);
                        vtime.reset();
                        currentlyKicking[0] = session;
                    }
                } else {
                    player.sendMessage("[scarlet]No player[orange]'" + args[0] + "'[scarlet] found.");
                }
            }
        });
        this.clientCommands.register("vote", "<y/n>", "Vote to kick the current player.", (arg, player) -> {
            if (currentlyKicking[0] == null) {
                player.sendMessage("[scarlet]Nobody is being voted on.");
            } else {
                if (player.isLocal) {
                    player.sendMessage("Local players can't vote. Kick the player yourself instead.");
                    return;
                }
                if (player.uuid != null && (currentlyKicking[0].voted.contains(player.uuid) || currentlyKicking[0].voted.contains(this.admins.getInfo((String)player.uuid).lastIP))) {
                    player.sendMessage("[scarlet]You've already voted. Sit down.");
                    return;
                }
                if (currentlyKicking[0].target == player) {
                    player.sendMessage("[scarlet]You can't vote on your own trial.");
                    return;
                }
                if (!arg[0].toLowerCase().equals("y") && !arg[0].toLowerCase().equals("n")) {
                    player.sendMessage("[scarlet]Vote either 'y' (yes) or 'n' (no).");
                    return;
                }
                int sign = arg[0].toLowerCase().equals("y") ? 1 : -1;
                currentlyKicking[0].vote((Player)player, sign);
            }
        });
        this.clientCommands.register("sync", "Re-synchronize world state.", (args, player) -> {
            if (player.isLocal) {
                player.sendMessage("[scarlet]Re-synchronizing as the host is pointless.");
            } else {
                Call.onWorldDataBegin(player.con);
                Vars.netServer.sendWorldData((Player)player);
            }
        });
    }

    public int votesRequired() {
        return 2 + (Vars.playerGroup.size() > 4 ? 1 : 0);
    }

    public Team assignTeam(Player current, Iterable<Player> players) {
        return Structs.findMin(Team.all, team -> {
            if (Vars.state.teams.isActive((Team)((Object)team)) && !Vars.state.teams.get((Team)team).cores.isEmpty()) {
                int count = 0;
                for (Player other : players) {
                    if (other.getTeam() != team || other == current) continue;
                    ++count;
                }
                return count;
            }
            return 2.1474836E9f;
        });
    }

    public void sendWorldData(Player player) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        FastDeflaterOutputStream def = new FastDeflaterOutputStream(stream);
        NetworkIO.writeWorld(player, def);
        Packets.WorldStream data = new Packets.WorldStream();
        data.stream = new ByteArrayInputStream(stream.toByteArray());
        player.con.sendStream(data);
        Log.debug("Packed {0} compressed bytes of world data.", stream.size());
    }

    public static void onDisconnect(Player player, String reason) {
        if (player.con == null) {
            player.remove();
            return;
        }
        if (!player.con.hasDisconnected) {
            if (player.con.hasConnected) {
                Events.fire(new EventType.PlayerLeave(player));
                Call.sendMessage("[accent]" + player.name + "[accent] has disconnected.");
                Call.onPlayerDisconnect(player.id);
            }
            Log.info("&lm[{1}] &lc{0} has disconnected. &lg&fi({2})", player.name, player.uuid, reason);
        }
        player.remove();
        player.con.hasDisconnected = true;
    }

    public static void onClientShapshot(Player player, int snapshotID, float x, float y, float pointerX, float pointerY, float rotation, float baseRotation, float xVelocity, float yVelocity, Tile mining, boolean boosting, boolean shooting, boolean chatting, boolean building, BuilderTrait.BuildRequest[] requests, float viewX, float viewY, float viewWidth, float viewHeight) {
        boolean verifyPosition;
        NetConnection connection = player.con;
        if (connection == null || snapshotID < connection.lastRecievedClientSnapshot) {
            return;
        }
        boolean bl = verifyPosition = !player.isDead() && Vars.netServer.admins.getStrict() && Vars.headless;
        if (connection.lastRecievedClientTime == 0L) {
            connection.lastRecievedClientTime = Time.millis() - 16L;
        }
        connection.viewX = viewX;
        connection.viewY = viewY;
        connection.viewWidth = viewWidth;
        connection.viewHeight = viewHeight;
        long elapsed = Time.timeSinceMillis(connection.lastRecievedClientTime);
        float maxSpeed = boosting && !player.mech.flying ? player.mech.compoundSpeedBoost : player.mech.compoundSpeed;
        float maxMove = (float)elapsed / 1000.0f * 60.0f * Math.min(maxSpeed, player.mech.maxSpeed) * 1.2f;
        player.pointerX = pointerX;
        player.pointerY = pointerY;
        player.setMineTile(mining);
        player.isTyping = chatting;
        player.isBoosting = boosting;
        player.isShooting = shooting;
        player.isBuilding = building;
        player.buildQueue().clear();
        for (BuilderTrait.BuildRequest req : requests) {
            Tile tile;
            if (req == null || (tile = Vars.world.tile(req.x, req.y)) == null || req.breaking && tile.block() == Blocks.air || !req.breaking && tile.block() == req.block && (!req.block.rotate || tile.rotation() == req.rotation)) continue;
            player.buildQueue().addLast(req);
        }
        vector.set(x - player.getInterpolator().target.x, y - player.getInterpolator().target.y);
        vector.limit(maxMove);
        float prevx = player.x;
        float prevy = player.y;
        player.set(player.getInterpolator().target.x, player.getInterpolator().target.y);
        if (!player.mech.flying && player.boostHeat < 0.01f) {
            player.move(NetServer.vector.x, NetServer.vector.y);
        } else {
            player.x += NetServer.vector.x;
            player.y += NetServer.vector.y;
        }
        float newx = player.x;
        float newy = player.y;
        if (!verifyPosition) {
            player.x = prevx;
            player.y = prevy;
            newx = x;
            newy = y;
        } else if (Mathf.dst(x, y, newx, newy) > 16.0f) {
            Call.onPositionSet(player.con, newx, newy);
        }
        player.x = prevx;
        player.y = prevy;
        player.getInterpolator().read(player.x, player.y, newx, newy, rotation, baseRotation);
        player.velocity().set(xVelocity, yVelocity);
        connection.lastRecievedClientSnapshot = snapshotID;
        connection.lastRecievedClientTime = Time.millis();
    }

    public static void onAdminRequest(Player player, Player other, Packets.AdminAction action) {
        if (!player.isAdmin) {
            Log.warn("ACCESS DENIED: Player {0} / {1} attempted to perform admin action without proper security access.", player.name, player.con.address);
            return;
        }
        if (other == null || other.isAdmin && !player.isLocal && other != player) {
            Log.warn("{0} attempted to perform admin action on nonexistant or admin player.", player.name);
            return;
        }
        if (action == Packets.AdminAction.wave) {
            Vars.state.wavetime = 0.0f;
        } else if (action == Packets.AdminAction.ban) {
            Vars.netServer.admins.banPlayerIP(other.con.address);
            other.con.kick(Packets.KickReason.banned);
            Log.info("&lc{0} has banned {1}.", player.name, other.name);
        } else if (action == Packets.AdminAction.kick) {
            other.con.kick(Packets.KickReason.kick);
            Log.info("&lc{0} has kicked {1}.", player.name, other.name);
        } else if (action == Packets.AdminAction.trace) {
            Administration.TraceInfo info = new Administration.TraceInfo(other.con.address, other.uuid, other.con.modclient, other.con.mobile);
            if (player.con != null) {
                Call.onTraceInfo(player.con, other, info);
            } else {
                NetClient.onTraceInfo(other, info);
            }
            Log.info("&lc{0} has requested trace info of {1}.", player.name, other.name);
        }
    }

    public static void connectConfirm(Player player) {
        if (player.con == null || player.con.hasConnected) {
            return;
        }
        player.add();
        player.con.hasConnected = true;
        Call.sendMessage("[accent]" + player.name + "[accent] has connected.");
        Log.info("&lm[{1}] &y{0} has connected. ", player.name, player.uuid);
        Events.fire(new EventType.PlayerJoin(player));
    }

    public boolean isWaitingForPlayers() {
        if (Vars.state.rules.pvp) {
            int used = 0;
            for (Team t : Team.all) {
                if (Vars.playerGroup.count(p -> p.getTeam() == t) <= 0) continue;
                ++used;
            }
            return used < 2;
        }
        return false;
    }

    @Override
    public void update() {
        if (!Vars.headless && !this.closing && Vars.net.server() && Vars.state.is(GameState.State.menu)) {
            this.closing = true;
            Vars.ui.loadfrag.show("$server.closing");
            Time.runTask(5.0f, () -> {
                Vars.net.closeServer();
                Vars.ui.loadfrag.hide();
                this.closing = false;
            });
        }
        if (!Vars.state.is(GameState.State.menu) && Vars.net.server()) {
            this.sync();
        }
    }

    public void kickAll(Packets.KickReason reason) {
        for (NetConnection con : Vars.net.getConnections()) {
            con.kick(reason);
        }
    }

    public void writeSnapshot(Player player) throws IOException {
        this.syncStream.reset();
        ObjectSet<Tile> cores = Vars.state.teams.get((Team)player.getTeam()).cores;
        this.dataStream.writeByte(cores.size);
        for (Tile tile : cores) {
            this.dataStream.writeInt(tile.pos());
            tile.entity.items.write(this.dataStream);
        }
        this.dataStream.close();
        byte[] stateBytes = this.syncStream.toByteArray();
        Call.onStateSnapshot(player.con, Vars.state.wavetime, Vars.state.wave, Vars.state.enemies(), (short)stateBytes.length, Vars.net.compressSnapshot(stateBytes));
        viewport.setSize(player.con.viewWidth, player.con.viewHeight).setCenter(player.con.viewX, player.con.viewY);
        for (EntityGroup<?> group : Vars.entities.all()) {
            if (group.isEmpty() || !(group.all().get(0) instanceof SyncTrait)) continue;
            if (!group.mappingEnabled()) {
                throw new RuntimeException("Entity group '" + group.getType() + "' contains SyncTrait entities, yet mapping is not enabled. In order for syncing to work, you must enable mapping for this group.");
            }
            this.syncStream.reset();
            int sent = 0;
            for (Entity entity : group.all()) {
                SyncTrait sync = (SyncTrait)entity;
                if (!sync.isSyncing()) continue;
                this.dataStream.writeInt(entity.getID());
                this.dataStream.writeByte(sync.getTypeID().id);
                sync.write(this.dataStream);
                ++sent;
                if (this.syncStream.size() <= 430) continue;
                this.dataStream.close();
                byte[] syncBytes = this.syncStream.toByteArray();
                Call.onEntitySnapshot(player.con, (byte)group.getID(), (short)sent, (short)syncBytes.length, Vars.net.compressSnapshot(syncBytes));
                sent = 0;
                this.syncStream.reset();
            }
            if (sent <= 0) continue;
            this.dataStream.close();
            byte[] syncBytes = this.syncStream.toByteArray();
            Call.onEntitySnapshot(player.con, (byte)group.getID(), (short)sent, (short)syncBytes.length, Vars.net.compressSnapshot(syncBytes));
        }
    }

    String fixName(String name) {
        if ((name = name.trim()).equals("[") || name.equals("]")) {
            return "";
        }
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) != '[' || i == name.length() - 1 || name.charAt(i + 1) == '[' || i != 0 && name.charAt(i - 1) == '[') continue;
            String prev = name.substring(0, i);
            String next = name.substring(i);
            String result = this.checkColor(next);
            name = prev + result;
        }
        StringBuilder result = new StringBuilder();
        int curChar = 0;
        while (curChar < name.length() && result.toString().getBytes().length < 40) {
            result.append(name.charAt(curChar++));
        }
        return result.toString();
    }

    String checkColor(String str) {
        for (int i = 1; i < str.length(); ++i) {
            Color result;
            if (str.charAt(i) != ']') continue;
            String color = str.substring(1, i);
            if (Colors.get(color.toUpperCase()) != null || Colors.get(color.toLowerCase()) != null) {
                Color color2 = result = Colors.get(color.toLowerCase()) == null ? Colors.get(color.toUpperCase()) : Colors.get(color.toLowerCase());
                if (!(result.a <= 0.8f)) continue;
                return str.substring(i + 1);
            }
            try {
                result = Color.valueOf(color);
                if (!(result.a <= 0.8f)) continue;
                return str.substring(i + 1);
            }
            catch (Exception e) {
                return str;
            }
        }
        return str;
    }

    void sync() {
        try {
            for (int i = 0; i < Vars.playerGroup.size(); ++i) {
                Player player = Vars.playerGroup.all().get(i);
                if (player.isLocal) continue;
                if (player.con == null || !player.con.isConnected()) {
                    NetServer.onDisconnect(player, "disappeared");
                    continue;
                }
                NetConnection connection = player.con;
                if (!player.timer.get(2, 12.0f) || !connection.hasConnected) continue;
                this.writeSnapshot(player);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

