/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.core;

import io.anuke.arc.ApplicationListener;
import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.IntSet;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.math.RandomXS128;
import io.anuke.arc.util.CommandHandler;
import io.anuke.arc.util.Interval;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.io.ReusableByteInStream;
import io.anuke.arc.util.serialization.Base64Coder;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.core.Version;
import io.anuke.mindustry.entities.EntityGroup;
import io.anuke.mindustry.entities.traits.BuilderTrait;
import io.anuke.mindustry.entities.traits.SyncTrait;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Rules;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.gen.RemoteReadClient;
import io.anuke.mindustry.net.Administration;
import io.anuke.mindustry.net.Net;
import io.anuke.mindustry.net.NetworkIO;
import io.anuke.mindustry.net.Packets;
import io.anuke.mindustry.net.ValidateException;
import io.anuke.mindustry.type.ContentType;
import io.anuke.mindustry.type.TypeID;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.modules.ItemModule;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.zip.InflaterInputStream;

public class NetClient
implements ApplicationListener {
    private static final float dataTimeout = 1080.0f;
    private static final float playerSyncTime = 2.0f;
    public static final float viewScale = 2.0f;
    private long ping;
    private Interval timer = new Interval(5);
    private boolean connecting = false;
    private boolean quiet = false;
    private boolean quietReset = false;
    private float timeoutTime = 0.0f;
    private int lastSent;
    private IntSet removed = new IntSet();
    private ReusableByteInStream byteStream = new ReusableByteInStream();
    private DataInputStream dataStream = new DataInputStream(this.byteStream);

    public NetClient() {
        Vars.net.handleClient(Packets.Connect.class, packet -> {
            Log.info("Connecting to server: {0}", packet.addressTCP);
            Vars.player.isAdmin = false;
            this.reset();
            Vars.ui.loadfrag.hide();
            Vars.ui.loadfrag.show("$connecting.data");
            Vars.ui.loadfrag.setButton(() -> {
                Vars.ui.loadfrag.hide();
                this.connecting = false;
                this.quiet = true;
                Vars.net.disconnect();
            });
            Packets.ConnectPacket c = new Packets.ConnectPacket();
            c.name = Vars.player.name;
            c.mods = Vars.mods.getModStrings();
            c.mobile = Vars.mobile;
            c.versionType = Version.type;
            c.color = Color.rgba8888(Vars.player.color);
            c.usid = this.getUsid(packet.addressTCP);
            c.uuid = Vars.platform.getUUID();
            if (c.uuid == null) {
                Vars.ui.showErrorMessage("$invalidid");
                Vars.ui.loadfrag.hide();
                this.disconnectQuietly();
                return;
            }
            Vars.net.send(c, Net.SendMode.tcp);
        });
        Vars.net.handleClient(Packets.Disconnect.class, packet -> {
            if (this.quietReset) {
                return;
            }
            this.connecting = false;
            Vars.state.set(GameState.State.menu);
            Vars.logic.reset();
            Vars.platform.updateRPC();
            if (this.quiet) {
                return;
            }
            Time.runTask(3.0f, Vars.ui.loadfrag::hide);
            if (packet.reason != null) {
                if (packet.reason.equals("closed")) {
                    Vars.ui.showSmall("$disconnect", "$disconnect.closed");
                } else if (packet.reason.equals("timeout")) {
                    Vars.ui.showSmall("$disconnect", "$disconnect.timeout");
                } else if (packet.reason.equals("error")) {
                    Vars.ui.showSmall("$disconnect", "$disconnect.error");
                }
            } else {
                Vars.ui.showErrorMessage("$disconnect");
            }
        });
        Vars.net.handleClient(Packets.WorldStream.class, data -> {
            Log.info("Recieved world data: {0} bytes.", data.stream.available());
            NetworkIO.loadWorld(new InflaterInputStream(data.stream));
            this.finishConnecting();
        });
        Vars.net.handleClient(Packets.InvokePacket.class, packet -> {
            packet.writeBuffer.position(0);
            RemoteReadClient.readPacket(packet.writeBuffer, packet.type);
        });
    }

    public static void sendMessage(String message, String sender, Player playersender) {
        if (!(Vars.ui == null || playersender != null && Vars.net.server() && sender.startsWith("[#" + Vars.player.getTeam().color.toString() + "]<T>"))) {
            Vars.ui.chatfrag.addMessage(message, sender);
        }
        if (playersender != null) {
            playersender.lastText = message;
            playersender.textFadeTime = 1.0f;
        }
    }

    public static void sendMessage(String message) {
        if (Vars.ui != null) {
            Vars.ui.chatfrag.addMessage(message, null);
        }
    }

    public static void sendChatMessage(Player player, String message) {
        if (message.length() > 150) {
            throw new ValidateException(player, "Player has sent a message above the text limit.");
        }
        CommandHandler.CommandResponse response = Vars.netServer.clientCommands.handleMessage(message, player);
        if (response.type == CommandHandler.ResponseType.noCommand) {
            Log.info("&y{0}: &lb{1}", player.name, message);
            Call.sendMessage(message, NetClient.colorizeName(player.id, player.name), player);
        } else {
            Log.info("<&y{0}: &lm{1}&lg>", player.name, message);
            if (response.type != CommandHandler.ResponseType.valid) {
                String text = response.type == CommandHandler.ResponseType.manyArguments ? "[scarlet]Too many arguments. Usage:[lightgray] " + response.command.text + "[gray] " + response.command.paramText : (response.type == CommandHandler.ResponseType.fewArguments ? "[scarlet]Too few arguments. Usage:[lightgray] " + response.command.text + "[gray] " + response.command.paramText : "[scarlet]Unknown command. Check [lightgray]/help[scarlet].");
                player.sendMessage(text);
            }
        }
        Events.fire(new EventType.PlayerChatEvent(player, message));
    }

    public static String colorizeName(int id, String name) {
        Player player = Vars.playerGroup.getByID(id);
        if (name == null || player == null) {
            return null;
        }
        return "[#" + player.color.toString().toUpperCase() + "]" + name;
    }

    public static void onConnect(String ip, int port) {
        Vars.netClient.disconnectQuietly();
        Vars.state.set(GameState.State.menu);
        Vars.logic.reset();
        Vars.netClient.beginConnecting();
        Vars.net.connect(ip, port, () -> {});
    }

    public static void onPing(Player player, long time) {
        Call.onPingResponse(player.con, time);
    }

    public static void onPingResponse(long time) {
        Vars.netClient.ping = Time.timeSinceMillis(time);
    }

    public static void onTraceInfo(Player player, Administration.TraceInfo info) {
        if (player != null) {
            Vars.ui.traces.show(player, info);
        }
    }

    public static void onKick(Packets.KickReason reason) {
        Vars.netClient.disconnectQuietly();
        Vars.state.set(GameState.State.menu);
        Vars.logic.reset();
        if (!reason.quiet) {
            if (reason.extraText() != null) {
                Vars.ui.showText(reason.toString(), reason.extraText());
            } else {
                Vars.ui.showText("$disconnect", reason.toString());
            }
        }
        Vars.ui.loadfrag.hide();
    }

    public static void onKick(String reason) {
        Vars.netClient.disconnectQuietly();
        Vars.state.set(GameState.State.menu);
        Vars.logic.reset();
        Vars.ui.showText("$disconnect", reason, 8);
        Vars.ui.loadfrag.hide();
    }

    public static void onInfoMessage(String message) {
        Vars.ui.showText("", message);
    }

    public static void onSetRules(Rules rules) {
        Vars.state.rules = rules;
    }

    public static void onWorldDataBegin() {
        Vars.entities.clear();
        Vars.netClient.removed.clear();
        Vars.logic.reset();
        Vars.ui.chatfrag.clearMessages();
        Vars.net.setClientLoaded(false);
        Vars.ui.loadfrag.show("$connecting.data");
        Vars.ui.loadfrag.setButton(() -> {
            Vars.ui.loadfrag.hide();
            Vars.netClient.connecting = false;
            Vars.netClient.quiet = true;
            Vars.net.disconnect();
        });
    }

    public static void onPositionSet(float x, float y) {
        Vars.player.x = x;
        Vars.player.y = y;
    }

    public static void onPlayerDisconnect(int playerid) {
        Vars.playerGroup.removeByID(playerid);
    }

    public static void onEntitySnapshot(byte groupID, short amount, short dataLen, byte[] data) {
        try {
            Vars.netClient.byteStream.setBytes(Vars.net.decompressSnapshot(data, dataLen));
            DataInputStream input = Vars.netClient.dataStream;
            EntityGroup<?> group = Vars.entities.get(groupID);
            for (int j = 0; j < amount; ++j) {
                int id = input.readInt();
                byte typeID = input.readByte();
                SyncTrait entity = group == null ? null : (SyncTrait)group.getByID(id);
                boolean add = false;
                boolean created = false;
                if (entity == null && id == Vars.player.id) {
                    entity = Vars.player;
                    add = true;
                }
                if (entity == null) {
                    entity = (SyncTrait)((TypeID)Vars.content.getByID((ContentType)ContentType.typeid, (int)typeID)).constructor.get();
                    entity.resetID(id);
                    if (!Vars.netClient.isEntityUsed(entity.getID())) {
                        add = true;
                    }
                    created = true;
                }
                entity.read(input);
                if (created && entity.getInterpolator() != null && entity.getInterpolator().target != null) {
                    entity.setNet(entity.getInterpolator().target.x, entity.getInterpolator().target.y);
                    if (entity instanceof Unit && entity.getInterpolator().targets.length > 0) {
                        ((Unit)entity).rotation = entity.getInterpolator().targets[0];
                    }
                }
                if (!add) continue;
                entity.add();
                Vars.netClient.addRemovedEntity(entity.getID());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void onStateSnapshot(float waveTime, int wave, int enemies, short coreDataLen, byte[] coreData) {
        try {
            if (wave > Vars.state.wave) {
                Vars.state.wave = wave;
                Events.fire(new EventType.WaveEvent());
            }
            Vars.state.wavetime = waveTime;
            Vars.state.wave = wave;
            Vars.state.enemies = enemies;
            Vars.netClient.byteStream.setBytes(Vars.net.decompressSnapshot(coreData, coreDataLen));
            DataInputStream input = Vars.netClient.dataStream;
            int cores = input.readByte();
            for (int i = 0; i < cores; ++i) {
                int pos = input.readInt();
                Tile tile = Vars.world.tile(pos);
                if (tile != null && tile.entity != null) {
                    tile.entity.items.read(input);
                    continue;
                }
                new ItemModule().read(input);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void update() {
        if (!Vars.net.client()) {
            return;
        }
        if (!Vars.state.is(GameState.State.menu)) {
            if (!this.connecting) {
                this.sync();
            }
        } else if (!this.connecting) {
            Vars.net.disconnect();
        } else {
            this.timeoutTime += Time.delta();
            if (this.timeoutTime > 1080.0f) {
                Log.err("Failed to load data!", new Object[0]);
                Vars.ui.loadfrag.hide();
                this.quiet = true;
                Vars.ui.showErrorMessage("$disconnect.data");
                Vars.net.disconnect();
                this.timeoutTime = 0.0f;
            }
        }
    }

    public boolean isConnecting() {
        return this.connecting;
    }

    public int getPing() {
        return (int)this.ping;
    }

    private void finishConnecting() {
        Vars.state.set(GameState.State.playing);
        this.connecting = false;
        Vars.ui.join.hide();
        Vars.net.setClientLoaded(true);
        Core.app.post(Call::connectConfirm);
        Time.runTask(40.0f, Vars.platform::updateRPC);
        Core.app.post(() -> Vars.ui.loadfrag.hide());
    }

    private void reset() {
        Vars.net.setClientLoaded(false);
        this.removed.clear();
        this.timeoutTime = 0.0f;
        this.connecting = true;
        this.quietReset = false;
        this.quiet = false;
        this.lastSent = 0;
        Vars.entities.clear();
        Vars.ui.chatfrag.clearMessages();
    }

    public void beginConnecting() {
        this.connecting = true;
    }

    public void disconnectQuietly() {
        this.quiet = true;
        Vars.net.disconnect();
    }

    public void disconnectNoReset() {
        this.quietReset = true;
        this.quiet = true;
        Vars.net.disconnect();
    }

    public void setQuiet() {
        this.quiet = true;
    }

    public void addRemovedEntity(int id) {
        this.removed.add(id);
    }

    public boolean isEntityUsed(int id) {
        return this.removed.contains(id);
    }

    void sync() {
        if (this.timer.get(0, 2.0f)) {
            int usedRequests = Math.min(Vars.player.buildQueue().size, 10);
            BuilderTrait.BuildRequest[] requests = new BuilderTrait.BuildRequest[usedRequests];
            for (int i = 0; i < usedRequests; ++i) {
                requests[i] = Vars.player.buildQueue().get(i);
            }
            Call.onClientShapshot(this.lastSent++, Vars.player.x, Vars.player.y, Vars.player.pointerX, Vars.player.pointerY, Vars.player.rotation, Vars.player.baseRotation, Vars.player.velocity().x, Vars.player.velocity().y, Vars.player.getMineTile(), Vars.player.isBoosting, Vars.player.isShooting, Vars.ui.chatfrag.chatOpen(), Vars.player.isBuilding, requests, Core.camera.position.x, Core.camera.position.y, Core.camera.width * 2.0f, Core.camera.height * 2.0f);
        }
        if (this.timer.get(1, 60.0f)) {
            Call.onPing(Time.millis());
        }
    }

    String getUsid(String ip) {
        if (Core.settings.getString("usid-" + ip, null) != null) {
            return Core.settings.getString("usid-" + ip, null);
        }
        byte[] bytes = new byte[8];
        new RandomXS128().nextBytes(bytes);
        String result = new String(Base64Coder.encode(bytes));
        Core.settings.put("usid-" + ip, result);
        Core.settings.save();
        return result;
    }
}

