/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.core;

import io.anuke.arc.ApplicationListener;
import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.assets.Loadable;
import io.anuke.arc.audio.Sound;
import io.anuke.arc.collection.Array;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.scene.ui.Dialog;
import io.anuke.arc.scene.ui.TextField;
import io.anuke.arc.util.Interval;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.content.Zones;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.type.BaseUnit;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.MusicControl;
import io.anuke.mindustry.game.Rules;
import io.anuke.mindustry.game.Saves;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.game.Tutorial;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.gen.Musics;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.input.Binding;
import io.anuke.mindustry.input.DesktopInput;
import io.anuke.mindustry.input.InputHandler;
import io.anuke.mindustry.input.MobileInput;
import io.anuke.mindustry.maps.Map;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.type.Zone;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.storage.CoreBlock;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Control
implements ApplicationListener,
Loadable {
    public Saves saves;
    public MusicControl music;
    public Tutorial tutorial;
    public InputHandler input;
    private Interval timer = new Interval(2);
    private boolean hiscore = false;
    private boolean wasPaused = false;

    public Control() {
        this.saves = new Saves();
        this.tutorial = new Tutorial();
        this.music = new MusicControl();
        Events.on(EventType.StateChangeEvent.class, event -> {
            block4: {
                block3: {
                    if (event.from == GameState.State.playing && event.to == GameState.State.menu) break block3;
                    if (event.from != GameState.State.menu || event.to == GameState.State.menu) break block4;
                }
                Time.runTask(5.0f, Vars.platform::updateRPC);
                for (Sound sound : Core.assets.getAll(Sound.class, new Array())) {
                    sound.stop();
                }
            }
        });
        Events.on(EventType.PlayEvent.class, event -> {
            Vars.player.setTeam(Vars.state.rules.pvp ? Vars.netServer.assignTeam(Vars.player, Vars.playerGroup.all()) : Vars.defaultTeam);
            Vars.player.setDead(true);
            Vars.player.add();
            Vars.state.set(GameState.State.playing);
        });
        Events.on(EventType.WorldLoadEvent.class, event -> Core.app.post(() -> Core.app.post(() -> {
            if (Vars.net.active() && Vars.player.getClosestCore() != null) {
                Core.camera.position.set(Vars.player.isDead() ? Vars.player.getClosestCore() : Vars.player);
            } else {
                Core.camera.position.set(Vars.player);
            }
        })));
        Events.on(EventType.ResetEvent.class, event -> {
            Vars.player.reset();
            this.tutorial.reset();
            this.hiscore = false;
            this.saves.resetSave();
        });
        Events.on(EventType.WaveEvent.class, event -> {
            if (Vars.world.getMap().getHightScore() < Vars.state.wave) {
                this.hiscore = true;
                Vars.world.getMap().setHighScore(Vars.state.wave);
            }
            Sounds.wave.play();
        });
        Events.on(EventType.GameOverEvent.class, event -> {
            Vars.state.stats.wavesLasted = Vars.state.wave;
            Effects.shake(5.0f, 6.0f, Core.camera.position.x, Core.camera.position.y);
            Call.onGameOver(event.winner);
            if (Vars.state.rules.zone != null && !Vars.net.client() && this.saves.getZoneSlot() != null && !Vars.state.rules.tutorial) {
                this.saves.getZoneSlot().delete();
            }
        });
        Events.on(EventType.WorldLoadEvent.class, event -> {
            if (Vars.state.rules.pvp && !Vars.net.active()) {
                try {
                    Vars.net.host(6567);
                    Vars.player.isAdmin = true;
                }
                catch (IOException e) {
                    Vars.ui.showException("$server.error", e);
                    Core.app.post(() -> Vars.state.set(GameState.State.menu));
                }
            }
        });
        Events.on(EventType.UnlockEvent.class, e -> Vars.ui.hudfrag.showUnlock(e.content));
        Events.on(EventType.BlockBuildEndEvent.class, e -> {
            if (e.team == Vars.player.getTeam()) {
                if (e.breaking) {
                    ++Vars.state.stats.buildingsDeconstructed;
                } else {
                    ++Vars.state.stats.buildingsBuilt;
                }
            }
        });
        Events.on(EventType.BlockDestroyEvent.class, e -> {
            if (e.tile.getTeam() == Vars.player.getTeam()) {
                ++Vars.state.stats.buildingsDestroyed;
            }
        });
        Events.on(EventType.UnitDestroyEvent.class, e -> {
            if (e.unit.getTeam() != Vars.player.getTeam()) {
                ++Vars.state.stats.enemyUnitsDestroyed;
            }
        });
        Events.on(EventType.ZoneRequireCompleteEvent.class, e -> {
            if (e.objective.display() != null) {
                Vars.ui.hudfrag.showToast(Core.bundle.format("zone.requirement.complete", e.zoneForMet.localizedName, e.objective.display()));
            }
        });
        Events.on(EventType.ZoneConfigureCompleteEvent.class, e -> {
            if (e.zone.configureObjective.display() != null) {
                Vars.ui.hudfrag.showToast(Core.bundle.format("zone.config.unlocked", e.zone.configureObjective.display()));
            }
        });
        Events.on((Object)EventType.Trigger.newGame, () -> {
            TileEntity core = Vars.player.getClosestCore();
            if (core == null) {
                return;
            }
            Core.app.post(() -> Vars.ui.hudfrag.showLand());
            Vars.renderer.zoomIn(Fx.coreLand.lifetime);
            Core.app.post(() -> Effects.effect(Fx.coreLand, core.x, core.y, 0.0f, core.block));
            Time.run(Fx.coreLand.lifetime, () -> {
                Effects.effect(Fx.launch, core);
                Effects.shake(5.0f, 5.0f, core);
            });
        });
        Events.on(EventType.UnitDestroyEvent.class, e -> {
            if (e.unit instanceof BaseUnit && Vars.world.isZone()) {
                Vars.data.unlockContent(((BaseUnit)e.unit).getType());
            }
        });
    }

    @Override
    public void loadAsync() {
        Draw.scl = 1.0f / (float)Core.atlas.find("scale_marker").getWidth();
        Core.input.setCatch(KeyCode.BACK, true);
        Vars.data.load();
        Core.settings.defaults("ip", "localhost", "color-0", Color.rgba8888(Vars.playerColors[8]), "name", "", "lastBuild", 0);
        this.createPlayer();
        this.saves.load();
    }

    void createPlayer() {
        Vars.player = new Player();
        Vars.player.name = Core.settings.getString("name");
        Vars.player.color.set(Core.settings.getInt("color-0"));
        Vars.player.isLocal = true;
        Vars.player.isMobile = Vars.mobile;
        this.input = Vars.mobile ? new MobileInput() : new DesktopInput();
        if (!Vars.state.is(GameState.State.menu)) {
            Vars.player.add();
        }
        Events.on(EventType.ClientLoadEvent.class, e -> this.input.add());
    }

    public void setInput(InputHandler newInput) {
        Block block = this.input.block;
        boolean added = Core.input.getInputProcessors().contains(this.input);
        this.input.remove();
        this.input = newInput;
        newInput.block = block;
        if (added) {
            newInput.add();
        }
    }

    public void playMap(Map map, Rules rules) {
        Vars.ui.loadAnd(() -> {
            Vars.logic.reset();
            Vars.world.loadMap(map, rules);
            Vars.state.rules = rules;
            Vars.state.rules.zone = null;
            Vars.state.rules.editor = false;
            Vars.logic.play();
            if (Core.settings.getBool("savecreate") && !Vars.world.isInvalidMap()) {
                Vars.control.saves.addSave(map.name() + " " + new SimpleDateFormat("MMM dd h:mm", Locale.getDefault()).format(new Date()));
            }
            Events.fire(EventType.Trigger.newGame);
        });
    }

    public void playZone(Zone zone) {
        Vars.ui.loadAnd(() -> {
            Vars.logic.reset();
            Vars.net.reset();
            Vars.world.loadGenerator(zone.generator);
            zone.rules.accept(Vars.state.rules);
            Vars.state.rules.zone = zone;
            for (Tile core : Vars.state.teams.get((Team)Vars.defaultTeam).cores) {
                for (ItemStack stack : zone.getStartingItems()) {
                    core.entity.items.add(stack.item, stack.amount);
                }
            }
            Vars.state.set(GameState.State.playing);
            Vars.control.saves.zoneSave();
            Vars.logic.play();
            Events.fire(EventType.Trigger.newGame);
        });
    }

    public void playTutorial() {
        Zone zone = Zones.groundZero;
        Vars.ui.loadAnd(() -> {
            Vars.logic.reset();
            Vars.net.reset();
            Vars.world.beginMapLoad();
            Vars.world.createTiles(zone.generator.width, zone.generator.height);
            zone.generator.generate(Vars.world.getTiles());
            Tile coreb = null;
            block0: for (int x = 0; x < Vars.world.width(); ++x) {
                for (int y = 0; y < Vars.world.height(); ++y) {
                    if (!(Vars.world.rawTile(x, y).block() instanceof CoreBlock)) continue;
                    coreb = Vars.world.rawTile(x, y);
                    break block0;
                }
            }
            Geometry.circle(coreb.x, coreb.y, 10, (cx, cy) -> {
                Tile tile = Vars.world.ltile(cx, cy);
                if (tile != null && tile.getTeam() == Vars.defaultTeam && !(tile.block() instanceof CoreBlock)) {
                    Vars.world.removeBlock(tile);
                }
            });
            Geometry.circle(coreb.x, coreb.y, 5, (cx, cy) -> Vars.world.tile(cx, cy).clearOverlay());
            Vars.world.endMapLoad();
            zone.rules.accept(Vars.state.rules);
            Vars.state.rules.zone = zone;
            for (Tile core : Vars.state.teams.get((Team)Vars.defaultTeam).cores) {
                for (ItemStack stack : zone.getStartingItems()) {
                    core.entity.items.add(stack.item, stack.amount);
                }
            }
            Tile core = Vars.state.teams.get((Team)Vars.defaultTeam).cores.first();
            core.entity.items.clear();
            Vars.logic.play();
            Vars.state.rules.waveTimer = false;
            Vars.state.rules.waveSpacing = 1800.0f;
            Vars.state.rules.buildCostMultiplier = 0.3f;
            Vars.state.rules.tutorial = true;
            Events.fire(EventType.Trigger.newGame);
        });
    }

    public boolean isHighScore() {
        return this.hiscore;
    }

    @Override
    public void dispose() {
        Vars.content.dispose();
        Vars.net.dispose();
        Musics.dispose();
        Sounds.dispose();
        Vars.ui.editor.dispose();
    }

    @Override
    public void pause() {
        this.wasPaused = Vars.state.is(GameState.State.paused);
        if (Vars.state.is(GameState.State.playing)) {
            Vars.state.set(GameState.State.paused);
        }
    }

    @Override
    public void resume() {
        if (Vars.state.is(GameState.State.paused) && !this.wasPaused) {
            Vars.state.set(GameState.State.playing);
        }
    }

    @Override
    public void init() {
        Vars.platform.updateRPC();
        if (!Core.settings.getBool("playedtutorial", false)) {
            Core.app.post(() -> Core.app.post(this::playTutorial));
        }
        if (Core.settings.getBool("uiscalechanged", false)) {
            Core.app.post(() -> Core.app.post(() -> {
                FloatingDialog dialog = new FloatingDialog("$confirm");
                dialog.setFillParent(true);
                float[] countdown = new float[]{660.0f};
                Runnable exit = () -> {
                    Core.settings.put("uiscale", 100);
                    Core.settings.put("uiscalechanged", false);
                    Core.settings.save();
                    dialog.hide();
                    Core.app.exit();
                };
                dialog.cont.label(() -> {
                    if (countdown[0] <= 0.0f) {
                        exit.run();
                    }
                    Object[] objectArray = new Object[1];
                    countdown[0] = countdown[0] - Time.delta();
                    objectArray[0] = (int)(countdown[0] / 60.0f);
                    return Core.bundle.format("uiscale.reset", objectArray);
                }).pad(10.0f).expand().center();
                dialog.buttons.defaults().size(200.0f, 60.0f);
                dialog.buttons.addButton("$uiscale.cancel", exit);
                dialog.buttons.addButton("$ok", () -> {
                    Core.settings.put("uiscalechanged", false);
                    Core.settings.save();
                    dialog.hide();
                });
                dialog.show();
            }));
        }
        if (Vars.android) {
            Sounds.empty.loop(0.0f, 1.0f, 0.0f);
        }
    }

    @Override
    public void update() {
        if (Core.assets == null) {
            return;
        }
        this.saves.update();
        try {
            Core.assets.update();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.input.updateState();
        Vars.data.checkSave();
        this.music.update();
        Vars.loops.update();
        Time.updateGlobal();
        if (Core.input.keyTap(Binding.fullscreen)) {
            boolean full = Core.settings.getBool("fullscreen");
            if (full) {
                Core.graphics.setWindowedMode(Core.graphics.getWidth(), Core.graphics.getHeight());
            } else {
                Core.graphics.setFullscreenMode(Core.graphics.getDisplayMode());
            }
            Core.settings.put("fullscreen", !full);
            Core.settings.save();
        }
        if (!Vars.state.is(GameState.State.menu)) {
            this.input.update();
            if (Vars.world.isZone()) {
                for (Tile tile : Vars.state.teams.get((Team)Vars.player.getTeam()).cores) {
                    for (Item item : Vars.content.items()) {
                        if (tile.entity == null || !tile.entity.items.has(item)) continue;
                        Vars.data.unlockContent(item);
                    }
                }
            }
            if (Vars.state.rules.tutorial) {
                this.tutorial.update();
            }
            if (this.timer.get(0, 300.0f)) {
                Vars.platform.updateRPC();
            }
            if (Core.input.keyTap(Binding.pause) && !Core.scene.hasDialog() && !Vars.ui.restart.isShown() && (Vars.state.is(GameState.State.paused) || Vars.state.is(GameState.State.playing))) {
                Vars.state.set(Vars.state.is(GameState.State.playing) ? GameState.State.paused : GameState.State.playing);
            }
            if (Core.input.keyTap(Binding.menu) && !Vars.ui.restart.isShown()) {
                if (Vars.ui.chatfrag.chatOpen()) {
                    Vars.ui.chatfrag.hide();
                } else if (!Vars.ui.paused.isShown() && !Core.scene.hasDialog()) {
                    Vars.ui.paused.show();
                    Vars.state.set(GameState.State.paused);
                }
            }
            if (!Vars.mobile && Core.input.keyTap(Binding.screenshot) && !(Core.scene.getKeyboardFocus() instanceof TextField) && !Vars.ui.chatfrag.chatOpen()) {
                Vars.renderer.takeMapScreenshot();
            }
        } else {
            if (!Vars.state.isPaused()) {
                Time.update();
            }
            if (!Core.scene.hasDialog() && !Core.scene.root.getChildren().isEmpty() && !(Core.scene.root.getChildren().peek() instanceof Dialog) && Core.input.keyTap(KeyCode.BACK)) {
                Vars.platform.hide();
            }
        }
    }
}

