/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.core;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.collection.ObjectSet;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Pixmap;
import io.anuke.arc.util.Log;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.content.Bullets;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.content.Items;
import io.anuke.mindustry.content.Liquids;
import io.anuke.mindustry.content.Loadouts;
import io.anuke.mindustry.content.Mechs;
import io.anuke.mindustry.content.StatusEffects;
import io.anuke.mindustry.content.TechTree;
import io.anuke.mindustry.content.TypeIDs;
import io.anuke.mindustry.content.UnitTypes;
import io.anuke.mindustry.content.Zones;
import io.anuke.mindustry.ctype.Content;
import io.anuke.mindustry.ctype.ContentList;
import io.anuke.mindustry.ctype.MappableContent;
import io.anuke.mindustry.entities.bullet.BulletType;
import io.anuke.mindustry.mod.Mods;
import io.anuke.mindustry.type.ContentType;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.type.UnitType;
import io.anuke.mindustry.type.Zone;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.LegacyColorMapper;

public class ContentLoader {
    private boolean loaded = false;
    private ObjectMap<String, MappableContent>[] contentNameMap = new ObjectMap[ContentType.values().length];
    private Array<Content>[] contentMap = new Array[ContentType.values().length];
    private MappableContent[][] temporaryMapper;
    private ObjectSet<Consumer<Content>> initialization = new ObjectSet();
    private ContentList[] content = new ContentList[]{new Fx(), new Items(), new StatusEffects(), new Liquids(), new Bullets(), new Mechs(), new UnitTypes(), new Blocks(), new Loadouts(), new TechTree(), new Zones(), new TypeIDs(), new LegacyColorMapper()};

    public void clear() {
        this.contentNameMap = new ObjectMap[ContentType.values().length];
        this.contentMap = new Array[ContentType.values().length];
        this.initialization = new ObjectSet();
        this.loaded = false;
    }

    public void createContent() {
        if (this.loaded) {
            Log.info("Content already loaded, skipping.");
            return;
        }
        for (ContentType contentType : ContentType.values()) {
            this.contentMap[contentType.ordinal()] = new Array();
            this.contentNameMap[contentType.ordinal()] = new ObjectMap();
        }
        for (ContentList contentList : this.content) {
            contentList.load();
        }
        if (Vars.mods != null) {
            Vars.mods.loadContent();
        }
        for (Array<Content> array : this.contentMap) {
            for (int i = 0; i < array.size; ++i) {
                short id = array.get((int)i).id;
                if (id == i) continue;
                throw new IllegalArgumentException("Out-of-order IDs for content '" + array.get(i) + "' (expected " + i + " but got " + id + ")");
            }
        }
        this.loaded = true;
    }

    public void logContent() {
        Log.info("--- CONTENT INFO ---");
        for (int k = 0; k < this.contentMap.length; ++k) {
            Log.info("[{0}]: loaded {1}", ContentType.values()[k].name(), this.contentMap[k].size);
        }
        Log.info("Total content loaded: {0}", Array.with(ContentType.values()).mapInt(c -> this.contentMap[c.ordinal()].size).sum());
        Log.info("-------------------");
    }

    public void init() {
        this.initialize(Content::init);
    }

    public void load() {
        this.initialize(Content::load);
    }

    private void initialize(Consumer<Content> callable) {
        if (this.initialization.contains(callable)) {
            return;
        }
        for (ContentType type : ContentType.values()) {
            for (Content content : this.contentMap[type.ordinal()]) {
                try {
                    callable.accept(content);
                }
                catch (Throwable e) {
                    if (content.mod != null) {
                        Vars.mods.handleError(new Mods.ModLoadException(content, e), content.mod);
                        continue;
                    }
                    throw new RuntimeException(e);
                }
            }
        }
        this.initialization.add(callable);
    }

    public void loadColors() {
        Pixmap pixmap = new Pixmap(Core.files.internal("sprites/block_colors.png"));
        for (int i = 0; i < pixmap.getWidth(); ++i) {
            int color;
            if (this.blocks().size <= i || (color = pixmap.getPixel(i, 0)) == 0) continue;
            Block block = this.block(i);
            Color.rgba8888ToColor(block.color, color);
        }
        pixmap.dispose();
    }

    public void dispose() {
    }

    public void handleContent(Content content) {
        this.contentMap[content.getContentType().ordinal()].add(content);
    }

    public void handleMappableContent(MappableContent content) {
        if (this.contentNameMap[content.getContentType().ordinal()].containsKey(content.name)) {
            throw new IllegalArgumentException("Two content objects cannot have the same name! (issue: '" + content.name + "')");
        }
        this.contentNameMap[content.getContentType().ordinal()].put(content.name, content);
    }

    public void setTemporaryMapper(MappableContent[][] temporaryMapper) {
        this.temporaryMapper = temporaryMapper;
    }

    public Array<Content>[] getContentMap() {
        return this.contentMap;
    }

    public <T extends MappableContent> T getByName(ContentType type, String name) {
        if (this.contentNameMap[type.ordinal()] == null) {
            return null;
        }
        return (T)this.contentNameMap[type.ordinal()].get(name);
    }

    public <T extends Content> T getByID(ContentType type, int id) {
        if (this.temporaryMapper != null && this.temporaryMapper[type.ordinal()] != null && this.temporaryMapper[type.ordinal()].length != 0) {
            if (id < 0) {
                return null;
            }
            if (this.temporaryMapper[type.ordinal()].length <= id || this.temporaryMapper[type.ordinal()][id] == null) {
                return (T)this.contentMap[type.ordinal()].get(0);
            }
            return (T)this.temporaryMapper[type.ordinal()][id];
        }
        if (id >= this.contentMap[type.ordinal()].size || id < 0) {
            return null;
        }
        return (T)this.contentMap[type.ordinal()].get(id);
    }

    public <T extends Content> Array<T> getBy(ContentType type) {
        return this.contentMap[type.ordinal()];
    }

    public Array<Block> blocks() {
        return this.getBy(ContentType.block);
    }

    public Block block(int id) {
        return (Block)this.getByID(ContentType.block, id);
    }

    public Array<Item> items() {
        return this.getBy(ContentType.item);
    }

    public Item item(int id) {
        return (Item)this.getByID(ContentType.item, id);
    }

    public Array<Liquid> liquids() {
        return this.getBy(ContentType.liquid);
    }

    public Liquid liquid(int id) {
        return (Liquid)this.getByID(ContentType.liquid, id);
    }

    public Array<BulletType> bullets() {
        return this.getBy(ContentType.bullet);
    }

    public BulletType bullet(int id) {
        return (BulletType)this.getByID(ContentType.bullet, id);
    }

    public Array<Zone> zones() {
        return this.getBy(ContentType.zone);
    }

    public Array<UnitType> units() {
        return this.getBy(ContentType.unit);
    }
}

