/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.content;

import io.anuke.arc.collection.Array;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.ctype.ContentList;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.world.Block;

public class TechTree
implements ContentList {
    public static Array<TechNode> all;
    public static TechNode root;

    @Override
    public void load() {
        TechNode.context = null;
        all = new Array();
        root = TechTree.node(Blocks.coreShard, () -> {
            TechTree.node(Blocks.conveyor, () -> TechTree.node(Blocks.junction, () -> {
                TechTree.node(Blocks.itemBridge);
                TechTree.node(Blocks.router, () -> {
                    TechTree.node(Blocks.launchPad, () -> TechTree.node(Blocks.launchPadLarge, () -> {}));
                    TechTree.node(Blocks.distributor);
                    TechTree.node(Blocks.sorter, () -> {
                        TechTree.node(Blocks.invertedSorter);
                        TechTree.node(Blocks.message);
                        TechTree.node(Blocks.overflowGate);
                    });
                    TechTree.node(Blocks.container, () -> {
                        TechTree.node(Blocks.unloader);
                        TechTree.node(Blocks.vault, () -> {});
                    });
                    TechTree.node(Blocks.titaniumConveyor, () -> {
                        TechTree.node(Blocks.phaseConveyor, () -> TechTree.node(Blocks.massDriver, () -> {}));
                        TechTree.node(Blocks.armoredConveyor, () -> {});
                    });
                });
            }));
            TechTree.node(Blocks.duo, () -> {
                TechTree.node(Blocks.scatter, () -> TechTree.node(Blocks.hail, () -> TechTree.node(Blocks.salvo, () -> {
                    TechTree.node(Blocks.swarmer, () -> TechTree.node(Blocks.cyclone, () -> TechTree.node(Blocks.spectre, () -> {})));
                    TechTree.node(Blocks.ripple, () -> TechTree.node(Blocks.fuse, () -> {}));
                })));
                TechTree.node(Blocks.scorch, () -> TechTree.node(Blocks.arc, () -> {
                    TechTree.node(Blocks.wave, () -> {});
                    TechTree.node(Blocks.lancer, () -> {
                        TechTree.node(Blocks.meltdown, () -> {});
                        TechTree.node(Blocks.shockMine, () -> {});
                    });
                }));
                TechTree.node(Blocks.copperWall, () -> {
                    TechTree.node(Blocks.copperWallLarge);
                    TechTree.node(Blocks.titaniumWall, () -> {
                        TechTree.node(Blocks.door, () -> TechTree.node(Blocks.doorLarge));
                        TechTree.node(Blocks.titaniumWallLarge);
                        TechTree.node(Blocks.thoriumWall, () -> {
                            TechTree.node(Blocks.thoriumWallLarge);
                            TechTree.node(Blocks.surgeWall, () -> {
                                TechTree.node(Blocks.surgeWallLarge);
                                TechTree.node(Blocks.phaseWall, () -> TechTree.node(Blocks.phaseWallLarge));
                            });
                        });
                    });
                });
            });
            TechTree.node(Blocks.mechanicalDrill, () -> {
                TechTree.node(Blocks.graphitePress, () -> {
                    TechTree.node(Blocks.pneumaticDrill, () -> {
                        TechTree.node(Blocks.cultivator, () -> {});
                        TechTree.node(Blocks.laserDrill, () -> {
                            TechTree.node(Blocks.blastDrill, () -> {});
                            TechTree.node(Blocks.waterExtractor, () -> TechTree.node(Blocks.oilExtractor, () -> {}));
                        });
                    });
                    TechTree.node(Blocks.pyratiteMixer, () -> TechTree.node(Blocks.blastMixer, () -> {}));
                    TechTree.node(Blocks.siliconSmelter, () -> {
                        TechTree.node(Blocks.sporePress, () -> {
                            TechTree.node(Blocks.coalCentrifuge, () -> {});
                            TechTree.node(Blocks.multiPress, () -> {});
                            TechTree.node(Blocks.plastaniumCompressor, () -> TechTree.node(Blocks.phaseWeaver, () -> {}));
                        });
                        TechTree.node(Blocks.kiln, () -> TechTree.node(Blocks.incinerator, () -> TechTree.node(Blocks.melter, () -> {
                            TechTree.node(Blocks.surgeSmelter, () -> {});
                            TechTree.node(Blocks.separator, () -> TechTree.node(Blocks.pulverizer, () -> {}));
                            TechTree.node(Blocks.cryofluidMixer, () -> {});
                        })));
                    });
                });
                TechTree.node(Blocks.mechanicalPump, () -> TechTree.node(Blocks.conduit, () -> TechTree.node(Blocks.liquidJunction, () -> {
                    TechTree.node(Blocks.liquidRouter, () -> {
                        TechTree.node(Blocks.liquidTank);
                        TechTree.node(Blocks.pulseConduit, () -> TechTree.node(Blocks.phaseConduit, () -> {}));
                        TechTree.node(Blocks.rotaryPump, () -> TechTree.node(Blocks.thermalPump, () -> {}));
                    });
                    TechTree.node(Blocks.bridgeConduit);
                })));
                TechTree.node(Blocks.combustionGenerator, () -> {
                    TechTree.node(Blocks.powerNode, () -> {
                        TechTree.node(Blocks.powerNodeLarge, () -> TechTree.node(Blocks.surgeTower, () -> {}));
                        TechTree.node(Blocks.battery, () -> TechTree.node(Blocks.batteryLarge, () -> {}));
                        TechTree.node(Blocks.mender, () -> TechTree.node(Blocks.mendProjector, () -> {
                            TechTree.node(Blocks.forceProjector, () -> TechTree.node(Blocks.overdriveProjector, () -> {}));
                            TechTree.node(Blocks.repairPoint, () -> {});
                        }));
                        TechTree.node(Blocks.turbineGenerator, () -> TechTree.node(Blocks.thermalGenerator, () -> TechTree.node(Blocks.differentialGenerator, () -> TechTree.node(Blocks.thoriumReactor, () -> {
                            TechTree.node(Blocks.impactReactor, () -> {});
                            TechTree.node(Blocks.rtgGenerator, () -> {});
                        }))));
                        TechTree.node(Blocks.solarPanel, () -> TechTree.node(Blocks.largeSolarPanel, () -> {}));
                    });
                    TechTree.node(Blocks.draugFactory, () -> {
                        TechTree.node(Blocks.spiritFactory, () -> TechTree.node(Blocks.phantomFactory));
                        TechTree.node(Blocks.daggerFactory, () -> {
                            TechTree.node(Blocks.commandCenter, () -> {});
                            TechTree.node(Blocks.crawlerFactory, () -> TechTree.node(Blocks.titanFactory, () -> TechTree.node(Blocks.fortressFactory, () -> {})));
                            TechTree.node(Blocks.wraithFactory, () -> TechTree.node(Blocks.ghoulFactory, () -> TechTree.node(Blocks.revenantFactory, () -> {})));
                        });
                    });
                    TechTree.node(Blocks.dartPad, () -> TechTree.node(Blocks.deltaPad, () -> {
                        TechTree.node(Blocks.javelinPad, () -> TechTree.node(Blocks.tridentPad, () -> TechTree.node(Blocks.glaivePad)));
                        TechTree.node(Blocks.tauPad, () -> TechTree.node(Blocks.omegaPad, () -> {}));
                    }));
                });
            });
        });
    }

    private static TechNode node(Block block, Runnable children) {
        ItemStack[] requirements = new ItemStack[block.requirements.length];
        for (int i = 0; i < requirements.length; ++i) {
            requirements[i] = new ItemStack(block.requirements[i].item, 30 + block.requirements[i].amount * 6);
        }
        return new TechNode(block, requirements, children);
    }

    private static TechNode node(Block block) {
        return TechTree.node(block, () -> {});
    }

    public static TechNode create(Block parent, Block block) {
        TechNode.context = all.find(t -> t.block == parent);
        return TechTree.node(block, () -> {});
    }

    public static class TechNode {
        static TechNode context;
        public final Block block;
        public final ItemStack[] requirements;
        public final Array<TechNode> children = new Array();

        TechNode(TechNode ccontext, Block block, ItemStack[] requirements, Runnable children) {
            if (ccontext != null) {
                ccontext.children.add(this);
            }
            this.block = block;
            this.requirements = requirements;
            context = this;
            children.run();
            context = ccontext;
            all.add(this);
        }

        TechNode(Block block, ItemStack[] requirements, Runnable children) {
            this(context, block, requirements, children);
        }
    }
}

