/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.content;

import io.anuke.arc.Events;
import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.ctype.ContentList;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.type.StatusEffect;

public class StatusEffects
implements ContentList {
    public static StatusEffect none;
    public static StatusEffect burning;
    public static StatusEffect freezing;
    public static StatusEffect wet;
    public static StatusEffect melting;
    public static StatusEffect tarred;
    public static StatusEffect overdrive;
    public static StatusEffect shielded;
    public static StatusEffect shocked;
    public static StatusEffect corroded;
    public static StatusEffect boss;

    @Override
    public void load() {
        none = new StatusEffect();
        burning = new StatusEffect(){
            {
                this.damage = 0.06f;
                this.effect = Fx.burning;
                this.opposite(() -> wet, () -> freezing);
                this.trans(() -> tarred, (unit, time, newTime, result) -> {
                    unit.damage(1.0f);
                    Effects.effect(Fx.burning, unit.x + Mathf.range(unit.getSize() / 2.0f), unit.y + Mathf.range(unit.getSize() / 2.0f));
                    result.set(this, Math.min(time + newTime, 300.0f));
                });
            }
        };
        freezing = new StatusEffect(){
            {
                this.speedMultiplier = 0.6f;
                this.armorMultiplier = 0.8f;
                this.effect = Fx.freezing;
                this.opposite(() -> melting, () -> burning);
            }
        };
        wet = new StatusEffect(){
            {
                this.speedMultiplier = 0.9f;
                this.effect = Fx.wet;
                this.trans(() -> shocked, (unit, time, newTime, result) -> {
                    unit.damage(20.0f);
                    if (unit.getTeam() == Vars.waveTeam) {
                        Events.fire(EventType.Trigger.shock);
                    }
                    result.set(this, time);
                });
                this.opposite(() -> burning);
            }
        };
        melting = new StatusEffect(){
            {
                this.speedMultiplier = 0.8f;
                this.armorMultiplier = 0.8f;
                this.damage = 0.3f;
                this.effect = Fx.melting;
                this.trans(() -> tarred, (unit, time, newTime, result) -> result.set(this, Math.min(time + newTime / 2.0f, 140.0f)));
                this.opposite(() -> wet, () -> freezing);
            }
        };
        tarred = new StatusEffect(){
            {
                this.speedMultiplier = 0.6f;
                this.effect = Fx.oily;
                this.trans(() -> melting, (unit, time, newTime, result) -> result.set(burning, newTime + time));
                this.trans(() -> burning, (unit, time, newTime, result) -> result.set(burning, newTime + time));
            }
        };
        overdrive = new StatusEffect(){
            {
                this.armorMultiplier = 0.95f;
                this.speedMultiplier = 1.15f;
                this.damageMultiplier = 1.4f;
                this.damage = -0.01f;
                this.effect = Fx.overdriven;
            }
        };
        shielded = new StatusEffect(){
            {
                this.armorMultiplier = 3.0f;
            }
        };
        boss = new StatusEffect(){
            {
                this.armorMultiplier = 3.0f;
                this.damageMultiplier = 3.0f;
                this.speedMultiplier = 1.1f;
            }
        };
        shocked = new StatusEffect();
        corroded = new StatusEffect(){
            {
                this.damage = 0.1f;
            }
        };
    }
}

