/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.content;

import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.CapStyle;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Fill;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.Tmp;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.content.Liquids;
import io.anuke.mindustry.content.StatusEffects;
import io.anuke.mindustry.ctype.ContentList;
import io.anuke.mindustry.entities.Damage;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.bullet.ArtilleryBulletType;
import io.anuke.mindustry.entities.bullet.BasicBulletType;
import io.anuke.mindustry.entities.bullet.BombBulletType;
import io.anuke.mindustry.entities.bullet.BulletType;
import io.anuke.mindustry.entities.bullet.FlakBulletType;
import io.anuke.mindustry.entities.bullet.HealBulletType;
import io.anuke.mindustry.entities.bullet.LiquidBulletType;
import io.anuke.mindustry.entities.bullet.MassDriverBolt;
import io.anuke.mindustry.entities.bullet.MissileBulletType;
import io.anuke.mindustry.entities.effect.Fire;
import io.anuke.mindustry.entities.effect.Lightning;
import io.anuke.mindustry.entities.effect.Puddle;
import io.anuke.mindustry.entities.type.Bullet;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.world.Tile;

public class Bullets
implements ContentList {
    public static BulletType artilleryDense;
    public static BulletType arilleryPlastic;
    public static BulletType artilleryPlasticFrag;
    public static BulletType artilleryHoming;
    public static BulletType artlleryIncendiary;
    public static BulletType artilleryExplosive;
    public static BulletType artilleryUnit;
    public static BulletType flakScrap;
    public static BulletType flakLead;
    public static BulletType flakPlastic;
    public static BulletType flakExplosive;
    public static BulletType flakSurge;
    public static BulletType flakGlass;
    public static BulletType glassFrag;
    public static BulletType missileExplosive;
    public static BulletType missileIncendiary;
    public static BulletType missileSurge;
    public static BulletType missileJavelin;
    public static BulletType missileSwarm;
    public static BulletType missileRevenant;
    public static BulletType standardCopper;
    public static BulletType standardDense;
    public static BulletType standardThorium;
    public static BulletType standardHoming;
    public static BulletType standardIncendiary;
    public static BulletType standardMechSmall;
    public static BulletType standardGlaive;
    public static BulletType standardDenseBig;
    public static BulletType standardThoriumBig;
    public static BulletType standardIncendiaryBig;
    public static BulletType lancerLaser;
    public static BulletType meltdownLaser;
    public static BulletType lightning;
    public static BulletType arc;
    public static BulletType damageLightning;
    public static BulletType waterShot;
    public static BulletType cryoShot;
    public static BulletType slagShot;
    public static BulletType oilShot;
    public static BulletType fireball;
    public static BulletType basicFlame;
    public static BulletType pyraFlame;
    public static BulletType driverBolt;
    public static BulletType healBullet;
    public static BulletType healBulletBig;
    public static BulletType frag;
    public static BulletType eruptorShot;
    public static BulletType bombExplosive;
    public static BulletType bombIncendiary;
    public static BulletType bombOil;

    @Override
    public void load() {
        artilleryDense = new ArtilleryBulletType(3.0f, 0.0f, "shell"){
            {
                this.hitEffect = Fx.flakExplosion;
                this.knockback = 0.8f;
                this.lifetime = 50.0f;
                this.bulletHeight = 11.0f;
                this.bulletWidth = 11.0f;
                this.collidesTiles = false;
                this.splashDamageRadius = 25.0f;
                this.splashDamage = 33.0f;
            }
        };
        artilleryPlasticFrag = new BasicBulletType(2.5f, 10.0f, "bullet"){
            {
                this.bulletWidth = 10.0f;
                this.bulletHeight = 12.0f;
                this.bulletShrink = 1.0f;
                this.lifetime = 15.0f;
                this.backColor = Pal.plastaniumBack;
                this.frontColor = Pal.plastaniumFront;
                this.despawnEffect = Fx.none;
            }
        };
        arilleryPlastic = new ArtilleryBulletType(3.4f, 0.0f, "shell"){
            {
                this.hitEffect = Fx.plasticExplosion;
                this.knockback = 1.0f;
                this.lifetime = 55.0f;
                this.bulletHeight = 13.0f;
                this.bulletWidth = 13.0f;
                this.collidesTiles = false;
                this.splashDamageRadius = 35.0f;
                this.splashDamage = 45.0f;
                this.fragBullet = artilleryPlasticFrag;
                this.fragBullets = 10;
                this.backColor = Pal.plastaniumBack;
                this.frontColor = Pal.plastaniumFront;
            }
        };
        artilleryHoming = new ArtilleryBulletType(3.0f, 0.0f, "shell"){
            {
                this.hitEffect = Fx.flakExplosion;
                this.knockback = 0.8f;
                this.lifetime = 45.0f;
                this.bulletHeight = 11.0f;
                this.bulletWidth = 11.0f;
                this.collidesTiles = false;
                this.splashDamageRadius = 25.0f;
                this.splashDamage = 33.0f;
                this.homingPower = 2.0f;
                this.homingRange = 50.0f;
            }
        };
        artlleryIncendiary = new ArtilleryBulletType(3.0f, 0.0f, "shell"){
            {
                this.hitEffect = Fx.blastExplosion;
                this.knockback = 0.8f;
                this.lifetime = 60.0f;
                this.bulletHeight = 13.0f;
                this.bulletWidth = 13.0f;
                this.collidesTiles = false;
                this.splashDamageRadius = 25.0f;
                this.splashDamage = 30.0f;
                this.status = StatusEffects.burning;
                this.frontColor = Pal.lightishOrange;
                this.backColor = Pal.lightOrange;
                this.trailEffect = Fx.incendTrail;
            }
        };
        artilleryExplosive = new ArtilleryBulletType(2.0f, 0.0f, "shell"){
            {
                this.hitEffect = Fx.blastExplosion;
                this.knockback = 0.8f;
                this.lifetime = 70.0f;
                this.bulletHeight = 14.0f;
                this.bulletWidth = 14.0f;
                this.collidesTiles = false;
                this.ammoMultiplier = 4.0f;
                this.splashDamageRadius = 45.0f;
                this.splashDamage = 50.0f;
                this.backColor = Pal.missileYellowBack;
                this.frontColor = Pal.missileYellow;
            }
        };
        artilleryUnit = new ArtilleryBulletType(2.0f, 0.0f, "shell"){
            {
                this.hitEffect = Fx.blastExplosion;
                this.knockback = 0.8f;
                this.lifetime = 90.0f;
                this.bulletHeight = 14.0f;
                this.bulletWidth = 14.0f;
                this.collides = true;
                this.collidesTiles = true;
                this.splashDamageRadius = 20.0f;
                this.splashDamage = 38.0f;
                this.backColor = Pal.bulletYellowBack;
                this.frontColor = Pal.bulletYellow;
            }
        };
        glassFrag = new BasicBulletType(3.0f, 6.0f, "bullet"){
            {
                this.bulletWidth = 5.0f;
                this.bulletHeight = 12.0f;
                this.bulletShrink = 1.0f;
                this.lifetime = 20.0f;
                this.backColor = Pal.gray;
                this.frontColor = Color.white;
                this.despawnEffect = Fx.none;
            }
        };
        flakLead = new FlakBulletType(4.2f, 3.0f){
            {
                this.lifetime = 60.0f;
                this.ammoMultiplier = 4.0f;
                this.shootEffect = Fx.shootSmall;
                this.bulletWidth = 6.0f;
                this.bulletHeight = 8.0f;
                this.hitEffect = Fx.flakExplosion;
                this.splashDamage = 27.0f;
                this.splashDamageRadius = 15.0f;
            }
        };
        flakScrap = new FlakBulletType(4.0f, 3.0f){
            {
                this.lifetime = 60.0f;
                this.ammoMultiplier = 5.0f;
                this.shootEffect = Fx.shootSmall;
                this.reloadMultiplier = 0.5f;
                this.bulletWidth = 6.0f;
                this.bulletHeight = 8.0f;
                this.hitEffect = Fx.flakExplosion;
                this.splashDamage = 22.0f;
                this.splashDamageRadius = 24.0f;
            }
        };
        flakGlass = new FlakBulletType(4.0f, 3.0f){
            {
                this.lifetime = 70.0f;
                this.ammoMultiplier = 5.0f;
                this.shootEffect = Fx.shootSmall;
                this.reloadMultiplier = 0.8f;
                this.bulletWidth = 6.0f;
                this.bulletHeight = 8.0f;
                this.hitEffect = Fx.flakExplosion;
                this.splashDamage = 30.0f;
                this.splashDamageRadius = 26.0f;
                this.fragBullet = glassFrag;
                this.fragBullets = 6;
            }
        };
        flakPlastic = new FlakBulletType(4.0f, 6.0f){
            {
                this.splashDamageRadius = 50.0f;
                this.splashDamage = 25.0f;
                this.fragBullet = artilleryPlasticFrag;
                this.fragBullets = 6;
                this.hitEffect = Fx.plasticExplosion;
                this.frontColor = Pal.plastaniumFront;
                this.backColor = Pal.plastaniumBack;
                this.shootEffect = Fx.shootBig;
            }
        };
        flakExplosive = new FlakBulletType(4.0f, 5.0f){
            {
                this.shootEffect = Fx.shootBig;
                this.ammoMultiplier = 4.0f;
            }
        };
        flakSurge = new FlakBulletType(4.0f, 7.0f){
            {
                this.splashDamage = 33.0f;
                this.lightining = 2;
                this.lightningLength = 12;
                this.shootEffect = Fx.shootBig;
            }
        };
        missileExplosive = new MissileBulletType(2.7f, 10.0f, "missile"){
            {
                this.bulletWidth = 8.0f;
                this.bulletHeight = 8.0f;
                this.bulletShrink = 0.0f;
                this.drag = -0.01f;
                this.splashDamageRadius = 30.0f;
                this.splashDamage = 30.0f;
                this.ammoMultiplier = 4.0f;
                this.lifetime = 150.0f;
                this.hitEffect = Fx.blastExplosion;
                this.despawnEffect = Fx.blastExplosion;
            }
        };
        missileIncendiary = new MissileBulletType(2.9f, 12.0f, "missile"){
            {
                this.frontColor = Pal.lightishOrange;
                this.backColor = Pal.lightOrange;
                this.bulletWidth = 7.0f;
                this.bulletHeight = 8.0f;
                this.bulletShrink = 0.0f;
                this.drag = -0.01f;
                this.homingPower = 7.0f;
                this.splashDamageRadius = 10.0f;
                this.splashDamage = 10.0f;
                this.lifetime = 160.0f;
                this.hitEffect = Fx.blastExplosion;
                this.status = StatusEffects.burning;
            }
        };
        missileSurge = new MissileBulletType(4.4f, 15.0f, "bullet"){
            {
                this.bulletWidth = 8.0f;
                this.bulletHeight = 8.0f;
                this.bulletShrink = 0.0f;
                this.drag = -0.01f;
                this.splashDamageRadius = 30.0f;
                this.splashDamage = 22.0f;
                this.lifetime = 150.0f;
                this.hitEffect = Fx.blastExplosion;
                this.despawnEffect = Fx.blastExplosion;
                this.lightining = 2;
                this.lightningLength = 14;
            }
        };
        missileJavelin = new MissileBulletType(5.0f, 10.5f, "missile"){
            {
                this.bulletWidth = 8.0f;
                this.bulletHeight = 8.0f;
                this.bulletShrink = 0.0f;
                this.drag = -0.003f;
                this.keepVelocity = false;
                this.splashDamageRadius = 20.0f;
                this.splashDamage = 1.0f;
                this.lifetime = 90.0f;
                this.trailColor = Color.valueOf("b6c6fd");
                this.hitEffect = Fx.blastExplosion;
                this.despawnEffect = Fx.blastExplosion;
                this.backColor = Pal.bulletYellowBack;
                this.frontColor = Pal.bulletYellow;
                this.weaveScale = 8.0f;
                this.weaveMag = 2.0f;
            }
        };
        missileSwarm = new MissileBulletType(2.7f, 12.0f, "missile"){
            {
                this.bulletWidth = 8.0f;
                this.bulletHeight = 8.0f;
                this.bulletShrink = 0.0f;
                this.drag = -0.003f;
                this.homingRange = 60.0f;
                this.keepVelocity = false;
                this.splashDamageRadius = 25.0f;
                this.splashDamage = 10.0f;
                this.lifetime = 120.0f;
                this.trailColor = Color.gray;
                this.backColor = Pal.bulletYellowBack;
                this.frontColor = Pal.bulletYellow;
                this.hitEffect = Fx.blastExplosion;
                this.despawnEffect = Fx.blastExplosion;
                this.weaveScale = 8.0f;
                this.weaveMag = 2.0f;
            }
        };
        missileRevenant = new MissileBulletType(2.7f, 12.0f, "missile"){
            {
                this.bulletWidth = 8.0f;
                this.bulletHeight = 8.0f;
                this.bulletShrink = 0.0f;
                this.drag = -0.003f;
                this.homingRange = 60.0f;
                this.keepVelocity = false;
                this.splashDamageRadius = 25.0f;
                this.splashDamage = 10.0f;
                this.lifetime = 60.0f;
                this.trailColor = Pal.unitBack;
                this.backColor = Pal.unitBack;
                this.frontColor = Pal.unitFront;
                this.hitEffect = Fx.blastExplosion;
                this.despawnEffect = Fx.blastExplosion;
                this.weaveScale = 6.0f;
                this.weaveMag = 1.0f;
            }
        };
        standardCopper = new BasicBulletType(2.5f, 9.0f, "bullet"){
            {
                this.bulletWidth = 7.0f;
                this.bulletHeight = 9.0f;
                this.lifetime = 60.0f;
                this.shootEffect = Fx.shootSmall;
                this.smokeEffect = Fx.shootSmallSmoke;
                this.ammoMultiplier = 2.0f;
            }
        };
        standardDense = new BasicBulletType(3.5f, 18.0f, "bullet"){
            {
                this.bulletWidth = 9.0f;
                this.bulletHeight = 12.0f;
                this.reloadMultiplier = 0.6f;
                this.ammoMultiplier = 4.0f;
                this.lifetime = 60.0f;
            }
        };
        standardThorium = new BasicBulletType(4.0f, 29.0f, "bullet"){
            {
                this.bulletWidth = 10.0f;
                this.bulletHeight = 13.0f;
                this.shootEffect = Fx.shootBig;
                this.smokeEffect = Fx.shootBigSmoke;
                this.ammoMultiplier = 4.0f;
                this.lifetime = 60.0f;
            }
        };
        standardHoming = new BasicBulletType(3.0f, 9.0f, "bullet"){
            {
                this.bulletWidth = 7.0f;
                this.bulletHeight = 9.0f;
                this.homingPower = 5.0f;
                this.reloadMultiplier = 1.4f;
                this.ammoMultiplier = 5.0f;
                this.lifetime = 60.0f;
            }
        };
        standardIncendiary = new BasicBulletType(3.2f, 11.0f, "bullet"){
            {
                this.bulletWidth = 10.0f;
                this.bulletHeight = 12.0f;
                this.frontColor = Pal.lightishOrange;
                this.backColor = Pal.lightOrange;
                this.status = StatusEffects.burning;
                this.inaccuracy = 3.0f;
                this.lifetime = 60.0f;
            }
        };
        standardGlaive = new BasicBulletType(4.0f, 7.5f, "bullet"){
            {
                this.bulletWidth = 10.0f;
                this.bulletHeight = 12.0f;
                this.frontColor = Color.valueOf("feb380");
                this.backColor = Color.valueOf("ea8878");
                this.status = StatusEffects.burning;
                this.lifetime = 60.0f;
            }
        };
        standardMechSmall = new BasicBulletType(4.0f, 9.0f, "bullet"){
            {
                this.bulletWidth = 11.0f;
                this.bulletHeight = 14.0f;
                this.lifetime = 40.0f;
                this.inaccuracy = 5.0f;
                this.despawnEffect = Fx.hitBulletSmall;
            }
        };
        standardDenseBig = new BasicBulletType(7.0f, 42.0f, "bullet"){
            {
                this.bulletWidth = 15.0f;
                this.bulletHeight = 21.0f;
                this.shootEffect = Fx.shootBig;
            }
        };
        standardThoriumBig = new BasicBulletType(8.0f, 65.0f, "bullet"){
            {
                this.bulletWidth = 16.0f;
                this.bulletHeight = 23.0f;
                this.shootEffect = Fx.shootBig;
            }
        };
        standardIncendiaryBig = new BasicBulletType(7.0f, 38.0f, "bullet"){
            {
                this.bulletWidth = 16.0f;
                this.bulletHeight = 21.0f;
                this.frontColor = Pal.lightishOrange;
                this.backColor = Pal.lightOrange;
                this.status = StatusEffects.burning;
                this.shootEffect = Fx.shootBig;
            }
        };
        damageLightning = new BulletType(1.0E-4f, 0.0f){
            {
                this.lifetime = 10.0f;
                this.hitEffect = Fx.hitLancer;
                this.despawnEffect = Fx.none;
                this.status = StatusEffects.shocked;
                this.statusDuration = 10.0f;
            }
        };
        healBullet = new HealBulletType(5.2f, 13.0f){
            {
                this.healPercent = 3.0f;
            }
        };
        healBulletBig = new HealBulletType(5.2f, 15.0f){
            {
                this.healPercent = 5.5f;
            }
        };
        fireball = new BulletType(1.0f, 4.0f){
            {
                this.pierce = true;
                this.hitTiles = false;
                this.collides = false;
                this.collidesTiles = false;
                this.drag = 0.03f;
                this.hitEffect = this.despawnEffect = Fx.none;
            }

            @Override
            public void init(Bullet b) {
                b.velocity().setLength(0.6f + Mathf.random(2.0f));
            }

            @Override
            public void draw(Bullet b) {
                Draw.color(Pal.lightFlame, Pal.darkFlame, Color.gray, b.fin());
                Fill.circle(b.x, b.y, 3.0f * b.fout());
                Draw.reset();
            }

            @Override
            public void update(Bullet b) {
                Tile tile;
                if (Mathf.chance(0.04 * (double)Time.delta()) && (tile = Vars.world.tileWorld(b.x, b.y)) != null) {
                    Fire.create(tile);
                }
                if (Mathf.chance(0.1 * (double)Time.delta())) {
                    Effects.effect(Fx.fireballsmoke, b.x, b.y);
                }
                if (Mathf.chance(0.1 * (double)Time.delta())) {
                    Effects.effect(Fx.ballfire, b.x, b.y);
                }
            }
        };
        basicFlame = new BulletType(3.0f, 6.0f){
            {
                this.ammoMultiplier = 3.0f;
                this.hitSize = 7.0f;
                this.lifetime = 42.0f;
                this.pierce = true;
                this.drag = 0.05f;
                this.statusDuration = 240.0f;
                this.shootEffect = Fx.shootSmallFlame;
                this.hitEffect = Fx.hitFlameSmall;
                this.despawnEffect = Fx.none;
                this.status = StatusEffects.burning;
            }

            @Override
            public float range() {
                return 50.0f;
            }

            @Override
            public void draw(Bullet b) {
            }
        };
        pyraFlame = new BulletType(3.3f, 9.0f){
            {
                this.ammoMultiplier = 4.0f;
                this.hitSize = 7.0f;
                this.lifetime = 42.0f;
                this.pierce = true;
                this.drag = 0.05f;
                this.statusDuration = 360.0f;
                this.shootEffect = Fx.shootPyraFlame;
                this.hitEffect = Fx.hitFlameSmall;
                this.despawnEffect = Fx.none;
                this.status = StatusEffects.burning;
            }

            @Override
            public void draw(Bullet b) {
            }
        };
        lancerLaser = new BulletType(0.001f, 140.0f){
            Color[] colors;
            float[] tscales;
            float[] lenscales;
            float length;
            {
                this.colors = new Color[]{Pal.lancerLaser.cpy().mul(1.0f, 1.0f, 1.0f, 0.4f), Pal.lancerLaser, Color.white};
                this.tscales = new float[]{1.0f, 0.7f, 0.5f, 0.2f};
                this.lenscales = new float[]{1.0f, 1.1f, 1.13f, 1.14f};
                this.length = 160.0f;
                this.hitEffect = Fx.hitLancer;
                this.despawnEffect = Fx.none;
                this.hitSize = 4.0f;
                this.lifetime = 16.0f;
                this.pierce = true;
            }

            @Override
            public float range() {
                return this.length;
            }

            @Override
            public void init(Bullet b) {
                Damage.collideLine(b, b.getTeam(), this.hitEffect, b.x, b.y, b.rot(), this.length);
            }

            @Override
            public void draw(Bullet b) {
                float f = Mathf.curve(b.fin(), 0.0f, 0.2f);
                float baseLen = this.length * f;
                Lines.lineAngle(b.x, b.y, b.rot(), baseLen);
                for (int s = 0; s < 3; ++s) {
                    Draw.color(this.colors[s]);
                    for (int i = 0; i < this.tscales.length; ++i) {
                        Lines.stroke(7.0f * b.fout() * (s == 0 ? 1.5f : (s == 1 ? 1.0f : 0.3f)) * this.tscales[i]);
                        Lines.lineAngle(b.x, b.y, b.rot(), baseLen * this.lenscales[i]);
                    }
                }
                Draw.reset();
            }
        };
        meltdownLaser = new BulletType(0.001f, 70.0f){
            Color tmpColor;
            Color[] colors;
            float[] tscales;
            float[] strokes;
            float[] lenscales;
            float length;
            {
                this.tmpColor = new Color();
                this.colors = new Color[]{Color.valueOf("ec745855"), Color.valueOf("ec7458aa"), Color.valueOf("ff9c5a"), Color.white};
                this.tscales = new float[]{1.0f, 0.7f, 0.5f, 0.2f};
                this.strokes = new float[]{2.0f, 1.5f, 1.0f, 0.3f};
                this.lenscales = new float[]{1.0f, 1.12f, 1.15f, 1.17f};
                this.length = 220.0f;
                this.hitEffect = Fx.hitMeltdown;
                this.despawnEffect = Fx.none;
                this.hitSize = 4.0f;
                this.drawSize = 420.0f;
                this.lifetime = 16.0f;
                this.pierce = true;
            }

            @Override
            public void update(Bullet b) {
                if (b.timer.get(1, 5.0f)) {
                    Damage.collideLine(b, b.getTeam(), this.hitEffect, b.x, b.y, b.rot(), this.length, true);
                }
                Effects.shake(1.0f, 1.0f, b.x, b.y);
            }

            @Override
            public void hit(Bullet b, float hitx, float hity) {
                Effects.effect(this.hitEffect, this.colors[2], hitx, hity);
                if (Mathf.chance(0.4)) {
                    Fire.create(Vars.world.tileWorld(hitx + Mathf.range(5.0f), hity + Mathf.range(5.0f)));
                }
            }

            @Override
            public void draw(Bullet b) {
                float baseLen = this.length * b.fout();
                Lines.lineAngle(b.x, b.y, b.rot(), baseLen);
                for (int s = 0; s < this.colors.length; ++s) {
                    Draw.color(this.tmpColor.set(this.colors[s]).mul(1.0f + Mathf.absin(Time.time(), 1.0f, 0.1f)));
                    for (int i = 0; i < this.tscales.length; ++i) {
                        Tmp.v1.trns(b.rot() + 180.0f, (this.lenscales[i] - 1.0f) * 35.0f);
                        Lines.stroke((9.0f + Mathf.absin(Time.time(), 0.8f, 1.5f)) * b.fout() * this.strokes[s] * this.tscales[i]);
                        Lines.lineAngle(b.x + Tmp.v1.x, b.y + Tmp.v1.y, b.rot(), baseLen * this.lenscales[i], CapStyle.none);
                    }
                }
                Draw.reset();
            }
        };
        waterShot = new LiquidBulletType(Liquids.water){
            {
                this.knockback = 0.7f;
            }
        };
        cryoShot = new LiquidBulletType(Liquids.cryofluid){};
        slagShot = new LiquidBulletType(Liquids.slag){
            {
                this.damage = 4.0f;
                this.drag = 0.03f;
            }
        };
        eruptorShot = new LiquidBulletType(Liquids.slag){
            {
                this.damage = 2.0f;
                this.speed = 2.1f;
                this.drag = 0.02f;
            }
        };
        oilShot = new LiquidBulletType(Liquids.oil){
            {
                this.drag = 0.03f;
            }
        };
        lightning = new BulletType(0.001f, 12.0f){
            {
                this.lifetime = 1.0f;
                this.shootEffect = Fx.hitLancer;
                this.smokeEffect = Fx.none;
                this.despawnEffect = Fx.none;
                this.hitEffect = Fx.hitLancer;
                this.keepVelocity = false;
            }

            @Override
            public float range() {
                return 70.0f;
            }

            @Override
            public void draw(Bullet b) {
            }

            @Override
            public void init(Bullet b) {
                Lightning.create(b.getTeam(), Pal.lancerLaser, this.damage * (b.getOwner() instanceof Player ? Vars.state.rules.playerDamageMultiplier : 1.0f), b.x, b.y, b.rot(), 30);
            }
        };
        arc = new BulletType(0.001f, 21.0f){
            {
                this.lifetime = 1.0f;
                this.despawnEffect = Fx.none;
                this.hitEffect = Fx.hitLancer;
            }

            @Override
            public void draw(Bullet b) {
            }

            @Override
            public void init(Bullet b) {
                Lightning.create(b.getTeam(), Pal.lancerLaser, this.damage, b.x, b.y, b.rot(), 25);
            }
        };
        driverBolt = new MassDriverBolt();
        frag = new BasicBulletType(5.0f, 8.0f, "bullet"){
            {
                this.bulletWidth = 8.0f;
                this.bulletHeight = 9.0f;
                this.bulletShrink = 0.5f;
                this.lifetime = 50.0f;
                this.drag = 0.04f;
            }
        };
        bombExplosive = new BombBulletType(10.0f, 20.0f, "shell"){
            {
                this.bulletWidth = 9.0f;
                this.bulletHeight = 13.0f;
                this.hitEffect = Fx.flakExplosion;
                this.shootEffect = Fx.none;
                this.smokeEffect = Fx.none;
            }
        };
        bombIncendiary = new BombBulletType(7.0f, 10.0f, "shell"){
            {
                this.bulletWidth = 8.0f;
                this.bulletHeight = 12.0f;
                this.hitEffect = Fx.flakExplosion;
                this.backColor = Pal.lightOrange;
                this.frontColor = Pal.lightishOrange;
                this.incendChance = 1.0f;
                this.incendAmount = 3;
                this.incendSpread = 10.0f;
            }
        };
        bombOil = new BombBulletType(2.0f, 3.0f, "shell"){
            {
                this.bulletWidth = 8.0f;
                this.bulletHeight = 12.0f;
                this.hitEffect = Fx.pulverize;
                this.backColor = new Color(0x4F4F4FFF);
                this.frontColor = Color.gray;
            }

            @Override
            public void hit(Bullet b, float x, float y) {
                super.hit(b, x, y);
                for (int i = 0; i < 3; ++i) {
                    Tile tile = Vars.world.tileWorld(x + Mathf.range(8.0f), y + Mathf.range(8.0f));
                    Puddle.deposit(tile, Liquids.oil, 5.0f);
                }
            }
        };
    }
}

