/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.content;

import io.anuke.arc.Core;
import io.anuke.arc.collection.EnumSet;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Tmp;
import io.anuke.mindustry.content.Bullets;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.content.Items;
import io.anuke.mindustry.content.Liquids;
import io.anuke.mindustry.content.Mechs;
import io.anuke.mindustry.content.StatusEffects;
import io.anuke.mindustry.content.UnitTypes;
import io.anuke.mindustry.ctype.ContentList;
import io.anuke.mindustry.entities.Damage;
import io.anuke.mindustry.entities.bullet.BulletType;
import io.anuke.mindustry.entities.type.Bullet;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.graphics.CacheLayer;
import io.anuke.mindustry.graphics.Drawf;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.type.Category;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.type.LiquidStack;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.StaticTree;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.BlockPart;
import io.anuke.mindustry.world.blocks.BuildBlock;
import io.anuke.mindustry.world.blocks.DoubleOverlayFloor;
import io.anuke.mindustry.world.blocks.Floor;
import io.anuke.mindustry.world.blocks.OreBlock;
import io.anuke.mindustry.world.blocks.OverlayFloor;
import io.anuke.mindustry.world.blocks.Rock;
import io.anuke.mindustry.world.blocks.StaticWall;
import io.anuke.mindustry.world.blocks.TreeBlock;
import io.anuke.mindustry.world.blocks.defense.DeflectorWall;
import io.anuke.mindustry.world.blocks.defense.Door;
import io.anuke.mindustry.world.blocks.defense.ForceProjector;
import io.anuke.mindustry.world.blocks.defense.MendProjector;
import io.anuke.mindustry.world.blocks.defense.OverdriveProjector;
import io.anuke.mindustry.world.blocks.defense.ShockMine;
import io.anuke.mindustry.world.blocks.defense.SurgeWall;
import io.anuke.mindustry.world.blocks.defense.Wall;
import io.anuke.mindustry.world.blocks.defense.turrets.ArtilleryTurret;
import io.anuke.mindustry.world.blocks.defense.turrets.BurstTurret;
import io.anuke.mindustry.world.blocks.defense.turrets.ChargeTurret;
import io.anuke.mindustry.world.blocks.defense.turrets.DoubleTurret;
import io.anuke.mindustry.world.blocks.defense.turrets.ItemTurret;
import io.anuke.mindustry.world.blocks.defense.turrets.LaserTurret;
import io.anuke.mindustry.world.blocks.defense.turrets.LiquidTurret;
import io.anuke.mindustry.world.blocks.defense.turrets.PowerTurret;
import io.anuke.mindustry.world.blocks.distribution.ArmoredConveyor;
import io.anuke.mindustry.world.blocks.distribution.BufferedItemBridge;
import io.anuke.mindustry.world.blocks.distribution.Conduit;
import io.anuke.mindustry.world.blocks.distribution.Conveyor;
import io.anuke.mindustry.world.blocks.distribution.ItemBridge;
import io.anuke.mindustry.world.blocks.distribution.Junction;
import io.anuke.mindustry.world.blocks.distribution.LiquidBridge;
import io.anuke.mindustry.world.blocks.distribution.LiquidExtendingBridge;
import io.anuke.mindustry.world.blocks.distribution.LiquidJunction;
import io.anuke.mindustry.world.blocks.distribution.LiquidRouter;
import io.anuke.mindustry.world.blocks.distribution.LiquidTank;
import io.anuke.mindustry.world.blocks.distribution.MassDriver;
import io.anuke.mindustry.world.blocks.distribution.OverflowGate;
import io.anuke.mindustry.world.blocks.distribution.Router;
import io.anuke.mindustry.world.blocks.distribution.Sorter;
import io.anuke.mindustry.world.blocks.logic.MessageBlock;
import io.anuke.mindustry.world.blocks.power.Battery;
import io.anuke.mindustry.world.blocks.power.BurnerGenerator;
import io.anuke.mindustry.world.blocks.power.DecayGenerator;
import io.anuke.mindustry.world.blocks.power.ImpactReactor;
import io.anuke.mindustry.world.blocks.power.NuclearReactor;
import io.anuke.mindustry.world.blocks.power.PowerNode;
import io.anuke.mindustry.world.blocks.power.SingleTypeGenerator;
import io.anuke.mindustry.world.blocks.power.SolarGenerator;
import io.anuke.mindustry.world.blocks.power.ThermalGenerator;
import io.anuke.mindustry.world.blocks.production.Cultivator;
import io.anuke.mindustry.world.blocks.production.Drill;
import io.anuke.mindustry.world.blocks.production.Fracker;
import io.anuke.mindustry.world.blocks.production.GenericCrafter;
import io.anuke.mindustry.world.blocks.production.GenericSmelter;
import io.anuke.mindustry.world.blocks.production.Incinerator;
import io.anuke.mindustry.world.blocks.production.LiquidConverter;
import io.anuke.mindustry.world.blocks.production.Pump;
import io.anuke.mindustry.world.blocks.production.Separator;
import io.anuke.mindustry.world.blocks.production.SolidPump;
import io.anuke.mindustry.world.blocks.sandbox.ItemSource;
import io.anuke.mindustry.world.blocks.sandbox.ItemVoid;
import io.anuke.mindustry.world.blocks.sandbox.LiquidSource;
import io.anuke.mindustry.world.blocks.sandbox.PowerSource;
import io.anuke.mindustry.world.blocks.sandbox.PowerVoid;
import io.anuke.mindustry.world.blocks.storage.CoreBlock;
import io.anuke.mindustry.world.blocks.storage.LaunchPad;
import io.anuke.mindustry.world.blocks.storage.Unloader;
import io.anuke.mindustry.world.blocks.storage.Vault;
import io.anuke.mindustry.world.blocks.units.CommandCenter;
import io.anuke.mindustry.world.blocks.units.MechPad;
import io.anuke.mindustry.world.blocks.units.RepairPoint;
import io.anuke.mindustry.world.blocks.units.UnitFactory;
import io.anuke.mindustry.world.consumers.ConsumeLiquidFilter;
import io.anuke.mindustry.world.meta.Attribute;
import io.anuke.mindustry.world.meta.BlockFlag;
import io.anuke.mindustry.world.meta.BuildVisibility;
import io.anuke.mindustry.world.modules.LiquidModule;

public class Blocks
implements ContentList {
    public static Block air;
    public static Block spawn;
    public static Block deepwater;
    public static Block water;
    public static Block taintedWater;
    public static Block tar;
    public static Block stone;
    public static Block craters;
    public static Block charr;
    public static Block sand;
    public static Block darksand;
    public static Block ice;
    public static Block snow;
    public static Block darksandTaintedWater;
    public static Block holostone;
    public static Block rocks;
    public static Block sporerocks;
    public static Block icerocks;
    public static Block cliffs;
    public static Block sporePine;
    public static Block snowPine;
    public static Block pine;
    public static Block shrubs;
    public static Block whiteTree;
    public static Block whiteTreeDead;
    public static Block sporeCluster;
    public static Block iceSnow;
    public static Block sandWater;
    public static Block darksandWater;
    public static Block duneRocks;
    public static Block sandRocks;
    public static Block moss;
    public static Block sporeMoss;
    public static Block shale;
    public static Block shaleRocks;
    public static Block shaleBoulder;
    public static Block sandBoulder;
    public static Block grass;
    public static Block salt;
    public static Block metalFloor;
    public static Block metalFloorDamaged;
    public static Block metalFloor2;
    public static Block metalFloor3;
    public static Block metalFloor5;
    public static Block ignarock;
    public static Block magmarock;
    public static Block hotrock;
    public static Block snowrocks;
    public static Block rock;
    public static Block snowrock;
    public static Block saltRocks;
    public static Block darkPanel1;
    public static Block darkPanel2;
    public static Block darkPanel3;
    public static Block darkPanel4;
    public static Block darkPanel5;
    public static Block darkPanel6;
    public static Block darkMetal;
    public static Block pebbles;
    public static Block tendrils;
    public static Block oreCopper;
    public static Block oreLead;
    public static Block oreScrap;
    public static Block oreCoal;
    public static Block oreTitanium;
    public static Block oreThorium;
    public static Block siliconSmelter;
    public static Block kiln;
    public static Block graphitePress;
    public static Block plastaniumCompressor;
    public static Block multiPress;
    public static Block phaseWeaver;
    public static Block surgeSmelter;
    public static Block pyratiteMixer;
    public static Block blastMixer;
    public static Block cryofluidMixer;
    public static Block melter;
    public static Block separator;
    public static Block sporePress;
    public static Block pulverizer;
    public static Block incinerator;
    public static Block coalCentrifuge;
    public static Block powerVoid;
    public static Block powerSource;
    public static Block itemSource;
    public static Block liquidSource;
    public static Block itemVoid;
    public static Block message;
    public static Block scrapWall;
    public static Block scrapWallLarge;
    public static Block scrapWallHuge;
    public static Block scrapWallGigantic;
    public static Block thruster;
    public static Block copperWall;
    public static Block copperWallLarge;
    public static Block titaniumWall;
    public static Block titaniumWallLarge;
    public static Block thoriumWall;
    public static Block thoriumWallLarge;
    public static Block door;
    public static Block doorLarge;
    public static Block phaseWall;
    public static Block phaseWallLarge;
    public static Block surgeWall;
    public static Block surgeWallLarge;
    public static Block mender;
    public static Block mendProjector;
    public static Block overdriveProjector;
    public static Block forceProjector;
    public static Block shockMine;
    public static Block conveyor;
    public static Block titaniumConveyor;
    public static Block armoredConveyor;
    public static Block distributor;
    public static Block junction;
    public static Block itemBridge;
    public static Block phaseConveyor;
    public static Block sorter;
    public static Block invertedSorter;
    public static Block router;
    public static Block overflowGate;
    public static Block massDriver;
    public static Block mechanicalPump;
    public static Block rotaryPump;
    public static Block thermalPump;
    public static Block conduit;
    public static Block pulseConduit;
    public static Block liquidRouter;
    public static Block liquidTank;
    public static Block liquidJunction;
    public static Block bridgeConduit;
    public static Block phaseConduit;
    public static Block combustionGenerator;
    public static Block thermalGenerator;
    public static Block turbineGenerator;
    public static Block differentialGenerator;
    public static Block rtgGenerator;
    public static Block solarPanel;
    public static Block largeSolarPanel;
    public static Block thoriumReactor;
    public static Block impactReactor;
    public static Block battery;
    public static Block batteryLarge;
    public static Block powerNode;
    public static Block powerNodeLarge;
    public static Block surgeTower;
    public static Block mechanicalDrill;
    public static Block pneumaticDrill;
    public static Block laserDrill;
    public static Block blastDrill;
    public static Block waterExtractor;
    public static Block oilExtractor;
    public static Block cultivator;
    public static Block coreShard;
    public static Block coreFoundation;
    public static Block coreNucleus;
    public static Block vault;
    public static Block container;
    public static Block unloader;
    public static Block launchPad;
    public static Block launchPadLarge;
    public static Block duo;
    public static Block scatter;
    public static Block scorch;
    public static Block hail;
    public static Block arc;
    public static Block wave;
    public static Block lancer;
    public static Block swarmer;
    public static Block salvo;
    public static Block fuse;
    public static Block ripple;
    public static Block cyclone;
    public static Block spectre;
    public static Block meltdown;
    public static Block commandCenter;
    public static Block draugFactory;
    public static Block spiritFactory;
    public static Block phantomFactory;
    public static Block wraithFactory;
    public static Block ghoulFactory;
    public static Block revenantFactory;
    public static Block daggerFactory;
    public static Block crawlerFactory;
    public static Block titanFactory;
    public static Block fortressFactory;
    public static Block repairPoint;
    public static Block dartPad;
    public static Block deltaPad;
    public static Block tauPad;
    public static Block omegaPad;
    public static Block javelinPad;
    public static Block tridentPad;
    public static Block glaivePad;

    @Override
    public void load() {
        air = new Floor("air"){
            {
                this.alwaysReplace = true;
                this.hasShadow = false;
            }

            @Override
            public void draw(Tile tile) {
            }

            @Override
            public void load() {
            }

            @Override
            public void init() {
            }

            @Override
            public boolean isHidden() {
                return true;
            }

            @Override
            public TextureRegion[] variantRegions() {
                if (this.variantRegions == null) {
                    this.variantRegions = new TextureRegion[]{Core.atlas.find("clear")};
                }
                return this.variantRegions;
            }
        };
        for (int dx = 0; dx < 9; ++dx) {
            for (int dy = 0; dy < 9; ++dy) {
                int fx = dx - 4;
                int fy = dy - 4;
                if (fx == 0 && fy == 0) continue;
                new BlockPart(fx, fy);
            }
        }
        spawn = new OverlayFloor("spawn"){
            {
                this.variants = 0;
            }

            @Override
            public void draw(Tile tile) {
            }
        };
        for (int i = 1; i <= 9; ++i) {
            new BuildBlock(i);
        }
        deepwater = new Floor("deepwater"){
            {
                this.speedMultiplier = 0.2f;
                this.variants = 0;
                this.liquidDrop = Liquids.water;
                this.isLiquid = true;
                this.status = StatusEffects.wet;
                this.statusDuration = 120.0f;
                this.drownTime = 140.0f;
                this.cacheLayer = CacheLayer.water;
            }
        };
        water = new Floor("water"){
            {
                this.speedMultiplier = 0.5f;
                this.variants = 0;
                this.status = StatusEffects.wet;
                this.statusDuration = 90.0f;
                this.liquidDrop = Liquids.water;
                this.isLiquid = true;
                this.cacheLayer = CacheLayer.water;
            }
        };
        taintedWater = new Floor("tainted-water"){
            {
                this.speedMultiplier = 0.17f;
                this.variants = 0;
                this.status = StatusEffects.wet;
                this.statusDuration = 140.0f;
                this.drownTime = 120.0f;
                this.liquidDrop = Liquids.water;
                this.isLiquid = true;
                this.cacheLayer = CacheLayer.water;
            }
        };
        darksandTaintedWater = new Floor("darksand-tainted-water"){
            {
                this.speedMultiplier = 0.75f;
                this.variants = 0;
                this.status = StatusEffects.wet;
                this.statusDuration = 60.0f;
                this.liquidDrop = Liquids.water;
                this.isLiquid = true;
                this.cacheLayer = CacheLayer.water;
            }
        };
        sandWater = new Floor("sand-water"){
            {
                this.speedMultiplier = 0.8f;
                this.variants = 0;
                this.status = StatusEffects.wet;
                this.statusDuration = 50.0f;
                this.liquidDrop = Liquids.water;
                this.isLiquid = true;
                this.cacheLayer = CacheLayer.water;
            }
        };
        darksandWater = new Floor("darksand-water"){
            {
                this.speedMultiplier = 0.8f;
                this.variants = 0;
                this.status = StatusEffects.wet;
                this.statusDuration = 50.0f;
                this.liquidDrop = Liquids.water;
                this.isLiquid = true;
                this.cacheLayer = CacheLayer.water;
            }
        };
        tar = new Floor("tar"){
            {
                this.drownTime = 150.0f;
                this.status = StatusEffects.tarred;
                this.statusDuration = 240.0f;
                this.speedMultiplier = 0.19f;
                this.variants = 0;
                this.liquidDrop = Liquids.oil;
                this.isLiquid = true;
                this.cacheLayer = CacheLayer.tar;
            }
        };
        stone = new Floor("stone"){};
        craters = new Floor("craters"){
            {
                this.variants = 3;
                this.blendGroup = stone;
            }
        };
        charr = new Floor("char"){
            {
                this.blendGroup = stone;
            }
        };
        ignarock = new Floor("ignarock"){};
        hotrock = new Floor("hotrock"){
            {
                this.attributes.set(Attribute.heat, 0.5f);
                this.blendGroup = ignarock;
            }
        };
        magmarock = new Floor("magmarock"){
            {
                this.attributes.set(Attribute.heat, 0.75f);
                this.updateEffect = Fx.magmasmoke;
                this.blendGroup = ignarock;
            }
        };
        sand = new Floor("sand"){
            {
                this.itemDrop = Items.sand;
                this.playerUnmineable = true;
            }
        };
        darksand = new Floor("darksand"){
            {
                this.itemDrop = Items.sand;
                this.playerUnmineable = true;
            }
        };
        holostone = new Floor("holostone"){};
        grass = new Floor("grass"){};
        salt = new Floor("salt"){
            {
                this.variants = 0;
            }
        };
        snow = new Floor("snow"){
            {
                this.attributes.set(Attribute.water, 0.2f);
            }
        };
        ice = new Floor("ice"){
            {
                this.dragMultiplier = 1.0f;
                this.speedMultiplier = 1.0f;
                this.attributes.set(Attribute.water, 0.4f);
            }
        };
        iceSnow = new Floor("ice-snow"){
            {
                this.variants = 3;
                this.attributes.set(Attribute.water, 0.3f);
            }
        };
        cliffs = new StaticWall("cliffs"){
            {
                this.variants = 1;
                this.fillsTile = false;
            }
        };
        rocks = new StaticWall("rocks"){
            {
                this.variants = 2;
            }
        };
        sporerocks = new StaticWall("sporerocks"){
            {
                this.variants = 2;
            }
        };
        rock = new Rock("rock"){
            {
                this.variants = 2;
            }
        };
        snowrock = new Rock("snowrock"){
            {
                this.variants = 2;
            }
        };
        icerocks = new StaticWall("icerocks"){
            {
                this.variants = 2;
            }
        };
        snowrocks = new StaticWall("snowrocks"){
            {
                this.variants = 2;
            }
        };
        duneRocks = new StaticWall("dunerocks"){
            {
                this.variants = 2;
            }
        };
        sandRocks = new StaticWall("sandrocks"){
            {
                this.variants = 2;
            }
        };
        saltRocks = new StaticWall("saltrocks"){};
        sporePine = new StaticTree("spore-pine"){
            {
                this.variants = 0;
            }
        };
        snowPine = new StaticTree("snow-pine"){
            {
                this.variants = 0;
            }
        };
        pine = new StaticTree("pine"){
            {
                this.variants = 0;
            }
        };
        shrubs = new StaticWall("shrubs"){};
        whiteTreeDead = new TreeBlock("white-tree-dead"){};
        whiteTree = new TreeBlock("white-tree"){};
        sporeCluster = new Rock("spore-cluster"){
            {
                this.variants = 3;
            }
        };
        shale = new Floor("shale"){
            {
                this.variants = 3;
                this.attributes.set(Attribute.oil, 0.15f);
            }
        };
        shaleRocks = new StaticWall("shalerocks"){
            {
                this.variants = 2;
            }
        };
        shaleBoulder = new Rock("shale-boulder"){
            {
                this.variants = 2;
            }
        };
        sandBoulder = new Rock("sand-boulder"){
            {
                this.variants = 2;
            }
        };
        moss = new Floor("moss"){
            {
                this.variants = 3;
                this.attributes.set(Attribute.spores, 0.15f);
            }
        };
        sporeMoss = new Floor("spore-moss"){
            {
                this.variants = 3;
                this.attributes.set(Attribute.spores, 0.3f);
            }
        };
        metalFloor = new Floor("metal-floor"){
            {
                this.variants = 0;
            }
        };
        metalFloorDamaged = new Floor("metal-floor-damaged"){
            {
                this.variants = 3;
            }
        };
        metalFloor2 = new Floor("metal-floor-2"){
            {
                this.variants = 0;
            }
        };
        metalFloor3 = new Floor("metal-floor-3"){
            {
                this.variants = 0;
            }
        };
        metalFloor5 = new Floor("metal-floor-5"){
            {
                this.variants = 0;
            }
        };
        darkPanel1 = new Floor("dark-panel-1"){
            {
                this.variants = 0;
            }
        };
        darkPanel2 = new Floor("dark-panel-2"){
            {
                this.variants = 0;
            }
        };
        darkPanel3 = new Floor("dark-panel-3"){
            {
                this.variants = 0;
            }
        };
        darkPanel4 = new Floor("dark-panel-4"){
            {
                this.variants = 0;
            }
        };
        darkPanel5 = new Floor("dark-panel-5"){
            {
                this.variants = 0;
            }
        };
        darkPanel6 = new Floor("dark-panel-6"){
            {
                this.variants = 0;
            }
        };
        darkMetal = new StaticWall("dark-metal");
        pebbles = new DoubleOverlayFloor("pebbles");
        tendrils = new OverlayFloor("tendrils");
        oreCopper = new OreBlock(Items.copper);
        oreLead = new OreBlock(Items.lead);
        oreScrap = new OreBlock(Items.scrap);
        oreCoal = new OreBlock(Items.coal);
        oreTitanium = new OreBlock(Items.titanium);
        oreThorium = new OreBlock(Items.thorium);
        graphitePress = new GenericCrafter("graphite-press"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.copper, 75, Items.lead, 30));
                this.craftEffect = Fx.pulverizeMedium;
                this.outputItem = new ItemStack(Items.graphite, 1);
                this.craftTime = 90.0f;
                this.size = 2;
                this.hasItems = true;
                this.consumes.item(Items.coal, 2);
            }
        };
        multiPress = new GenericCrafter("multi-press"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.titanium, 100, Items.silicon, 25, Items.lead, 100, Items.graphite, 50));
                this.craftEffect = Fx.pulverizeMedium;
                this.outputItem = new ItemStack(Items.graphite, 2);
                this.craftTime = 30.0f;
                this.size = 3;
                this.hasItems = true;
                this.hasLiquids = true;
                this.hasPower = true;
                this.consumes.power(1.8f);
                this.consumes.item(Items.coal, 3);
                this.consumes.liquid(Liquids.water, 0.1f);
            }
        };
        siliconSmelter = new GenericSmelter("silicon-smelter"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.copper, 30, Items.lead, 25));
                this.craftEffect = Fx.smeltsmoke;
                this.outputItem = new ItemStack(Items.silicon, 1);
                this.craftTime = 40.0f;
                this.size = 2;
                this.hasPower = true;
                this.hasLiquids = false;
                this.flameColor = Color.valueOf("ffef99");
                this.consumes.items(new ItemStack(Items.coal, 1), new ItemStack(Items.sand, 2));
                this.consumes.power(0.5f);
            }
        };
        kiln = new GenericSmelter("kiln"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.copper, 60, Items.graphite, 30, Items.lead, 30));
                this.craftEffect = Fx.smeltsmoke;
                this.outputItem = new ItemStack(Items.metaglass, 1);
                this.craftTime = 30.0f;
                this.size = 2;
                this.hasItems = true;
                this.hasPower = true;
                this.flameColor = Color.valueOf("ffc099");
                this.consumes.items(new ItemStack(Items.lead, 1), new ItemStack(Items.sand, 1));
                this.consumes.power(0.6f);
            }
        };
        plastaniumCompressor = new GenericCrafter("plastanium-compressor"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.silicon, 80, Items.lead, 115, Items.graphite, 60, Items.titanium, 80));
                this.hasItems = true;
                this.liquidCapacity = 60.0f;
                this.craftTime = 60.0f;
                this.outputItem = new ItemStack(Items.plastanium, 1);
                this.size = 2;
                this.health = 320;
                this.hasLiquids = true;
                this.hasPower = true;
                this.craftEffect = Fx.formsmoke;
                this.updateEffect = Fx.plasticburn;
                this.consumes.liquid(Liquids.oil, 0.25f);
                this.consumes.power(3.0f);
                this.consumes.item(Items.titanium, 2);
                int topRegion = this.reg("-top");
                this.drawer = tile -> {
                    Draw.rect(this.region, tile.drawx(), tile.drawy());
                    GenericCrafter.GenericCrafterEntity entity = (GenericCrafter.GenericCrafterEntity)tile.entity();
                    Draw.alpha(Mathf.absin(entity.totalProgress, 3.0f, 0.9f) * entity.warmup);
                    Draw.rect(this.reg(topRegion), tile.drawx(), tile.drawy());
                    Draw.reset();
                };
            }
        };
        phaseWeaver = new GenericCrafter("phase-weaver"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.silicon, 130, Items.lead, 120, Items.thorium, 75));
                this.craftEffect = Fx.smeltsmoke;
                this.outputItem = new ItemStack(Items.phasefabric, 1);
                this.craftTime = 120.0f;
                this.size = 2;
                this.hasPower = true;
                this.consumes.items(new ItemStack(Items.thorium, 4), new ItemStack(Items.sand, 10));
                this.consumes.power(5.0f);
                this.itemCapacity = 20;
                int bottomRegion = this.reg("-bottom");
                int weaveRegion = this.reg("-weave");
                this.drawIcons = () -> new TextureRegion[]{Core.atlas.find(this.name + "-bottom"), Core.atlas.find(this.name)};
                this.drawer = tile -> {
                    GenericCrafter.GenericCrafterEntity entity = (GenericCrafter.GenericCrafterEntity)tile.entity();
                    Draw.rect(this.reg(bottomRegion), tile.drawx(), tile.drawy());
                    Draw.rect(this.reg(weaveRegion), tile.drawx(), tile.drawy(), entity.totalProgress);
                    Draw.color(Pal.accent);
                    Draw.alpha(entity.warmup);
                    Lines.lineAngleCenter(tile.drawx() + Mathf.sin(entity.totalProgress, 6.0f, 2.6666667f * (float)this.size), tile.drawy(), 90.0f, (float)(this.size * 8) / 2.0f);
                    Draw.reset();
                    Draw.rect(this.region, tile.drawx(), tile.drawy());
                };
            }
        };
        surgeSmelter = new GenericSmelter("alloy-smelter"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.silicon, 80, Items.lead, 80, Items.thorium, 70));
                this.craftEffect = Fx.smeltsmoke;
                this.outputItem = new ItemStack(Items.surgealloy, 1);
                this.craftTime = 75.0f;
                this.size = 3;
                this.hasPower = true;
                this.consumes.power(4.0f);
                this.consumes.items(new ItemStack(Items.titanium, 2), new ItemStack(Items.lead, 4), new ItemStack(Items.silicon, 3), new ItemStack(Items.copper, 3));
            }
        };
        cryofluidMixer = new LiquidConverter("cryofluidmixer"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.lead, 65, Items.silicon, 40, Items.titanium, 60));
                this.outputLiquid = new LiquidStack(Liquids.cryofluid, 0.2f);
                this.craftTime = 120.0f;
                this.size = 2;
                this.hasPower = true;
                this.hasItems = true;
                this.hasLiquids = true;
                this.rotate = false;
                this.solid = true;
                this.outputsLiquid = true;
                this.consumes.power(1.0f);
                this.consumes.item(Items.titanium);
                this.consumes.liquid(Liquids.water, 0.2f);
                int liquidRegion = this.reg("-liquid");
                int topRegion = this.reg("-top");
                int bottomRegion = this.reg("-bottom");
                this.drawIcons = () -> new TextureRegion[]{Core.atlas.find(this.name + "-bottom"), Core.atlas.find(this.name + "-top")};
                this.drawer = tile -> {
                    LiquidModule mod = tile.entity.liquids;
                    int rotation = this.rotate ? tile.rotation() * 90 : 0;
                    Draw.rect(this.reg(bottomRegion), tile.drawx(), tile.drawy(), (float)rotation);
                    if (mod.total() > 0.001f) {
                        Draw.color(this.outputLiquid.liquid.color);
                        Draw.alpha(mod.get(this.outputLiquid.liquid) / this.liquidCapacity);
                        Draw.rect(this.reg(liquidRegion), tile.drawx(), tile.drawy(), (float)rotation);
                        Draw.color();
                    }
                    Draw.rect(this.reg(topRegion), tile.drawx(), tile.drawy(), (float)rotation);
                };
            }
        };
        blastMixer = new GenericCrafter("blast-mixer"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.lead, 30, Items.titanium, 20));
                this.hasItems = true;
                this.hasPower = true;
                this.outputItem = new ItemStack(Items.blastCompound, 1);
                this.size = 2;
                this.consumes.items(new ItemStack(Items.pyratite, 1), new ItemStack(Items.sporePod, 1));
                this.consumes.power(0.4f);
            }
        };
        pyratiteMixer = new GenericSmelter("pyratite-mixer"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.copper, 50, Items.lead, 25));
                this.flameColor = Color.clear;
                this.hasItems = true;
                this.hasPower = true;
                this.outputItem = new ItemStack(Items.pyratite, 1);
                this.size = 2;
                this.consumes.power(0.2f);
                this.consumes.items(new ItemStack(Items.coal, 1), new ItemStack(Items.lead, 2), new ItemStack(Items.sand, 2));
            }
        };
        melter = new GenericCrafter("melter"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.copper, 30, Items.lead, 35, Items.graphite, 45));
                this.health = 200;
                this.outputLiquid = new LiquidStack(Liquids.slag, 2.0f);
                this.craftTime = 10.0f;
                this.hasPower = true;
                this.hasLiquids = true;
                this.consumes.power(1.0f);
                this.consumes.item(Items.scrap, 1);
            }
        };
        separator = new Separator("separator"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.copper, 30, Items.titanium, 25));
                this.results = ItemStack.with(Items.copper, 5, Items.lead, 3, Items.graphite, 2, Items.titanium, 2);
                this.hasPower = true;
                this.craftTime = 35.0f;
                this.spinnerLength = 1.5f;
                this.spinnerRadius = 3.5f;
                this.spinnerThickness = 1.5f;
                this.spinnerSpeed = 3.0f;
                this.size = 2;
                this.consumes.power(1.0f);
                this.consumes.liquid(Liquids.slag, 0.07f);
            }
        };
        sporePress = new GenericCrafter("spore-press"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.lead, 35, Items.silicon, 30));
                this.liquidCapacity = 60.0f;
                this.craftTime = 20.0f;
                this.outputLiquid = new LiquidStack(Liquids.oil, 6.0f);
                this.size = 2;
                this.health = 320;
                this.hasLiquids = true;
                this.hasPower = true;
                this.craftEffect = Fx.none;
                this.consumes.item(Items.sporePod, 1);
                this.consumes.power(0.6f);
                int[] frameRegions = new int[3];
                for (int i = 0; i < 3; ++i) {
                    frameRegions[i] = this.reg("-frame" + i);
                }
                int liquidRegion = this.reg("-liquid");
                int topRegion = this.reg("-top");
                this.drawIcons = () -> new TextureRegion[]{Core.atlas.find(this.name), Core.atlas.find(this.name + "-top")};
                this.drawer = tile -> {
                    GenericCrafter.GenericCrafterEntity entity = (GenericCrafter.GenericCrafterEntity)tile.entity();
                    Draw.rect(this.region, tile.drawx(), tile.drawy());
                    Draw.rect(this.reg(frameRegions[(int)Mathf.absin(entity.totalProgress, 5.0f, 2.999f)]), tile.drawx(), tile.drawy());
                    Draw.color(Color.clear, tile.entity.liquids.current().color, tile.entity.liquids.total() / this.liquidCapacity);
                    Draw.rect(this.reg(liquidRegion), tile.drawx(), tile.drawy());
                    Draw.color();
                    Draw.rect(this.reg(topRegion), tile.drawx(), tile.drawy());
                };
            }
        };
        pulverizer = new GenericCrafter("pulverizer"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.copper, 30, Items.lead, 25));
                this.outputItem = new ItemStack(Items.sand, 1);
                this.craftEffect = Fx.pulverize;
                this.craftTime = 40.0f;
                this.updateEffect = Fx.pulverizeSmall;
                this.hasPower = true;
                this.hasItems = true;
                this.consumes.item(Items.scrap, 1);
                this.consumes.power(0.5f);
                int rotatorRegion = this.reg("-rotator");
                this.drawIcons = () -> new TextureRegion[]{Core.atlas.find(this.name), Core.atlas.find(this.name + "-rotator")};
                this.drawer = tile -> {
                    GenericCrafter.GenericCrafterEntity entity = (GenericCrafter.GenericCrafterEntity)tile.entity();
                    Draw.rect(this.region, tile.drawx(), tile.drawy());
                    Draw.rect(this.reg(rotatorRegion), tile.drawx(), tile.drawy(), entity.totalProgress * 2.0f);
                };
            }
        };
        coalCentrifuge = new GenericCrafter("coal-centrifuge"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.titanium, 20, Items.graphite, 40, Items.lead, 30));
                this.craftEffect = Fx.smeltsmoke;
                this.outputItem = new ItemStack(Items.coal, 1);
                this.craftTime = 30.0f;
                this.size = 2;
                this.hasLiquids = true;
                this.hasItems = true;
                this.hasPower = true;
                this.consumes.liquid(Liquids.oil, 0.09f);
                this.consumes.power(0.5f);
            }
        };
        incinerator = new Incinerator("incinerator"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.graphite, 5, Items.lead, 15));
                this.health = 90;
                this.consumes.power(0.5f);
            }
        };
        powerVoid = new PowerVoid("power-void"){
            {
                this.requirements(Category.power, BuildVisibility.sandboxOnly, ItemStack.with(new Object[0]));
                this.alwaysUnlocked = true;
            }
        };
        powerSource = new PowerSource("power-source"){
            {
                this.requirements(Category.power, BuildVisibility.sandboxOnly, ItemStack.with(new Object[0]));
                this.alwaysUnlocked = true;
            }
        };
        itemSource = new ItemSource("item-source"){
            {
                this.requirements(Category.distribution, BuildVisibility.sandboxOnly, ItemStack.with(new Object[0]));
                this.alwaysUnlocked = true;
            }
        };
        itemVoid = new ItemVoid("item-void"){
            {
                this.requirements(Category.distribution, BuildVisibility.sandboxOnly, ItemStack.with(new Object[0]));
                this.alwaysUnlocked = true;
            }
        };
        liquidSource = new LiquidSource("liquid-source"){
            {
                this.requirements(Category.liquid, BuildVisibility.sandboxOnly, ItemStack.with(new Object[0]));
                this.alwaysUnlocked = true;
            }
        };
        message = new MessageBlock("message"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.graphite, 5));
            }
        };
        final int wallHealthMultiplier = 4;
        scrapWall = new Wall("scrap-wall"){
            {
                super(name);
                this.requirements(Category.defense, BuildVisibility.sandboxOnly, ItemStack.with(new Object[0]));
                this.health = 60 * wallHealthMultiplier;
                this.variants = 5;
            }
        };
        scrapWallLarge = new Wall("scrap-wall-large"){
            {
                super(name);
                this.requirements(Category.defense, BuildVisibility.sandboxOnly, ItemStack.with(new Object[0]));
                this.health = 240 * wallHealthMultiplier;
                this.size = 2;
                this.variants = 4;
            }
        };
        scrapWallHuge = new Wall("scrap-wall-huge"){
            {
                super(name);
                this.requirements(Category.defense, BuildVisibility.sandboxOnly, ItemStack.with(new Object[0]));
                this.health = 540 * wallHealthMultiplier;
                this.size = 3;
                this.variants = 3;
            }
        };
        scrapWallGigantic = new Wall("scrap-wall-gigantic"){
            {
                super(name);
                this.requirements(Category.defense, BuildVisibility.sandboxOnly, ItemStack.with(new Object[0]));
                this.health = 960 * wallHealthMultiplier;
                this.size = 4;
            }
        };
        thruster = new Wall("thruster"){
            {
                super(name);
                this.health = 880 * wallHealthMultiplier;
                this.size = 4;
            }
        };
        copperWall = new Wall("copper-wall"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.with(Items.copper, 6));
                this.health = 80 * wallHealthMultiplier;
            }
        };
        copperWallLarge = new Wall("copper-wall-large"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.mult(Blocks.copperWall.requirements, 4));
                this.health = 320 * wallHealthMultiplier;
                this.size = 2;
            }
        };
        titaniumWall = new Wall("titanium-wall"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.with(Items.titanium, 6));
                this.health = 110 * wallHealthMultiplier;
            }
        };
        titaniumWallLarge = new Wall("titanium-wall-large"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.mult(Blocks.titaniumWall.requirements, 4));
                this.health = 110 * wallHealthMultiplier * 4;
                this.size = 2;
            }
        };
        thoriumWall = new Wall("thorium-wall"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.with(Items.thorium, 6));
                this.health = 200 * wallHealthMultiplier;
            }
        };
        thoriumWallLarge = new Wall("thorium-wall-large"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.mult(Blocks.thoriumWall.requirements, 4));
                this.health = 200 * wallHealthMultiplier * 4;
                this.size = 2;
            }
        };
        phaseWall = new DeflectorWall("phase-wall"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.with(Items.phasefabric, 6));
                this.health = 150 * wallHealthMultiplier;
            }
        };
        phaseWallLarge = new DeflectorWall("phase-wall-large"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.mult(Blocks.phaseWall.requirements, 4));
                this.health = 600 * wallHealthMultiplier;
                this.size = 2;
            }
        };
        surgeWall = new SurgeWall("surge-wall"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.with(Items.surgealloy, 6));
                this.health = 230 * wallHealthMultiplier;
            }
        };
        surgeWallLarge = new SurgeWall("surge-wall-large"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.mult(Blocks.surgeWall.requirements, 4));
                this.health = 920 * wallHealthMultiplier;
                this.size = 2;
            }
        };
        door = new Door("door"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.with(Items.graphite, 6, Items.silicon, 4));
                this.health = 100 * wallHealthMultiplier;
            }
        };
        doorLarge = new Door("door-large"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.mult(Blocks.door.requirements, 4));
                this.openfx = Fx.dooropenlarge;
                this.closefx = Fx.doorcloselarge;
                this.health = 400 * wallHealthMultiplier;
                this.size = 2;
            }
        };
        mender = new MendProjector("mender"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.lead, 30, Items.copper, 25));
                this.consumes.power(0.3f);
                this.size = 1;
                this.reload = 200.0f;
                this.range = 40.0f;
                this.healPercent = 4.0f;
                this.phaseBoost = 4.0f;
                this.phaseRangeBoost = 20.0f;
                this.health = 80;
                this.consumes.item(Items.silicon).boost();
            }
        };
        mendProjector = new MendProjector("mend-projector"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.lead, 100, Items.titanium, 25, Items.silicon, 40));
                this.consumes.power(1.5f);
                this.size = 2;
                this.reload = 250.0f;
                this.range = 85.0f;
                this.healPercent = 14.0f;
                this.health = 80 * this.size * this.size;
                this.consumes.item(Items.phasefabric).boost();
            }
        };
        overdriveProjector = new OverdriveProjector("overdrive-projector"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.lead, 100, Items.titanium, 75, Items.silicon, 75, Items.plastanium, 30));
                this.consumes.power(3.5f);
                this.size = 2;
                this.consumes.item(Items.phasefabric).boost();
            }
        };
        forceProjector = new ForceProjector("force-projector"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.lead, 100, Items.titanium, 75, Items.silicon, 125));
                this.size = 3;
                this.consumes.item(Items.phasefabric).boost();
                this.consumes.power(3.0f);
            }
        };
        shockMine = new ShockMine("shock-mine"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.lead, 25, Items.silicon, 12));
                this.hasShadow = false;
                this.health = 40;
                this.damage = 11.0f;
                this.tileDamage = 7.0f;
                this.length = 10;
                this.tendrils = 5;
            }
        };
        conveyor = new Conveyor("conveyor"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.copper, 1), true);
                this.health = 45;
                this.speed = 0.03f;
            }
        };
        titaniumConveyor = new Conveyor("titanium-conveyor"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.copper, 1, Items.lead, 1, Items.titanium, 1));
                this.health = 65;
                this.speed = 0.08f;
            }
        };
        armoredConveyor = new ArmoredConveyor("armored-conveyor"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.metaglass, 1, Items.thorium, 1));
                this.health = 180;
                this.speed = 0.08f;
            }
        };
        junction = new Junction("junction"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.copper, 1), true);
                this.speed = 26.0f;
                this.capacity = 12;
                this.health = 30;
            }
        };
        itemBridge = new BufferedItemBridge("bridge-conveyor"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.lead, 4, Items.copper, 4));
                this.range = 4;
                this.speed = 70.0f;
                this.bufferCapacity = 14;
            }
        };
        phaseConveyor = new ItemBridge("phase-conveyor"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.phasefabric, 5, Items.silicon, 7, Items.lead, 10, Items.graphite, 10));
                this.range = 12;
                this.hasPower = true;
                this.consumes.power(0.3f);
            }
        };
        sorter = new Sorter("sorter"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.lead, 2, Items.copper, 2));
            }
        };
        invertedSorter = new Sorter("inverted-sorter"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.lead, 2, Items.copper, 2));
                this.invert = true;
            }
        };
        router = new Router("router"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.copper, 3));
            }
        };
        distributor = new Router("distributor"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.lead, 4, Items.copper, 4));
                this.size = 2;
            }
        };
        overflowGate = new OverflowGate("overflow-gate"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.lead, 2, Items.copper, 4));
            }
        };
        massDriver = new MassDriver("mass-driver"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.titanium, 125, Items.silicon, 75, Items.lead, 125, Items.thorium, 50));
                this.size = 3;
                this.itemCapacity = 120;
                this.reloadTime = 200.0f;
                this.range = 440.0f;
                this.consumes.power(1.75f);
            }
        };
        mechanicalPump = new Pump("mechanical-pump"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.copper, 15, Items.metaglass, 10));
                this.pumpAmount = 0.1f;
            }
        };
        rotaryPump = new Pump("rotary-pump"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.copper, 70, Items.metaglass, 50, Items.silicon, 20, Items.titanium, 35));
                this.pumpAmount = 0.8f;
                this.consumes.power(0.15f);
                this.liquidCapacity = 30.0f;
                this.hasPower = true;
                this.size = 2;
            }
        };
        thermalPump = new Pump("thermal-pump"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.copper, 80, Items.metaglass, 70, Items.silicon, 30, Items.titanium, 40, Items.thorium, 35));
                this.pumpAmount = 1.5f;
                this.consumes.power(0.3f);
                this.liquidCapacity = 40.0f;
                this.hasPower = true;
                this.size = 3;
            }
        };
        conduit = new Conduit("conduit"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.metaglass, 1));
                this.health = 45;
            }
        };
        pulseConduit = new Conduit("pulse-conduit"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.titanium, 2, Items.metaglass, 1));
                this.liquidCapacity = 16.0f;
                this.health = 90;
            }
        };
        liquidRouter = new LiquidRouter("liquid-router"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.graphite, 4, Items.metaglass, 2));
                this.liquidCapacity = 20.0f;
            }
        };
        liquidTank = new LiquidTank("liquid-tank"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.titanium, 25, Items.metaglass, 25));
                this.size = 3;
                this.liquidCapacity = 1500.0f;
                this.health = 500;
            }
        };
        liquidJunction = new LiquidJunction("liquid-junction"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.graphite, 2, Items.metaglass, 2));
            }
        };
        bridgeConduit = new LiquidExtendingBridge("bridge-conduit"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.graphite, 4, Items.metaglass, 8));
                this.range = 4;
                this.hasPower = false;
            }
        };
        phaseConduit = new LiquidBridge("phase-conduit"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.phasefabric, 5, Items.silicon, 7, Items.metaglass, 20, Items.titanium, 10));
                this.range = 12;
                this.hasPower = true;
                this.consumes.power(0.3f);
            }
        };
        powerNode = new PowerNode("power-node"){
            {
                this.requirements(Category.power, ItemStack.with(Items.copper, 1, Items.lead, 3));
                this.maxNodes = 20;
                this.laserRange = 6.0f;
            }
        };
        powerNodeLarge = new PowerNode("power-node-large"){
            {
                this.requirements(Category.power, ItemStack.with(Items.titanium, 5, Items.lead, 10, Items.silicon, 3));
                this.size = 2;
                this.maxNodes = 30;
                this.laserRange = 9.5f;
            }
        };
        surgeTower = new PowerNode("surge-tower"){
            {
                this.requirements(Category.power, ItemStack.with(Items.titanium, 7, Items.lead, 10, Items.silicon, 15, Items.surgealloy, 15));
                this.size = 2;
                this.maxNodes = 2;
                this.laserRange = 30.0f;
            }
        };
        battery = new Battery("battery"){
            {
                this.requirements(Category.power, ItemStack.with(Items.copper, 4, Items.lead, 20));
                this.consumes.powerBuffered(4000.0f);
            }
        };
        batteryLarge = new Battery("battery-large"){
            {
                this.requirements(Category.power, ItemStack.with(Items.titanium, 20, Items.lead, 40, Items.silicon, 20));
                this.size = 3;
                this.consumes.powerBuffered(50000.0f);
            }
        };
        combustionGenerator = new BurnerGenerator("combustion-generator"){
            {
                this.requirements(Category.power, ItemStack.with(Items.copper, 25, Items.lead, 15));
                this.powerProduction = 1.0f;
                this.itemDuration = 120.0f;
            }
        };
        thermalGenerator = new ThermalGenerator("thermal-generator"){
            {
                this.requirements(Category.power, ItemStack.with(Items.copper, 40, Items.graphite, 35, Items.lead, 50, Items.silicon, 35, Items.metaglass, 40));
                this.powerProduction = 1.8f;
                this.generateEffect = Fx.redgeneratespark;
                this.size = 2;
            }
        };
        turbineGenerator = new BurnerGenerator("turbine-generator"){
            {
                this.requirements(Category.power, ItemStack.with(Items.copper, 35, Items.graphite, 25, Items.lead, 40, Items.silicon, 30));
                this.powerProduction = 6.0f;
                this.itemDuration = 90.0f;
                this.consumes.liquid(Liquids.water, 0.05f);
                this.hasLiquids = true;
                this.size = 2;
            }
        };
        differentialGenerator = new SingleTypeGenerator("differential-generator"){
            {
                this.requirements(Category.power, ItemStack.with(Items.copper, 70, Items.titanium, 50, Items.lead, 100, Items.silicon, 65, Items.metaglass, 50));
                this.powerProduction = 16.0f;
                this.itemDuration = 120.0f;
                this.hasLiquids = true;
                this.hasItems = true;
                this.size = 3;
                this.consumes.item(Items.pyratite).optional(true, false);
                this.consumes.liquid(Liquids.cryofluid, 0.18f);
            }
        };
        rtgGenerator = new DecayGenerator("rtg-generator"){
            {
                this.requirements(Category.power, ItemStack.with(Items.lead, 100, Items.silicon, 75, Items.phasefabric, 25, Items.plastanium, 75, Items.thorium, 50));
                this.size = 2;
                this.powerProduction = 3.0f;
                this.itemDuration = 440.0f;
            }
        };
        solarPanel = new SolarGenerator("solar-panel"){
            {
                this.requirements(Category.power, ItemStack.with(Items.lead, 10, Items.silicon, 15));
                this.powerProduction = 0.06f;
            }
        };
        largeSolarPanel = new SolarGenerator("solar-panel-large"){
            {
                this.requirements(Category.power, ItemStack.with(Items.lead, 100, Items.silicon, 145, Items.phasefabric, 15));
                this.size = 3;
                this.powerProduction = 0.9f;
            }
        };
        thoriumReactor = new NuclearReactor("thorium-reactor"){
            {
                this.requirements(Category.power, ItemStack.with(Items.lead, 300, Items.silicon, 200, Items.graphite, 150, Items.thorium, 150, Items.metaglass, 50));
                this.size = 3;
                this.health = 700;
                this.itemDuration = 360.0f;
                this.powerProduction = 14.0f;
                this.consumes.item(Items.thorium);
                this.heating = 0.02f;
                this.consumes.liquid(Liquids.cryofluid, 0.1f).update(false);
            }
        };
        impactReactor = new ImpactReactor("impact-reactor"){
            {
                this.requirements(Category.power, ItemStack.with(Items.lead, 500, Items.silicon, 300, Items.graphite, 400, Items.thorium, 100, Items.surgealloy, 250, Items.metaglass, 250));
                this.size = 4;
                this.health = 900;
                this.powerProduction = 130.0f;
                this.itemDuration = 140.0f;
                this.consumes.power(25.0f);
                this.consumes.item(Items.blastCompound);
                this.consumes.liquid(Liquids.cryofluid, 0.25f);
            }
        };
        mechanicalDrill = new Drill("mechanical-drill"){
            {
                this.requirements(Category.production, ItemStack.with(Items.copper, 12), true);
                this.tier = 2;
                this.drillTime = 600.0f;
                this.size = 2;
                this.drawMineItem = true;
                this.consumes.liquid(Liquids.water, 0.05f).boost();
            }
        };
        pneumaticDrill = new Drill("pneumatic-drill"){
            {
                this.requirements(Category.production, ItemStack.with(Items.copper, 18, Items.graphite, 10));
                this.tier = 3;
                this.drillTime = 400.0f;
                this.size = 2;
                this.drawMineItem = true;
                this.consumes.liquid(Liquids.water, 0.06f).boost();
            }
        };
        laserDrill = new Drill("laser-drill"){
            {
                this.requirements(Category.production, ItemStack.with(Items.copper, 35, Items.graphite, 30, Items.silicon, 30, Items.titanium, 20));
                this.drillTime = 280.0f;
                this.size = 3;
                this.hasPower = true;
                this.tier = 4;
                this.updateEffect = Fx.pulverizeMedium;
                this.drillEffect = Fx.mineBig;
                this.consumes.power(1.1f);
                this.consumes.liquid(Liquids.water, 0.08f).boost();
            }
        };
        blastDrill = new Drill("blast-drill"){
            {
                this.requirements(Category.production, ItemStack.with(Items.copper, 65, Items.silicon, 60, Items.titanium, 50, Items.thorium, 75));
                this.drillTime = 280.0f;
                this.size = 4;
                this.drawRim = true;
                this.hasPower = true;
                this.tier = 5;
                this.updateEffect = Fx.pulverizeRed;
                this.updateEffectChance = 0.03f;
                this.drillEffect = Fx.mineHuge;
                this.rotateSpeed = 6.0f;
                this.warmupSpeed = 0.01f;
                this.consumes.power(3.0f);
                this.consumes.liquid(Liquids.water, 0.1f).boost();
            }
        };
        waterExtractor = new SolidPump("water-extractor"){
            {
                this.requirements(Category.production, ItemStack.with(Items.copper, 25, Items.graphite, 25, Items.lead, 20));
                this.result = Liquids.water;
                this.pumpAmount = 0.13f;
                this.size = 2;
                this.liquidCapacity = 30.0f;
                this.rotateSpeed = 1.4f;
                this.attribute = Attribute.water;
                this.consumes.power(1.0f);
            }
        };
        cultivator = new Cultivator("cultivator"){
            {
                this.requirements(Category.production, ItemStack.with(Items.copper, 10, Items.lead, 25, Items.silicon, 10));
                this.outputItem = new ItemStack(Items.sporePod, 1);
                this.craftTime = 140.0f;
                this.size = 2;
                this.hasLiquids = true;
                this.hasPower = true;
                this.hasItems = true;
                this.consumes.power(0.8f);
                this.consumes.liquid(Liquids.water, 0.18f);
            }
        };
        oilExtractor = new Fracker("oil-extractor"){
            {
                this.requirements(Category.production, ItemStack.with(Items.copper, 150, Items.graphite, 175, Items.lead, 115, Items.thorium, 115, Items.silicon, 75));
                this.result = Liquids.oil;
                this.updateEffect = Fx.pulverize;
                this.liquidCapacity = 50.0f;
                this.updateEffectChance = 0.05f;
                this.pumpAmount = 0.25f;
                this.size = 3;
                this.liquidCapacity = 30.0f;
                this.attribute = Attribute.oil;
                this.consumes.item(Items.sand);
                this.consumes.power(3.0f);
                this.consumes.liquid(Liquids.water, 0.15f);
            }
        };
        coreShard = new CoreBlock("core-shard"){
            {
                this.requirements(Category.effect, BuildVisibility.debugOnly, ItemStack.with(Items.titanium, 4000));
                this.alwaysUnlocked = true;
                this.health = 1100;
                this.itemCapacity = 4000;
                this.size = 3;
            }
        };
        coreFoundation = new CoreBlock("core-foundation"){
            {
                this.requirements(Category.effect, BuildVisibility.debugOnly, ItemStack.with(Items.titanium, 400, Items.silicon, 3000));
                this.health = 2000;
                this.itemCapacity = 9000;
                this.size = 4;
            }
        };
        coreNucleus = new CoreBlock("core-nucleus"){
            {
                this.requirements(Category.effect, BuildVisibility.debugOnly, ItemStack.with(Items.titanium, 4000, Items.silicon, 2000, Items.surgealloy, 3000));
                this.health = 4000;
                this.itemCapacity = 13000;
                this.size = 5;
            }
        };
        vault = new Vault("vault"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.titanium, 250, Items.thorium, 125));
                this.size = 3;
                this.itemCapacity = 1000;
            }
        };
        container = new Vault("container"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.titanium, 100));
                this.size = 2;
                this.itemCapacity = 300;
            }
        };
        unloader = new Unloader("unloader"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.titanium, 25, Items.silicon, 30));
                this.speed = 7.0f;
            }
        };
        launchPad = new LaunchPad("launch-pad"){
            {
                this.requirements(Category.effect, BuildVisibility.campaignOnly, ItemStack.with(Items.copper, 250, Items.silicon, 75, Items.lead, 100));
                this.size = 3;
                this.itemCapacity = 100;
                this.launchTime = 960.0f;
                this.hasPower = true;
                this.consumes.power(1.0f);
            }
        };
        launchPadLarge = new LaunchPad("launch-pad-large"){
            {
                this.requirements(Category.effect, BuildVisibility.campaignOnly, ItemStack.with(Items.titanium, 200, Items.silicon, 150, Items.lead, 250, Items.plastanium, 75));
                this.size = 4;
                this.itemCapacity = 250;
                this.launchTime = 840.0f;
                this.hasPower = true;
                this.consumes.power(2.0f);
            }
        };
        duo = new DoubleTurret("duo"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 35), true);
                this.ammo(Items.copper, Bullets.standardCopper, Items.graphite, Bullets.standardDense, Items.pyratite, Bullets.standardIncendiary, Items.silicon, Bullets.standardHoming);
                this.reload = 20.0f;
                this.restitution = 0.03f;
                this.range = 100.0f;
                this.shootCone = 15.0f;
                this.ammoUseEffect = Fx.shellEjectSmall;
                this.health = 250;
                this.inaccuracy = 2.0f;
                this.rotatespeed = 10.0f;
            }
        };
        scatter = new BurstTurret("scatter"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 85, Items.lead, 45));
                this.ammo(Items.scrap, Bullets.flakScrap, Items.lead, Bullets.flakLead, Items.metaglass, Bullets.flakGlass);
                this.reload = 18.0f;
                this.range = 170.0f;
                this.size = 2;
                this.burstSpacing = 5.0f;
                this.shots = 2;
                this.targetGround = false;
                this.recoil = 2.0f;
                this.rotatespeed = 15.0f;
                this.inaccuracy = 17.0f;
                this.shootCone = 35.0f;
                this.health = 200 * this.size * this.size;
                this.shootSound = Sounds.shootSnap;
            }
        };
        scorch = new ItemTurret("scorch"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 25, Items.graphite, 22));
                this.ammo(Items.coal, Bullets.basicFlame, Items.pyratite, Bullets.pyraFlame);
                this.recoil = 0.0f;
                this.reload = 5.0f;
                this.coolantMultiplier = 2.0f;
                this.range = 60.0f;
                this.shootCone = 50.0f;
                this.targetAir = false;
                this.ammoUseEffect = Fx.none;
                this.health = 400;
                this.shootSound = Sounds.flame;
            }
        };
        hail = new ArtilleryTurret("hail"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 40, Items.graphite, 17));
                this.ammo(Items.graphite, Bullets.artilleryDense, Items.silicon, Bullets.artilleryHoming, Items.pyratite, Bullets.artlleryIncendiary);
                this.reload = 60.0f;
                this.recoil = 2.0f;
                this.range = 230.0f;
                this.inaccuracy = 1.0f;
                this.shootCone = 10.0f;
                this.health = 260;
                this.shootSound = Sounds.artillery;
            }
        };
        wave = new LiquidTurret("wave"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.metaglass, 45, Items.lead, 75));
                this.ammo(Liquids.water, Bullets.waterShot, Liquids.slag, Bullets.slagShot, Liquids.cryofluid, Bullets.cryoShot, Liquids.oil, Bullets.oilShot);
                this.size = 2;
                this.recoil = 0.0f;
                this.reload = 2.0f;
                this.inaccuracy = 5.0f;
                this.shootCone = 50.0f;
                this.shootEffect = Fx.shootLiquid;
                this.range = 110.0f;
                this.health = 250 * this.size * this.size;
                this.shootSound = Sounds.splash;
                this.drawer = (tile, entity) -> {
                    Draw.rect(this.region, tile.drawx() + this.tr2.x, tile.drawy() + this.tr2.y, entity.rotation - 90.0f);
                    Draw.color(entity.liquids.current().color);
                    Draw.alpha(entity.liquids.total() / this.liquidCapacity);
                    Draw.rect(this.name + "-liquid", tile.drawx() + this.tr2.x, tile.drawy() + this.tr2.y, entity.rotation - 90.0f);
                    Draw.color();
                };
            }
        };
        lancer = new ChargeTurret("lancer"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 25, Items.lead, 50, Items.silicon, 45));
                this.range = 155.0f;
                this.chargeTime = 50.0f;
                this.chargeMaxDelay = 30.0f;
                this.chargeEffects = 7;
                this.shootType = Bullets.lancerLaser;
                this.recoil = 2.0f;
                this.reload = 90.0f;
                this.cooldown = 0.03f;
                this.powerUse = 2.5f;
                this.shootShake = 2.0f;
                this.shootEffect = Fx.lancerLaserShoot;
                this.smokeEffect = Fx.lancerLaserShootSmoke;
                this.chargeEffect = Fx.lancerLaserCharge;
                this.chargeBeginEffect = Fx.lancerLaserChargeBegin;
                this.heatColor = Color.red;
                this.size = 2;
                this.health = 280 * this.size * this.size;
                this.targetAir = false;
                this.shootSound = Sounds.laser;
            }
        };
        arc = new PowerTurret("arc"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 35, Items.lead, 50));
                this.shootType = Bullets.arc;
                this.reload = 35.0f;
                this.shootCone = 40.0f;
                this.rotatespeed = 8.0f;
                this.powerUse = 1.5f;
                this.targetAir = false;
                this.range = 90.0f;
                this.shootEffect = Fx.lightningShoot;
                this.heatColor = Color.red;
                this.recoil = 1.0f;
                this.size = 1;
                this.health = 260;
                this.shootSound = Sounds.spark;
            }
        };
        swarmer = new BurstTurret("swarmer"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.graphite, 35, Items.titanium, 35, Items.plastanium, 45, Items.silicon, 30));
                this.ammo(Items.blastCompound, Bullets.missileExplosive, Items.pyratite, Bullets.missileIncendiary, Items.surgealloy, Bullets.missileSurge);
                this.reload = 40.0f;
                this.shots = 4;
                this.burstSpacing = 5.0f;
                this.inaccuracy = 10.0f;
                this.range = 185.0f;
                this.xRand = 6.0f;
                this.size = 2;
                this.health = 300 * this.size * this.size;
                this.shootSound = Sounds.missile;
            }
        };
        salvo = new BurstTurret("salvo"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 105, Items.graphite, 95, Items.titanium, 60));
                this.ammo(Items.copper, Bullets.standardCopper, Items.graphite, Bullets.standardDense, Items.pyratite, Bullets.standardIncendiary, Items.silicon, Bullets.standardHoming, Items.thorium, Bullets.standardThorium);
                this.size = 2;
                this.range = 150.0f;
                this.reload = 38.0f;
                this.restitution = 0.03f;
                this.ammoEjectBack = 3.0f;
                this.cooldown = 0.03f;
                this.recoil = 3.0f;
                this.shootShake = 2.0f;
                this.burstSpacing = 3.0f;
                this.shots = 4;
                this.ammoUseEffect = Fx.shellEjectBig;
                this.health = 240 * this.size * this.size;
                this.shootSound = Sounds.shootBig;
            }
        };
        fuse = new ItemTurret("fuse"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 225, Items.graphite, 225, Items.thorium, 100));
                this.reload = 35.0f;
                this.shootShake = 4.0f;
                this.range = 90.0f;
                this.recoil = 5.0f;
                this.shots = 3;
                this.spread = 20.0f;
                this.restitution = 0.1f;
                this.shootCone = 30.0f;
                this.size = 3;
                this.health = 220 * this.size * this.size;
                this.shootSound = Sounds.shotgun;
                this.ammo(Items.graphite, new BulletType(0.01f, 105.0f){
                    int rays;
                    float rayLength;
                    {
                        this.rays = 1;
                        this.rayLength = range + 10.0f;
                        this.hitEffect = Fx.hitLancer;
                        this.shootEffect = this.smokeEffect = Fx.lightningShoot;
                        this.lifetime = 10.0f;
                        this.despawnEffect = Fx.none;
                        this.pierce = true;
                    }

                    @Override
                    public void init(Bullet b) {
                        for (int i = 0; i < this.rays; ++i) {
                            Damage.collideLine(b, b.getTeam(), this.hitEffect, b.x, b.y, b.rot(), this.rayLength - (float)Math.abs(i - this.rays / 2) * 20.0f);
                        }
                    }

                    @Override
                    public void draw(Bullet b) {
                        super.draw(b);
                        Draw.color(Color.white, Pal.lancerLaser, b.fin());
                        for (int i = 0; i < 7; ++i) {
                            Tmp.v1.trns(b.rot(), (float)i * 8.0f);
                            float sl = Mathf.clamp(b.fout() - 0.5f) * (80.0f - (float)(i * 10));
                            Drawf.tri(b.x + Tmp.v1.x, b.y + Tmp.v1.y, 4.0f, sl, b.rot() + 90.0f);
                            Drawf.tri(b.x + Tmp.v1.x, b.y + Tmp.v1.y, 4.0f, sl, b.rot() - 90.0f);
                        }
                        Drawf.tri(b.x, b.y, 20.0f * b.fout(), this.rayLength + 50.0f, b.rot());
                        Drawf.tri(b.x, b.y, 20.0f * b.fout(), 10.0f, b.rot() + 180.0f);
                        Draw.reset();
                    }
                });
            }
        };
        ripple = new ArtilleryTurret("ripple"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 150, Items.graphite, 135, Items.titanium, 60));
                this.ammo(Items.graphite, Bullets.artilleryDense, Items.silicon, Bullets.artilleryHoming, Items.pyratite, Bullets.artlleryIncendiary, Items.blastCompound, Bullets.artilleryExplosive, Items.plastanium, Bullets.arilleryPlastic);
                this.size = 3;
                this.shots = 4;
                this.inaccuracy = 12.0f;
                this.reload = 60.0f;
                this.ammoEjectBack = 5.0f;
                this.ammoUseEffect = Fx.shellEjectBig;
                this.cooldown = 0.03f;
                this.velocityInaccuracy = 0.2f;
                this.restitution = 0.02f;
                this.recoil = 6.0f;
                this.shootShake = 2.0f;
                this.range = 290.0f;
                this.health = 130 * this.size * this.size;
                this.shootSound = Sounds.artillery;
            }
        };
        cyclone = new ItemTurret("cyclone"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 200, Items.titanium, 125, Items.plastanium, 80));
                this.ammo(Items.metaglass, Bullets.flakGlass, Items.blastCompound, Bullets.flakExplosive, Items.plastanium, Bullets.flakPlastic, Items.surgealloy, Bullets.flakSurge);
                this.xRand = 4.0f;
                this.reload = 6.0f;
                this.range = 200.0f;
                this.size = 3;
                this.recoil = 3.0f;
                this.rotatespeed = 10.0f;
                this.inaccuracy = 10.0f;
                this.shootCone = 30.0f;
                this.shootSound = Sounds.shootSnap;
                this.health = 145 * this.size * this.size;
            }
        };
        spectre = new DoubleTurret("spectre"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 350, Items.graphite, 300, Items.surgealloy, 250, Items.plastanium, 175, Items.thorium, 250));
                this.ammo(Items.graphite, Bullets.standardDenseBig, Items.pyratite, Bullets.standardIncendiaryBig, Items.thorium, Bullets.standardThoriumBig);
                this.reload = 6.0f;
                this.coolantMultiplier = 0.5f;
                this.restitution = 0.1f;
                this.ammoUseEffect = Fx.shellEjectBig;
                this.range = 200.0f;
                this.inaccuracy = 3.0f;
                this.recoil = 3.0f;
                this.xRand = 3.0f;
                this.shotWidth = 4.0f;
                this.shootShake = 2.0f;
                this.shots = 2;
                this.size = 4;
                this.shootCone = 24.0f;
                this.shootSound = Sounds.shootBig;
                this.health = 155 * this.size * this.size;
                this.consumes.add(new ConsumeLiquidFilter(liquid -> liquid.temperature <= 0.5f && liquid.flammability < 0.1f, 2.0f)).update(false).optional(true, true);
            }
        };
        meltdown = new LaserTurret("meltdown"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 250, Items.lead, 350, Items.graphite, 300, Items.surgealloy, 325, Items.silicon, 325));
                this.shootType = Bullets.meltdownLaser;
                this.shootEffect = Fx.shootBigSmoke2;
                this.shootCone = 40.0f;
                this.recoil = 4.0f;
                this.size = 4;
                this.shootShake = 2.0f;
                this.range = 190.0f;
                this.reload = 80.0f;
                this.firingMoveFract = 0.5f;
                this.shootDuration = 220.0f;
                this.powerUse = 14.0f;
                this.shootSound = Sounds.laserbig;
                this.activeSound = Sounds.beam;
                this.activeSoundVolume = 2.0f;
                this.health = 200 * this.size * this.size;
                this.consumes.add(new ConsumeLiquidFilter(liquid -> liquid.temperature <= 0.5f && liquid.flammability < 0.1f, 0.5f)).update(false);
            }
        };
        draugFactory = new UnitFactory("draug-factory"){
            {
                this.requirements(Category.units, ItemStack.with(Items.copper, 30, Items.lead, 70));
                this.unitType = UnitTypes.draug;
                this.produceTime = 2500.0f;
                this.size = 2;
                this.maxSpawn = 1;
                this.consumes.power(1.2f);
                this.consumes.items(new ItemStack[0]);
            }
        };
        spiritFactory = new UnitFactory("spirit-factory"){
            {
                this.requirements(Category.units, ItemStack.with(Items.metaglass, 45, Items.lead, 55, Items.silicon, 45));
                this.unitType = UnitTypes.spirit;
                this.produceTime = 4000.0f;
                this.size = 2;
                this.maxSpawn = 1;
                this.consumes.power(1.2f);
                this.consumes.items(new ItemStack(Items.silicon, 30), new ItemStack(Items.lead, 30));
            }
        };
        phantomFactory = new UnitFactory("phantom-factory"){
            {
                this.requirements(Category.units, ItemStack.with(Items.titanium, 50, Items.thorium, 60, Items.lead, 65, Items.silicon, 105));
                this.unitType = UnitTypes.phantom;
                this.produceTime = 4400.0f;
                this.size = 2;
                this.maxSpawn = 1;
                this.consumes.power(2.5f);
                this.consumes.items(new ItemStack(Items.silicon, 50), new ItemStack(Items.lead, 30), new ItemStack(Items.titanium, 20));
            }
        };
        commandCenter = new CommandCenter("command-center"){
            {
                this.requirements(Category.units, ItemStack.with(Items.copper, 200, Items.lead, 250, Items.silicon, 250, Items.graphite, 100));
                this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.rally, BlockFlag.comandCenter});
                this.size = 2;
                this.health = this.size * this.size * 55;
            }
        };
        wraithFactory = new UnitFactory("wraith-factory"){
            {
                this.requirements(Category.units, ItemStack.with(Items.titanium, 30, Items.lead, 40, Items.silicon, 45));
                this.unitType = UnitTypes.wraith;
                this.produceTime = 700.0f;
                this.size = 2;
                this.consumes.power(0.5f);
                this.consumes.items(new ItemStack(Items.silicon, 10), new ItemStack(Items.titanium, 5));
            }
        };
        ghoulFactory = new UnitFactory("ghoul-factory"){
            {
                this.requirements(Category.units, ItemStack.with(Items.titanium, 75, Items.lead, 65, Items.silicon, 110));
                this.unitType = UnitTypes.ghoul;
                this.produceTime = 1150.0f;
                this.size = 3;
                this.consumes.power(1.2f);
                this.consumes.items(new ItemStack(Items.silicon, 15), new ItemStack(Items.titanium, 10));
            }
        };
        revenantFactory = new UnitFactory("revenant-factory"){
            {
                this.requirements(Category.units, ItemStack.with(Items.plastanium, 50, Items.titanium, 150, Items.lead, 150, Items.silicon, 200));
                this.unitType = UnitTypes.revenant;
                this.produceTime = 2000.0f;
                this.size = 4;
                this.consumes.power(3.0f);
                this.consumes.items(new ItemStack(Items.silicon, 40), new ItemStack(Items.titanium, 30));
            }
        };
        daggerFactory = new UnitFactory("dagger-factory"){
            {
                this.requirements(Category.units, ItemStack.with(Items.lead, 55, Items.silicon, 35));
                this.unitType = UnitTypes.dagger;
                this.produceTime = 850.0f;
                this.size = 2;
                this.consumes.power(0.5f);
                this.consumes.items(new ItemStack(Items.silicon, 6));
            }
        };
        crawlerFactory = new UnitFactory("crawler-factory"){
            {
                this.requirements(Category.units, ItemStack.with(Items.lead, 45, Items.silicon, 30));
                this.unitType = UnitTypes.crawler;
                this.produceTime = 300.0f;
                this.size = 2;
                this.maxSpawn = 6;
                this.consumes.power(0.5f);
                this.consumes.items(new ItemStack(Items.coal, 10));
            }
        };
        titanFactory = new UnitFactory("titan-factory"){
            {
                this.requirements(Category.units, ItemStack.with(Items.graphite, 50, Items.lead, 50, Items.silicon, 45));
                this.unitType = UnitTypes.titan;
                this.produceTime = 1050.0f;
                this.size = 3;
                this.consumes.power(0.6f);
                this.consumes.items(new ItemStack(Items.silicon, 12));
            }
        };
        fortressFactory = new UnitFactory("fortress-factory"){
            {
                this.requirements(Category.units, ItemStack.with(Items.thorium, 40, Items.lead, 110, Items.silicon, 75));
                this.unitType = UnitTypes.fortress;
                this.produceTime = 2000.0f;
                this.size = 3;
                this.maxSpawn = 3;
                this.consumes.power(1.4f);
                this.consumes.items(new ItemStack(Items.silicon, 20), new ItemStack(Items.graphite, 10));
            }
        };
        repairPoint = new RepairPoint("repair-point"){
            {
                this.requirements(Category.units, ItemStack.with(Items.lead, 15, Items.copper, 15, Items.silicon, 15));
                this.repairSpeed = 0.5f;
                this.repairRadius = 65.0f;
                this.powerUse = 1.0f;
            }
        };
        dartPad = new MechPad("dart-mech-pad"){
            {
                this.requirements(Category.upgrade, ItemStack.with(Items.lead, 100, Items.graphite, 50, Items.copper, 75));
                this.mech = Mechs.alpha;
                this.size = 2;
                this.consumes.power(0.5f);
            }
        };
        deltaPad = new MechPad("delta-mech-pad"){
            {
                this.requirements(Category.upgrade, ItemStack.with(Items.lead, 175, Items.titanium, 175, Items.copper, 200, Items.silicon, 225, Items.thorium, 150));
                this.mech = Mechs.delta;
                this.size = 2;
                this.consumes.power(0.7f);
            }
        };
        tauPad = new MechPad("tau-mech-pad"){
            {
                this.requirements(Category.upgrade, ItemStack.with(Items.lead, 125, Items.titanium, 125, Items.copper, 125, Items.silicon, 125));
                this.mech = Mechs.tau;
                this.size = 2;
                this.consumes.power(1.0f);
            }
        };
        omegaPad = new MechPad("omega-mech-pad"){
            {
                this.requirements(Category.upgrade, ItemStack.with(Items.lead, 225, Items.graphite, 275, Items.silicon, 325, Items.thorium, 300, Items.surgealloy, 120));
                this.mech = Mechs.omega;
                this.size = 3;
                this.consumes.power(1.2f);
            }
        };
        javelinPad = new MechPad("javelin-ship-pad"){
            {
                this.requirements(Category.upgrade, ItemStack.with(Items.lead, 175, Items.silicon, 225, Items.titanium, 250, Items.plastanium, 200, Items.phasefabric, 100));
                this.mech = Mechs.javelin;
                this.size = 2;
                this.consumes.power(0.8f);
            }
        };
        tridentPad = new MechPad("trident-ship-pad"){
            {
                this.requirements(Category.upgrade, ItemStack.with(Items.lead, 125, Items.copper, 125, Items.silicon, 125, Items.titanium, 150, Items.plastanium, 100));
                this.mech = Mechs.trident;
                this.size = 2;
                this.consumes.power(1.0f);
            }
        };
        glaivePad = new MechPad("glaive-ship-pad"){
            {
                this.requirements(Category.upgrade, ItemStack.with(Items.lead, 225, Items.silicon, 325, Items.titanium, 350, Items.plastanium, 300, Items.surgealloy, 100));
                this.mech = Mechs.glaive;
                this.size = 3;
                this.consumes.power(1.2f);
            }
        };
    }
}

