/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ai;

import io.anuke.arc.Events;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.EnumSet;
import io.anuke.arc.collection.GridBits;
import io.anuke.arc.collection.IntMap;
import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.collection.ObjectSet;
import io.anuke.arc.function.Predicate;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.game.Teams;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.BuildBlock;
import io.anuke.mindustry.world.meta.BlockFlag;

public class BlockIndexer {
    private static final int quadrantSize = 16;
    private final ObjectSet<Item> scanOres = new ObjectSet();
    private final ObjectSet<Item> itemSet = new ObjectSet();
    private ObjectMap<Item, ObjectSet<Tile>> ores;
    private GridBits[] structQuadrants;
    private ObjectSet<Tile>[] damagedTiles = new ObjectSet[Team.all.length];
    private ObjectSet<Item> allOres = new ObjectSet();
    private ObjectSet<Tile>[][] flagMap = new ObjectSet[Team.all.length][BlockFlag.all.length];
    private IntMap<TileIndex> typeMap = new IntMap();
    private ObjectSet<Tile> emptySet = new ObjectSet();
    private Array<Tile> returnArray = new Array();

    public BlockIndexer() {
        Events.on(EventType.TileChangeEvent.class, event -> {
            if (this.typeMap.get(event.tile.pos()) != null) {
                TileIndex index = this.typeMap.get(event.tile.pos());
                for (BlockFlag flag : index.flags) {
                    this.getFlagged(index.team)[flag.ordinal()].remove(event.tile);
                }
            }
            this.process(event.tile);
            this.updateQuadrant(event.tile);
        });
        Events.on(EventType.WorldLoadEvent.class, event -> {
            int y;
            int x;
            int i;
            this.scanOres.clear();
            this.scanOres.addAll(Item.getAllOres());
            this.damagedTiles = new ObjectSet[Team.all.length];
            this.flagMap = new ObjectSet[Team.all.length][BlockFlag.all.length];
            for (i = 0; i < this.flagMap.length; ++i) {
                for (int j = 0; j < BlockFlag.all.length; ++j) {
                    this.flagMap[i][j] = new ObjectSet();
                }
            }
            this.typeMap.clear();
            this.allOres.clear();
            this.ores = null;
            this.structQuadrants = new GridBits[Team.all.length];
            for (i = 0; i < Team.all.length; ++i) {
                this.structQuadrants[i] = new GridBits(Mathf.ceil((float)Vars.world.width() / 16.0f), Mathf.ceil((float)Vars.world.height() / 16.0f));
            }
            for (x = 0; x < Vars.world.width(); ++x) {
                for (y = 0; y < Vars.world.height(); ++y) {
                    Tile tile = Vars.world.tile(x, y);
                    this.process(tile);
                    if (tile.entity != null && tile.entity.damaged()) {
                        this.notifyTileDamaged(tile.entity);
                    }
                    if (tile.drop() == null) continue;
                    this.allOres.add(tile.drop());
                }
            }
            for (x = 0; x < this.quadWidth(); ++x) {
                for (y = 0; y < this.quadHeight(); ++y) {
                    this.updateQuadrant(Vars.world.tile(x * 16, y * 16));
                }
            }
            this.scanOres();
        });
    }

    private ObjectSet<Tile>[] getFlagged(Team team) {
        return this.flagMap[team.ordinal()];
    }

    public boolean hasOre(Item item) {
        return this.allOres.contains(item);
    }

    public ObjectSet<Tile> getDamaged(Team team) {
        this.returnArray.clear();
        if (this.damagedTiles[team.ordinal()] == null) {
            this.damagedTiles[team.ordinal()] = new ObjectSet();
        }
        ObjectSet<Tile> set = this.damagedTiles[team.ordinal()];
        for (Tile tile : set) {
            if (tile.entity != null && tile.entity.getTeam() == team && tile.entity.damaged() && !(tile.block() instanceof BuildBlock)) continue;
            this.returnArray.add(tile);
        }
        for (Tile tile : this.returnArray) {
            set.remove(tile);
        }
        return set;
    }

    public ObjectSet<Tile> getAllied(Team team, BlockFlag type) {
        return this.flagMap[team.ordinal()][type.ordinal()];
    }

    public Array<Tile> getEnemy(Team team, BlockFlag type) {
        this.returnArray.clear();
        for (Team enemy : Vars.state.teams.enemiesOf(team)) {
            ObjectSet<Tile> set;
            if (!Vars.state.teams.isActive(enemy) || (set = this.getFlagged(enemy)[type.ordinal()]) == null) continue;
            for (Tile tile : set) {
                this.returnArray.add(tile);
            }
        }
        return this.returnArray;
    }

    public void notifyTileDamaged(TileEntity entity) {
        if (this.damagedTiles[entity.getTeam().ordinal()] == null) {
            this.damagedTiles[entity.getTeam().ordinal()] = new ObjectSet();
        }
        ObjectSet<Tile> set = this.damagedTiles[entity.getTeam().ordinal()];
        set.add(entity.tile);
    }

    public TileEntity findTile(Team team, float x, float y, float range, Predicate<Tile> pred) {
        return this.findTile(team, x, y, range, pred, false);
    }

    public TileEntity findTile(Team team, float x, float y, float range, Predicate<Tile> pred, boolean usePriority) {
        TileEntity closest = null;
        float dst = 0.0f;
        for (int rx = Math.max((int)((x - range) / 8.0f / 16.0f), 0); rx <= (int)((x + range) / 8.0f / 16.0f) && rx < this.quadWidth(); ++rx) {
            for (int ry = Math.max((int)((y - range) / 8.0f / 16.0f), 0); ry <= (int)((y + range) / 8.0f / 16.0f) && ry < this.quadHeight(); ++ry) {
                if (!this.getQuad(team, rx, ry)) continue;
                for (int tx = rx * 16; tx < (rx + 1) * 16 && tx < Vars.world.width(); ++tx) {
                    for (int ty = ry * 16; ty < (ry + 1) * 16 && ty < Vars.world.height(); ++ty) {
                        Tile other = Vars.world.ltile(tx, ty);
                        if (other == null || other.entity == null || other.getTeam() != team || !pred.test(other) || !other.block().targetable) continue;
                        TileEntity e = other.entity;
                        float ndst = Mathf.dst(x, y, e.x, e.y);
                        if (!(ndst < range) || closest != null && !(ndst < dst) && (!usePriority || closest.block.priority.ordinal() >= e.block.priority.ordinal())) continue;
                        dst = ndst;
                        closest = e;
                    }
                }
            }
        }
        return closest;
    }

    public ObjectSet<Tile> getOrePositions(Item item) {
        return this.ores.get(item, this.emptySet);
    }

    public Tile findClosestOre(float xp, float yp, Item item) {
        Tile tile = Geometry.findClosest(xp, yp, this.getOrePositions(item));
        if (tile == null) {
            return null;
        }
        for (int x = Math.max(0, tile.x - 8); x < tile.x + 8 && x < Vars.world.width(); ++x) {
            for (int y = Math.max(0, tile.y - 8); y < tile.y + 8 && y < Vars.world.height(); ++y) {
                Tile res = Vars.world.tile(x, y);
                if (res.block() != Blocks.air || res.drop() != item) continue;
                return res;
            }
        }
        return null;
    }

    private void process(Tile tile) {
        if (tile.block().flags.size() > 0 && tile.getTeam() != Team.derelict) {
            ObjectSet<Tile>[] map = this.getFlagged(tile.getTeam());
            for (BlockFlag flag : tile.block().flags) {
                ObjectSet<Tile> arr = map[flag.ordinal()];
                arr.add(tile);
                map[flag.ordinal()] = arr;
            }
            this.typeMap.put(tile.pos(), new TileIndex(tile.block().flags, tile.getTeam()));
        }
        if (this.ores == null) {
            return;
        }
        int quadrantX = tile.x / 16;
        int quadrantY = tile.y / 16;
        this.itemSet.clear();
        Tile rounded = Vars.world.tile(Mathf.clamp(quadrantX * 16 + 8, 0, Vars.world.width() - 1), Mathf.clamp(quadrantY * 16 + 8, 0, Vars.world.height() - 1));
        for (int x = Math.max(0, rounded.x - 8); x < rounded.x + 8 && x < Vars.world.width(); ++x) {
            for (int y = Math.max(0, rounded.y - 8); y < rounded.y + 8 && y < Vars.world.height(); ++y) {
                Tile result = Vars.world.tile(x, y);
                if (result == null || result.drop() == null || !this.scanOres.contains(result.drop()) || result.block() != Blocks.air) continue;
                this.itemSet.add(result.drop());
            }
        }
        for (Item item : this.scanOres) {
            ObjectSet<Tile> set = this.ores.get(item);
            if (!this.itemSet.contains(item)) {
                set.remove(rounded);
                continue;
            }
            set.add(rounded);
        }
    }

    private void updateQuadrant(Tile tile) {
        if (this.structQuadrants == null) {
            return;
        }
        int quadrantX = tile.x / 16;
        int quadrantY = tile.y / 16;
        int index = quadrantX + quadrantY * this.quadWidth();
        block0: for (Team team : Team.all) {
            Teams.TeamData data = Vars.state.teams.get(team);
            if (tile.getTeam() == data.team && tile.entity != null && tile.block().targetable) {
                this.structQuadrants[data.team.ordinal()].set(quadrantX, quadrantY);
                continue;
            }
            this.structQuadrants[data.team.ordinal()].set(quadrantX, quadrantY, false);
            for (int x = quadrantX * 16; x < Vars.world.width() && x < (quadrantX + 1) * 16; ++x) {
                for (int y = quadrantY * 16; y < Vars.world.height() && y < (quadrantY + 1) * 16; ++y) {
                    Tile result = Vars.world.ltile(x, y);
                    if (result.entity == null || result.getTeam() != data.team) continue;
                    this.structQuadrants[data.team.ordinal()].set(quadrantX, quadrantY);
                    continue block0;
                }
            }
        }
    }

    private boolean getQuad(Team team, int quadrantX, int quadrantY) {
        return this.structQuadrants[team.ordinal()].get(quadrantX, quadrantY);
    }

    private int quadWidth() {
        return Mathf.ceil((float)Vars.world.width() / 16.0f);
    }

    private int quadHeight() {
        return Mathf.ceil((float)Vars.world.height() / 16.0f);
    }

    private void scanOres() {
        this.ores = new ObjectMap();
        for (Item item : this.scanOres) {
            this.ores.put(item, new ObjectSet());
        }
        for (int x = 0; x < Vars.world.width(); ++x) {
            for (int y = 0; y < Vars.world.height(); ++y) {
                int qx = x / 16;
                int qy = y / 16;
                Tile tile = Vars.world.tile(x, y);
                if (tile.drop() == null || !this.scanOres.contains(tile.drop()) || tile.block() != Blocks.air) continue;
                this.ores.get(tile.drop()).add(Vars.world.tile(Mathf.clamp(qx * 16 + 8, 0, Vars.world.width() - 1), Mathf.clamp(qy * 16 + 8, 0, Vars.world.height() - 1)));
            }
        }
    }

    private class TileIndex {
        public final EnumSet<BlockFlag> flags;
        public final Team team;

        public TileIndex(EnumSet<BlockFlag> flags, Team team) {
            this.flags = flags;
            this.team = team;
        }
    }
}

