/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.util.viewport;

import io.anuke.arc.graphics.Camera;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.util.Scaling;
import io.anuke.arc.util.viewport.Viewport;

public class ScalingViewport
extends Viewport {
    private Scaling scaling;

    public ScalingViewport(Scaling scaling, float worldWidth, float worldHeight) {
        this(scaling, worldWidth, worldHeight, new Camera());
    }

    public ScalingViewport(Scaling scaling, float worldWidth, float worldHeight, Camera camera) {
        this.scaling = scaling;
        this.setWorldSize(worldWidth, worldHeight);
        this.setCamera(camera);
    }

    @Override
    public void update(int screenWidth, int screenHeight, boolean centerCamera) {
        Vector2 scaled = this.scaling.apply(this.getWorldWidth(), this.getWorldHeight(), screenWidth, screenHeight);
        int viewportWidth = Math.round(scaled.x);
        int viewportHeight = Math.round(scaled.y);
        this.setScreenBounds((screenWidth - viewportWidth) / 2, (screenHeight - viewportHeight) / 2, viewportWidth, viewportHeight);
        this.apply(centerCamera);
    }

    public Scaling getScaling() {
        return this.scaling;
    }

    public void setScaling(Scaling scaling) {
        this.scaling = scaling;
    }
}

