/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.util.noise;

import io.anuke.arc.util.noise.VectorTable;

public class RidgedPerlin {
    static final int X_NOISE_GEN = 1619;
    static final int Y_NOISE_GEN = 31337;
    static final int Z_NOISE_GEN = 6971;
    static final int SEED_NOISE_GEN = 1013;
    static final int SHIFT_NOISE_GEN = 8;
    float lacunarity = 2.0f;
    double[] spectralWeights = new double[20];
    private int octaves;
    private int seed;

    public RidgedPerlin(int seed, int octaves) {
        this.octaves = octaves;
        this.seed = seed;
        double h = 1.0;
        double frequency = 1.0;
        for (int i = 0; i < this.spectralWeights.length; ++i) {
            this.spectralWeights[i] = Math.pow(frequency, -h);
            frequency *= (double)this.lacunarity;
        }
    }

    public static double MakeInt32Range(double n) {
        if (n >= 1.073741824E9) {
            return 2.0 * (n % 1.073741824E9) - 1.073741824E9;
        }
        if (n <= -1.073741824E9) {
            return 2.0 * (n % 1.073741824E9) + 1.073741824E9;
        }
        return n;
    }

    public static double GradientCoherentNoise3D(double x, double y, double z, int seed) {
        int quality = 2;
        int x0 = x > 0.0 ? (int)x : (int)x - 1;
        int x1 = x0 + 1;
        int y0 = y > 0.0 ? (int)y : (int)y - 1;
        int y1 = y0 + 1;
        int z0 = z > 0.0 ? (int)z : (int)z - 1;
        int z1 = z0 + 1;
        double xs = 0.0;
        double ys = 0.0;
        double zs = 0.0;
        switch (quality) {
            case 0: {
                xs = x - (double)x0;
                ys = y - (double)y0;
                zs = z - (double)z0;
                break;
            }
            case 1: {
                xs = RidgedPerlin.SCurve3(x - (double)x0);
                ys = RidgedPerlin.SCurve3(y - (double)y0);
                zs = RidgedPerlin.SCurve3(z - (double)z0);
                break;
            }
            case 2: {
                xs = RidgedPerlin.SCurve5(x - (double)x0);
                ys = RidgedPerlin.SCurve5(y - (double)y0);
                zs = RidgedPerlin.SCurve5(z - (double)z0);
            }
        }
        double n0 = RidgedPerlin.GradientNoise3D(x, y, z, x0, y0, z0, seed);
        double n1 = RidgedPerlin.GradientNoise3D(x, y, z, x1, y0, z0, seed);
        double ix0 = RidgedPerlin.linearInterp(n0, n1, xs);
        n0 = RidgedPerlin.GradientNoise3D(x, y, z, x0, y1, z0, seed);
        n1 = RidgedPerlin.GradientNoise3D(x, y, z, x1, y1, z0, seed);
        double ix1 = RidgedPerlin.linearInterp(n0, n1, xs);
        double iy0 = RidgedPerlin.linearInterp(ix0, ix1, ys);
        n0 = RidgedPerlin.GradientNoise3D(x, y, z, x0, y0, z1, seed);
        n1 = RidgedPerlin.GradientNoise3D(x, y, z, x1, y0, z1, seed);
        ix0 = RidgedPerlin.linearInterp(n0, n1, xs);
        n0 = RidgedPerlin.GradientNoise3D(x, y, z, x0, y1, z1, seed);
        n1 = RidgedPerlin.GradientNoise3D(x, y, z, x1, y1, z1, seed);
        ix1 = RidgedPerlin.linearInterp(n0, n1, xs);
        double iy1 = RidgedPerlin.linearInterp(ix0, ix1, ys);
        return RidgedPerlin.linearInterp(iy0, iy1, zs);
    }

    public static double GradientNoise3D(double fx, double fy, double fz, int ix, int iy, int iz, int seed) {
        int vectorIndex = 1619 * ix + 31337 * iy + 6971 * iz + 1013 * seed;
        vectorIndex ^= vectorIndex >> 8;
        double xvGradient = VectorTable.getRandomVectors(vectorIndex &= 0xFF, 0);
        double yvGradient = VectorTable.getRandomVectors(vectorIndex, 1);
        double zvGradient = VectorTable.getRandomVectors(vectorIndex, 2);
        double xvPoint = fx - (double)ix;
        double yvPoint = fy - (double)iy;
        double zvPoint = fz - (double)iz;
        return (xvGradient * xvPoint + yvGradient * yvPoint + zvGradient * zvPoint) * 2.12;
    }

    public static double cubicInterp(double n0, double n1, double n2, double n3, double a) {
        double p = n3 - n2 - (n0 - n1);
        double q = n0 - n1 - p;
        double r = n2 - n0;
        return p * a * a * a + q * a * a + r * a + n1;
    }

    public static double linearInterp(double n0, double n1, double a) {
        return (1.0 - a) * n0 + a * n1;
    }

    public static double SCurve3(double a) {
        return a * a * (3.0 - 2.0 * a);
    }

    static double SCurve5(double a) {
        double a3 = a * a * a;
        double a4 = a3 * a;
        double a5 = a4 * a;
        return 6.0 * a5 - 15.0 * a4 + 10.0 * a3;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public float getValue(int x, int y, float frequency) {
        return this.getValue(x, y, 0, frequency);
    }

    public float getValue(int x, int y, int z, float frequency) {
        double x1 = x;
        double y1 = y;
        double z1 = z;
        x1 *= (double)frequency;
        y1 *= (double)frequency;
        z1 *= (double)frequency;
        double value = 0.0;
        double weight = 1.0;
        double offset = 1.0;
        double gain = 2.0;
        for (int curOctave = 0; curOctave < this.octaves; ++curOctave) {
            double nx = RidgedPerlin.MakeInt32Range(x1);
            double ny = RidgedPerlin.MakeInt32Range(y1);
            double nz = RidgedPerlin.MakeInt32Range(z1);
            int seed = this.seed + curOctave & Integer.MAX_VALUE;
            double signal = RidgedPerlin.GradientCoherentNoise3D(nx, ny, nz, seed);
            signal = Math.abs(signal);
            signal = offset - signal;
            signal *= signal;
            if ((weight = (signal *= weight) * gain) > 1.0) {
                weight = 1.0;
            }
            if (weight < 0.0) {
                weight = 0.0;
            }
            value += signal * this.spectralWeights[curOctave];
            x1 *= (double)this.lacunarity;
            y1 *= (double)this.lacunarity;
            z1 *= (double)this.lacunarity;
        }
        return (float)(value * 1.25 - 1.0);
    }
}

