/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.util;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.LongArray;
import io.anuke.arc.util.Timer;
import io.anuke.arc.util.pooling.Pool;
import io.anuke.arc.util.pooling.Pools;
import java.util.Iterator;

public class Time {
    private static final long nanosPerMilli = 1000000L;
    private static double time;
    private static double globalTime;
    private static Array<DelayRun> runs;
    private static Array<DelayRun> removal;
    private static LongArray marks;
    private static DeltaProvider deltaimpl;

    public static synchronized void run(float delay, Runnable r) {
        DelayRun run = Pools.obtain(DelayRun.class, DelayRun::new);
        run.finish = r;
        run.delay = delay;
        runs.add(run);
    }

    public static synchronized void runTask(float delay, Runnable r) {
        Timer.schedule(r, delay / 60.0f);
    }

    public static float time() {
        return (float)time;
    }

    public static float globalTime() {
        return (float)globalTime;
    }

    public static void mark() {
        marks.add(Time.nanos());
    }

    public static float elapsed() {
        if (Time.marks.size == 0) {
            return -1.0f;
        }
        return (float)Time.timeSinceNanos(marks.pop()) / 1000000.0f;
    }

    public static void updateGlobal() {
        globalTime += (double)(Core.graphics.getDeltaTime() * 60.0f);
    }

    public static void update() {
        float delta = Time.delta();
        removal.clear();
        if (Double.isInfinite(time += (double)delta) || Double.isNaN(time)) {
            time = 0.0;
        }
        Iterator<DelayRun> iterator = runs.iterator();
        while (iterator.hasNext()) {
            DelayRun run;
            DelayRun delayRun = run = iterator.next();
            delayRun.delay = delayRun.delay - delta;
            if (!(run.delay <= 0.0f)) continue;
            run.finish.run();
            removal.add(run);
            Pools.free(run);
        }
        runs.removeAll(removal);
    }

    public static synchronized void clear() {
        runs.clear();
    }

    public static float delta() {
        return deltaimpl.get();
    }

    public static void setDeltaProvider(DeltaProvider impl) {
        deltaimpl = impl;
    }

    static void dispose() {
        runs.clear();
    }

    public static long nanos() {
        return System.nanoTime();
    }

    public static long millis() {
        return System.currentTimeMillis();
    }

    public static long nanosToMillis(long nanos) {
        return nanos / 1000000L;
    }

    public static long millisToNanos(long millis) {
        return millis * 1000000L;
    }

    public static long timeSinceNanos(long prevTime) {
        return Time.nanos() - prevTime;
    }

    public static long timeSinceMillis(long prevTime) {
        return Time.millis() - prevTime;
    }

    static {
        runs = new Array();
        removal = new Array();
        marks = new LongArray();
        deltaimpl = () -> Math.min(Core.graphics.getDeltaTime() * 60.0f, 3.0f);
    }

    public static class DelayRun
    implements Pool.Poolable {
        private float delay;
        private Runnable finish;

        @Override
        public void reset() {
            this.delay = 0.0f;
            this.finish = null;
        }
    }

    public static interface DeltaProvider {
        public float get();
    }
}

