/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.util;

import io.anuke.arc.collection.Array;
import java.nio.charset.Charset;

public class Strings {
    public static final Charset utf8 = Charset.forName("UTF-8");

    public static Array<Throwable> getCauses(Throwable e) {
        Array<Throwable> arr = new Array<Throwable>();
        while (e != null) {
            arr.add(e);
            e = e.getCause();
        }
        return arr;
    }

    public static String getFinalMesage(Throwable e) {
        String message = e.getMessage();
        while (e.getCause() != null) {
            if ((e = e.getCause()).getMessage() == null) continue;
            message = e.getMessage();
        }
        return message;
    }

    public static Throwable getFinalCause(Throwable e) {
        while (e.getCause() != null) {
            e = e.getCause();
        }
        return e;
    }

    public static String parseException(Throwable e, boolean stacktrace) {
        StringBuilder build = new StringBuilder();
        while (e != null) {
            String name = e.getClass().toString().substring("class ".length()).replace("Exception", "");
            if (name.indexOf(46) != -1) {
                name = name.substring(name.lastIndexOf(46) + 1);
            }
            build.append("> ").append(name);
            if (e.getMessage() != null) {
                build.append(": ");
                build.append("'").append(e.getMessage()).append("'");
            }
            if (stacktrace) {
                for (StackTraceElement s : e.getStackTrace()) {
                    if (s.getClassName().contains("MethodAccessor") || s.getClassName().substring(s.getClassName().lastIndexOf(".") + 1).equals("Method")) continue;
                    build.append("\n");
                    String className = s.getClassName();
                    build.append(className.substring(className.lastIndexOf(".") + 1)).append(".").append(s.getMethodName()).append(": ").append(s.getLineNumber());
                }
            }
            build.append("\n");
            e = e.getCause();
        }
        return build.toString();
    }

    public static String format(String text, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            text = text.replace("{" + i + "}", String.valueOf(args[i]));
        }
        return text;
    }

    public static String join(String separator, String ... strings) {
        StringBuilder builder = new StringBuilder();
        for (String s : strings) {
            builder.append(s);
            builder.append(separator);
        }
        builder.setLength(builder.length() - separator.length());
        return builder.toString();
    }

    public static String join(String separator, Iterable<String> strings) {
        StringBuilder builder = new StringBuilder();
        for (String s : strings) {
            builder.append(s);
            builder.append(separator);
        }
        builder.setLength(builder.length() - separator.length());
        return builder.toString();
    }

    public static int levenshtein(String x, String y) {
        int[][] dp = new int[x.length() + 1][y.length() + 1];
        for (int i = 0; i <= x.length(); ++i) {
            for (int j = 0; j <= y.length(); ++j) {
                dp[i][j] = i == 0 ? j : (j == 0 ? i : Math.min(Math.min(dp[i - 1][j - 1] + (x.charAt(i - 1) == y.charAt(j - 1) ? 0 : 1), dp[i - 1][j] + 1), dp[i][j - 1] + 1));
            }
        }
        return dp[x.length()][y.length()];
    }

    public static String animated(float time, int length, float scale, String replacement) {
        return new String(new char[Math.abs((int)(time / scale) % length)]).replace("\u0000", replacement);
    }

    public static String capitalize(String s) {
        StringBuilder result = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '_' || c == '-') {
                result.append(" ");
                continue;
            }
            if (i == 0 || s.charAt(i - 1) == '_' || s.charAt(i - 1) == '-') {
                result.append(Character.toUpperCase(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String camelize(String s) {
        StringBuilder result = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (i == 0) {
                result.append(Character.toLowerCase(c));
                continue;
            }
            if (c == ' ') continue;
            result.append(c);
        }
        return result.toString();
    }

    public static boolean canParseInt(String s) {
        return Strings.parseInt(s) != Integer.MIN_VALUE;
    }

    public static boolean canParsePostiveInt(String s) {
        int p = Strings.parseInt(s);
        return p >= 0;
    }

    public static long parseLong(String s, long defaultValue) {
        try {
            return Long.parseLong(s);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int parseInt(String s, int defaultValue) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int parseInt(String s) {
        return Strings.parseInt(s, Integer.MIN_VALUE);
    }

    public static boolean canParsePositiveFloat(String s) {
        float p = Strings.parseFloat(s);
        return p >= 0.0f;
    }

    public static int parsePositiveInt(String s) {
        if (!Strings.canParsePostiveInt(s)) {
            return Integer.MIN_VALUE;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return Integer.MIN_VALUE;
        }
    }

    public static float parseFloat(String s) {
        return Strings.parseFloat(s, Float.MIN_VALUE);
    }

    public static float parseFloat(String s, float defaultValue) {
        try {
            return Float.parseFloat(s);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String autoFixed(float value, int max) {
        int precision = Math.abs((float)((int)value) - value) <= 0.001f ? 0 : (Math.abs((float)((int)(value * 10.0f)) - value * 10.0f) <= 0.001f ? 1 : 2);
        return Strings.fixed(value, Math.min(precision, max));
    }

    public static String fixed(float d, int decimalPlaces) {
        if (decimalPlaces < 0 || decimalPlaces > 8) {
            throw new IllegalArgumentException("Unsupported number of decimal places: " + decimalPlaces);
        }
        String s = "" + Math.round((double)d * Math.pow(10.0, decimalPlaces));
        int len = s.length();
        int decimalPosition = len - decimalPlaces;
        StringBuilder result = new StringBuilder();
        if (decimalPlaces == 0) {
            return s;
        }
        if (decimalPosition > 0) {
            result.append(s, 0, decimalPosition);
            result.append(".");
            result.append(s.substring(decimalPosition));
        } else {
            result.append("0.");
            while (decimalPosition++ < 0) {
                result.append("0");
            }
            result.append(s);
        }
        return result.toString();
    }

    public static String formatMillis(long val) {
        StringBuilder buf = new StringBuilder(20);
        String sgn = "";
        if (val < 0L) {
            sgn = "-";
        }
        val = Math.abs(val);
        Strings.append(buf, sgn, 0, val / 3600000L);
        Strings.append(buf, ":", 2, (val %= 3600000L) / 60000L);
        Strings.append(buf, ":", 2, (val %= 60000L) / 1000L);
        return buf.toString();
    }

    private static void append(StringBuilder tgt, String pfx, int dgt, long val) {
        tgt.append(pfx);
        if (dgt > 1) {
            int pad = dgt - 1;
            for (long xa = val; xa > 9L && pad > 0; --pad, xa /= 10L) {
            }
            for (int xa = 0; xa < pad; ++xa) {
                tgt.append('0');
            }
        }
        tgt.append(val);
    }

    public static StringBuilder replace(StringBuilder builder, String find, String replace) {
        int findLength = find.length();
        int replaceLength = replace.length();
        int index = 0;
        while ((index = builder.indexOf(find, index)) != -1) {
            builder.replace(index, index + findLength, replace);
            index += replaceLength;
        }
        return builder;
    }

    public static StringBuilder replace(StringBuilder builder, char find, String replace) {
        int replaceLength = replace.length();
        int index = 0;
        while (index != builder.length()) {
            if (builder.charAt(index) != find) {
                ++index;
                continue;
            }
            builder.replace(index, index + 1, replace);
            index += replaceLength;
        }
        return builder;
    }
}

