/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.util;

import io.anuke.arc.Core;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.graphics.Pixmap;
import io.anuke.arc.graphics.PixmapIO;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.BufferUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public final class ScreenUtils {
    public static void saveScreenshot(FileHandle file) {
        ScreenUtils.saveScreenshot(file, 0, 0, Core.graphics.getWidth(), Core.graphics.getHeight());
    }

    public static void saveScreenshot(FileHandle file, int x, int y, int width, int height) {
        Pixmap pixmap = ScreenUtils.getFrameBufferPixmap(x, y, width, height, true);
        PixmapIO.writePNG(file, pixmap);
        pixmap.dispose();
    }

    public static TextureRegion getFrameBufferTexture() {
        int w = Core.graphics.getBackBufferWidth();
        int h = Core.graphics.getBackBufferHeight();
        return ScreenUtils.getFrameBufferTexture(0, 0, w, h);
    }

    public static TextureRegion getFrameBufferTexture(int x, int y, int w, int h) {
        int potW = Mathf.nextPowerOfTwo(w);
        int potH = Mathf.nextPowerOfTwo(h);
        Pixmap pixmap = ScreenUtils.getFrameBufferPixmap(x, y, w, h);
        Pixmap potPixmap = new Pixmap(potW, potH, Pixmap.Format.RGBA8888);
        potPixmap.drawPixmap(pixmap, 0, 0);
        Texture texture = new Texture(potPixmap);
        TextureRegion textureRegion = new TextureRegion(texture, 0, h, w, -h);
        potPixmap.dispose();
        pixmap.dispose();
        return textureRegion;
    }

    public static Pixmap getFrameBufferPixmap(int x, int y, int w, int h) {
        Core.gl.glPixelStorei(3333, 1);
        Pixmap pixmap = new Pixmap(w, h, Pixmap.Format.RGBA8888);
        ByteBuffer pixels = pixmap.getPixels();
        Core.gl.glReadPixels(x, y, w, h, 6408, 5121, pixels);
        return pixmap;
    }

    public static Pixmap getFrameBufferPixmap(int x, int y, int w, int h, boolean flip) {
        byte[] lines = ScreenUtils.getFrameBufferPixels(x, y, w, h, flip);
        Pixmap pixmap = new Pixmap(w, h, Pixmap.Format.RGBA8888);
        BufferUtils.copy(lines, 0, (Buffer)pixmap.getPixels(), lines.length);
        return pixmap;
    }

    public static byte[] getFrameBufferPixels(boolean flipY) {
        int w = Core.graphics.getBackBufferWidth();
        int h = Core.graphics.getBackBufferHeight();
        return ScreenUtils.getFrameBufferPixels(0, 0, w, h, flipY);
    }

    public static byte[] getFrameBufferPixels(int x, int y, int w, int h, boolean flipY) {
        Core.gl.glPixelStorei(3333, 1);
        ByteBuffer pixels = BufferUtils.newByteBuffer(w * h * 4);
        Core.gl.glReadPixels(x, y, w, h, 6408, 5121, pixels);
        int numBytes = w * h * 4;
        byte[] lines = new byte[numBytes];
        if (flipY) {
            int numBytesPerLine = w * 4;
            for (int i = 0; i < h; ++i) {
                pixels.position((h - i - 1) * numBytesPerLine);
                pixels.get(lines, i * numBytesPerLine, numBytesPerLine);
            }
        } else {
            pixels.clear();
            pixels.get(lines);
        }
        return lines;
    }
}

