/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.util;

import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.util.OS;

public class ColorCodes {
    public static String FLUSH = "\u001b[H\u001b[2J";
    public static String RESET = "\u001b[0m";
    public static String BOLD = "\u001b[1m";
    public static String ITALIC = "\u001b[3m";
    public static String UNDERLINED = "\u001b[4m";
    public static String BLACK = "\u001b[30m";
    public static String RED = "\u001b[31m";
    public static String GREEN = "\u001b[32m";
    public static String YELLOW = "\u001b[33m";
    public static String BLUE = "\u001b[34m";
    public static String PURPLE = "\u001b[35m";
    public static String CYAN = "\u001b[36m";
    public static String LIGHT_RED = "\u001b[91m";
    public static String LIGHT_GREEN = "\u001b[92m";
    public static String LIGHT_YELLOW = "\u001b[93m";
    public static String LIGHT_BLUE = "\u001b[94m";
    public static String LIGHT_MAGENTA = "\u001b[95m";
    public static String LIGHT_CYAN = "\u001b[96m";
    public static String WHITE = "\u001b[37m";
    public static String BACK_DEFAULT = "\u001b[49m";
    public static String BACK_RED = "\u001b[41m";
    public static String BACK_GREEN = "\u001b[42m";
    public static String BACK_YELLOW = "\u001b[43m";
    public static String BACK_BLUE = "\u001b[44m";
    private static ObjectMap<String, String> codes = new ObjectMap();

    public static Iterable<String> getColorCodes() {
        return new ObjectMap.Keys<String>(codes);
    }

    public static String getColorText(String code) {
        return codes.get(code);
    }

    static {
        if (OS.isWindows) {
            ITALIC = "";
            BACK_GREEN = "";
            BACK_BLUE = "";
            BACK_YELLOW = "";
            BACK_RED = "";
            BACK_DEFAULT = "";
            WHITE = "";
            LIGHT_CYAN = "";
            LIGHT_MAGENTA = "";
            LIGHT_BLUE = "";
            LIGHT_YELLOW = "";
            LIGHT_GREEN = "";
            LIGHT_RED = "";
            CYAN = "";
            PURPLE = "";
            BLUE = "";
            YELLOW = "";
            GREEN = "";
            RED = "";
            BLACK = "";
            UNDERLINED = "";
            BOLD = "";
            RESET = "";
            FLUSH = "";
        }
        codes.put("ff", FLUSH);
        codes.put("fr", RESET);
        codes.put("fb", BOLD);
        codes.put("fi", ITALIC);
        codes.put("fu", UNDERLINED);
        codes.put("bk", BLACK);
        codes.put("r", RED);
        codes.put("g", GREEN);
        codes.put("y", YELLOW);
        codes.put("b", BLUE);
        codes.put("p", PURPLE);
        codes.put("c", CYAN);
        codes.put("lr", LIGHT_RED);
        codes.put("lg", LIGHT_GREEN);
        codes.put("ly", LIGHT_YELLOW);
        codes.put("lm", LIGHT_MAGENTA);
        codes.put("lb", LIGHT_BLUE);
        codes.put("lc", LIGHT_CYAN);
        codes.put("w", WHITE);
        codes.put("bd", BACK_DEFAULT);
        codes.put("br", BACK_RED);
        codes.put("bg", BACK_GREEN);
        codes.put("by", BACK_YELLOW);
        codes.put("bb", BACK_BLUE);
    }
}

