/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.scene.utils;

import io.anuke.arc.function.BooleanConsumer;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.scene.style.Drawable;
import io.anuke.arc.scene.ui.CheckBox;
import io.anuke.arc.scene.ui.ImageButton;
import io.anuke.arc.scene.ui.TextButton;
import io.anuke.arc.scene.ui.TextField;

public class Elements {
    public static CheckBox newCheck(String text, BooleanConsumer listener) {
        CheckBox button = new CheckBox(text);
        if (listener != null) {
            button.changed(() -> listener.accept(button.isChecked()));
        }
        return button;
    }

    public static TextButton newButton(String text, Runnable listener) {
        TextButton button = new TextButton(text);
        if (listener != null) {
            button.changed(listener);
        }
        return button;
    }

    public static TextButton newButton(String text, TextButton.TextButtonStyle style, Runnable listener) {
        TextButton button = new TextButton(text, style);
        if (listener != null) {
            button.changed(listener);
        }
        return button;
    }

    public static ImageButton newImageButton(Drawable icon, Runnable listener) {
        ImageButton button = new ImageButton(icon);
        if (listener != null) {
            button.changed(listener);
        }
        return button;
    }

    public static ImageButton newImageButton(Drawable icon, float size, Runnable listener) {
        ImageButton button = new ImageButton(icon);
        button.resizeImage(size);
        if (listener != null) {
            button.changed(listener);
        }
        return button;
    }

    public static ImageButton newImageButton(ImageButton.ImageButtonStyle style, Drawable icon, float size, Runnable listener) {
        ImageButton button = new ImageButton(icon, style);
        button.resizeImage(size);
        if (listener != null) {
            button.changed(listener);
        }
        return button;
    }

    public static ImageButton newImageButton(Drawable icon, float size, Color color, Runnable listener) {
        ImageButton button = new ImageButton(icon);
        button.resizeImage(size);
        button.getImage().setColor(color);
        if (listener != null) {
            button.changed(listener);
        }
        return button;
    }

    public static TextField newField(String text, Consumer<String> listener) {
        TextField field = new TextField(text);
        if (listener != null) {
            field.changed(() -> {
                if (field.isValid()) {
                    listener.accept(field.getText());
                }
            });
        }
        return field;
    }
}

