/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.scene.utils;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.Scene;
import io.anuke.arc.scene.event.DragListener;
import io.anuke.arc.scene.event.EventListener;
import io.anuke.arc.scene.event.InputEvent;
import io.anuke.arc.scene.event.Touchable;

public class DragAndDrop {
    static final Vector2 tmpVector = new Vector2();
    Payload payload;
    Element dragActor;
    Target target;
    boolean isValidTarget;
    Array<Target> targets = new Array();
    ObjectMap<Source, DragListener> sourceListeners = new ObjectMap();
    float dragActorX = 0.0f;
    float dragActorY = 0.0f;
    float touchOffsetX;
    float touchOffsetY;
    long dragStartTime;
    int dragTime = 250;
    int activePointer = -1;
    boolean cancelTouchFocus = true;
    boolean keepWithinStage = true;
    private float tapSquareSize = 8.0f;
    private int button;

    public void addSource(final Source source) {
        DragListener listener = new DragListener(){

            @Override
            public void dragStart(InputEvent event, float x, float y, int pointer) {
                if (DragAndDrop.this.activePointer != -1) {
                    event.stop();
                    return;
                }
                DragAndDrop.this.activePointer = pointer;
                DragAndDrop.this.dragStartTime = System.currentTimeMillis();
                DragAndDrop.this.payload = source.dragStart(event, this.getTouchDownX(), this.getTouchDownY(), pointer);
                event.stop();
                if (DragAndDrop.this.cancelTouchFocus && DragAndDrop.this.payload != null) {
                    source.getActor().getScene().cancelTouchFocusExcept(this, source.getActor());
                }
            }

            @Override
            public void drag(InputEvent event, float x, float y, int pointer) {
                if (DragAndDrop.this.payload == null) {
                    return;
                }
                if (pointer != DragAndDrop.this.activePointer) {
                    return;
                }
                Touchable dragActorTouchable = null;
                if (DragAndDrop.this.dragActor != null) {
                    dragActorTouchable = DragAndDrop.this.dragActor.getTouchable();
                    DragAndDrop.this.dragActor.touchable(Touchable.disabled);
                }
                Target newTarget = null;
                DragAndDrop.this.isValidTarget = false;
                float stageX = event.stageX + DragAndDrop.this.touchOffsetX;
                float stageY = event.stageY + DragAndDrop.this.touchOffsetY;
                Element hit = Core.scene.hit(stageX, stageY, true);
                if (hit == null) {
                    hit = Core.scene.hit(stageX, stageY, false);
                }
                if (hit != null) {
                    int n = DragAndDrop.this.targets.size;
                    for (int i = 0; i < n; ++i) {
                        Target target = DragAndDrop.this.targets.get(i);
                        if (!target.actor.isAscendantOf(hit)) continue;
                        newTarget = target;
                        target.actor.stageToLocalCoordinates(tmpVector.set(stageX, stageY));
                        break;
                    }
                }
                if (newTarget != DragAndDrop.this.target) {
                    if (DragAndDrop.this.target != null) {
                        DragAndDrop.this.target.reset(source, DragAndDrop.this.payload);
                    }
                    DragAndDrop.this.target = newTarget;
                }
                if (newTarget != null) {
                    DragAndDrop.this.isValidTarget = newTarget.drag(source, DragAndDrop.this.payload, DragAndDrop.tmpVector.x, DragAndDrop.tmpVector.y, pointer);
                }
                if (DragAndDrop.this.dragActor != null) {
                    DragAndDrop.this.dragActor.touchable(dragActorTouchable);
                }
                Element actor = null;
                if (DragAndDrop.this.target != null) {
                    Element element = actor = DragAndDrop.this.isValidTarget ? DragAndDrop.this.payload.validDragActor : DragAndDrop.this.payload.invalidDragActor;
                }
                if (actor == null) {
                    actor = DragAndDrop.this.payload.dragActor;
                }
                if (actor == null) {
                    return;
                }
                if (DragAndDrop.this.dragActor != actor) {
                    if (DragAndDrop.this.dragActor != null) {
                        DragAndDrop.this.dragActor.remove();
                    }
                    DragAndDrop.this.dragActor = actor;
                    Core.scene.add(actor);
                }
                float actorX = event.stageX - actor.getWidth() + DragAndDrop.this.dragActorX;
                float actorY = event.stageY + DragAndDrop.this.dragActorY;
                if (DragAndDrop.this.keepWithinStage) {
                    if (actorX < 0.0f) {
                        actorX = 0.0f;
                    }
                    if (actorY < 0.0f) {
                        actorY = 0.0f;
                    }
                    if (actorX + actor.getWidth() > Core.scene.getWidth()) {
                        actorX = Core.scene.getWidth() - actor.getWidth();
                    }
                    if (actorY + actor.getHeight() > Core.scene.getHeight()) {
                        actorY = Core.scene.getHeight() - actor.getHeight();
                    }
                }
                actor.setPosition(actorX, actorY);
            }

            @Override
            public void dragStop(InputEvent event, float x, float y, int pointer) {
                if (pointer != DragAndDrop.this.activePointer) {
                    return;
                }
                DragAndDrop.this.activePointer = -1;
                if (DragAndDrop.this.payload == null) {
                    return;
                }
                if (System.currentTimeMillis() - DragAndDrop.this.dragStartTime < (long)DragAndDrop.this.dragTime) {
                    DragAndDrop.this.isValidTarget = false;
                }
                if (DragAndDrop.this.dragActor != null) {
                    DragAndDrop.this.dragActor.remove();
                }
                if (DragAndDrop.this.isValidTarget) {
                    float stageX = event.stageX + DragAndDrop.this.touchOffsetX;
                    float stageY = event.stageY + DragAndDrop.this.touchOffsetY;
                    DragAndDrop.this.target.actor.stageToLocalCoordinates(tmpVector.set(stageX, stageY));
                    DragAndDrop.this.target.drop(source, DragAndDrop.this.payload, DragAndDrop.tmpVector.x, DragAndDrop.tmpVector.y, pointer);
                }
                source.dragStop(event, x, y, pointer, DragAndDrop.this.payload, DragAndDrop.this.isValidTarget ? DragAndDrop.this.target : null);
                if (DragAndDrop.this.target != null) {
                    DragAndDrop.this.target.reset(source, DragAndDrop.this.payload);
                }
                DragAndDrop.this.payload = null;
                DragAndDrop.this.target = null;
                DragAndDrop.this.isValidTarget = false;
                DragAndDrop.this.dragActor = null;
            }
        };
        listener.setTapSquareSize(this.tapSquareSize);
        listener.setButton(this.button);
        source.actor.addCaptureListener(listener);
        this.sourceListeners.put(source, listener);
    }

    public void removeSource(Source source) {
        DragListener dragListener = this.sourceListeners.remove(source);
        source.actor.removeCaptureListener(dragListener);
    }

    public void addTarget(Target target) {
        this.targets.add(target);
    }

    public void removeTarget(Target target) {
        this.targets.removeValue(target, true);
    }

    public void clear() {
        this.targets.clear();
        for (ObjectMap.Entry entry : this.sourceListeners.entries()) {
            ((Source)entry.key).actor.removeCaptureListener((EventListener)entry.value);
        }
        this.sourceListeners.clear();
    }

    public void setTapSquareSize(float halfTapSquareSize) {
        this.tapSquareSize = halfTapSquareSize;
    }

    public void setButton(int button) {
        this.button = button;
    }

    public void setDragActorPosition(float dragActorX, float dragActorY) {
        this.dragActorX = dragActorX;
        this.dragActorY = dragActorY;
    }

    public void setTouchOffset(float touchOffsetX, float touchOffsetY) {
        this.touchOffsetX = touchOffsetX;
        this.touchOffsetY = touchOffsetY;
    }

    public boolean isDragging() {
        return this.payload != null;
    }

    public Element getDragActor() {
        return this.dragActor;
    }

    public void setDragTime(int dragMillis) {
        this.dragTime = dragMillis;
    }

    public void setCancelTouchFocus(boolean cancelTouchFocus) {
        this.cancelTouchFocus = cancelTouchFocus;
    }

    public void setKeepWithinStage(boolean keepWithinStage) {
        this.keepWithinStage = keepWithinStage;
    }

    public static class Payload {
        Element dragActor;
        Element validDragActor;
        Element invalidDragActor;
        Object object;

        public Element getDragActor() {
            return this.dragActor;
        }

        public void setDragActor(Element dragActor) {
            this.dragActor = dragActor;
        }

        public Element getValidDragActor() {
            return this.validDragActor;
        }

        public void setValidDragActor(Element validDragActor) {
            this.validDragActor = validDragActor;
        }

        public Element getInvalidDragActor() {
            return this.invalidDragActor;
        }

        public void setInvalidDragActor(Element invalidDragActor) {
            this.invalidDragActor = invalidDragActor;
        }

        public Object getObject() {
            return this.object;
        }

        public void setObject(Object object) {
            this.object = object;
        }
    }

    public static abstract class Target {
        final Element actor;

        public Target(Element actor) {
            if (actor == null) {
                throw new IllegalArgumentException("actor cannot be null.");
            }
            this.actor = actor;
            Scene stage = actor.getScene();
            if (stage != null && actor == stage.root) {
                throw new IllegalArgumentException("The stage root cannot be a drag and drop target.");
            }
        }

        public abstract boolean drag(Source var1, Payload var2, float var3, float var4, int var5);

        public void reset(Source source, Payload payload) {
        }

        public abstract void drop(Source var1, Payload var2, float var3, float var4, int var5);

        public Element getActor() {
            return this.actor;
        }
    }

    public static abstract class Source {
        final Element actor;

        public Source(Element actor) {
            if (actor == null) {
                throw new IllegalArgumentException("actor cannot be null.");
            }
            this.actor = actor;
        }

        public abstract Payload dragStart(InputEvent var1, float var2, float var3, int var4);

        public void dragStop(InputEvent event, float x, float y, int pointer, Payload payload, Target target) {
        }

        public Element getActor() {
            return this.actor;
        }
    }
}

