/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.scene.ui.layout;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.SnapshotArray;
import io.anuke.arc.function.BooleanConsumer;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.function.FloatConsumer;
import io.anuke.arc.function.Supplier;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.event.Touchable;
import io.anuke.arc.scene.style.Drawable;
import io.anuke.arc.scene.ui.Button;
import io.anuke.arc.scene.ui.CheckBox;
import io.anuke.arc.scene.ui.Image;
import io.anuke.arc.scene.ui.ImageButton;
import io.anuke.arc.scene.ui.Label;
import io.anuke.arc.scene.ui.ScrollPane;
import io.anuke.arc.scene.ui.Slider;
import io.anuke.arc.scene.ui.TextArea;
import io.anuke.arc.scene.ui.TextButton;
import io.anuke.arc.scene.ui.TextField;
import io.anuke.arc.scene.ui.layout.Cell;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.scene.ui.layout.Stack;
import io.anuke.arc.scene.ui.layout.WidgetGroup;
import io.anuke.arc.scene.utils.Elements;
import io.anuke.arc.util.pooling.Pool;
import io.anuke.arc.util.pooling.Pools;

public class Table
extends WidgetGroup {
    private static float[] columnWeightedWidth;
    private static float[] rowWeightedHeight;
    private static Pool<Cell> cellPool;
    private final Array<Cell> cells = new Array(4);
    private final Cell cellDefaults;
    private final Array<Cell> columnDefaults = new Array(2);
    float marginTop = Float.NEGATIVE_INFINITY;
    float marginLeft = Float.NEGATIVE_INFINITY;
    float marginBot = Float.NEGATIVE_INFINITY;
    float marginRight = Float.NEGATIVE_INFINITY;
    int align = 1;
    Drawable background;
    boolean round = true;
    private int columns;
    private int rows;
    private boolean implicitEndRow;
    private Cell rowDefaults;
    private boolean sizeInvalid = true;
    private float[] columnMinWidth;
    private float[] rowMinHeight;
    private float[] columnPrefWidth;
    private float[] rowPrefHeight;
    private float tableMinWidth;
    private float tableMinHeight;
    private float tablePrefWidth;
    private float tablePrefHeight;
    private float[] columnWidth;
    private float[] rowHeight;
    private float[] expandWidth;
    private float[] expandHeight;
    private boolean clip;

    public Table() {
        this.cellDefaults = this.obtainCell();
        this.setTransform(false);
        this.touchable(Touchable.childrenOnly);
    }

    public Table(Drawable background) {
        this();
        this.background(background);
    }

    public Table(Drawable background, Consumer<Table> cons) {
        this(background);
        cons.accept(this);
    }

    public Table(Consumer<Table> cons) {
        this();
        cons.accept(this);
    }

    private Cell obtainCell() {
        Cell cell = cellPool.obtain();
        cell.setLayout(this);
        return cell;
    }

    public Table fill() {
        Table table = new Table();
        table.setFillParent(true);
        this.add((T)table);
        return table;
    }

    @Override
    public void draw() {
        this.validate();
        if (this.isTransform()) {
            this.applyTransform(this.computeTransform());
            this.drawBackground(0.0f, 0.0f);
            if (this.clip) {
                Draw.flush();
                float padLeft = this.getMarginLeft();
                float padBottom = this.getMarginBottom();
                if (this.clipBegin(padLeft, padBottom, this.getWidth() - padLeft - this.getMarginRight(), this.getHeight() - padBottom - this.getMarginTop())) {
                    this.drawChildren();
                    Draw.flush();
                    this.clipEnd();
                }
            } else {
                this.drawChildren();
            }
            this.resetTransform();
        } else {
            this.drawBackground(this.x, this.y);
            super.draw();
        }
    }

    protected void drawBackground(float x, float y) {
        if (this.background == null) {
            return;
        }
        Color color = this.getColor();
        Draw.color(color.r, color.g, color.b, color.a * this.parentAlpha);
        this.background.draw(x, y, this.width, this.height);
    }

    public Table background(Drawable background) {
        this.setBackground(background);
        return this;
    }

    public Drawable getBackground() {
        return this.background;
    }

    public void setBackground(Drawable background) {
        if (this.background == background) {
            return;
        }
        float padTopOld = this.getMarginTop();
        float padLeftOld = this.getMarginLeft();
        float padBottomOld = this.getMarginBottom();
        float padRightOld = this.getMarginRight();
        this.background = background;
        float padTopNew = this.getMarginTop();
        float padLeftNew = this.getMarginLeft();
        float padBottomNew = this.getMarginBottom();
        float padRightNew = this.getMarginRight();
        if (padTopOld + padBottomOld != padTopNew + padBottomNew || padLeftOld + padRightOld != padLeftNew + padRightNew) {
            this.invalidateHierarchy();
        } else if (padTopOld != padTopNew || padLeftOld != padLeftNew || padBottomOld != padBottomNew || padRightOld != padRightNew) {
            this.invalidate();
        }
    }

    @Override
    public Element hit(float x, float y, boolean touchable) {
        if (this.clip) {
            if (touchable && this.getTouchable() == Touchable.disabled) {
                return null;
            }
            if (x < 0.0f || x >= this.getWidth() || y < 0.0f || y >= this.getHeight()) {
                return null;
            }
        }
        return super.hit(x, y, touchable);
    }

    public boolean getClip() {
        return this.clip;
    }

    public void setClip(boolean enabled) {
        this.clip = enabled;
        this.setTransform(enabled);
        this.invalidate();
    }

    @Override
    public void invalidate() {
        this.sizeInvalid = true;
        super.invalidate();
    }

    public <T extends Element> Cell<T> add(T element) {
        Array<Cell> cells;
        Cell cell;
        block10: {
            cell = this.obtainCell();
            cell.element = element;
            if (this.implicitEndRow) {
                this.implicitEndRow = false;
                --this.rows;
                this.cells.peek().endRow = false;
            }
            cells = this.cells;
            int cellCount = cells.size;
            if (cellCount > 0) {
                Cell lastCell = cells.peek();
                if (!lastCell.endRow) {
                    cell.column = lastCell.column + lastCell.colspan;
                    cell.row = lastCell.row;
                } else {
                    cell.column = 0;
                    cell.row = lastCell.row + 1;
                }
                if (cell.row > 0) {
                    for (int i = cellCount - 1; i >= 0; --i) {
                        int column;
                        Cell other = cells.get(i);
                        int nn = column + other.colspan;
                        for (column = other.column; column < nn; ++column) {
                            if (column != cell.column) continue;
                            cell.cellAboveIndex = i;
                            break block10;
                        }
                    }
                }
            } else {
                cell.column = 0;
                cell.row = 0;
            }
        }
        cells.add(cell);
        cell.set(this.cellDefaults);
        if (cell.column < this.columnDefaults.size) {
            Cell cell2 = this.columnDefaults.get(cell.column);
        }
        if (element != null) {
            this.addChild(element);
        }
        return cell;
    }

    public void add(Element ... elements) {
        for (Element element : elements) {
            this.add((T)element);
        }
    }

    public Cell<Table> table() {
        return this.table((Drawable)null);
    }

    public Cell<Table> table(Drawable background) {
        Table table = new Table(background);
        return this.add((T)table);
    }

    public Cell<Table> table(Consumer<Table> cons) {
        Table table = new Table();
        cons.accept(table);
        return this.add((T)table);
    }

    public Cell<Table> table(Drawable background, Consumer<Table> cons) {
        return this.table(background, 1, cons);
    }

    public Cell<Table> table(Drawable background, int align, Consumer<Table> cons) {
        Table table = new Table(background);
        table.align(align);
        cons.accept(table);
        return this.add((T)table);
    }

    public Cell<Label> label(Supplier<CharSequence> text) {
        return this.add((T)new Label(text));
    }

    public Cell<Label> labelWrap(Supplier<CharSequence> text) {
        Label label = new Label(text);
        label.setWrap(true);
        return this.add((T)label);
    }

    public Cell<Label> labelWrap(String text) {
        Label label = new Label(text);
        label.setWrap(true);
        return this.add((T)label);
    }

    public Cell<ScrollPane> pane(Consumer<Table> consumer) {
        return this.pane(Core.scene.getStyle(ScrollPane.ScrollPaneStyle.class), consumer);
    }

    public Cell<ScrollPane> pane(ScrollPane.ScrollPaneStyle style, Consumer<Table> consumer) {
        Table table = new Table();
        consumer.accept(table);
        ScrollPane pane = new ScrollPane((Element)table, style);
        return this.add((T)pane);
    }

    public Cell<ScrollPane> pane(ScrollPane.ScrollPaneStyle style, Element element) {
        ScrollPane pane = new ScrollPane(element, style);
        return this.add((T)pane);
    }

    public Cell<ScrollPane> pane(Element element) {
        return this.pane(Core.scene.getStyle(ScrollPane.ScrollPaneStyle.class), element);
    }

    public Cell<Label> add(CharSequence text) {
        return this.add((T)new Label(text));
    }

    public Cell<Label> add(CharSequence text, float scl) {
        Label l = new Label(text);
        l.setFontScale(scl);
        return this.add((T)l);
    }

    public Cell<Label> add(CharSequence text, Label.LabelStyle labelStyle, float scl) {
        Label l = new Label(text, labelStyle);
        l.setFontScale(scl);
        return this.add((T)l);
    }

    public Cell<Label> add(CharSequence text, Color color, float scl) {
        Label l = new Label(text);
        l.setColor(color);
        l.setFontScale(scl);
        return this.add((T)l);
    }

    public Cell<Label> add(CharSequence text, Label.LabelStyle labelStyle) {
        return this.add((T)new Label(text, labelStyle));
    }

    public Cell<Label> add(CharSequence text, Color color) {
        return this.add((T)new Label(text, new Label.LabelStyle(Core.scene.getStyle(Label.LabelStyle.class).font, color)));
    }

    public Cell add() {
        return this.add((T)null);
    }

    public Cell<Stack> stack(Element ... elements) {
        Stack stack = new Stack();
        if (elements != null) {
            int n = elements.length;
            for (int i = 0; i < n; ++i) {
                stack.addChild(elements[i]);
            }
        }
        return this.add((T)stack);
    }

    public Cell<Image> addImage() {
        return this.add((T)new Image());
    }

    public Cell<Image> addImage(Drawable name) {
        return this.add((T)new Image(name));
    }

    public Cell<Image> addImage(Drawable name, Color color) {
        Image image = new Image(name);
        image.setColor(color);
        return this.add((T)image);
    }

    public Cell<Image> addImage(TextureRegion region) {
        return this.add((T)new Image(region));
    }

    public Cell<CheckBox> addCheck(String text, BooleanConsumer listener) {
        CheckBox button = Elements.newCheck(text, listener);
        return this.add((T)button);
    }

    public Cell<CheckBox> addCheck(String text, boolean checked, BooleanConsumer listener) {
        CheckBox button = Elements.newCheck(text, listener);
        button.setChecked(checked);
        return this.add((T)button);
    }

    public Cell<CheckBox> addCheck(String text, float imagesize, boolean checked, BooleanConsumer listener) {
        CheckBox button = Elements.newCheck(text, listener);
        button.getImageCell().size(imagesize);
        button.setChecked(checked);
        return this.add((T)button);
    }

    public Cell<Button> addButton(Consumer<Button> cons, Runnable listener) {
        Button button = new Button();
        button.clearChildren();
        button.clicked(listener);
        cons.accept(button);
        return this.add((T)button);
    }

    public Cell<Button> addButton(Consumer<Button> cons, Button.ButtonStyle style, Runnable listener) {
        Button button = new Button(style);
        button.clearChildren();
        button.clicked(listener);
        cons.accept(button);
        return this.add((T)button);
    }

    public Cell<TextButton> addButton(String text, Runnable listener) {
        TextButton button = Elements.newButton(text, listener);
        return this.add((T)button);
    }

    public Cell<TextButton> addButton(String text, TextButton.TextButtonStyle style, Runnable listener) {
        TextButton button = Elements.newButton(text, style, listener);
        return this.add((T)button);
    }

    public Cell<ImageButton> addImageButton(Drawable icon, Runnable listener) {
        ImageButton button = Elements.newImageButton(icon, listener);
        return this.add((T)button);
    }

    public Cell<ImageButton> addImageButton(Drawable icon, float isize, Runnable listener) {
        ImageButton button = Elements.newImageButton(icon, listener);
        button.resizeImage(isize);
        return this.add((T)button);
    }

    public Cell<ImageButton> addImageButton(Drawable icon, ImageButton.ImageButtonStyle style, float isize, Runnable listener) {
        ImageButton button = new ImageButton(icon, style);
        button.clicked(listener);
        button.resizeImage(isize);
        return this.add((T)button);
    }

    public Cell<ImageButton> addImageButton(Drawable icon, ImageButton.ImageButtonStyle style, Runnable listener) {
        ImageButton button = new ImageButton(icon, style);
        button.clicked(listener);
        button.resizeImage(icon.imageSize());
        return this.add((T)button);
    }

    public Cell<TextField> addField(String text, Consumer<String> listener) {
        TextField field = Elements.newField(text, listener);
        return this.add((T)field);
    }

    public Cell<TextArea> addArea(String text, Consumer<String> listener) {
        TextArea area = new TextArea(text);
        area.changed(() -> listener.accept(area.getText()));
        return this.add((T)area);
    }

    public Cell<TextArea> addArea(String text, TextField.TextFieldStyle style, Consumer<String> listener) {
        TextArea area = new TextArea(text, style);
        area.changed(() -> listener.accept(area.getText()));
        return this.add((T)area);
    }

    public Cell<TextField> addField(String text, TextField.TextFieldFilter filter, Consumer<String> listener) {
        TextField field = Elements.newField(text, listener);
        field.setFilter(filter);
        return this.add((T)field);
    }

    public Cell addRect(final DrawRect draw) {
        return this.add((T)new Element(){

            @Override
            public void draw() {
                draw.draw(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            }
        });
    }

    public Cell<TextButton> addRowImageTextButton(String text, Drawable image, Runnable clicked) {
        TextButton button = new TextButton(text);
        button.clearChildren();
        button.add((T)new Image(image)).update((T i) -> i.setColor(button.isDisabled() ? Color.gray : Color.white));
        button.row();
        button.add((T)button.getLabel()).padTop(4.0f);
        button.clicked(clicked);
        return this.add((T)button);
    }

    public Cell<TextButton> addImageTextButton(String text, Drawable image, Runnable clicked) {
        return this.addImageTextButton(text, image, image.imageSize(), clicked);
    }

    public Cell<TextButton> addImageTextButton(String text, Drawable image, float imagesize, Runnable clicked) {
        TextButton button = new TextButton(text);
        button.add((T)new Image(image)).size(imagesize);
        button.getCells().reverse();
        button.clicked(clicked);
        return this.add((T)button);
    }

    public Cell<TextButton> addImageTextButton(String text, Drawable image, TextButton.TextButtonStyle style, float imagesize, Runnable clicked) {
        TextButton button = new TextButton(text, style);
        button.add((T)new Image(image)).size(imagesize);
        button.getCells().reverse();
        button.clicked(clicked);
        return this.add((T)button);
    }

    public Cell<TextButton> addImageTextButton(String text, Drawable image, TextButton.TextButtonStyle style, Runnable clicked) {
        TextButton button = new TextButton(text, style);
        button.add((T)new Image(image)).size(image.imageSize());
        button.getCells().reverse();
        button.clicked(clicked);
        return this.add((T)button);
    }

    public Cell<TextButton> addCenteredImageTextButton(String text, Drawable image, float imagesize, Runnable clicked) {
        TextButton button = new TextButton(text);
        button.add((T)new Image(image)).size(imagesize);
        button.getCells().reverse();
        button.clicked(clicked);
        button.getLabelCell().padLeft(-imagesize);
        return this.add((T)button);
    }

    public Cell<TextButton> addCenteredImageTextButton(String text, Drawable image, Runnable clicked) {
        TextButton button = new TextButton(text);
        button.add((T)new Image(image));
        button.getCells().reverse();
        button.clicked(clicked);
        button.getLabelCell().padLeft(-image.imageSize());
        return this.add((T)button);
    }

    public Cell<TextButton> addCenteredImageTextButton(String text, Drawable image, TextButton.TextButtonStyle style, float imagesize, Runnable clicked) {
        TextButton button = new TextButton(text, style);
        button.add((T)new Image(image)).size(imagesize);
        button.getCells().reverse();
        button.clicked(clicked);
        button.getLabelCell().padLeft(-imagesize);
        return this.add((T)button);
    }

    public Cell<Slider> addSlider(float min, float max, float step, FloatConsumer listener) {
        return this.addSlider(min, max, step, 0.0f, listener);
    }

    public Cell<Slider> addSlider(float min, float max, float step, float defvalue, FloatConsumer listener) {
        Slider slider = new Slider(min, max, step, false);
        slider.setValue(defvalue);
        if (listener != null) {
            slider.moved(listener);
        }
        return this.add((T)slider);
    }

    public Cell<Slider> addSlider(float min, float max, float step, float defvalue, boolean onUp, FloatConsumer listener) {
        Slider slider = new Slider(min, max, step, false);
        slider.setValue(defvalue);
        if (listener != null) {
            if (!onUp) {
                slider.moved(listener);
            } else {
                slider.released(() -> listener.accept(slider.getValue()));
            }
        }
        return this.add((T)slider);
    }

    @Override
    public boolean removeChild(Element element) {
        return this.removeChild(element, true);
    }

    @Override
    public boolean removeChild(Element element, boolean unfocus) {
        if (!super.removeChild(element, unfocus)) {
            return false;
        }
        Cell cell = this.getCell(element);
        if (cell != null) {
            cell.element = null;
        }
        return true;
    }

    @Override
    public void clearChildren() {
        Array<Cell> cells = this.cells;
        for (int i = cells.size - 1; i >= 0; --i) {
            Cell cell = cells.get(i);
            Element actor = cell.element;
            if (actor == null) continue;
            actor.remove();
        }
        cellPool.freeAll(cells);
        cells.clear();
        this.rows = 0;
        this.columns = 0;
        if (this.rowDefaults != null) {
            cellPool.free(this.rowDefaults);
        }
        this.rowDefaults = null;
        this.implicitEndRow = false;
        super.clearChildren();
    }

    public void reset() {
        this.clearChildren();
        this.marginTop = Float.NEGATIVE_INFINITY;
        this.marginLeft = Float.NEGATIVE_INFINITY;
        this.marginBot = Float.NEGATIVE_INFINITY;
        this.marginRight = Float.NEGATIVE_INFINITY;
        this.align = 1;
        this.cellDefaults.reset();
        int n = this.columnDefaults.size;
        for (int i = 0; i < n; ++i) {
            Cell columnCell = this.columnDefaults.get(i);
            if (columnCell == null) continue;
            cellPool.free(columnCell);
        }
        this.columnDefaults.clear();
    }

    public Table row() {
        if (this.cells.size > 0) {
            if (!this.implicitEndRow) {
                this.endRow();
            }
            this.invalidate();
        }
        this.implicitEndRow = false;
        if (this.rowDefaults != null) {
            cellPool.free(this.rowDefaults);
        }
        this.rowDefaults = this.obtainCell();
        this.rowDefaults.clear();
        return this;
    }

    private void endRow() {
        Array<Cell> cells = this.cells;
        int rowColumns = 0;
        for (int i = cells.size - 1; i >= 0; --i) {
            Cell cell = cells.get(i);
            if (cell.endRow) break;
            rowColumns += cell.colspan;
        }
        this.columns = Math.max(this.columns, rowColumns);
        ++this.rows;
        cells.peek().endRow = true;
    }

    public Cell columnDefaults(int column) {
        Cell cell;
        Cell cell2 = cell = this.columnDefaults.size > column ? this.columnDefaults.get(column) : null;
        if (cell == null) {
            cell = this.obtainCell();
            cell.clear();
            if (column >= this.columnDefaults.size) {
                for (int i = this.columnDefaults.size; i < column; ++i) {
                    this.columnDefaults.add(null);
                }
                this.columnDefaults.add(cell);
            } else {
                this.columnDefaults.set(column, cell);
            }
        }
        return cell;
    }

    public <T extends Element> Cell getCell(T actor) {
        Array<Cell> cells = this.cells;
        int n = cells.size;
        for (int i = 0; i < n; ++i) {
            Cell c = cells.get(i);
            if (c.element != actor) continue;
            return c;
        }
        return null;
    }

    public Array<Cell> getCells() {
        return this.cells;
    }

    @Override
    public float getPrefWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        float width = this.tablePrefWidth;
        if (this.background != null) {
            return Math.max(width, this.background.getMinWidth());
        }
        return width;
    }

    @Override
    public float getPrefHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        float height = this.tablePrefHeight;
        if (this.background != null) {
            return Math.max(height, this.background.getMinHeight());
        }
        return height;
    }

    @Override
    public float getMinWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.tableMinWidth;
    }

    @Override
    public float getMinHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.tableMinHeight;
    }

    public Cell defaults() {
        return this.cellDefaults;
    }

    public Table margin(float pad) {
        this.margin(pad, pad, pad, pad);
        return this;
    }

    public Table margin(float top, float left, float bottom, float right) {
        this.marginTop = Scl.scl(top);
        this.marginLeft = Scl.scl(left);
        this.marginBot = Scl.scl(bottom);
        this.marginRight = Scl.scl(right);
        this.sizeInvalid = true;
        return this;
    }

    public Table marginTop(float padTop) {
        this.marginTop = Scl.scl(padTop);
        this.sizeInvalid = true;
        return this;
    }

    public Table marginLeft(float padLeft) {
        this.marginLeft = Scl.scl(padLeft);
        this.sizeInvalid = true;
        return this;
    }

    public Table marginBottom(float padBottom) {
        this.marginBot = Scl.scl(padBottom);
        this.sizeInvalid = true;
        return this;
    }

    public Table marginRight(float padRight) {
        this.marginRight = Scl.scl(padRight);
        this.sizeInvalid = true;
        return this;
    }

    public Table align(int align) {
        this.align = align;
        return this;
    }

    public Table center() {
        this.align = 1;
        return this;
    }

    public Table top() {
        this.align |= 2;
        this.align &= 0xFFFFFFFB;
        return this;
    }

    public Table left() {
        this.align |= 8;
        this.align &= 0xFFFFFFEF;
        return this;
    }

    public Table bottom() {
        this.align |= 4;
        this.align &= 0xFFFFFFFD;
        return this;
    }

    public Table right() {
        this.align |= 0x10;
        this.align &= 0xFFFFFFF7;
        return this;
    }

    public float getMarginTop() {
        return this.marginTop != Float.NEGATIVE_INFINITY ? this.marginTop : (this.background == null ? 0.0f : this.background.getTopHeight());
    }

    public float getMarginLeft() {
        return this.marginLeft != Float.NEGATIVE_INFINITY ? this.marginLeft : (this.background == null ? 0.0f : this.background.getLeftWidth());
    }

    public float getMarginBottom() {
        return this.marginBot != Float.NEGATIVE_INFINITY ? this.marginBot : (this.background == null ? 0.0f : this.background.getBottomHeight());
    }

    public float getMarginRight() {
        return this.marginRight != Float.NEGATIVE_INFINITY ? this.marginRight : (this.background == null ? 0.0f : this.background.getRightWidth());
    }

    public int getAlign() {
        return this.align;
    }

    public int getRow(float y) {
        Array<Cell> cells = this.cells;
        int row = 0;
        y += this.getMarginTop();
        int i = 0;
        int n = cells.size;
        if (n == 0) {
            return -1;
        }
        if (n == 1) {
            return 0;
        }
        while (i < n) {
            Cell c = cells.get(i++);
            if (c.elementY + c.computedPadTop < y) break;
            if (!c.endRow) continue;
            ++row;
        }
        return row;
    }

    public void setRound(boolean round) {
        this.round = round;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public float getRowHeight(int rowIndex) {
        return this.rowHeight[rowIndex];
    }

    public float getColumnWidth(int columnIndex) {
        return this.columnWidth[columnIndex];
    }

    private float[] ensureSize(float[] array, int size) {
        if (array == null || array.length < size) {
            return new float[size];
        }
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            array[i] = 0.0f;
        }
        return array;
    }

    @Override
    public void layout() {
        Cell c;
        int i;
        int n;
        float width = this.getWidth();
        float height = this.getHeight();
        this.layout(0.0f, 0.0f, width, height);
        Array<Cell> cells = this.cells;
        if (this.round) {
            n = cells.size;
            for (i = 0; i < n; ++i) {
                c = cells.get(i);
                float actorWidth = Math.round(c.elementWidth);
                float actorHeight = Math.round(c.elementHeight);
                float actorX = Math.round(c.elementX);
                float actorY = height - (float)Math.round(c.elementY) - actorHeight;
                c.setBounds(actorX, actorY, actorWidth, actorHeight);
                Element actor = c.element;
                if (actor == null) continue;
                actor.setBounds(actorX, actorY, actorWidth, actorHeight);
            }
        } else {
            n = cells.size;
            for (i = 0; i < n; ++i) {
                float actorY;
                c = cells.get(i);
                float actorHeight = c.elementHeight;
                c.elementY = actorY = height - c.elementY - actorHeight;
                Element actor = c.element;
                if (actor == null) continue;
                actor.setBounds(c.elementX, actorY, c.elementWidth, actorHeight);
            }
        }
        SnapshotArray<Element> children = this.getChildren();
        int n2 = children.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Element child = (Element)children.get(i2);
            child.validate();
        }
    }

    private void computeSize() {
        int i;
        this.sizeInvalid = false;
        Array<Cell> cells = this.cells;
        int cellCount = cells.size;
        if (cellCount > 0 && !cells.peek().endRow) {
            this.endRow();
            this.implicitEndRow = true;
        }
        int columns = this.columns;
        int rows = this.rows;
        this.columnMinWidth = this.ensureSize(this.columnMinWidth, columns);
        this.rowMinHeight = this.ensureSize(this.rowMinHeight, rows);
        this.columnPrefWidth = this.ensureSize(this.columnPrefWidth, columns);
        this.rowPrefHeight = this.ensureSize(this.rowPrefHeight, rows);
        this.columnWidth = this.ensureSize(this.columnWidth, columns);
        this.rowHeight = this.ensureSize(this.rowHeight, rows);
        this.expandWidth = this.ensureSize(this.expandWidth, columns);
        this.expandHeight = this.ensureSize(this.expandHeight, rows);
        for (int i2 = 0; i2 < cellCount; ++i2) {
            Cell c = cells.get(i2);
            int column = c.column;
            int row = c.row;
            int colspan = c.colspan;
            if (c.expandY != 0 && this.expandHeight[row] == 0.0f) {
                this.expandHeight[row] = c.expandY;
            }
            if (colspan == 1 && c.expandX != 0 && this.expandWidth[column] == 0.0f) {
                this.expandWidth[column] = c.expandX;
            }
            c.computedPadLeft = c.padLeft;
            c.computedPadTop = c.padTop;
            c.computedPadRight = c.padRight;
            c.computedPadBottom = c.padBottom;
            float prefWidth = c.prefWidth();
            float prefHeight = c.prefHeight();
            float minWidth = c.minWidth();
            float minHeight = c.minHeight();
            float maxWidth = c.maxWidth();
            float maxHeight = c.maxHeight();
            if (prefWidth < minWidth) {
                prefWidth = minWidth;
            }
            if (prefHeight < minHeight) {
                prefHeight = minHeight;
            }
            if (maxWidth > 0.0f && prefWidth > maxWidth) {
                prefWidth = maxWidth;
            }
            if (maxHeight > 0.0f && prefHeight > maxHeight) {
                prefHeight = maxHeight;
            }
            if (colspan == 1) {
                float hpadding = c.computedPadLeft + c.computedPadRight;
                this.columnPrefWidth[column] = Math.max(this.columnPrefWidth[column], prefWidth + hpadding);
                this.columnMinWidth[column] = Math.max(this.columnMinWidth[column], minWidth + hpadding);
            }
            float vpadding = c.computedPadTop + c.computedPadBottom;
            this.rowPrefHeight[row] = Math.max(this.rowPrefHeight[row], prefHeight + vpadding);
            this.rowMinHeight[row] = Math.max(this.rowMinHeight[row], minHeight + vpadding);
        }
        float uniformMinWidth = 0.0f;
        float uniformMinHeight = 0.0f;
        float uniformPrefWidth = 0.0f;
        float uniformPrefHeight = 0.0f;
        for (i = 0; i < cellCount; ++i) {
            int column;
            Cell c;
            block25: {
                c = cells.get(i);
                column = c.column;
                int expandX = c.expandX;
                if (expandX != 0) {
                    int ii;
                    int nn = column + c.colspan;
                    for (ii = column; ii < nn; ++ii) {
                        if (this.expandWidth[ii] == 0.0f) {
                            continue;
                        }
                        break block25;
                    }
                    for (ii = column; ii < nn; ++ii) {
                        this.expandWidth[ii] = expandX;
                    }
                }
            }
            if (c.uniformX && c.colspan == 1) {
                float hpadding = c.computedPadLeft + c.computedPadRight;
                uniformMinWidth = Math.max(uniformMinWidth, this.columnMinWidth[column] - hpadding);
                uniformPrefWidth = Math.max(uniformPrefWidth, this.columnPrefWidth[column] - hpadding);
            }
            if (!c.uniformY) continue;
            float vpadding = c.computedPadTop + c.computedPadBottom;
            uniformMinHeight = Math.max(uniformMinHeight, this.rowMinHeight[c.row] - vpadding);
            uniformPrefHeight = Math.max(uniformPrefHeight, this.rowPrefHeight[c.row] - vpadding);
        }
        if (uniformPrefWidth > 0.0f || uniformPrefHeight > 0.0f) {
            for (i = 0; i < cellCount; ++i) {
                Cell c = cells.get(i);
                if (uniformPrefWidth > 0.0f && c.uniformX && c.colspan == 1) {
                    float hpadding = c.computedPadLeft + c.computedPadRight;
                    this.columnMinWidth[c.column] = uniformMinWidth + hpadding;
                    this.columnPrefWidth[c.column] = uniformPrefWidth + hpadding;
                }
                if (!(uniformPrefHeight > 0.0f) || !c.uniformY) continue;
                float vpadding = c.computedPadTop + c.computedPadBottom;
                this.rowMinHeight[c.row] = uniformMinHeight + vpadding;
                this.rowPrefHeight[c.row] = uniformPrefHeight + vpadding;
            }
        }
        for (i = 0; i < cellCount; ++i) {
            int ii;
            float spannedMinWidth;
            Cell c = cells.get(i);
            int colspan = c.colspan;
            if (colspan == 1) continue;
            int column = c.column;
            Element a = c.element;
            float minWidth = c.minWidth();
            float prefWidth = c.prefWidth();
            float maxWidth = c.maxWidth();
            if (prefWidth < minWidth) {
                prefWidth = minWidth;
            }
            if (maxWidth > 0.0f && prefWidth > maxWidth) {
                prefWidth = maxWidth;
            }
            float spannedPrefWidth = spannedMinWidth = -(c.computedPadLeft + c.computedPadRight);
            float totalExpandWidth = 0.0f;
            int nn = ii + colspan;
            for (ii = column; ii < nn; ++ii) {
                spannedMinWidth += this.columnMinWidth[ii];
                spannedPrefWidth += this.columnPrefWidth[ii];
                totalExpandWidth += this.expandWidth[ii];
            }
            float extraMinWidth = Math.max(0.0f, minWidth - spannedMinWidth);
            float extraPrefWidth = Math.max(0.0f, prefWidth - spannedPrefWidth);
            int ii2 = column;
            int nn2 = ii2 + colspan;
            while (ii2 < nn2) {
                float ratio = totalExpandWidth == 0.0f ? 1.0f / (float)colspan : this.expandWidth[ii2] / totalExpandWidth;
                int n = ii2;
                this.columnMinWidth[n] = this.columnMinWidth[n] + extraMinWidth * ratio;
                int n2 = ii2++;
                this.columnPrefWidth[n2] = this.columnPrefWidth[n2] + extraPrefWidth * ratio;
            }
        }
        this.tableMinWidth = 0.0f;
        this.tableMinHeight = 0.0f;
        this.tablePrefWidth = 0.0f;
        this.tablePrefHeight = 0.0f;
        for (i = 0; i < columns; ++i) {
            this.tableMinWidth += this.columnMinWidth[i];
            this.tablePrefWidth += this.columnPrefWidth[i];
        }
        for (i = 0; i < rows; ++i) {
            this.tableMinHeight += this.rowMinHeight[i];
            this.tablePrefHeight += Math.max(this.rowMinHeight[i], this.rowPrefHeight[i]);
        }
        float hpadding = this.getMarginLeft() + this.getMarginRight();
        float vpadding = this.getMarginTop() + this.getMarginBottom();
        this.tableMinWidth += hpadding;
        this.tableMinHeight += vpadding;
        this.tablePrefWidth = Math.max(this.tablePrefWidth + hpadding, this.tableMinWidth);
        this.tablePrefHeight = Math.max(this.tablePrefHeight + vpadding, this.tableMinHeight);
    }

    private void layout(float layoutX, float layoutY, float layoutWidth, float layoutHeight) {
        int i;
        float amount;
        float maxHeight;
        float[] rowWeightedHeight;
        int i2;
        float[] columnWeightedWidth;
        int i3;
        Array<Cell> cells = this.cells;
        int cellCount = cells.size;
        if (this.sizeInvalid) {
            this.computeSize();
        }
        float padLeft = this.getMarginLeft();
        float hpadding = padLeft + this.getMarginRight();
        float padTop = this.getMarginTop();
        float vpadding = padTop + this.getMarginBottom();
        int columns = this.columns;
        int rows = this.rows;
        float[] expandWidth = this.expandWidth;
        float[] expandHeight = this.expandHeight;
        float[] columnWidth = this.columnWidth;
        float[] rowHeight = this.rowHeight;
        float totalExpandWidth = 0.0f;
        float totalExpandHeight = 0.0f;
        for (i3 = 0; i3 < columns; ++i3) {
            totalExpandWidth += expandWidth[i3];
        }
        for (i3 = 0; i3 < rows; ++i3) {
            totalExpandHeight += expandHeight[i3];
        }
        float totalGrowWidth = this.tablePrefWidth - this.tableMinWidth;
        if (totalGrowWidth == 0.0f) {
            columnWeightedWidth = this.columnMinWidth;
        } else {
            float extraWidth = Math.min(totalGrowWidth, Math.max(0.0f, layoutWidth - this.tableMinWidth));
            Table.columnWeightedWidth = this.ensureSize(Table.columnWeightedWidth, columns);
            columnWeightedWidth = Table.columnWeightedWidth;
            float[] columnMinWidth = this.columnMinWidth;
            float[] columnPrefWidth = this.columnPrefWidth;
            for (i2 = 0; i2 < columns; ++i2) {
                float growWidth = columnPrefWidth[i2] - columnMinWidth[i2];
                float growRatio = growWidth / totalGrowWidth;
                columnWeightedWidth[i2] = columnMinWidth[i2] + extraWidth * growRatio;
            }
        }
        float totalGrowHeight = this.tablePrefHeight - this.tableMinHeight;
        if (totalGrowHeight == 0.0f) {
            rowWeightedHeight = this.rowMinHeight;
        } else {
            Table.rowWeightedHeight = this.ensureSize(Table.rowWeightedHeight, rows);
            rowWeightedHeight = Table.rowWeightedHeight;
            float extraHeight = Math.min(totalGrowHeight, Math.max(0.0f, layoutHeight - this.tableMinHeight));
            float[] rowMinHeight = this.rowMinHeight;
            float[] rowPrefHeight = this.rowPrefHeight;
            for (int i4 = 0; i4 < rows; ++i4) {
                float growHeight = rowPrefHeight[i4] - rowMinHeight[i4];
                float growRatio = growHeight / totalGrowHeight;
                rowWeightedHeight[i4] = rowMinHeight[i4] + extraHeight * growRatio;
            }
        }
        for (int i5 = 0; i5 < cellCount; ++i5) {
            int ii;
            Cell c = cells.get(i5);
            int column = c.column;
            int row = c.row;
            float spannedWeightedWidth = 0.0f;
            int colspan = c.colspan;
            int nn = ii + colspan;
            for (ii = column; ii < nn; ++ii) {
                spannedWeightedWidth += columnWeightedWidth[ii];
            }
            float weightedHeight = rowWeightedHeight[row];
            float prefWidth = c.prefWidth();
            float prefHeight = c.prefHeight();
            float minWidth = c.minWidth();
            float minHeight = c.minHeight();
            float maxWidth = c.maxWidth();
            maxHeight = c.maxHeight();
            if (prefWidth < minWidth) {
                prefWidth = minWidth;
            }
            if (prefHeight < minHeight) {
                prefHeight = minHeight;
            }
            if (maxWidth > 0.0f && prefWidth > maxWidth) {
                prefWidth = maxWidth;
            }
            if (maxHeight > 0.0f && prefHeight > maxHeight) {
                prefHeight = maxHeight;
            }
            c.elementWidth = Math.min(spannedWeightedWidth - c.computedPadLeft - c.computedPadRight, prefWidth);
            c.elementHeight = Math.min(weightedHeight - c.computedPadTop - c.computedPadBottom, prefHeight);
            if (colspan == 1) {
                columnWidth[column] = Math.max(columnWidth[column], spannedWeightedWidth);
            }
            rowHeight[row] = Math.max(rowHeight[row], weightedHeight);
        }
        if (totalExpandWidth > 0.0f) {
            float extra = layoutWidth - hpadding;
            for (i2 = 0; i2 < columns; ++i2) {
                extra -= columnWidth[i2];
            }
            float used = 0.0f;
            int lastIndex = 0;
            for (int i6 = 0; i6 < columns; ++i6) {
                if (expandWidth[i6] == 0.0f) continue;
                amount = extra * expandWidth[i6] / totalExpandWidth;
                int n = i6;
                columnWidth[n] = columnWidth[n] + amount;
                used += amount;
                lastIndex = i6;
            }
            int n = lastIndex;
            columnWidth[n] = columnWidth[n] + (extra - used);
        }
        if (totalExpandHeight > 0.0f) {
            float extra = layoutHeight - vpadding;
            for (i2 = 0; i2 < rows; ++i2) {
                extra -= rowHeight[i2];
            }
            float used = 0.0f;
            int lastIndex = 0;
            for (int i7 = 0; i7 < rows; ++i7) {
                if (expandHeight[i7] == 0.0f) continue;
                amount = extra * expandHeight[i7] / totalExpandHeight;
                int n = i7;
                rowHeight[n] = rowHeight[n] + amount;
                used += amount;
                lastIndex = i7;
            }
            int n = lastIndex;
            rowHeight[n] = rowHeight[n] + (extra - used);
        }
        for (int i8 = 0; i8 < cellCount; ++i8) {
            int column;
            Cell c = cells.get(i8);
            int colspan = c.colspan;
            if (colspan == 1) continue;
            float extraWidth = 0.0f;
            int nn = column + colspan;
            for (column = c.column; column < nn; ++column) {
                extraWidth += columnWeightedWidth[column] - columnWidth[column];
            }
            extraWidth -= Math.max(0.0f, c.computedPadLeft + c.computedPadRight);
            if (!((extraWidth /= (float)colspan) > 0.0f)) continue;
            column = c.column;
            nn = column + colspan;
            while (column < nn) {
                int n = column++;
                columnWidth[n] = columnWidth[n] + extraWidth;
            }
        }
        float tableWidth = hpadding;
        float tableHeight = vpadding;
        for (i = 0; i < columns; ++i) {
            tableWidth += columnWidth[i];
        }
        for (i = 0; i < rows; ++i) {
            tableHeight += rowHeight[i];
        }
        int align = this.align;
        float x = layoutX + padLeft;
        if ((align & 0x10) != 0) {
            x += layoutWidth - tableWidth;
        } else if ((align & 8) == 0) {
            x += (layoutWidth - tableWidth) / 2.0f;
        }
        float y = layoutY + padTop;
        if ((align & 4) != 0) {
            y += layoutHeight - tableHeight;
        } else if ((align & 2) == 0) {
            y += (layoutHeight - tableHeight) / 2.0f;
        }
        float currentX = x;
        float currentY = y;
        for (int i9 = 0; i9 < cellCount; ++i9) {
            int column;
            Cell c = cells.get(i9);
            float spannedCellWidth = 0.0f;
            int nn = column + c.colspan;
            for (column = c.column; column < nn; ++column) {
                spannedCellWidth += columnWidth[column];
            }
            spannedCellWidth -= c.computedPadLeft + c.computedPadRight;
            currentX += c.computedPadLeft;
            float fillX = c.fillX;
            float fillY = c.fillY;
            if (fillX > 0.0f) {
                c.elementWidth = Math.max(spannedCellWidth * fillX, c.minWidth());
                float maxWidth = c.maxWidth;
                if (maxWidth > 0.0f) {
                    c.elementWidth = Math.min(c.elementWidth, maxWidth);
                }
            }
            if (fillY > 0.0f) {
                c.elementHeight = Math.max(rowHeight[c.row] * fillY - c.computedPadTop - c.computedPadBottom, c.minHeight());
                maxHeight = c.maxHeight();
                if (maxHeight > 0.0f) {
                    c.elementHeight = Math.min(c.elementHeight, maxHeight);
                }
            }
            c.elementX = ((align = c.align) & 8) != 0 ? currentX : ((align & 0x10) != 0 ? currentX + spannedCellWidth - c.elementWidth : currentX + (spannedCellWidth - c.elementWidth) / 2.0f);
            c.elementY = (align & 2) != 0 ? currentY + c.computedPadTop : ((align & 4) != 0 ? currentY + rowHeight[c.row] - c.elementHeight - c.computedPadBottom : currentY + (rowHeight[c.row] - c.elementHeight + c.computedPadTop - c.computedPadBottom) / 2.0f);
            if (c.endRow) {
                currentX = x;
                currentY += rowHeight[c.row];
                continue;
            }
            currentX += spannedCellWidth + c.computedPadRight;
        }
    }

    static {
        cellPool = Pools.get(Cell.class, Cell::new);
    }

    public static interface DrawRect {
        public void draw(float var1, float var2, float var3, float var4);
    }
}

