/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.scene.ui;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.math.Interpolation;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.scene.Action;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.Scene;
import io.anuke.arc.scene.actions.Actions;
import io.anuke.arc.scene.event.InputEvent;
import io.anuke.arc.scene.event.InputListener;
import io.anuke.arc.scene.event.Touchable;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.StaticReset;
import io.anuke.arc.util.Timer;

public class Tooltip
extends InputListener {
    static Vector2 tmp = new Vector2();
    final Tooltips manager;
    final Table container;
    boolean instant = true;
    boolean always;
    Element targetActor;
    Runnable show;

    public Tooltip(Consumer<Table> contents) {
        this(contents, Tooltips.getInstance());
    }

    public Tooltip(Consumer<Table> contents, Runnable show) {
        this(contents, Tooltips.getInstance());
        this.show = show;
    }

    public Tooltip(Consumer<Table> contents, Tooltips manager) {
        this.manager = manager;
        this.container = new Table(){

            @Override
            public void act(float delta) {
                super.act(delta);
                if (Tooltip.this.targetActor != null && Tooltip.this.targetActor.getScene() == null) {
                    this.remove();
                }
            }
        };
        contents.accept(this.container);
        this.container.touchable(Touchable.disabled);
    }

    public Tooltips getManager() {
        return this.manager;
    }

    public Table getContainer() {
        return this.container;
    }

    public void setInstant(boolean instant) {
        this.instant = instant;
    }

    public void setAlways(boolean always) {
        this.always = always;
    }

    @Override
    public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
        if (this.instant) {
            this.container.toFront();
            return false;
        }
        this.manager.touchDown(this);
        return false;
    }

    @Override
    public boolean mouseMoved(InputEvent event, float x, float y) {
        if (this.container.hasParent()) {
            return false;
        }
        this.setContainerPosition(event.listenerActor, x, y);
        return true;
    }

    protected void setContainerPosition(Element element, float x, float y) {
        this.targetActor = element;
        Scene stage = element.getScene();
        if (stage == null) {
            return;
        }
        this.container.pack();
        float offsetX = this.manager.offsetX;
        float offsetY = this.manager.offsetY;
        float dist = this.manager.edgeDistance;
        Vector2 point = element.localToStageCoordinates(tmp.set(x + offsetX, y - offsetY - this.container.getHeight()));
        if (point.y < dist) {
            point = element.localToStageCoordinates(tmp.set(x + offsetX, y + offsetY));
        }
        if (point.x < dist) {
            point.x = dist;
        }
        if (point.x + this.container.getWidth() > stage.getWidth() - dist) {
            point.x = stage.getWidth() - dist - this.container.getWidth();
        }
        if (point.y + this.container.getHeight() > stage.getHeight() - dist) {
            point.y = stage.getHeight() - dist - this.container.getHeight();
        }
        this.container.setPosition(point.x, point.y);
        point = element.localToStageCoordinates(tmp.set(element.getWidth() / 2.0f, element.getHeight() / 2.0f));
        point.sub(this.container.getX(), this.container.getY());
        this.container.setOrigin(point.x, point.y);
    }

    @Override
    public void enter(InputEvent event, float x, float y, int pointer, Element fromActor) {
        if (pointer != -1) {
            return;
        }
        if (Core.input.isTouched()) {
            return;
        }
        Element element = event.listenerActor;
        if (fromActor != null && fromActor.isDescendantOf(element)) {
            return;
        }
        this.setContainerPosition(element, x, y);
        this.manager.enter(this);
        if (this.show != null) {
            this.show.run();
        }
    }

    @Override
    public void exit(InputEvent event, float x, float y, int pointer, Element toActor) {
        if (toActor != null && toActor.isDescendantOf(event.listenerActor)) {
            return;
        }
        this.hide();
    }

    public void hide() {
        this.manager.hide(this);
    }

    public static class Tooltips {
        private static Tooltips instance;
        private static StaticReset reset;
        final Array<Tooltip> shown = new Array();
        public float initialTime = 2.0f;
        public float subsequentTime = 0.0f;
        public float resetTime = 1.5f;
        public boolean enabled = true;
        public boolean animations = false;
        public float maxWidth = 2.1474836E9f;
        public float offsetX = 15.0f;
        public float offsetY = 19.0f;
        public float edgeDistance = 7.0f;
        float time = this.initialTime;
        final Timer.Task resetTask = new Timer.Task(){

            @Override
            public void run() {
                time = initialTime;
            }
        };
        Tooltip showTooltip;
        final Timer.Task showTask = new Timer.Task(){

            @Override
            public void run() {
                if (showTooltip == null) {
                    return;
                }
                Scene stage = showTooltip.targetActor.getScene();
                if (stage == null) {
                    return;
                }
                stage.add(showTooltip.container);
                showTooltip.container.toFront();
                shown.add(showTooltip);
                showTooltip.container.clearActions();
                this.showAction(showTooltip);
                if (!showTooltip.instant) {
                    time = subsequentTime;
                    resetTask.cancel();
                }
            }
        };

        public static Tooltips getInstance() {
            if (reset.check()) {
                instance = new Tooltips();
            }
            return instance;
        }

        public void touchDown(Tooltip tooltip) {
            this.showTask.cancel();
            if (tooltip.container.remove()) {
                this.resetTask.cancel();
            }
            this.resetTask.run();
            if (this.enabled || tooltip.always) {
                this.showTooltip = tooltip;
                Timer.schedule(this.showTask, this.time);
            }
        }

        public void enter(Tooltip tooltip) {
            this.showTooltip = tooltip;
            this.showTask.cancel();
            if (this.enabled || tooltip.always) {
                if (this.time == 0.0f || tooltip.instant) {
                    this.showTask.run();
                } else {
                    Timer.schedule(this.showTask, this.time);
                }
            }
        }

        public void hide(Tooltip tooltip) {
            this.showTooltip = null;
            this.showTask.cancel();
            if (tooltip.container.hasParent()) {
                this.shown.removeValue(tooltip, true);
                this.hideAction(tooltip);
                this.resetTask.cancel();
                Timer.schedule(this.resetTask, this.resetTime);
            }
        }

        protected void showAction(Tooltip tooltip) {
            float actionTime = this.animations ? (this.time > 0.0f ? 0.5f : 0.15f) : 0.1f;
            tooltip.container.setTransform(true);
            tooltip.container.getColor().a = 0.2f;
            tooltip.container.setScale(0.05f);
            tooltip.container.addAction(Actions.parallel((Action)Actions.fadeIn(actionTime, Interpolation.fade), (Action)Actions.scaleTo(1.0f, 1.0f, actionTime, Interpolation.fade)));
        }

        protected void hideAction(Tooltip tooltip) {
            tooltip.container.addAction(Actions.sequence((Action)Actions.parallel((Action)Actions.alpha(0.2f, 0.2f, Interpolation.fade), (Action)Actions.scaleTo(0.05f, 0.05f, 0.2f, Interpolation.fade)), (Action)Actions.remove()));
        }

        public void hideAll() {
            this.resetTask.cancel();
            this.showTask.cancel();
            this.time = this.initialTime;
            this.showTooltip = null;
            for (Tooltip tooltip : this.shown) {
                tooltip.hide();
            }
            this.shown.clear();
        }

        public void instant() {
            this.time = 0.0f;
            this.showTask.run();
            this.showTask.cancel();
        }

        static {
            reset = new StaticReset();
        }
    }
}

