/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.scene.ui;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.function.BooleanConsumer;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.scene.ui.CheckBox;
import io.anuke.arc.scene.ui.Dialog;
import io.anuke.arc.scene.ui.Label;
import io.anuke.arc.scene.ui.Slider;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.scene.ui.layout.Table;

public class SettingsDialog
extends Dialog {
    public SettingsTable main;

    public SettingsDialog() {
        super(Core.bundle.get("settings", "Settings"));
        this.addCloseButton();
        this.main = new SettingsTable();
        this.cont.add(this.main);
    }

    public static class SettingsTable
    extends Table {
        protected Array<Setting> list = new Array();
        protected Consumer<SettingsTable> rebuilt;

        public SettingsTable() {
            this.left();
        }

        public SettingsTable(Consumer<SettingsTable> rebuilt) {
            this.rebuilt = rebuilt;
            this.left();
        }

        public Array<Setting> getSettings() {
            return this.list;
        }

        public void pref(Setting setting) {
            this.list.add(setting);
            this.rebuild();
        }

        public void screenshakePref() {
            this.sliderPref("screenshake", Core.bundle.get("setting.screenshake.name", "Screen Shake"), 4, 0, 8, (int i) -> (float)i / 4.0f + "x");
        }

        public void sliderPref(String name, String title, int def, int min, int max, StringProcessor s) {
            this.sliderPref(name, title, def, min, max, 1, s);
        }

        public void sliderPref(String name, String title, int def, int min, int max, int step, StringProcessor s) {
            this.list.add(new SliderSetting(name, title, def, min, max, step, s));
            Core.settings.defaults(name, def);
            this.rebuild();
        }

        public void sliderPref(String name, int def, int min, int max, StringProcessor s) {
            this.sliderPref(name, def, min, max, 1, s);
        }

        public void sliderPref(String name, int def, int min, int max, int step, StringProcessor s) {
            this.list.add(new SliderSetting(name, Core.bundle.get("setting." + name + ".name"), def, min, max, step, s));
            Core.settings.defaults(name, def);
            this.rebuild();
        }

        public void checkPref(String name, String title, boolean def) {
            this.list.add(new CheckSetting(name, title, def, null));
            Core.settings.defaults(name, def);
            this.rebuild();
        }

        public void checkPref(String name, String title, boolean def, BooleanConsumer changed) {
            this.list.add(new CheckSetting(name, title, def, changed));
            Core.settings.defaults(name, def);
            this.rebuild();
        }

        public void checkPref(String name, boolean def) {
            this.list.add(new CheckSetting(name, Core.bundle.get("setting." + name + ".name"), def, null));
            Core.settings.defaults(name, def);
            this.rebuild();
        }

        public void checkPref(String name, boolean def, BooleanConsumer changed) {
            this.list.add(new CheckSetting(name, Core.bundle.get("setting." + name + ".name"), def, changed));
            Core.settings.defaults(name, def);
            this.rebuild();
        }

        void rebuild() {
            this.clearChildren();
            for (Setting setting : this.list) {
                setting.add(this);
            }
            this.addButton(Core.bundle.get("settings.reset", "Reset to Defaults"), () -> {
                for (Setting setting : this.list) {
                    if (setting.name == null || setting.title == null) continue;
                    Core.settings.put(setting.name, Core.settings.getDefault(setting.name));
                    Core.settings.save();
                }
                this.rebuild();
            }).margin(14.0f).width(240.0f).pad(6.0f);
            if (this.rebuilt != null) {
                this.rebuilt.accept(this);
            }
        }

        public class SliderSetting
        extends Setting {
            int def;
            int min;
            int max;
            int step;
            StringProcessor sp;

            SliderSetting(String name, String title, int def, int min, int max, int step, StringProcessor s) {
                this.name = name;
                this.title = title;
                this.def = def;
                this.min = min;
                this.max = max;
                this.step = step;
                this.sp = s;
            }

            @Override
            public void add(SettingsTable table) {
                Slider slider = new Slider(this.min, this.max, this.step, false);
                slider.setValue(Core.settings.getInt(this.name));
                Label label = new Label(this.title);
                slider.changed(() -> {
                    Core.settings.put(this.name, (int)slider.getValue());
                    Core.settings.save();
                    label.setText(this.title + ": " + this.sp.get((int)slider.getValue()));
                });
                slider.change();
                table.table(t -> {
                    t.left().defaults().left();
                    t.add(label).minWidth(label.getPrefWidth() / Scl.scl(1.0f) + 50.0f);
                    t.add(slider).width(180.0f);
                }).left().padTop(3.0f);
                table.row();
            }
        }

        public class CheckSetting
        extends Setting {
            boolean def;
            BooleanConsumer changed;

            CheckSetting(String name, String title, boolean def, BooleanConsumer changed) {
                this.name = name;
                this.title = title;
                this.def = def;
                this.changed = changed;
            }

            @Override
            public void add(SettingsTable table) {
                CheckBox box = new CheckBox(this.title);
                box.update(() -> box.setChecked(Core.settings.getBool(this.name)));
                box.changed(() -> {
                    Core.settings.put(this.name, box.isChecked);
                    Core.settings.save();
                    if (this.changed != null) {
                        this.changed.accept(box.isChecked);
                    }
                });
                box.left();
                table.add(box).left().padTop(3.0f);
                table.row();
            }
        }

        public static abstract class Setting {
            public String name;
            public String title;

            public abstract void add(SettingsTable var1);
        }
    }

    public static interface StringProcessor {
        public String get(int var1);
    }
}

