/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.scene.ui;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.NinePatch;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.style.Drawable;
import io.anuke.arc.scene.style.NinePatchDrawable;
import io.anuke.arc.scene.style.TextureRegionDrawable;
import io.anuke.arc.scene.style.TransformDrawable;
import io.anuke.arc.util.Scaling;

public class Image
extends Element {
    protected float imageX;
    protected float imageY;
    protected float imageWidth;
    protected float imageHeight;
    private Scaling scaling;
    private int align;
    private Drawable drawable;

    public Image() {
        this(Core.atlas.has("whiteui") ? Core.atlas.find("whiteui") : Core.atlas.find("white"));
    }

    public Image(Drawable name, Color color) {
        this(name);
        this.setColor(color);
    }

    public Image(NinePatch patch) {
        this(new NinePatchDrawable(patch), Scaling.stretch, 1);
    }

    public Image(TextureRegion region) {
        this(new TextureRegionDrawable(region), Scaling.stretch, 1);
    }

    public Image(Texture texture) {
        this(new TextureRegionDrawable(new TextureRegion(texture)));
    }

    public Image(Drawable drawable) {
        this(drawable, Scaling.stretch, 1);
    }

    public Image(Drawable drawable, Scaling scaling) {
        this(drawable, scaling, 1);
    }

    public Image(Drawable drawable, Scaling scaling, int align) {
        this.setDrawable(drawable);
        this.scaling = scaling;
        this.align = align;
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    @Override
    public void layout() {
        if (this.drawable == null) {
            return;
        }
        float regionWidth = this.drawable.getMinWidth();
        float regionHeight = this.drawable.getMinHeight();
        float width = this.getWidth();
        float height = this.getHeight();
        Vector2 size = this.scaling.apply(regionWidth, regionHeight, width, height);
        this.imageWidth = size.x;
        this.imageHeight = size.y;
        this.imageX = (this.align & 8) != 0 ? 0.0f : ((this.align & 0x10) != 0 ? (float)((int)(width - this.imageWidth)) : (float)((int)(width / 2.0f - this.imageWidth / 2.0f)));
        this.imageY = (this.align & 2) != 0 ? (float)((int)(height - this.imageHeight)) : ((this.align & 4) != 0 ? 0.0f : (float)((int)(height / 2.0f - this.imageHeight / 2.0f)));
    }

    @Override
    public void draw() {
        this.validate();
        float x = this.getX();
        float y = this.getY();
        float scaleX = this.getScaleX();
        float scaleY = this.getScaleY();
        Draw.color(this.getColor());
        Draw.alpha(this.parentAlpha * this.getColor().a);
        if (this.drawable instanceof TransformDrawable) {
            float rotation = this.getRotation();
            if (scaleX != 1.0f || scaleY != 1.0f || rotation != 0.0f) {
                this.drawable.draw(x + this.imageX, y + this.imageY, this.getOriginX() - this.imageX, this.getOriginY() - this.imageY, this.imageWidth, this.imageHeight, scaleX, scaleY, rotation);
                return;
            }
        }
        if (this.drawable != null) {
            this.drawable.draw(x + this.imageX, y + this.imageY, this.imageWidth * scaleX, this.imageHeight * scaleY);
        }
    }

    public TextureRegion getRegion() {
        return ((TextureRegionDrawable)this.drawable).getRegion();
    }

    public Drawable getDrawable() {
        return this.drawable;
    }

    public void setDrawable(TextureRegion region) {
        this.setDrawable(new TextureRegionDrawable(region));
    }

    public void setDrawable(Drawable drawable) {
        if (this.drawable == drawable) {
            return;
        }
        if (drawable != null) {
            if (this.getPrefWidth() != drawable.getMinWidth() || this.getPrefHeight() != drawable.getMinHeight()) {
                this.invalidateHierarchy();
            }
        } else {
            this.invalidateHierarchy();
        }
        this.drawable = drawable;
    }

    public Image setScaling(Scaling scaling) {
        if (scaling == null) {
            throw new IllegalArgumentException("scaling cannot be null.");
        }
        this.scaling = scaling;
        this.invalidate();
        return this;
    }

    public void setAlign(int align) {
        this.align = align;
        this.invalidate();
    }

    @Override
    public float getMinWidth() {
        return 0.0f;
    }

    @Override
    public float getMinHeight() {
        return 0.0f;
    }

    @Override
    public float getPrefWidth() {
        if (this.drawable != null) {
            return this.drawable.getMinWidth();
        }
        return 0.0f;
    }

    @Override
    public float getPrefHeight() {
        if (this.drawable != null) {
            return this.drawable.getMinHeight();
        }
        return 0.0f;
    }

    public float getImageX() {
        return this.imageX;
    }

    public float getImageY() {
        return this.imageY;
    }

    public float getImageWidth() {
        return this.imageWidth;
    }

    public float getImageHeight() {
        return this.imageHeight;
    }
}

