/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.scene.ui;

import io.anuke.arc.Core;
import io.anuke.arc.scene.style.Drawable;
import io.anuke.arc.scene.ui.Button;
import io.anuke.arc.scene.ui.Image;
import io.anuke.arc.scene.ui.Label;
import io.anuke.arc.scene.ui.TextButton;
import io.anuke.arc.scene.ui.layout.Cell;
import io.anuke.arc.util.Scaling;

public class CheckBox
extends TextButton {
    private Image image;
    private Cell imageCell;
    private CheckBoxStyle style;

    public CheckBox(String text) {
        this(text, Core.scene.getStyle(CheckBoxStyle.class));
    }

    public CheckBox(String text, CheckBoxStyle style) {
        super(text, style);
        this.clearChildren();
        Label label = this.getLabel();
        this.image = new Image(style.checkboxOff, Scaling.stretch);
        this.imageCell = this.add(this.image);
        this.add(label).padLeft(4.0f).get().setWrap(false);
        label.setAlignment(8);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    @Override
    public CheckBoxStyle getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(Button.ButtonStyle style) {
        if (!(style instanceof CheckBoxStyle)) {
            throw new IllegalArgumentException("style must be a CheckBoxStyle.");
        }
        super.setStyle(style);
        this.style = (CheckBoxStyle)style;
    }

    @Override
    public void draw() {
        Drawable checkbox = null;
        if (this.isDisabled()) {
            checkbox = this.isChecked && this.style.checkboxOnDisabled != null ? this.style.checkboxOnDisabled : this.style.checkboxOffDisabled;
        }
        if (checkbox == null) {
            checkbox = this.isChecked && this.isOver() && this.style.checkboxOnOver != null ? this.style.checkboxOnOver : (this.isChecked && this.style.checkboxOn != null ? this.style.checkboxOn : (this.isOver() && this.style.checkboxOver != null && !this.isDisabled() ? this.style.checkboxOver : this.style.checkboxOff));
        }
        this.image.setDrawable(checkbox);
        super.draw();
    }

    public Image getImage() {
        return this.image;
    }

    public Cell getImageCell() {
        return this.imageCell;
    }

    public static class CheckBoxStyle
    extends TextButton.TextButtonStyle {
        public Drawable checkboxOn;
        public Drawable checkboxOff;
        public Drawable checkboxOver;
        public Drawable checkboxOnDisabled;
        public Drawable checkboxOffDisabled;
        public Drawable checkboxOnOver;
    }
}

