/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.scene.style;

import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.scene.style.TextureRegionDrawable;
import io.anuke.arc.util.Tmp;

public class TiledDrawable
extends TextureRegionDrawable {
    private final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private float tileWidth;
    private float tileHeight;

    public TiledDrawable() {
    }

    public TiledDrawable(TextureRegion region) {
        super(region);
    }

    public TiledDrawable(TextureRegionDrawable drawable) {
        super(drawable);
    }

    @Override
    public void setRegion(TextureRegion region) {
        super.setRegion(region);
        this.tileWidth = region.getWidth();
        this.tileHeight = region.getHeight();
    }

    public void setTileSize(float w, float h) {
        this.tileWidth = w;
        this.tileHeight = h;
    }

    @Override
    public void draw(float x, float y, float width, float height) {
        float v;
        float u2;
        TextureRegion region = this.getRegion();
        float regionWidth = this.tileWidth;
        float regionHeight = this.tileHeight;
        int fullX = (int)(width / regionWidth);
        int fullY = (int)(height / regionHeight);
        float remainingX = width - regionWidth * (float)fullX;
        float remainingY = height - regionHeight * (float)fullY;
        float startX = x;
        float startY = y;
        Draw.color(this.color);
        for (int i = 0; i < fullX; ++i) {
            y = startY;
            for (int ii = 0; ii < fullY; ++ii) {
                Draw.rect(region, x, y, regionWidth, regionHeight);
                y += regionHeight;
            }
            x += regionWidth;
        }
        Texture texture = region.getTexture();
        float u = region.getU();
        float v2 = region.getV2();
        if (remainingX > 0.0f) {
            u2 = u + remainingX / (float)texture.getWidth();
            v = region.getV();
            y = startY;
            for (int ii = 0; ii < fullY; ++ii) {
                Tmp.tr1.set(texture);
                Tmp.tr1.set(u, v2, u2, v);
                Draw.rect(Tmp.tr1, x + remainingX / 2.0f, y + remainingY / 2.0f, remainingX, remainingY);
                y += regionHeight;
            }
            if (remainingY > 0.0f) {
                v = v2 - remainingY / (float)texture.getHeight();
                Tmp.tr1.set(texture);
                Tmp.tr1.set(u, v2, u2, v);
                Draw.rect(Tmp.tr1, x + remainingX / 2.0f, y + remainingY / 2.0f, remainingX, remainingY);
            }
        }
        if (remainingY > 0.0f) {
            u2 = region.getU2();
            v = v2 - remainingY / (float)texture.getHeight();
            x = startX;
            for (int i = 0; i < fullX; ++i) {
                Tmp.tr1.set(texture);
                Tmp.tr1.set(u, v2, u2, v);
                Draw.rect(Tmp.tr1, x + remainingX / 2.0f, y + remainingY / 2.0f, remainingX, remainingY);
                x += regionWidth;
            }
        }
    }

    @Override
    public void draw(float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation) {
        throw new UnsupportedOperationException();
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public TiledDrawable tint(Color tint) {
        TiledDrawable drawable = new TiledDrawable(this);
        drawable.color.set(tint);
        drawable.setLeftWidth(this.getLeftWidth());
        drawable.setRightWidth(this.getRightWidth());
        drawable.setTopHeight(this.getTopHeight());
        drawable.setBottomHeight(this.getBottomHeight());
        return drawable;
    }
}

