/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.scene.event;

import io.anuke.arc.Core;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.event.InputEvent;
import io.anuke.arc.scene.event.InputListener;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.Tmp;

public class ClickListener
extends InputListener {
    public static float visualPressedDuration = 0.1f;
    public static Runnable clicked = () -> {};
    protected float tapSquareSize = 14.0f;
    protected float touchDownX = -1.0f;
    protected float touchDownY = -1.0f;
    protected int pressedPointer = -1;
    protected KeyCode pressedButton;
    protected KeyCode button = KeyCode.MOUSE_LEFT;
    protected boolean pressed;
    protected boolean over;
    protected boolean overAny;
    protected boolean cancelled;
    protected long visualPressedTime;
    protected long tapCountInterval = 400000000L;
    protected int tapCount;
    protected long lastTapTime;
    protected boolean stop = false;

    public ClickListener() {
    }

    public ClickListener(KeyCode button) {
        this.button = button;
    }

    @Override
    public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
        if (this.pressed) {
            return false;
        }
        if (pointer == 0 && this.button != null && button != this.button) {
            return false;
        }
        this.pressed = true;
        this.pressedPointer = pointer;
        this.pressedButton = button;
        this.touchDownX = x;
        this.touchDownY = y;
        this.visualPressedTime = Time.millis() + (long)(visualPressedDuration * 1000.0f);
        return true;
    }

    @Override
    public void touchDragged(InputEvent event, float x, float y, int pointer) {
        if (pointer != this.pressedPointer || this.cancelled) {
            return;
        }
        this.pressed = this.isOver(event.listenerActor, x, y);
        if (this.pressed && pointer == 0 && this.button != null && !Core.input.keyDown(this.button)) {
            this.pressed = false;
        }
        if (!this.pressed) {
            this.invalidateTapSquare();
        }
    }

    @Override
    public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
        if (pointer == this.pressedPointer) {
            if (!this.cancelled) {
                boolean touchUpOver = this.isOver(event.listenerActor, x, y);
                if (touchUpOver && pointer == 0 && this.button != null && button != this.button) {
                    touchUpOver = false;
                }
                if (touchUpOver) {
                    long time = Time.nanos();
                    if (time - this.lastTapTime > this.tapCountInterval) {
                        this.tapCount = 0;
                    }
                    ++this.tapCount;
                    this.lastTapTime = time;
                    clicked.run();
                    this.clicked(event, x, y);
                }
            }
            this.pressed = false;
            this.pressedPointer = -1;
            this.pressedButton = null;
            this.cancelled = false;
        }
    }

    @Override
    public void enter(InputEvent event, float x, float y, int pointer, Element fromActor) {
        if (pointer == -1 && !this.cancelled) {
            this.over = true;
        }
        if (!this.cancelled) {
            this.overAny = true;
        }
    }

    @Override
    public void exit(InputEvent event, float x, float y, int pointer, Element toActor) {
        if (pointer == -1 && !this.cancelled) {
            this.over = false;
        }
        if (!this.cancelled) {
            this.overAny = false;
        }
    }

    public void cancel() {
        if (this.pressedPointer == -1) {
            return;
        }
        this.cancelled = true;
        this.pressed = false;
    }

    public void clicked(InputEvent event, float x, float y) {
    }

    public boolean isOver(Element element, float x, float y) {
        element.localToStageCoordinates(Tmp.v1.set(x, y));
        Element hit = Core.scene.hit(Tmp.v1.x, Tmp.v1.y, true);
        return hit != null && hit.isDescendantOf(element);
    }

    public boolean inTapSquare(float x, float y) {
        return (this.touchDownX != -1.0f || this.touchDownY != -1.0f) && Math.abs(x - this.touchDownX) < this.tapSquareSize && Math.abs(y - this.touchDownY) < this.tapSquareSize;
    }

    public boolean inTapSquare() {
        return this.touchDownX != -1.0f;
    }

    public void invalidateTapSquare() {
        this.touchDownX = -1.0f;
        this.touchDownY = -1.0f;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public boolean isVisualPressed() {
        if (this.pressed) {
            return true;
        }
        if (this.visualPressedTime <= 0L) {
            return false;
        }
        if (this.visualPressedTime > Time.millis()) {
            return true;
        }
        this.visualPressedTime = 0L;
        return false;
    }

    public boolean isOver() {
        return this.over || this.pressed;
    }

    public float getTapSquareSize() {
        return this.tapSquareSize;
    }

    public void setTapSquareSize(float halfTapSquareSize) {
        this.tapSquareSize = halfTapSquareSize;
    }

    public void setTapCountInterval(float tapCountInterval) {
        this.tapCountInterval = (long)(tapCountInterval * 1.0E9f);
    }

    public int getTapCount() {
        return this.tapCount;
    }

    public void setTapCount(int tapCount) {
        this.tapCount = tapCount;
    }

    public float getTouchDownX() {
        return this.touchDownX;
    }

    public float getTouchDownY() {
        return this.touchDownY;
    }

    public KeyCode getPressedButton() {
        return this.pressedButton;
    }

    public int getPressedPointer() {
        return this.pressedPointer;
    }

    public KeyCode getButton() {
        return this.button;
    }

    public void setButton(KeyCode button) {
        this.button = button;
    }
}

