/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.scene;

import io.anuke.arc.collection.SnapshotArray;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.function.Predicate;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.math.Affine2;
import io.anuke.arc.math.Matrix3;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.Scene;
import io.anuke.arc.scene.event.Touchable;
import io.anuke.arc.scene.style.Drawable;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.scene.utils.Cullable;

public abstract class Group
extends Element
implements Cullable {
    private static final Vector2 tmp = new Vector2();
    final SnapshotArray<Element> children = new SnapshotArray(true, 4, Element.class);
    private final Affine2 worldTransform = new Affine2();
    private final Matrix3 computedTransform = new Matrix3();
    private final Matrix3 oldTransform = new Matrix3();
    boolean transform = false;
    private Rectangle cullingArea;

    @Override
    public void act(float delta) {
        super.act(delta);
        Element[] actors = this.children.begin();
        int n = this.children.size;
        for (int i = 0; i < n; ++i) {
            if (actors[i].isVisible()) {
                actors[i].act(delta);
            }
            actors[i].updateVisibility();
        }
        this.children.end();
    }

    @Override
    public void draw() {
        if (this.transform) {
            this.applyTransform(this.computeTransform());
        }
        this.drawChildren();
        if (this.transform) {
            this.resetTransform();
        }
    }

    protected void drawChildren() {
        this.parentAlpha *= this.color.a;
        SnapshotArray<Element> children = this.children;
        Element[] actors = children.begin();
        Rectangle cullingArea = this.cullingArea;
        if (cullingArea != null) {
            float cullLeft = cullingArea.x;
            float cullRight = cullLeft + cullingArea.width;
            float cullBottom = cullingArea.y;
            float cullTop = cullBottom + cullingArea.height;
            if (this.transform) {
                int n = children.size;
                for (int i = 0; i < n; ++i) {
                    Element child = actors[i];
                    child.parentAlpha = this.parentAlpha;
                    if (!child.isVisible()) continue;
                    float cx = child.x;
                    float cy = child.y;
                    child.x += child.translation.x;
                    child.y += child.translation.y;
                    if (cx <= cullRight && cy <= cullTop && cx + child.width >= cullLeft && cy + child.height >= cullBottom) {
                        child.draw();
                    }
                    child.x -= child.translation.x;
                    child.y -= child.translation.y;
                }
            } else {
                float offsetX = this.x;
                float offsetY = this.y;
                this.x = 0.0f;
                this.y = 0.0f;
                int n = children.size;
                for (int i = 0; i < n; ++i) {
                    Element child = actors[i];
                    child.parentAlpha = this.parentAlpha;
                    if (!child.isVisible()) continue;
                    float cx = child.x;
                    float cy = child.y;
                    if (!(cx <= cullRight) || !(cy <= cullTop) || !(cx + child.width >= cullLeft) || !(cy + child.height >= cullBottom)) continue;
                    child.x = cx + offsetX + child.getTranslation().x;
                    child.y = cy + offsetY + child.getTranslation().y;
                    child.draw();
                    child.x = cx;
                    child.y = cy;
                }
                this.x = offsetX;
                this.y = offsetY;
            }
        } else if (this.transform) {
            int n = children.size;
            for (int i = 0; i < n; ++i) {
                Element child = actors[i];
                child.parentAlpha = this.parentAlpha;
                if (!child.isVisible()) continue;
                child.x += child.translation.x;
                child.y += child.translation.y;
                child.draw();
                child.x -= child.translation.x;
                child.y -= child.translation.y;
            }
        } else {
            float offsetX = this.x;
            float offsetY = this.y;
            this.x = 0.0f;
            this.y = 0.0f;
            int n = children.size;
            for (int i = 0; i < n; ++i) {
                Element child = actors[i];
                child.parentAlpha = this.parentAlpha;
                if (!child.isVisible()) continue;
                float cx = child.x;
                float cy = child.y;
                child.x = cx + offsetX + child.getTranslation().x;
                child.y = cy + offsetY + child.getTranslation().y;
                child.draw();
                child.x = cx;
                child.y = cy;
            }
            this.x = offsetX;
            this.y = offsetY;
        }
        children.end();
    }

    protected Matrix3 computeTransform() {
        Affine2 worldTransform = this.worldTransform;
        float originX = this.originX;
        float originY = this.originY;
        worldTransform.setToTrnRotScl(this.x + originX, this.y + originY, this.rotation, this.scaleX, this.scaleY);
        if (originX != 0.0f || originY != 0.0f) {
            worldTransform.translate(-originX, -originY);
        }
        Group parentGroup = this.parent;
        while (parentGroup != null && !parentGroup.transform) {
            parentGroup = parentGroup.parent;
        }
        if (parentGroup != null) {
            worldTransform.preMul(parentGroup.worldTransform);
        }
        this.computedTransform.set(worldTransform);
        return this.computedTransform;
    }

    protected void applyTransform(Matrix3 transform) {
        this.oldTransform.set(Draw.trans());
        Draw.trans(transform);
    }

    protected void resetTransform() {
        Draw.trans(this.oldTransform);
    }

    public Rectangle getCullingArea() {
        return this.cullingArea;
    }

    @Override
    public void setCullingArea(Rectangle cullingArea) {
        this.cullingArea = cullingArea;
    }

    @Override
    public Element hit(float x, float y, boolean touchable) {
        if (touchable && this.getTouchable() == Touchable.disabled) {
            return null;
        }
        Vector2 point = tmp;
        Element[] childrenArray = (Element[])this.children.items;
        for (int i = this.children.size - 1; i >= 0; --i) {
            Element child = childrenArray[i];
            if (!child.isVisible()) continue;
            child.parentToLocalCoordinates(point.set(x, y));
            Element hit = child.hit(point.x, point.y, touchable);
            if (hit == null) continue;
            return hit;
        }
        return super.hit(x, y, touchable);
    }

    protected void childrenChanged() {
    }

    public void forEach(Consumer<Element> cons) {
        for (Element e : this.getChildren()) {
            cons.accept(e);
            if (!(e instanceof Group)) continue;
            ((Group)e).forEach(cons);
        }
    }

    public Element fill(final Table.DrawRect rect) {
        Element e = new Element(){

            @Override
            public void draw() {
                rect.draw(this.x, this.y, this.width, this.height);
            }
        };
        e.setFillParent(true);
        this.addChild(e);
        return e;
    }

    public void fill(Consumer<Table> cons) {
        this.fill(null, cons);
    }

    public void fill(Drawable background, Consumer<Table> cons) {
        Table table = background == null ? new Table() : new Table(background);
        table.setFillParent(true);
        this.addChild(table);
        cons.accept(table);
    }

    public void addChild(Element actor) {
        if (actor.parent != null) {
            if (actor.parent == this) {
                return;
            }
            actor.parent.removeChild(actor, false);
        }
        this.children.add(actor);
        actor.setParent(this);
        actor.setScene(this.getScene());
        this.childrenChanged();
    }

    public void addChildAt(int index, Element actor) {
        if (actor.parent != null) {
            if (actor.parent == this) {
                return;
            }
            actor.parent.removeChild(actor, false);
        }
        if (index >= this.children.size) {
            this.children.add(actor);
        } else {
            this.children.insert(index, actor);
        }
        actor.setParent(this);
        actor.setScene(this.getScene());
        this.childrenChanged();
    }

    public void addChildBefore(Element actorBefore, Element actor) {
        if (actor.parent != null) {
            if (actor.parent == this) {
                return;
            }
            actor.parent.removeChild(actor, false);
        }
        int index = this.children.indexOf(actorBefore, true);
        this.children.insert(index, actor);
        actor.setParent(this);
        actor.setScene(this.getScene());
        this.childrenChanged();
    }

    public void addChildAfter(Element actorAfter, Element actor) {
        int index;
        if (actor.parent != null) {
            if (actor.parent == this) {
                return;
            }
            actor.parent.removeChild(actor, false);
        }
        if ((index = this.children.indexOf(actorAfter, true)) == this.children.size) {
            this.children.add(actor);
        } else {
            this.children.insert(index + 1, actor);
        }
        actor.setParent(this);
        actor.setScene(this.getScene());
        this.childrenChanged();
    }

    public boolean removeChild(Element actor) {
        return this.removeChild(actor, true);
    }

    public boolean removeChild(Element actor, boolean unfocus) {
        Scene stage;
        if (!this.children.removeValue(actor, true)) {
            return false;
        }
        if (unfocus && (stage = this.getScene()) != null) {
            stage.unfocus(actor);
        }
        actor.setParent(null);
        actor.setScene(null);
        this.childrenChanged();
        return true;
    }

    public void clearChildren() {
        Element[] actors = this.children.begin();
        int n = this.children.size;
        for (int i = 0; i < n; ++i) {
            Element child = actors[i];
            child.setScene(null);
            child.setParent(null);
        }
        this.children.end();
        this.children.clear();
        this.childrenChanged();
    }

    @Override
    public void clear() {
        super.clear();
        this.clearChildren();
    }

    public <T extends Element> T find(String name) {
        int i;
        SnapshotArray<Element> children = this.children;
        int n = children.size;
        for (i = 0; i < n; ++i) {
            if (!name.equals(((Element)children.get(i)).getName())) continue;
            return (T)((Element)children.get(i));
        }
        n = children.size;
        for (i = 0; i < n; ++i) {
            T actor;
            Element child = (Element)children.get(i);
            if (!(child instanceof Group) || (actor = ((Group)child).find(name)) == null) continue;
            return actor;
        }
        return null;
    }

    public <T extends Element> T findVisible(String name) {
        int i;
        SnapshotArray<Element> children = this.children;
        int n = children.size;
        for (i = 0; i < n; ++i) {
            if (!name.equals(((Element)children.get(i)).getName()) || !((Element)children.get(i)).isVisible()) continue;
            return (T)((Element)children.get(i));
        }
        n = children.size;
        for (i = 0; i < n; ++i) {
            T actor;
            Element child = (Element)children.get(i);
            if (!(child instanceof Group) || !child.isVisible() || (actor = ((Group)child).findVisible(name)) == null) continue;
            return actor;
        }
        return null;
    }

    public <T extends Element> T find(Predicate<Element> pred) {
        int i;
        SnapshotArray<Element> children = this.children;
        int n = children.size;
        for (i = 0; i < n; ++i) {
            if (!pred.test((Element)children.get(i))) continue;
            return (T)((Element)children.get(i));
        }
        n = children.size;
        for (i = 0; i < n; ++i) {
            T actor;
            Element child = (Element)children.get(i);
            if (!(child instanceof Group) || (actor = ((Group)child).find(pred)) == null) continue;
            return actor;
        }
        return null;
    }

    @Override
    protected void setScene(Scene stage) {
        super.setScene(stage);
        Element[] childrenArray = (Element[])this.children.items;
        int n = this.children.size;
        for (int i = 0; i < n; ++i) {
            childrenArray[i].setScene(stage);
        }
    }

    public boolean swapActor(int first, int second) {
        int maxIndex = this.children.size;
        if (first < 0 || first >= maxIndex) {
            return false;
        }
        if (second < 0 || second >= maxIndex) {
            return false;
        }
        this.children.swap(first, second);
        return true;
    }

    public boolean swapActor(Element first, Element second) {
        int firstIndex = this.children.indexOf(first, true);
        int secondIndex = this.children.indexOf(second, true);
        if (firstIndex == -1 || secondIndex == -1) {
            return false;
        }
        this.children.swap(firstIndex, secondIndex);
        return true;
    }

    public SnapshotArray<Element> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children.size > 0;
    }

    public boolean isTransform() {
        return this.transform;
    }

    public void setTransform(boolean transform) {
        this.transform = transform;
    }

    public Vector2 localToDescendantCoordinates(Element descendant, Vector2 localCoords) {
        Group parent = descendant.parent;
        if (parent == null) {
            throw new IllegalArgumentException("Child is not a descendant: " + descendant);
        }
        if (parent != this) {
            this.localToDescendantCoordinates(parent, localCoords);
        }
        descendant.parentToLocalCoordinates(localCoords);
        return localCoords;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        this.toString(buffer, 1);
        buffer.setLength(buffer.length() - 1);
        return buffer.toString();
    }

    void toString(StringBuilder buffer, int indent) {
        buffer.append(super.toString());
        buffer.append('\n');
        Element[] actors = this.children.begin();
        int n = this.children.size;
        for (int i = 0; i < n; ++i) {
            for (int ii = 0; ii < indent; ++ii) {
                buffer.append("|  ");
            }
            Element actor = actors[i];
            if (actor instanceof Group) {
                ((Group)actor).toString(buffer, indent + 1);
                continue;
            }
            buffer.append(actor);
            buffer.append('\n');
        }
        this.children.end();
    }
}

