/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.net;

import io.anuke.arc.function.Consumer;
import io.anuke.arc.function.Supplier;
import io.anuke.arc.net.ArcNetException;
import io.anuke.arc.net.Connection;
import io.anuke.arc.net.DcReason;
import io.anuke.arc.net.EndPoint;
import io.anuke.arc.net.FrameworkMessage;
import io.anuke.arc.net.NetSerializer;
import io.anuke.arc.net.UdpConnection;
import io.anuke.arc.util.async.AsyncExecutor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class Client
extends Connection
implements EndPoint {
    private final NetSerializer serialization;
    private Selector selector;
    private int emptySelects;
    private volatile boolean tcpRegistered;
    private volatile boolean udpRegistered;
    private Object tcpRegistrationLock = new Object();
    private Object udpRegistrationLock = new Object();
    private volatile boolean shutdown;
    private final Object updateLock = new Object();
    private Thread updateThread;
    private int connectTimeout;
    private InetAddress connectHost;
    private int connectTcpPort;
    private int connectUdpPort;
    private boolean isClosed;
    private AsyncExecutor discoverExecutor = new AsyncExecutor(6);
    private Supplier<DatagramPacket> discoveryPacket = () -> new DatagramPacket(new byte[256], 256);

    public Client(int writeBufferSize, int objectBufferSize, NetSerializer serialization) {
        this.endPoint = this;
        this.serialization = serialization;
        this.initialize(serialization, writeBufferSize, objectBufferSize);
        try {
            this.selector = Selector.open();
        }
        catch (IOException ex) {
            throw new RuntimeException("Error opening selector.", ex);
        }
    }

    public void setDiscoveryPacket(Supplier<DatagramPacket> discoveryPacket) {
    }

    public void connect(int timeout, String host, int tcpPort) throws IOException {
        this.connect(timeout, InetAddress.getByName(host), tcpPort, -1);
    }

    public void connect(int timeout, String host, int tcpPort, int udpPort) throws IOException {
        this.connect(timeout, InetAddress.getByName(host), tcpPort, udpPort);
    }

    public void connect(int timeout, InetAddress host, int tcpPort) throws IOException {
        this.connect(timeout, host, tcpPort, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(int timeout, InetAddress host, int tcpPort, int udpPort) throws IOException {
        if (host == null) {
            throw new IllegalArgumentException("host cannot be null.");
        }
        if (Thread.currentThread() == this.getUpdateThread()) {
            throw new IllegalStateException("Cannot connect on the connection's update thread.");
        }
        this.connectTimeout = timeout;
        this.connectHost = host;
        this.connectTcpPort = tcpPort;
        this.connectUdpPort = udpPort;
        this.close();
        this.id = -1;
        try {
            long endTime;
            if (udpPort != -1) {
                this.udp = new UdpConnection(this.serialization, this.tcp.readBuffer.capacity());
            }
            Object object = this.updateLock;
            synchronized (object) {
                this.tcpRegistered = false;
                this.selector.wakeup();
                endTime = System.currentTimeMillis() + (long)timeout;
                this.tcp.connect(this.selector, new InetSocketAddress(host, tcpPort), 5000);
            }
            object = this.tcpRegistrationLock;
            synchronized (object) {
                while (!this.tcpRegistered && System.currentTimeMillis() < endTime) {
                    try {
                        this.tcpRegistrationLock.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!this.tcpRegistered) {
                    throw new SocketTimeoutException("Connected, but timed out during TCP registration.\nNote: Client#update must be called in a separate thread during connect.");
                }
            }
            if (udpPort == -1) return;
            InetSocketAddress udpAddress = new InetSocketAddress(host, udpPort);
            Object object2 = this.updateLock;
            synchronized (object2) {
                this.udpRegistered = false;
                this.selector.wakeup();
                this.udp.connect(this.selector, udpAddress);
            }
            object2 = this.udpRegistrationLock;
            synchronized (object2) {
                while (!this.udpRegistered && System.currentTimeMillis() < endTime) {
                    FrameworkMessage.RegisterUDP registerUDP = new FrameworkMessage.RegisterUDP();
                    registerUDP.connectionID = this.id;
                    this.udp.send(registerUDP, udpAddress);
                    try {
                        this.udpRegistrationLock.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.udpRegistered) return;
                throw new SocketTimeoutException("Connected, but timed out during UDP registration: " + host + ":" + udpPort);
            }
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
    }

    public void reconnect() throws IOException {
        this.reconnect(this.connectTimeout);
    }

    public void reconnect(int timeout) throws IOException {
        if (this.connectHost == null) {
            throw new IllegalStateException("This client has never been connected.");
        }
        this.connect(timeout, this.connectHost, this.connectTcpPort, this.connectUdpPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(int timeout) throws IOException {
        this.updateThread = Thread.currentThread();
        Object object = this.updateLock;
        synchronized (object) {
        }
        long startTime = System.currentTimeMillis();
        int select = 0;
        select = timeout > 0 ? this.selector.select(timeout) : this.selector.selectNow();
        if (select == 0) {
            ++this.emptySelects;
            if (this.emptySelects == 100) {
                this.emptySelects = 0;
                long elapsedTime = System.currentTimeMillis() - startTime;
                try {
                    if (elapsedTime < 25L) {
                        Thread.sleep(25L - elapsedTime);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            Set<SelectionKey> keys;
            this.emptySelects = 0;
            this.isClosed = false;
            Set<SelectionKey> set = keys = this.selector.selectedKeys();
            synchronized (set) {
                Iterator<SelectionKey> iter = keys.iterator();
                while (iter.hasNext()) {
                    this.keepAlive();
                    SelectionKey selectionKey = iter.next();
                    iter.remove();
                    try {
                        int ops = selectionKey.readyOps();
                        if ((ops & 1) == 1) {
                            Object object2;
                            if (selectionKey.attachment() == this.tcp) {
                                while ((object2 = this.tcp.readObject()) != null) {
                                    Object object3;
                                    if (!this.tcpRegistered) {
                                        if (!(object2 instanceof FrameworkMessage.RegisterTCP)) continue;
                                        this.id = ((FrameworkMessage.RegisterTCP)object2).connectionID;
                                        object3 = this.tcpRegistrationLock;
                                        synchronized (object3) {
                                            this.tcpRegistered = true;
                                            this.tcpRegistrationLock.notifyAll();
                                            if (this.udp == null) {
                                                this.setConnected(true);
                                            }
                                        }
                                        if (this.udp != null) continue;
                                        this.notifyConnected();
                                        continue;
                                    }
                                    if (this.udp != null && !this.udpRegistered) {
                                        if (!(object2 instanceof FrameworkMessage.RegisterUDP)) continue;
                                        object3 = this.udpRegistrationLock;
                                        synchronized (object3) {
                                            this.udpRegistered = true;
                                            this.udpRegistrationLock.notifyAll();
                                            this.setConnected(true);
                                        }
                                        this.notifyConnected();
                                        continue;
                                    }
                                    if (!this.isConnected) continue;
                                    this.notifyReceived(object2);
                                }
                            } else {
                                if (this.udp.readFromAddress() == null || (object2 = this.udp.readObject()) == null) continue;
                                this.notifyReceived(object2);
                            }
                        }
                        if ((ops & 4) != 4) continue;
                        this.tcp.writeOperation();
                    }
                    catch (CancelledKeyException cancelledKeyException) {}
                }
            }
        }
        if (this.isConnected) {
            long time = System.currentTimeMillis();
            if (this.tcp.isTimedOut(time)) {
                this.close();
            } else {
                this.keepAlive();
            }
            if (this.isIdle()) {
                this.notifyIdle();
            }
        }
    }

    void keepAlive() {
        if (!this.isConnected) {
            return;
        }
        long time = System.currentTimeMillis();
        if (this.tcp.needsKeepAlive(time)) {
            this.sendTCP(FrameworkMessage.keepAlive);
        }
        if (this.udp != null && this.udpRegistered && this.udp.needsKeepAlive(time)) {
            this.sendUDP(FrameworkMessage.keepAlive);
        }
    }

    @Override
    public void run() {
        this.shutdown = false;
        while (!this.shutdown) {
            try {
                this.update(250);
            }
            catch (IOException ex) {
                this.close();
            }
            catch (ArcNetException ex) {
                this.lastProtocolError = ex;
                this.close();
                throw ex;
            }
        }
    }

    @Override
    public void start() {
        if (this.updateThread != null) {
            this.shutdown = true;
            try {
                this.updateThread.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.updateThread = new Thread((Runnable)this, "Client");
        this.updateThread.setDaemon(true);
        this.updateThread.start();
    }

    @Override
    public void stop() {
        if (this.shutdown) {
            return;
        }
        this.close();
        this.shutdown = true;
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close(DcReason.closed);
        Object object = this.updateLock;
        synchronized (object) {
        }
        if (!this.isClosed) {
            this.isClosed = true;
            this.selector.wakeup();
        }
    }

    public void dispose() throws IOException {
        this.close();
        this.selector.close();
    }

    public void setKeepAliveUDP(int keepAliveMillis) {
        if (this.udp == null) {
            throw new IllegalStateException("Not connected via UDP.");
        }
        this.udp.keepAliveMillis = keepAliveMillis;
    }

    @Override
    public Thread getUpdateThread() {
        return this.updateThread;
    }

    public NetSerializer getSerialization() {
        return this.serialization;
    }

    private void broadcast(int udpPort, DatagramSocket socket) throws IOException {
        ByteBuffer dataBuffer = ByteBuffer.allocate(64);
        this.serialization.write(dataBuffer, new FrameworkMessage.DiscoverHost());
        dataBuffer.flip();
        byte[] data = new byte[dataBuffer.limit()];
        dataBuffer.get(data);
        for (NetworkInterface iface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
            if (!iface.isUp()) continue;
            for (InterfaceAddress baseAddress : iface.getInterfaceAddresses()) {
                InetAddress address = baseAddress.getBroadcast();
                if (address == null) continue;
                socket.send(new DatagramPacket(data, data.length, address, udpPort));
            }
        }
    }

    public void discoverHosts(int udpPort, String multicastGroup, int multicastPort, int timeoutMillis, Consumer<DatagramPacket> handler, Runnable done) {
        boolean[] isDone = new boolean[]{false};
        this.discoverExecutor.submit(() -> {
            try {
                DatagramSocket socket = new DatagramSocket();
                Throwable throwable = null;
                try {
                    try {
                        socket.setBroadcast(true);
                        this.broadcast(udpPort, socket);
                        socket.setSoTimeout(timeoutMillis);
                        while (true) {
                            DatagramPacket packet = this.discoveryPacket.get();
                            socket.receive(packet);
                            handler.accept(packet);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (socket != null) {
                        if (throwable != null) {
                            try {
                                socket.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            socket.close();
                        }
                    }
                    throw throwable3;
                }
            }
            catch (Throwable throwable) {
                boolean[] blArray = isDone;
                synchronized (isDone) {
                    if (!isDone[0]) {
                        isDone[0] = true;
                        done.run();
                    }
                    // ** MonitorExit[var12_13] (shouldn't be in output)
                    throw throwable;
                }
            }
        });
        this.discoverExecutor.submit(() -> {
            try {
                DatagramSocket socket = new DatagramSocket();
                Throwable throwable = null;
                try {
                    try {
                        ByteBuffer dataBuffer = ByteBuffer.allocate(64);
                        this.serialization.write(dataBuffer, new FrameworkMessage.DiscoverHost());
                        dataBuffer.flip();
                        byte[] data = new byte[dataBuffer.limit()];
                        dataBuffer.get(data);
                        socket.send(new DatagramPacket(data, data.length, InetAddress.getByName(multicastGroup), multicastPort));
                        socket.setSoTimeout(timeoutMillis);
                        while (true) {
                            DatagramPacket packet = this.discoveryPacket.get();
                            socket.receive(packet);
                            handler.accept(packet);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (socket != null) {
                        if (throwable != null) {
                            try {
                                socket.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            socket.close();
                        }
                    }
                    throw throwable3;
                }
            }
            catch (Throwable throwable) {
                boolean[] blArray = isDone;
                synchronized (isDone) {
                    if (!isDone[0]) {
                        isDone[0] = true;
                        done.run();
                    }
                    // ** MonitorExit[var15_16] (shouldn't be in output)
                    throw throwable;
                }
            }
        });
    }

    static {
        try {
            System.setProperty("java.net.preferIPv6Addresses", "false");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

