/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.math.geom;

import io.anuke.arc.math.geom.Vector2;

public class Spring2D {
    public Vector2 value = new Vector2();
    public Vector2 target = new Vector2();
    public Vector2 velocity = new Vector2();
    public float damping;
    public float frequency;

    public Spring2D(float damping, float frequency) {
        this.damping = damping;
        this.frequency = frequency;
    }

    public void update(float deltaTime) {
        float angularFrequency = this.frequency;
        float f = 1.0f + 2.0f * deltaTime * this.damping * (angularFrequency *= (float)Math.PI * 2);
        float oo = angularFrequency * angularFrequency;
        float hoo = deltaTime * oo;
        float hhoo = deltaTime * hoo;
        float detInv = 1.0f / (f + hhoo);
        float detX = f * this.value.x + deltaTime * this.velocity.x + hhoo * this.target.x;
        float detV = this.velocity.x + hoo * (this.target.x - this.value.x);
        this.value.x = detX * detInv;
        this.velocity.x = detV * detInv;
        detX = f * this.value.y + deltaTime * this.velocity.y + hhoo * this.target.y;
        detV = this.velocity.y + hoo * (this.target.y - this.value.y);
        this.value.y = detX * detInv;
        this.velocity.y = detV * detInv;
    }
}

