/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.math.geom;

import io.anuke.arc.collection.Array;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.math.geom.Rectangle;
import java.util.Iterator;

public class QuadTree<T extends QuadTreeObject> {
    private static final Rectangle tmp = new Rectangle();
    private static final int maxObjectsPerNode = 5;
    private static final int botLeft = 0;
    private static final int botRight = 1;
    private static final int topRight = 2;
    private static final int topLeft = 3;
    private Rectangle bounds;
    private Array<T> objects = new Array();
    private QuadTree<T>[] children;

    public QuadTree(Rectangle bounds) {
        this.bounds = bounds;
    }

    private void split() {
        if (this.children != null) {
            return;
        }
        float subW = this.bounds.width / 2.0f;
        float subH = this.bounds.height / 2.0f;
        this.children = new QuadTree[4];
        this.children[0] = new QuadTree<T>(new Rectangle(this.bounds.x, this.bounds.y, subW, subH));
        this.children[1] = new QuadTree<T>(new Rectangle(this.bounds.x + subW, this.bounds.y, subW, subH));
        this.children[3] = new QuadTree<T>(new Rectangle(this.bounds.x, this.bounds.y + subH, subW, subH));
        this.children[2] = new QuadTree<T>(new Rectangle(this.bounds.x + subW, this.bounds.y + subH, subW, subH));
        Iterator<T> iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            QuadTreeObject obj = (QuadTreeObject)iterator.next();
            obj.hitbox(tmp);
            QuadTree<QuadTreeObject> child = this.getFittingChild(tmp);
            if (child == null) continue;
            child.insert(obj);
            iterator.remove();
        }
    }

    private void unsplit() {
        if (this.children == null) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            this.objects.addAll(this.children[i].objects);
        }
        this.children = null;
    }

    public void insert(T obj) {
        obj.hitbox(tmp);
        if (!this.bounds.overlaps(tmp)) {
            return;
        }
        if (this.children == null && this.objects.size + 1 > 5) {
            this.split();
        }
        if (this.children == null) {
            this.objects.add(obj);
        } else {
            obj.hitbox(tmp);
            QuadTree<T> child = this.getFittingChild(tmp);
            if (child != null) {
                child.insert(obj);
            } else {
                this.objects.add(obj);
            }
        }
    }

    public void remove(T obj) {
        if (this.children == null) {
            this.objects.removeValue(obj, true);
        } else {
            obj.hitbox(tmp);
            QuadTree<T> child = this.getFittingChild(tmp);
            if (child != null) {
                child.remove(obj);
            } else {
                this.objects.removeValue(obj, true);
            }
            if (this.getTotalObjectCount() <= 5) {
                this.unsplit();
            }
        }
    }

    public void clear() {
        this.objects.clear();
        if (this.children != null) {
            for (int i = 0; i < 4; ++i) {
                this.children[i].clear();
            }
        }
    }

    private QuadTree<T> getFittingChild(Rectangle boundingBox) {
        boolean bottomQuadrant;
        float verticalMidpoint = this.bounds.x + this.bounds.width / 2.0f;
        float horizontalMidpoint = this.bounds.y + this.bounds.height / 2.0f;
        boolean topQuadrant = boundingBox.y > horizontalMidpoint;
        boolean bl = bottomQuadrant = boundingBox.y < horizontalMidpoint && boundingBox.y + boundingBox.height < horizontalMidpoint;
        if (boundingBox.x < verticalMidpoint && boundingBox.x + boundingBox.width < verticalMidpoint) {
            if (topQuadrant) {
                return this.children[3];
            }
            if (bottomQuadrant) {
                return this.children[0];
            }
        } else if (boundingBox.x > verticalMidpoint) {
            if (topQuadrant) {
                return this.children[2];
            }
            if (bottomQuadrant) {
                return this.children[1];
            }
        }
        return null;
    }

    public void getIntersect(Consumer<T> out, float x, float y, float width, float height) {
        int i;
        if (this.children != null) {
            for (i = 0; i < 4; ++i) {
                if (!this.children[i].bounds.overlaps(x, y, width, height)) continue;
                this.children[i].getIntersect(out, x, y, width, height);
            }
        }
        for (i = 0; i < this.objects.size; ++i) {
            ((QuadTreeObject)this.objects.get(i)).hitbox(tmp);
            if (!tmp.overlaps(x, y, width, height)) continue;
            out.accept(this.objects.get(i));
        }
    }

    public void getIntersect(Consumer<T> out, Rectangle rect) {
        this.getIntersect(out, rect.x, rect.y, rect.width, rect.height);
    }

    public void getIntersect(Array<T> out, Rectangle toCheck) {
        if (this.children != null) {
            for (int i = 0; i < 4; ++i) {
                if (!this.children[i].bounds.overlaps(toCheck)) continue;
                this.children[i].getIntersect(out, toCheck);
            }
        }
        out.addAll(this.objects);
    }

    public boolean isLeaf() {
        return this.children == null;
    }

    public QuadTree<T> getBottomLeftChild() {
        return this.children[0];
    }

    public QuadTree<T> getBottomRightChild() {
        return this.children[1];
    }

    public QuadTree<T> getTopLeftChild() {
        return this.children[3];
    }

    public QuadTree<T> getTopRightChild() {
        return this.children[2];
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public Array<T> getObjects() {
        return this.objects;
    }

    public int getTotalObjectCount() {
        int count = this.objects.size;
        if (this.children != null) {
            for (int i = 0; i < 4; ++i) {
                count += this.children[i].getTotalObjectCount();
            }
        }
        return count;
    }

    public void getAllChildren(Array<T> out) {
        out.addAll(this.objects);
        if (this.children != null) {
            for (int i = 0; i < 4; ++i) {
                this.children[i].getAllChildren(out);
            }
        }
    }

    public static interface QuadTreeObject {
        public void hitbox(Rectangle var1);
    }
}

