/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.math.geom;

import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;

public interface Position {
    public float getX();

    public float getY();

    default public float angleTo(Position other) {
        return Angles.angle(this.getX(), this.getY(), other.getX(), other.getY());
    }

    default public float angleTo(float x, float y) {
        return Angles.angle(this.getX(), this.getY(), x, y);
    }

    default public float dst2(Position other) {
        return this.dst2(other.getX(), other.getY());
    }

    default public float dst(Position other) {
        return this.dst(other.getX(), other.getY());
    }

    default public float dst(float x, float y) {
        float xd = this.getX() - x;
        float yd = this.getY() - y;
        return Mathf.sqrt(xd * xd + yd * yd);
    }

    default public float dst2(float x, float y) {
        float xd = this.getX() - x;
        float yd = this.getY() - y;
        return xd * xd + yd * yd;
    }

    default public boolean withinDst(Position other, float dst) {
        return this.withinDst(other.getX(), other.getY(), dst);
    }

    default public boolean withinDst(float x, float y, float dst) {
        return Mathf.dst2(this.getX(), this.getY(), x, y) < dst * dst;
    }
}

