/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.math.geom;

import java.io.Serializable;

public class Point2
implements Serializable {
    private static final long serialVersionUID = -4019969926331717380L;
    public int x;
    public int y;

    public Point2() {
    }

    public Point2(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Point2(Point2 point) {
        this.x = point.x;
        this.y = point.y;
    }

    public Point2 set(Point2 point) {
        this.x = point.x;
        this.y = point.y;
        return this;
    }

    public Point2 set(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public float dst2(Point2 other) {
        int xd = other.x - this.x;
        int yd = other.y - this.y;
        return xd * xd + yd * yd;
    }

    public float dst2(int x, int y) {
        int xd = x - this.x;
        int yd = y - this.y;
        return xd * xd + yd * yd;
    }

    public float dst(Point2 other) {
        int xd = other.x - this.x;
        int yd = other.y - this.y;
        return (float)Math.sqrt(xd * xd + yd * yd);
    }

    public float dst(int x, int y) {
        int xd = x - this.x;
        int yd = y - this.y;
        return (float)Math.sqrt(xd * xd + yd * yd);
    }

    public Point2 add(Point2 other) {
        this.x += other.x;
        this.y += other.y;
        return this;
    }

    public Point2 add(int x, int y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public Point2 sub(Point2 other) {
        this.x -= other.x;
        this.y -= other.y;
        return this;
    }

    public Point2 sub(int x, int y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    public Point2 cpy() {
        return new Point2(this);
    }

    public boolean equals(int x, int y) {
        return this.x == x && this.y == y;
    }

    public static boolean equals(int x, int y, int ox, int oy) {
        return x == ox && y == oy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Point2 g = (Point2)o;
        return this.x == g.x && this.y == g.y;
    }

    public int hashCode() {
        return this.x * 49471 + this.y * 37345;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

