/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.math;

import io.anuke.arc.Core;
import io.anuke.arc.function.FloatConsumer;
import io.anuke.arc.function.IntConsumer;
import io.anuke.arc.function.PositionConsumer;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.RandomXS128;
import io.anuke.arc.math.geom.Vector2;

public class Angles {
    private static final RandomXS128 random = new RandomXS128();
    private static final Vector2 rv = new Vector2();

    public static float forwardDistance(float angle1, float angle2) {
        return angle1 > angle2 ? angle1 - angle2 : angle2 - angle1;
    }

    public static float backwardDistance(float angle1, float angle2) {
        return 360.0f - Angles.forwardDistance(angle1, angle2);
    }

    public static float angleDist(float a, float b) {
        return Math.min(Angles.forwardDistance(a %= 360.0f, b %= 360.0f), Angles.backwardDistance(a, b));
    }

    public static boolean near(float a, float b, float range) {
        return Angles.angleDist(a, b) < range;
    }

    public static float moveToward(float angle, float to, float speed) {
        if (Math.abs(Angles.angleDist(angle, to)) < speed) {
            return to;
        }
        angle = angle > to && Angles.backwardDistance(angle, to) > Angles.forwardDistance(angle, to) || angle < to && Angles.backwardDistance(angle, to) < Angles.forwardDistance(angle, to) ? (angle -= speed) : (angle += speed);
        return angle;
    }

    public static float angle(float x, float y, float x2, float y2) {
        float ang = Mathf.atan2(x2 - x, y2 - y) * 57.295776f;
        if (ang < 0.0f) {
            ang += 360.0f;
        }
        return ang;
    }

    public static float trnsx(float angle, float len) {
        return len * Mathf.cos((float)Math.PI / 180 * angle);
    }

    public static float trnsy(float angle, float len) {
        return len * Mathf.sin((float)Math.PI / 180 * angle);
    }

    public static float trnsx(float angle, float x, float y) {
        return Angles.rv.set((float)x, (float)y).rotate((float)angle).x;
    }

    public static float trnsy(float angle, float x, float y) {
        return Angles.rv.set((float)x, (float)y).rotate((float)angle).y;
    }

    public static float mouseAngle(float cx, float cy) {
        Vector2 avector = Core.camera.project(cx, cy);
        return Angles.angle(avector.x, avector.y, Core.input.mouseX(), Core.input.mouseY());
    }

    public static void loop(int max, IntConsumer i) {
        for (int j = 0; j < max; ++j) {
            i.accept(j);
        }
    }

    public static void circle(int points, float offset, FloatConsumer cons) {
        for (int i = 0; i < points; ++i) {
            cons.accept(offset + (float)i * 360.0f / (float)points);
        }
    }

    public static void circle(int points, FloatConsumer cons) {
        for (int i = 0; i < points; ++i) {
            cons.accept((float)i * 360.0f / (float)points);
        }
    }

    public static void circleVectors(int points, float length, PositionConsumer pos) {
        for (int i = 0; i < points; ++i) {
            float f = (float)i * 360.0f / (float)points;
            pos.accept(Angles.trnsx(f, length), Angles.trnsy(f, length));
        }
    }

    public static void circleVectors(int points, float length, float offset, PositionConsumer pos) {
        for (int i = 0; i < points; ++i) {
            float f = (float)i * 360.0f / (float)points + offset;
            pos.accept(Angles.trnsx(f, length), Angles.trnsy(f, length));
        }
    }

    public static void shotgun(int points, float spacing, float offset, FloatConsumer cons) {
        for (int i = 0; i < points; ++i) {
            cons.accept((float)i * spacing - (float)(points - 1) * spacing / 2.0f + offset);
        }
    }

    public static void randVectors(long seed, int amount, float length, PositionConsumer cons) {
        random.setSeed(seed);
        for (int i = 0; i < amount; ++i) {
            float vang = random.nextFloat() * 360.0f;
            rv.set(length, 0.0f).rotate(vang);
            cons.accept(Angles.rv.x, Angles.rv.y);
        }
    }

    public static void randLenVectors(long seed, int amount, float length, PositionConsumer cons) {
        random.setSeed(seed);
        for (int i = 0; i < amount; ++i) {
            float scl = length * random.nextFloat();
            float vang = random.nextFloat() * 360.0f;
            rv.set(scl, 0.0f).rotate(vang);
            cons.accept(Angles.rv.x, Angles.rv.y);
        }
    }

    public static void randLenVectors(long seed, int amount, float length, float angle, float range, PositionConsumer cons) {
        random.setSeed(seed);
        for (int i = 0; i < amount; ++i) {
            float scl = length * random.nextFloat();
            float vang = angle + random.nextFloat() * range * 2.0f - range;
            rv.set(scl, 0.0f).rotate(vang);
            cons.accept(Angles.rv.x, Angles.rv.y);
        }
    }

    public static void randLenVectors(long seed, float fin, int amount, float length, ParticleConsumer cons) {
        random.setSeed(seed);
        for (int i = 0; i < amount; ++i) {
            float l = random.nextFloat();
            float scl = length * l * fin;
            float vang = random.nextFloat() * 360.0f;
            rv.set(scl, 0.0f).rotate(vang);
            cons.accept(Angles.rv.x, Angles.rv.y, fin * l, (1.0f - fin) * l);
        }
    }

    public static void randLenVectors(long seed, float fin, int amount, float length, float angle, float range, ParticleConsumer cons) {
        random.setSeed(seed);
        for (int i = 0; i < amount; ++i) {
            float scl = length * random.nextFloat() * fin;
            float vang = angle + random.nextFloat() * range * 2.0f - range;
            rv.set(scl, 0.0f).rotate(vang);
            cons.accept(Angles.rv.x, Angles.rv.y, fin * random.nextFloat(), 0.0f);
        }
    }

    public static interface ParticleConsumer {
        public void accept(float var1, float var2, float var3, float var4);
    }
}

