/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.maps.loaders;

import io.anuke.arc.assets.AssetLoaderParameters;
import io.anuke.arc.assets.loaders.AsynchronousAssetLoader;
import io.anuke.arc.assets.loaders.FileHandleResolver;
import io.anuke.arc.collection.Array;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.maps.ImageLayer;
import io.anuke.arc.maps.MapGroupLayer;
import io.anuke.arc.maps.MapLayer;
import io.anuke.arc.maps.MapObject;
import io.anuke.arc.maps.MapProperties;
import io.anuke.arc.maps.MapTile;
import io.anuke.arc.maps.TileLayer;
import io.anuke.arc.maps.TileSets;
import io.anuke.arc.maps.TiledMap;
import io.anuke.arc.maps.loaders.ImageResolver;
import io.anuke.arc.maps.objects.EllipseMapObject;
import io.anuke.arc.maps.objects.PolygonMapObject;
import io.anuke.arc.maps.objects.PolylineMapObject;
import io.anuke.arc.maps.objects.RectangleMapObject;
import io.anuke.arc.maps.objects.TileMapObject;
import io.anuke.arc.math.geom.Polygon;
import io.anuke.arc.math.geom.Polyline;
import io.anuke.arc.util.ArcRuntimeException;
import io.anuke.arc.util.io.Streams;
import io.anuke.arc.util.serialization.Base64Coder;
import io.anuke.arc.util.serialization.XmlReader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public abstract class BaseTmxMapLoader<P extends AssetLoaderParameters<TiledMap>>
extends AsynchronousAssetLoader<TiledMap, P> {
    protected static final int FLAG_FLIP_HORIZONTALLY = Integer.MIN_VALUE;
    protected static final int FLAG_FLIP_VERTICALLY = 0x40000000;
    protected static final int FLAG_FLIP_DIAGONALLY = 0x20000000;
    protected static final int MASK_CLEAR = -536870912;
    protected XmlReader xml = new XmlReader();
    protected XmlReader.Element root;
    protected boolean convertObjectToTileSpace;
    protected boolean flipY = true;
    protected int mapTileWidth;
    protected int mapTileHeight;
    protected int mapWidthInPixels;
    protected int mapHeightInPixels;
    protected TiledMap map;

    public BaseTmxMapLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    public static int[] getTileIds(XmlReader.Element element, int width, int height) {
        int[] ids;
        block17: {
            String encoding;
            block18: {
                XmlReader.Element data;
                block16: {
                    data = element.getChildByName("data");
                    encoding = data.getAttribute("encoding", null);
                    if (encoding == null) {
                        throw new ArcRuntimeException("Unsupported encoding (XML) for TMX Layer Data");
                    }
                    ids = new int[width * height];
                    if (!encoding.equals("csv")) break block16;
                    String[] array = data.getText().split(",");
                    for (int i = 0; i < array.length; ++i) {
                        ids[i] = (int)Long.parseLong(array[i].trim());
                    }
                    break block17;
                }
                if (!encoding.equals("base64")) break block18;
                InputStream is = null;
                try {
                    String compression = data.getAttribute("compression", null);
                    byte[] bytes = Base64Coder.decode(data.getText());
                    if (compression == null) {
                        is = new ByteArrayInputStream(bytes);
                    } else if (compression.equals("gzip")) {
                        is = new BufferedInputStream(new GZIPInputStream((InputStream)new ByteArrayInputStream(bytes), bytes.length));
                    } else if (compression.equals("zlib")) {
                        is = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(bytes)));
                    } else {
                        throw new ArcRuntimeException("Unrecognised compression (" + compression + ") for TMX Layer Data");
                    }
                    byte[] temp = new byte[4];
                    for (int y = 0; y < height; ++y) {
                        for (int x = 0; x < width; ++x) {
                            int read;
                            int curr;
                            for (read = is.read(temp); read < temp.length && (curr = is.read(temp, read, temp.length - read)) != -1; read += curr) {
                            }
                            if (read != temp.length) {
                                throw new ArcRuntimeException("Error Reading TMX Layer Data: Premature end of tile data");
                            }
                            ids[y * width + x] = BaseTmxMapLoader.unsignedByteToInt(temp[0]) | BaseTmxMapLoader.unsignedByteToInt(temp[1]) << 8 | BaseTmxMapLoader.unsignedByteToInt(temp[2]) << 16 | BaseTmxMapLoader.unsignedByteToInt(temp[3]) << 24;
                        }
                    }
                }
                catch (IOException e) {
                    try {
                        throw new ArcRuntimeException("Error Reading TMX Layer Data - IOException: " + e.getMessage());
                    }
                    catch (Throwable throwable) {
                        Streams.closeQuietly(is);
                        throw throwable;
                    }
                }
                Streams.closeQuietly(is);
                break block17;
            }
            throw new ArcRuntimeException("Unrecognised encoding (" + encoding + ") for TMX Layer Data");
        }
        return ids;
    }

    protected static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    protected static FileHandle getRelativeFileHandle(FileHandle file, String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, "\\/");
        FileHandle result = file.parent();
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            if (token.equals("..")) {
                result = result.parent();
                continue;
            }
            result = result.child(token);
        }
        return result;
    }

    protected void loadTileGroup(TiledMap map, Array<MapLayer> parentLayers, XmlReader.Element element, FileHandle tmxFile, ImageResolver imageResolver) {
        if (element.getName().equals("group")) {
            MapGroupLayer groupLayer = new MapGroupLayer();
            this.loadBasicLayerInfo(groupLayer, element);
            XmlReader.Element properties = element.getChildByName("properties");
            if (properties != null) {
                this.loadProperties(groupLayer.properties, properties);
            }
            int j = element.getChildCount();
            for (int i = 0; i < j; ++i) {
                XmlReader.Element child = element.getChild(i);
                this.loadLayer(map, groupLayer.layers, child, tmxFile, imageResolver);
            }
            for (MapLayer layer : groupLayer.layers) {
                layer.setParent(groupLayer);
            }
            parentLayers.add(groupLayer);
        }
    }

    protected void loadLayer(TiledMap map, Array<MapLayer> parentLayers, XmlReader.Element element, FileHandle tmxFile, ImageResolver imageResolver) {
        String name = element.getName();
        if (name.equals("group")) {
            this.loadTileGroup(map, parentLayers, element, tmxFile, imageResolver);
        } else if (name.equals("layer")) {
            this.loadTileLayer(map, parentLayers, element);
        } else if (name.equals("objectgroup")) {
            this.loadObjectGroup(map, parentLayers, element);
        } else if (name.equals("imagelayer")) {
            this.loadImageLayer(map, parentLayers, element, tmxFile, imageResolver);
        }
    }

    protected void loadTileLayer(TiledMap map, Array<MapLayer> parentLayers, XmlReader.Element element) {
        if (element.getName().equals("layer")) {
            int width = element.getIntAttribute("width", 0);
            int height = element.getIntAttribute("height", 0);
            int tileWidth = (Integer)map.properties.get("tilewidth");
            int tileHeight = (Integer)map.properties.get("tileheight");
            TileLayer layer = new TileLayer(width, height, tileWidth, tileHeight);
            this.loadBasicLayerInfo(layer, element);
            int[] ids = BaseTmxMapLoader.getTileIds(element, width, height);
            TileSets tilesets = map.tilesets;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int id = ids[y * width + x];
                    boolean flipHorizontally = (id & Integer.MIN_VALUE) != 0;
                    boolean flipVertically = (id & 0x40000000) != 0;
                    boolean flipDiagonally = (id & 0x20000000) != 0;
                    MapTile tile = tilesets.getTile(id & 0x1FFFFFFF);
                    if (tile == null) continue;
                    TileLayer.Cell cell = this.createTileLayerCell(flipHorizontally, flipVertically, flipDiagonally);
                    cell.tile = tile;
                    layer.setCell(x, this.flipY ? height - 1 - y : y, cell);
                }
            }
            XmlReader.Element properties = element.getChildByName("properties");
            if (properties != null) {
                this.loadProperties(layer.properties, properties);
            }
            parentLayers.add(layer);
        }
    }

    protected void loadObjectGroup(TiledMap map, Array<MapLayer> parentLayers, XmlReader.Element element) {
        if (element.getName().equals("objectgroup")) {
            MapLayer layer = new MapLayer();
            this.loadBasicLayerInfo(layer, element);
            XmlReader.Element properties = element.getChildByName("properties");
            if (properties != null) {
                this.loadProperties(layer.properties, properties);
            }
            for (XmlReader.Element objectElement : element.getChildrenByName("object")) {
                this.loadObject(map, layer, objectElement);
            }
            parentLayers.add(layer);
        }
    }

    protected void loadImageLayer(TiledMap map, Array<MapLayer> parentLayers, XmlReader.Element element, FileHandle tmxFile, ImageResolver imageResolver) {
        if (element.getName().equals("imagelayer")) {
            int x = 0;
            int y = 0;
            x = element.hasAttribute("offsetx") ? Integer.parseInt(element.getAttribute("offsetx", "0")) : Integer.parseInt(element.getAttribute("x", "0"));
            y = element.hasAttribute("offsety") ? Integer.parseInt(element.getAttribute("offsety", "0")) : Integer.parseInt(element.getAttribute("y", "0"));
            if (this.flipY) {
                y = this.mapHeightInPixels - y;
            }
            TextureRegion texture = null;
            XmlReader.Element image = element.getChildByName("image");
            if (image != null) {
                String source = image.getAttribute("source");
                FileHandle handle = BaseTmxMapLoader.getRelativeFileHandle(tmxFile, source);
                texture = imageResolver.getImage(handle.path());
                y -= texture.getHeight();
            }
            ImageLayer layer = new ImageLayer(texture, x, y);
            this.loadBasicLayerInfo(layer, element);
            XmlReader.Element properties = element.getChildByName("properties");
            if (properties != null) {
                this.loadProperties(layer.properties, properties);
            }
            parentLayers.add(layer);
        }
    }

    protected void loadBasicLayerInfo(MapLayer layer, XmlReader.Element element) {
        String name = element.getAttribute("name", null);
        float opacity = Float.parseFloat(element.getAttribute("opacity", "1.0"));
        boolean visible = element.getIntAttribute("visible", 1) == 1;
        float offsetX = element.getFloatAttribute("offsetx", 0.0f);
        float offsetY = element.getFloatAttribute("offsety", 0.0f);
        layer.name = name;
        layer.opacity = opacity;
        layer.visible = visible;
        layer.setOffsetX(offsetX);
        layer.setOffsetY(offsetY);
    }

    protected void loadObject(TiledMap map, MapLayer layer, XmlReader.Element element) {
        this.loadObject(map, layer.objects, element, this.mapHeightInPixels);
    }

    protected void loadObject(TiledMap map, MapTile tile, XmlReader.Element element) {
        this.loadObject(map, tile.getObjects(), element, tile.region.getHeight());
    }

    protected void loadObject(TiledMap map, Array<MapObject> objects, XmlReader.Element element, float heightInPixels) {
        if (element.getName().equals("object")) {
            int id;
            String type;
            MapObject object = null;
            float scaleX = this.convertObjectToTileSpace ? 1.0f / (float)this.mapTileWidth : 1.0f;
            float scaleY = this.convertObjectToTileSpace ? 1.0f / (float)this.mapTileHeight : 1.0f;
            float x = element.getFloatAttribute("x", 0.0f) * scaleX;
            float y = (this.flipY ? heightInPixels - element.getFloatAttribute("y", 0.0f) : element.getFloatAttribute("y", 0.0f)) * scaleY;
            float width = element.getFloatAttribute("width", 0.0f) * scaleX;
            float height = element.getFloatAttribute("height", 0.0f) * scaleY;
            if (element.getChildCount() > 0) {
                String[] point;
                float[] vertices;
                String[] points;
                XmlReader.Element child = null;
                child = element.getChildByName("polygon");
                if (child != null) {
                    points = child.getAttribute("points").split(" ");
                    vertices = new float[points.length * 2];
                    for (int i = 0; i < points.length; ++i) {
                        point = points[i].split(",");
                        vertices[i * 2] = Float.parseFloat(point[0]) * scaleX;
                        vertices[i * 2 + 1] = Float.parseFloat(point[1]) * scaleY * (float)(this.flipY ? -1 : 1);
                    }
                    Polygon polygon = new Polygon(vertices);
                    polygon.setPosition(x, y);
                    object = new PolygonMapObject(polygon);
                } else {
                    child = element.getChildByName("polyline");
                    if (child != null) {
                        points = child.getAttribute("points").split(" ");
                        vertices = new float[points.length * 2];
                        for (int i = 0; i < points.length; ++i) {
                            point = points[i].split(",");
                            vertices[i * 2] = Float.parseFloat(point[0]) * scaleX;
                            vertices[i * 2 + 1] = Float.parseFloat(point[1]) * scaleY * (float)(this.flipY ? -1 : 1);
                        }
                        Polyline polyline = new Polyline(vertices);
                        polyline.setPosition(x, y);
                        object = new PolylineMapObject(polyline);
                    } else {
                        child = element.getChildByName("ellipse");
                        if (child != null) {
                            object = new EllipseMapObject(x, this.flipY ? y - height : y, width, height);
                        }
                    }
                }
            }
            if (object == null) {
                String gid = null;
                gid = element.getAttribute("gid", null);
                if (gid != null) {
                    float y1;
                    int id2 = (int)Long.parseLong(gid);
                    boolean flipHorizontally = (id2 & Integer.MIN_VALUE) != 0;
                    boolean flipVertically = (id2 & 0x40000000) != 0;
                    MapTile tile = map.tilesets.getTile(id2 & 0x1FFFFFFF);
                    TileMapObject tileMapObject = new TileMapObject(tile, flipHorizontally, flipVertically);
                    TextureRegion textureRegion = tileMapObject.textureRegion;
                    tileMapObject.properties.put("gid", id2);
                    tileMapObject.x = x;
                    tileMapObject.y = y1 = this.flipY ? y : y - height;
                    float objectWidth = element.getFloatAttribute("width", textureRegion.getWidth());
                    float objectHeight = element.getFloatAttribute("height", textureRegion.getHeight());
                    tileMapObject.scaleX = scaleX * (objectWidth / (float)textureRegion.getWidth());
                    tileMapObject.scaleY = scaleY * (objectHeight / (float)textureRegion.getHeight());
                    tileMapObject.rotation = element.getFloatAttribute("rotation", 0.0f);
                    object = tileMapObject;
                } else {
                    object = new RectangleMapObject(x, this.flipY ? y - height : y, width, height);
                }
            }
            object.name = element.getAttribute("name", null);
            String rotation = element.getAttribute("rotation", null);
            if (rotation != null) {
                object.properties.put("rotation", Float.valueOf(Float.parseFloat(rotation)));
            }
            if ((type = element.getAttribute("type", null)) != null) {
                object.properties.put("type", type);
            }
            if ((id = element.getIntAttribute("id", 0)) != 0) {
                object.properties.put("id", id);
            }
            object.properties.put("x", Float.valueOf(x));
            if (object instanceof TileMapObject) {
                object.properties.put("y", Float.valueOf(y));
            } else {
                object.properties.put("y", Float.valueOf(this.flipY ? y - height : y));
            }
            object.properties.put("width", Float.valueOf(width));
            object.properties.put("height", Float.valueOf(height));
            object.visible = element.getIntAttribute("visible", 1) == 1;
            XmlReader.Element properties = element.getChildByName("properties");
            if (properties != null) {
                this.loadProperties(object.properties, properties);
            }
            objects.add(object);
        }
    }

    protected void loadProperties(MapProperties properties, XmlReader.Element element) {
        if (element == null) {
            return;
        }
        if (element.getName().equals("properties")) {
            for (XmlReader.Element property : element.getChildrenByName("property")) {
                String name = property.getAttribute("name", null);
                String value = property.getAttribute("value", null);
                String type = property.getAttribute("type", null);
                if (value == null) {
                    value = property.getText();
                }
                Object castValue = this.castProperty(name, value, type);
                properties.put(name, castValue);
            }
        }
    }

    private Object castProperty(String name, String value, String type) {
        if (type == null) {
            return value;
        }
        if (type.equals("int")) {
            return Integer.valueOf(value);
        }
        if (type.equals("float")) {
            return Float.valueOf(value);
        }
        if (type.equals("bool")) {
            return Boolean.valueOf(value);
        }
        if (type.equals("color")) {
            String opaqueColor = value.substring(3);
            String alpha = value.substring(1, 3);
            return Color.valueOf(opaqueColor + alpha);
        }
        throw new ArcRuntimeException("Wrong type given for property " + name + ", given : " + type + ", supported : string, bool, int, float, color");
    }

    protected TileLayer.Cell createTileLayerCell(boolean flipHorizontally, boolean flipVertically, boolean flipDiagonally) {
        TileLayer.Cell cell = new TileLayer.Cell();
        if (flipDiagonally) {
            if (flipHorizontally && flipVertically) {
                cell.flipHorizontally = true;
                cell.rotation = 3;
            } else if (flipHorizontally) {
                cell.rotation = 3;
            } else if (flipVertically) {
                cell.rotation = 1;
            } else {
                cell.flipVertically = true;
                cell.rotation = 3;
            }
        } else {
            cell.rotation = flipVertically ? 2 : 0;
            cell.flipHorizontally = flipHorizontally;
            cell.flipVertically = flipVertically;
        }
        return cell;
    }

    public static class Parameters
    extends AssetLoaderParameters<TiledMap> {
        public boolean generateMipMaps = false;
        public Texture.TextureFilter textureMinFilter = Texture.TextureFilter.Nearest;
        public Texture.TextureFilter textureMagFilter = Texture.TextureFilter.Nearest;
        public boolean convertObjectToTileSpace = false;
        public boolean flipY = true;
    }
}

