/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.maps;

import io.anuke.arc.maps.MapLayer;
import io.anuke.arc.maps.MapTile;

public class TileLayer
extends MapLayer {
    public final int width;
    public final int height;
    public final float tileWidth;
    public final float tileHeight;
    private Cell[][] cells;

    public TileLayer(int width, int height, int tileWidth, int tileHeight) {
        this.width = width;
        this.height = height;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.cells = new Cell[width][height];
    }

    public Cell getCell(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return null;
        }
        return this.cells[x][y];
    }

    public void setCell(int x, int y, Cell cell) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return;
        }
        this.cells[x][y] = cell;
    }

    public MapTile getTile(int x, int y) {
        return this.getCell(x, y) == null ? null : this.getCell((int)x, (int)y).tile;
    }

    public static class Cell {
        public static final int ROTATE_0 = 0;
        public static final int ROTATE_90 = 1;
        public static final int ROTATE_180 = 2;
        public static final int ROTATE_270 = 3;
        public MapTile tile;
        public boolean flipHorizontally;
        public boolean flipVertically;
        public int rotation;
    }
}

