/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.graphics.profiling;

import io.anuke.arc.graphics.profiling.GLInterceptor;
import io.anuke.arc.util.ArcRuntimeException;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.Strings;

public interface GLErrorListener {
    public static final GLErrorListener LOGGING_LISTENER = error -> {
        String place = null;
        try {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            for (int i = 0; i < stack.length; ++i) {
                if (!"check".equals(stack[i].getMethodName())) continue;
                if (i + 1 < stack.length) {
                    StackTraceElement glMethod = stack[i + 1];
                    place = glMethod.getMethodName();
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (place != null) {
            Log.err("[GLProfiler] Error {0} from {1}", GLInterceptor.resolveErrorNumber(error), place);
            throw new RuntimeException(Strings.format("[GLProfiler] Error {0} from {1}", GLInterceptor.resolveErrorNumber(error), place));
        }
        Log.err("[GLProfiler] Error {0} at: {1}", GLInterceptor.resolveErrorNumber(error), new Exception());
        throw new RuntimeException(Strings.format("[GLProfiler] Error {0}", GLInterceptor.resolveErrorNumber(error)));
    };
    public static final GLErrorListener THROWING_LISTENER = error -> {
        throw new ArcRuntimeException("GLProfiler: Got GL error " + GLInterceptor.resolveErrorNumber(error));
    };

    public void onError(int var1);
}

