/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.graphics.g2d;

import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.g2d.TextureAtlas;

public class TextureRegion {
    Texture texture;
    float u;
    float v;
    float u2;
    float v2;
    int width;
    int height;

    public TextureRegion() {
    }

    public TextureRegion(Texture texture) {
        if (texture == null) {
            throw new IllegalArgumentException("texture cannot be null.");
        }
        this.texture = texture;
        this.set(0, 0, texture.getWidth(), texture.getHeight());
    }

    public TextureRegion(Texture texture, int width, int height) {
        this.texture = texture;
        this.set(0, 0, width, height);
    }

    public TextureRegion(Texture texture, int x, int y, int width, int height) {
        this.texture = texture;
        this.set(x, y, width, height);
    }

    public TextureRegion(Texture texture, float u, float v, float u2, float v2) {
        this.texture = texture;
        this.set(u, v, u2, v2);
    }

    public TextureRegion(TextureRegion region) {
        this.set(region);
    }

    public TextureRegion(TextureRegion region, int x, int y, int width, int height) {
        this.set(region, x, y, width, height);
    }

    public static TextureRegion[][] split(Texture texture, int tileWidth, int tileHeight) {
        TextureRegion region = new TextureRegion(texture);
        return region.split(tileWidth, tileHeight);
    }

    public TextureAtlas.AtlasRegion asAtlas() {
        return (TextureAtlas.AtlasRegion)this;
    }

    public void set(Texture texture) {
        this.texture = texture;
        this.set(0, 0, texture.getWidth(), texture.getHeight());
    }

    public void set(int x, int y, int width, int height) {
        float invTexWidth = 1.0f / (float)this.texture.getWidth();
        float invTexHeight = 1.0f / (float)this.texture.getHeight();
        this.set((float)x * invTexWidth, (float)y * invTexHeight, (float)(x + width) * invTexWidth, (float)(y + height) * invTexHeight);
        this.width = Math.abs(width);
        this.height = Math.abs(height);
    }

    public void set(float u, float v, float u2, float v2) {
        int texWidth = this.texture.getWidth();
        int texHeight = this.texture.getHeight();
        this.width = Math.round(Math.abs(u2 - u) * (float)texWidth);
        this.height = Math.round(Math.abs(v2 - v) * (float)texHeight);
        if (this.width == 1 && this.height == 1) {
            float adjustX = 0.25f / (float)texWidth;
            u += adjustX;
            u2 -= adjustX;
            float adjustY = 0.25f / (float)texHeight;
            v += adjustY;
            v2 -= adjustY;
        }
        this.u = u;
        this.v = v;
        this.u2 = u2;
        this.v2 = v2;
    }

    public void set(TextureRegion region) {
        this.texture = region.texture;
        this.set(region.u, region.v, region.u2, region.v2);
    }

    public void set(TextureRegion region, int x, int y, int width, int height) {
        this.texture = region.texture;
        this.set(region.getX() + x, region.getY() + y, width, height);
    }

    public void set(Texture texture, int x, int y, int width, int height) {
        this.texture = texture;
        this.set(x, y, width, height);
    }

    public Texture getTexture() {
        return this.texture;
    }

    public void setTexture(Texture texture) {
        this.texture = texture;
    }

    public float getU() {
        return this.u;
    }

    public void setU(float u) {
        this.u = u;
        this.width = Math.round(Math.abs(this.u2 - u) * (float)this.texture.getWidth());
    }

    public float getV() {
        return this.v;
    }

    public void setV(float v) {
        this.v = v;
        this.height = Math.round(Math.abs(this.v2 - v) * (float)this.texture.getHeight());
    }

    public float getU2() {
        return this.u2;
    }

    public void setU2(float u2) {
        this.u2 = u2;
        this.width = Math.round(Math.abs(u2 - this.u) * (float)this.texture.getWidth());
    }

    public float getV2() {
        return this.v2;
    }

    public void setV2(float v2) {
        this.v2 = v2;
        this.height = Math.round(Math.abs(v2 - this.v) * (float)this.texture.getHeight());
    }

    public int getX() {
        return Math.round(this.u * (float)this.texture.getWidth());
    }

    public void setX(int x) {
        this.setU((float)x / (float)this.texture.getWidth());
    }

    public int getY() {
        return Math.round(this.v * (float)this.texture.getHeight());
    }

    public void setY(int y) {
        this.setV((float)y / (float)this.texture.getHeight());
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        if (this.isFlipX()) {
            this.setU(this.u2 + (float)width / (float)this.texture.getWidth());
        } else {
            this.setU2(this.u + (float)width / (float)this.texture.getWidth());
        }
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        if (this.isFlipY()) {
            this.setV(this.v2 + (float)height / (float)this.texture.getHeight());
        } else {
            this.setV2(this.v + (float)height / (float)this.texture.getHeight());
        }
    }

    public void flip(boolean x, boolean y) {
        float temp;
        if (x) {
            temp = this.u;
            this.u = this.u2;
            this.u2 = temp;
        }
        if (y) {
            temp = this.v;
            this.v = this.v2;
            this.v2 = temp;
        }
    }

    public boolean isFlipX() {
        return this.u > this.u2;
    }

    public boolean isFlipY() {
        return this.v > this.v2;
    }

    public void scroll(float xAmount, float yAmount) {
        if (xAmount != 0.0f) {
            float width = (this.u2 - this.u) * (float)this.texture.getWidth();
            this.u = (this.u + xAmount) % 1.0f;
            this.u2 = this.u + width / (float)this.texture.getWidth();
        }
        if (yAmount != 0.0f) {
            float height = (this.v2 - this.v) * (float)this.texture.getHeight();
            this.v = (this.v + yAmount) % 1.0f;
            this.v2 = this.v + height / (float)this.texture.getHeight();
        }
    }

    public TextureRegion[][] split(int tileWidth, int tileHeight) {
        if (this.texture == null) {
            return null;
        }
        int x = this.getX();
        int y = this.getY();
        int width = this.width;
        int height = this.height;
        int sw = width / tileWidth;
        int sh = height / tileHeight;
        int startX = x;
        TextureRegion[][] tiles = new TextureRegion[sw][sh];
        int cy = 0;
        while (cy < sh) {
            x = startX;
            int cx = 0;
            while (cx < sw) {
                tiles[cx][cy] = new TextureRegion(this.texture, x, y, tileWidth, tileHeight);
                ++cx;
                x += tileWidth;
            }
            ++cy;
            y += tileHeight;
        }
        return tiles;
    }
}

