/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.graphics.g2d;

import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Pixmap;
import io.anuke.arc.graphics.Pixmaps;
import io.anuke.arc.util.ArcAnnotate;

public class PixmapRegion {
    @ArcAnnotate.NonNull
    public Pixmap pixmap;
    public int x;
    public int y;
    public int width;
    public int height;

    public PixmapRegion(Pixmap pixmap, int x, int y, int width, int height) {
        this.set(pixmap, x, y, width, height);
    }

    public PixmapRegion(Pixmap pixmap) {
        this.set(pixmap);
    }

    public int getPixel(int x, int y) {
        return this.pixmap.getPixel(this.x + x, this.y + y);
    }

    public int getPixel(int x, int y, Color color) {
        int c = this.getPixel(x, y);
        color.set(c);
        return c;
    }

    public PixmapRegion set(Pixmap pixmap) {
        return this.set(pixmap, 0, 0, pixmap.getWidth(), pixmap.getHeight());
    }

    public PixmapRegion set(Pixmap pixmap, int x, int y, int width, int height) {
        this.pixmap = pixmap;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        return this;
    }

    public Pixmap crop() {
        return Pixmaps.crop(this.pixmap, this.x, this.y, this.width, this.height);
    }
}

