/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.graphics.g2d;

import io.anuke.arc.Core;
import io.anuke.arc.collection.FloatArray;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.CapStyle;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Fill;
import io.anuke.arc.graphics.g2d.TextureAtlas;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.math.geom.Vector2;

public class Lines {
    private static float stroke = 1.0f;
    private static Vector2 vector = new Vector2();
    private static FloatArray floats = new FloatArray(20);
    private static FloatArray floatBuilder = new FloatArray(20);
    private static boolean building;
    private static boolean precise;
    private static float circlePrecision;

    public static void setCirclePrecision(float amount) {
        circlePrecision = amount;
    }

    public static int circleVertices(float rad) {
        return 11 + (int)(rad * circlePrecision);
    }

    public static void lineAngle(float x, float y, float angle, float length, CapStyle style) {
        vector.set(1.0f, 1.0f).setLength(length).setAngle(angle);
        Lines.line(x, y, x + Lines.vector.x, y + Lines.vector.y, style);
    }

    public static void lineAngle(float x, float y, float angle, float length) {
        vector.set(1.0f, 1.0f).setLength(length).setAngle(angle);
        Lines.line(x, y, x + Lines.vector.x, y + Lines.vector.y);
    }

    public static void lineAngle(float x, float y, float offset, float angle, float length) {
        vector.set(1.0f, 1.0f).setLength(length + offset).setAngle(angle);
        Lines.line(x, y, x + Lines.vector.x, y + Lines.vector.y);
    }

    public static void lineAngleCenter(float x, float y, float angle, float length) {
        vector.set(1.0f, 1.0f).setLength(length).setAngle(angle);
        Lines.line(x - Lines.vector.x / 2.0f, y - Lines.vector.y / 2.0f, x + Lines.vector.x / 2.0f, y + Lines.vector.y / 2.0f);
    }

    public static void line(float x, float y, float x2, float y2) {
        Lines.line(x, y, x2, y2, CapStyle.square, 0.0f);
    }

    public static void line(float x, float y, float x2, float y2, CapStyle cap) {
        Lines.line(x, y, x2, y2, cap, 0.0f);
    }

    public static void line(float x, float y, float x2, float y2, CapStyle cap, float padding) {
        Lines.line(Core.atlas.white(), x, y, x2, y2, cap, padding);
    }

    public static void line(TextureRegion region, float x, float y, float x2, float y2, CapStyle cap, float padding) {
        float length = Mathf.dst(x, y, x2, y2) + (cap == CapStyle.none || cap == CapStyle.round ? padding * 2.0f : stroke + padding * 2.0f);
        float angle = (precise ? (float)Math.atan2(y2 - y, x2 - x) : Mathf.atan2(x2 - x, y2 - y)) * 57.295776f;
        if (cap == CapStyle.square) {
            Draw.rect(region, x - stroke / 2.0f - padding + length / 2.0f, y, length, stroke, stroke / 2.0f + padding, stroke / 2.0f, angle);
        } else if (cap == CapStyle.none) {
            Draw.rect(region, x - padding + length / 2.0f, y, length, stroke, padding, stroke / 2.0f, angle);
        } else if (cap == CapStyle.round) {
            TextureAtlas.AtlasRegion cir = Core.atlas.has("hcircle") ? Core.atlas.find("hcircle") : Core.atlas.find("circle");
            Draw.rect(region, x - padding + length / 2.0f, y, length, stroke, padding, stroke / 2.0f, angle);
            Draw.rect(cir, x, y, stroke, stroke, angle + 180.0f);
            Draw.rect(cir, x2, y2, stroke, stroke, angle);
        }
    }

    public static void precise(boolean precise) {
        Lines.precise = precise;
    }

    public static void linePoint(float x, float y) {
        if (!building) {
            throw new IllegalStateException("Not building");
        }
        floatBuilder.add(x, y);
    }

    public static void beginLine() {
        if (building) {
            throw new IllegalStateException("Already building");
        }
        floatBuilder.clear();
        building = true;
    }

    public static void endLine() {
        if (!building) {
            throw new IllegalStateException("Not building");
        }
        Lines.polyline(floatBuilder, false);
        building = false;
    }

    public static void polyline(FloatArray points, boolean wrap) {
        Lines.polyline(points.items, points.size, wrap);
    }

    public static void polyline(float[] points, int length, boolean wrap) {
        if (length < 4) {
            return;
        }
        float x1 = points[length - 2];
        float y1 = points[length - 1];
        float x2 = points[0];
        float y2 = points[1];
        float x3 = points[2];
        float y3 = points[3];
        float lasta = wrap ? Mathf.slerp(Angles.angle(x1, y1, x2, y2), Angles.angle(x2, y2, x3, y3), 0.5f) : Angles.angle(x1, y1, x2, y2) + 180.0f;
        for (int i = 0; i < (wrap ? length : length - 2); i += 2) {
            float avg;
            float x12 = points[i];
            float y12 = points[i + 1];
            float x22 = points[(i + 2) % length];
            float y22 = points[(i + 3) % length];
            float ang1 = Angles.angle(x12, y12, x22, y22);
            if (wrap) {
                float x32 = points[(i + 4) % length];
                float y32 = points[(i + 5) % length];
                float ang2 = Angles.angle(x22, y22, x32, y32);
                avg = Mathf.slerp(ang1, ang2, 0.5f);
            } else {
                avg = ang1;
            }
            float s = stroke / 2.0f;
            float cos1 = Mathf.cosDeg(lasta - 90.0f) * s;
            float sin1 = Mathf.sinDeg(lasta - 90.0f) * s;
            float cos2 = Mathf.cosDeg(avg - 90.0f) * s;
            float sin2 = Mathf.sinDeg(avg - 90.0f) * s;
            float qx1 = x12 + cos1;
            float qy1 = y12 + sin1;
            float qx4 = x12 - cos1;
            float qy4 = y12 - sin1;
            float qx2 = x22 + cos2;
            float qy2 = y22 + sin2;
            float qx3 = x22 - cos2;
            float qy3 = y22 - sin2;
            Fill.quad(qx1, qy1, qx2, qy2, qx3, qy3, qx4, qy4);
            lasta = avg;
        }
    }

    public static void dashLine(float x1, float y1, float x2, float y2, int divisions) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        for (int i = 0; i < divisions; ++i) {
            if (i % 2 != 0) continue;
            Lines.line(x1 + (float)i / (float)divisions * dx, y1 + (float)i / (float)divisions * dy, x1 + ((float)i + 1.0f) / (float)divisions * dx, y1 + ((float)i + 1.0f) / (float)divisions * dy);
        }
    }

    public static void circle(float x, float y, float rad) {
        Lines.poly(x, y, Lines.circleVertices(rad), rad);
    }

    public static void dashCircle(float x, float y, float radius) {
        float scaleFactor = 0.6f;
        int sides = 10 + (int)(radius * scaleFactor);
        if (sides % 2 == 1) {
            ++sides;
        }
        vector.set(0.0f, 0.0f);
        for (int i = 0; i < sides; ++i) {
            if (i % 2 == 0) continue;
            vector.set(radius, 0.0f).setAngle(360.0f / (float)sides * (float)i + 90.0f);
            float x1 = Lines.vector.x;
            float y1 = Lines.vector.y;
            vector.set(radius, 0.0f).setAngle(360.0f / (float)sides * (float)(i + 1) + 90.0f);
            Lines.line(x1 + x, y1 + y, Lines.vector.x + x, Lines.vector.y + y);
        }
    }

    public static void spikes(float x, float y, float radius, float length, int spikes, float rot) {
        vector.set(0.0f, 1.0f);
        float step = 360.0f / (float)spikes;
        for (int i = 0; i < spikes; ++i) {
            vector.setAngle((float)i * step + rot);
            vector.setLength(radius);
            float x1 = Lines.vector.x;
            float y1 = Lines.vector.y;
            vector.setLength(radius + length);
            Lines.line(x + x1, y + y1, x + Lines.vector.x, y + Lines.vector.y);
        }
    }

    public static void spikes(float x, float y, float rad, float length, int spikes) {
        Lines.spikes(x, y, rad, length, spikes, 0.0f);
    }

    public static void poly(float x, float y, int sides, float radius, float angle) {
        vector.set(0.0f, 0.0f);
        for (int i = 0; i < sides; ++i) {
            vector.set(radius, 0.0f).setAngle(360.0f / (float)sides * (float)i + angle + 90.0f);
            float x1 = Lines.vector.x;
            float y1 = Lines.vector.y;
            vector.set(radius, 0.0f).setAngle(360.0f / (float)sides * (float)(i + 1) + angle + 90.0f);
            Lines.line(x1 + x, y1 + y, Lines.vector.x + x, Lines.vector.y + y);
        }
    }

    public static void poly2(float x, float y, int sides, float radius, float angle) {
        vector.set(0.0f, 0.0f);
        Lines.beginLine();
        for (int i = 0; i < sides; ++i) {
            vector.set(radius, 0.0f).setAngle(360.0f / (float)sides * (float)i + angle + 90.0f);
            Lines.linePoint(Lines.vector.x + x, Lines.vector.y + y);
        }
        Lines.endLine();
    }

    public static void polySeg(int sides, int from, int to, float x, float y, float radius, float angle) {
        vector.set(0.0f, 0.0f);
        for (int i = from; i < to; ++i) {
            vector.set(radius, 0.0f).setAngle(360.0f / (float)sides * (float)i + angle + 90.0f);
            float x1 = Lines.vector.x;
            float y1 = Lines.vector.y;
            vector.set(radius, 0.0f).setAngle(360.0f / (float)sides * (float)(i + 1) + angle + 90.0f);
            Lines.line(x1 + x, y1 + y, Lines.vector.x + x, Lines.vector.y + y);
        }
    }

    public static void curve(float x1, float y1, float cx1, float cy1, float cx2, float cy2, float x2, float y2, int segments) {
        float subdiv_step = 1.0f / (float)segments;
        float subdiv_step2 = subdiv_step * subdiv_step;
        float subdiv_step3 = subdiv_step * subdiv_step * subdiv_step;
        float pre1 = 3.0f * subdiv_step;
        float pre2 = 3.0f * subdiv_step2;
        float pre4 = 6.0f * subdiv_step2;
        float pre5 = 6.0f * subdiv_step3;
        float tmp1x = x1 - cx1 * 2.0f + cx2;
        float tmp1y = y1 - cy1 * 2.0f + cy2;
        float tmp2x = (cx1 - cx2) * 3.0f - x1 + x2;
        float tmp2y = (cy1 - cy2) * 3.0f - y1 + y2;
        float fx = x1;
        float fy = y1;
        float dfx = (cx1 - x1) * pre1 + tmp1x * pre2 + tmp2x * subdiv_step3;
        float dfy = (cy1 - y1) * pre1 + tmp1y * pre2 + tmp2y * subdiv_step3;
        float ddfx = tmp1x * pre4 + tmp2x * pre5;
        float ddfy = tmp1y * pre4 + tmp2y * pre5;
        float dddfx = tmp2x * pre5;
        float dddfy = tmp2y * pre5;
        while (segments-- > 0) {
            float fxold = fx;
            float fyold = fy;
            dfx += ddfx;
            ddfx += dddfx;
            ddfy += dddfy;
            Lines.line(fxold, fyold, fx += dfx, fy += (dfy += ddfy));
        }
        Lines.line(fx, fy, x2, y2);
    }

    public static void swirl(float x, float y, float radius, float finion) {
        Lines.swirl(x, y, radius, finion, 0.0f);
    }

    public static void swirl(float x, float y, float radius, float finion, float angle) {
        int sides = 50;
        int max = (int)((float)sides * (finion + 0.001f));
        vector.set(0.0f, 0.0f);
        floats.clear();
        for (int i = 0; i < max; ++i) {
            vector.set(radius, 0.0f).setAngle(360.0f / (float)sides * (float)i + angle);
            float x1 = Lines.vector.x;
            float y1 = Lines.vector.y;
            vector.set(radius, 0.0f).setAngle(360.0f / (float)sides * (float)(i + 1) + angle);
            floats.add(x1 + x, y1 + y);
        }
        Lines.polyline(floats, false);
    }

    public static void poly(float x, float y, int sides, float radius) {
        floats.clear();
        for (int i = 0; i < sides; ++i) {
            float rad = (float)i / (float)sides * ((float)Math.PI * 2);
            floats.add(Mathf.cos(rad) * radius + x, Mathf.sin(rad) * radius + y);
        }
        Lines.polyline(floats, true);
    }

    public static void poly(Vector2[] vertices, float offsetx, float offsety, float scl) {
        for (int i = 0; i < vertices.length; ++i) {
            Vector2 current = vertices[i];
            Vector2 next = i == vertices.length - 1 ? vertices[0] : vertices[i + 1];
            Lines.line(current.x * scl + offsetx, current.y * scl + offsety, next.x * scl + offsetx, next.y * scl + offsety);
        }
    }

    public static void square(float x, float y, float rad) {
        Lines.rect(x - rad, y - rad, rad * 2.0f, rad * 2.0f);
    }

    public static void square(float x, float y, float rad, float rot) {
        Lines.poly(x, y, 4, rad, rot - 45.0f);
    }

    public static void rect(float x, float y, float width, float height, float xspace, float yspace) {
        Fill.crect(x -= xspace, y -= yspace, width += xspace * 2.0f, stroke);
        Fill.crect(x, y + (height += yspace * 2.0f), width, -stroke);
        Fill.crect(x + width, y, -stroke, height);
        Fill.crect(x, y, stroke, height);
    }

    public static void rect(float x, float y, float width, float height) {
        Lines.rect(x, y, width, height, 0);
    }

    public static void rect(Rectangle rect) {
        Lines.rect(rect.x, rect.y, rect.width, rect.height, 0);
    }

    public static void rect(float x, float y, float width, float height, int space) {
        Lines.rect(x, y, width, height, space, space);
    }

    public static void stroke(float thick) {
        stroke = thick;
    }

    public static void stroke(float thick, Color color) {
        stroke = thick;
        Draw.color(color);
    }

    public static float getStroke() {
        return stroke;
    }

    static {
        circlePrecision = 0.38f;
    }
}

