/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.graphics.g2d;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.Blending;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.graphics.glutils.Shader;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.Matrix3;
import io.anuke.arc.util.Tmp;

public class Draw {
    private static Color[] carr = new Color[3];
    public static float scl = 1.0f;

    public static Shader getShader() {
        return Core.batch.getShader();
    }

    public static void shader(Shader shader) {
        Draw.shader(shader, true);
    }

    public static void shader(Shader shader, boolean apply) {
        Core.batch.setShader(shader, apply);
    }

    public static void shader() {
        Core.batch.setShader(null);
    }

    public static Color getColor() {
        return Core.batch.getColor();
    }

    public static Color getMixColor() {
        return Core.batch.getMixColor();
    }

    public static void mixcol(Color color, float a) {
        Core.batch.setMixColor(color.r, color.g, color.b, Mathf.clamp(a));
    }

    public static void mixcol() {
        Core.batch.setPackedMixColor(Color.clearFloatBits);
    }

    public static void tint(Color a, Color b, float s) {
        Tmp.c1.set(a).lerp(b, s);
        Core.batch.setColor(Tmp.c1.r, Tmp.c1.g, Tmp.c1.b, Core.batch.getColor().a);
    }

    public static void tint(Color color) {
        Core.batch.setColor(color.r, color.g, color.b, Core.batch.getColor().a);
    }

    public static void colorMul(Color color, float mul) {
        Draw.color(color.r * mul, color.g * mul, color.b * mul, 1.0f);
    }

    public static void color(Color color) {
        Core.batch.setColor(color);
    }

    public static void color(Color color, float alpha) {
        Core.batch.setColor(color.r, color.g, color.b, alpha);
    }

    public static void color(float color) {
        Core.batch.setPackedColor(color);
    }

    public static void color(Color a, Color b, Color c, float progress) {
        Draw.carr[0] = a;
        Draw.carr[1] = b;
        Draw.carr[2] = c;
        Draw.color(Tmp.c1.lerp(carr, progress));
    }

    public static void color(Color a, Color b, float s) {
        Core.batch.setColor(Tmp.c1.set(a).lerp(b, s));
    }

    public static void color() {
        Core.batch.setPackedColor(Color.whiteFloatBits);
    }

    public static void color(float r, float g, float b) {
        Core.batch.setColor(r, g, b, 1.0f);
    }

    public static void color(float r, float g, float b, float a) {
        Core.batch.setColor(r, g, b, a);
    }

    public static void colorl(float l) {
        Draw.color(l, l, l);
    }

    public static void colorl(float l, float a) {
        Draw.color(l, l, l, a);
    }

    public static void blend(Blending blending) {
        Core.batch.setBlending(blending);
    }

    public static void blend() {
        Draw.blend(Blending.normal);
    }

    public static void reset() {
        Draw.color();
        Draw.mixcol();
        Lines.stroke(1.0f);
    }

    public static void alpha(float alpha) {
        Core.batch.setColor(Core.batch.getColor().r, Core.batch.getColor().g, Core.batch.getColor().b, alpha);
    }

    public static void fbo(Texture texture, int worldWidth, int worldHeight, int tilesize) {
        float ww = worldWidth * tilesize;
        float wh = worldHeight * tilesize;
        float x = Core.camera.position.x + (float)tilesize / 2.0f;
        float y = Core.camera.position.y + (float)tilesize / 2.0f;
        float u = (x - Core.camera.width / 2.0f) / ww;
        float v = (y - Core.camera.height / 2.0f) / wh;
        float u2 = (x + Core.camera.width / 2.0f) / ww;
        float v2 = (y + Core.camera.height / 2.0f) / wh;
        Tmp.tr1.set(texture);
        Tmp.tr1.set(u, v2, u2, v);
        Draw.rect(Tmp.tr1, Core.camera.position.x, Core.camera.position.y, Core.camera.width, Core.camera.height);
    }

    public static void rect(String region, float x, float y, float w, float h) {
        Draw.rect(Core.atlas.find(region), x, y, w, h);
    }

    public static void rect(TextureRegion region, float x, float y, float w, float h) {
        Core.batch.draw(region, x - w / 2.0f, y - h / 2.0f, w, h);
    }

    public static void rect(TextureRegion region, float x, float y) {
        Draw.rect(region, x, y, (float)region.getWidth() * scl, (float)region.getHeight() * scl);
    }

    public static void rect(String region, float x, float y) {
        Draw.rect(Core.atlas.find(region), x, y);
    }

    public static void rect(TextureRegion region, float x, float y, float w, float h, float originX, float originY, float rotation) {
        Core.batch.draw(region, x - w / 2.0f, y - h / 2.0f, originX, originY, w, h, rotation);
    }

    public static void rect(String region, float x, float y, float w, float h, float originX, float originY, float rotation) {
        Core.batch.draw(Core.atlas.find(region), x - w / 2.0f, y - h / 2.0f, originX, originY, w, h, rotation);
    }

    public static void rect(TextureRegion region, float x, float y, float w, float h, float rotation) {
        Draw.rect(region, x, y, w, h, w / 2.0f, h / 2.0f, rotation);
    }

    public static void rect(String region, float x, float y, float w, float h, float rotation) {
        Draw.rect(Core.atlas.find(region), x, y, w, h, w / 2.0f, h / 2.0f, rotation);
    }

    public static void rect(TextureRegion region, float x, float y, float rotation) {
        Draw.rect(region, x, y, (float)region.getWidth() * scl, (float)region.getHeight() * scl, rotation);
    }

    public static void rect(String region, float x, float y, float rotation) {
        Draw.rect(Core.atlas.find(region), x, y, rotation);
    }

    public static void vert(Texture texture, float[] vertices, int offset, int length) {
        Core.batch.draw(texture, vertices, offset, length);
    }

    public static void vert(float[] vertices) {
        Draw.vert(Core.atlas.texture(), vertices, 0, vertices.length);
    }

    public static void flush() {
        Core.batch.flush();
    }

    public static void proj(Matrix3 proj) {
        Core.batch.setProjection(proj);
    }

    public static Matrix3 proj() {
        return Core.batch.getProjection();
    }

    public static void trans(Matrix3 trans) {
        Core.batch.setTransform(trans);
    }

    public static Matrix3 trans() {
        return Core.batch.getTransform();
    }

    public static TextureRegion wrap(Texture texture) {
        Tmp.tr2.set(texture);
        return Tmp.tr2;
    }
}

