/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.graphics.g2d;

import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.g2d.SpriteBatch;
import io.anuke.arc.graphics.g2d.SpriteCache;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.graphics.glutils.Shader;
import io.anuke.arc.math.Matrix3;

public class CacheBatch
extends SpriteBatch {
    SpriteCache cache;
    float[] tmpVertices = new float[20];

    public CacheBatch(int size) {
        this(new SpriteCache(size, false));
    }

    public CacheBatch(SpriteCache cache) {
        super(0);
        this.cache = cache;
    }

    @Override
    public void flush() {
    }

    @Override
    public void setColor(Color tint) {
        this.cache.setColor(tint);
    }

    @Override
    void setColor(float r, float g, float b, float a) {
        this.cache.setColor(r, g, b, a);
    }

    @Override
    public void setPackedColor(float color) {
        this.cache.setPackedColor(color);
    }

    @Override
    public Color getColor() {
        return this.cache.getColor();
    }

    @Override
    public float getPackedColor() {
        return this.cache.getColor().toFloatBits();
    }

    @Override
    public void setProjection(Matrix3 projection) {
        this.cache.setProjectionMatrix(projection);
    }

    public void beginCache() {
        this.cache.beginCache();
    }

    public int endCache() {
        return this.cache.endCache();
    }

    @Override
    protected void draw(Texture texture, float[] spriteVertices, int offset, int count) {
        float[] vertices = count / 6 * 5 == this.tmpVertices.length ? this.tmpVertices : new float[count / 6 * 5];
        for (int i = 0; i < count / 6; ++i) {
            int index = i * 6;
            int dest = i * 5;
            vertices[dest] = spriteVertices[offset + index];
            vertices[dest + 1] = spriteVertices[offset + index + 1];
            vertices[dest + 2] = spriteVertices[offset + index + 2];
            vertices[dest + 3] = spriteVertices[offset + index + 3];
            vertices[dest + 4] = spriteVertices[offset + index + 4];
        }
        this.cache.add(texture, vertices, 0, vertices.length);
    }

    @Override
    protected void draw(TextureRegion region, float x, float y, float originX, float originY, float width, float height, float rotation) {
        this.cache.add(region, x, y, originX, originY, width, height, 1.0f, 1.0f, rotation);
    }

    @Override
    void setShader(Shader shader) {
        this.setShader(shader, true);
    }

    @Override
    void setShader(Shader shader, boolean apply) {
        boolean drawing = this.cache.isDrawing();
        if (drawing) {
            this.cache.end();
        }
        this.cache.setShader(shader);
        if (drawing) {
            this.cache.begin();
        }
        if (apply && shader != null) {
            shader.apply();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.cache.dispose();
    }

    public void beginDraw() {
        this.cache.begin();
    }

    public void endDraw() {
        this.cache.end();
    }

    public void drawCache(int id) {
        this.cache.draw(id);
    }
}

