/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.graphics.g2d;

import io.anuke.arc.graphics.glutils.Shader;
import io.anuke.arc.math.Matrix3;
import io.anuke.arc.util.Strings;

public class BatchShader {
    private static final float[] val = new float[16];
    private static final int M00 = 0;
    private static final int M01 = 4;
    private static final int M02 = 8;
    private static final int M03 = 12;
    private static final int M10 = 1;
    private static final int M11 = 5;
    private static final int M12 = 9;
    private static final int M13 = 13;
    private static final int M20 = 2;
    private static final int M21 = 6;
    private static final int M22 = 10;
    private static final int M23 = 14;
    private static final int M30 = 3;
    private static final int M31 = 7;
    private static final int M32 = 11;
    private static final int M33 = 15;
    private static final String vertexShader = Strings.join("\n", "attribute vec4 a_position;", "attribute vec4 a_color;", "attribute vec2 a_texCoord0;", "attribute vec4 a_mix_color;", "uniform mat4 u_projTrans;", "varying vec4 v_color;", "varying vec4 v_mix_color;", "varying vec2 v_texCoords;", "", "void main(){", "   v_color = a_color;", "   v_color.a = v_color.a * (255.0/254.0);", "   v_mix_color = a_mix_color;", "   v_mix_color.a *= (255.0/254.0);", "   v_texCoords = a_texCoord0;", "   gl_Position = u_projTrans * a_position;", "}");
    private static final String fragmentShader = Strings.join("\n", "#ifdef GL_ES", "#define LOWP lowp", "precision mediump float;", "#else", "#define LOWP ", "#endif", "", "varying LOWP vec4 v_color;", "varying LOWP vec4 v_mix_color;", "varying vec2 v_texCoords;", "uniform sampler2D u_texture;", "", "void main(){", "  vec4 c = texture2D(u_texture, v_texCoords);", "  gl_FragColor = v_color * mix(c, vec4(v_mix_color.rgb, c.a), v_mix_color.a);", "}");

    public static Shader create() {
        return new Shader(vertexShader, fragmentShader);
    }

    public static float[] copyTransform(Matrix3 matrix) {
        BatchShader.val[4] = matrix.val[3];
        BatchShader.val[1] = matrix.val[1];
        BatchShader.val[0] = matrix.val[0];
        BatchShader.val[5] = matrix.val[4];
        BatchShader.val[10] = matrix.val[8];
        BatchShader.val[12] = matrix.val[6];
        BatchShader.val[13] = matrix.val[7];
        BatchShader.val[15] = 1.0f;
        return val;
    }
}

