/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.graphics;

import io.anuke.arc.files.FileHandle;
import io.anuke.arc.graphics.Pixmap;
import io.anuke.arc.graphics.PixmapIO;
import io.anuke.arc.graphics.glutils.FileTextureData;

public interface TextureData {
    public TextureDataType getType();

    public boolean isPrepared();

    public void prepare();

    public Pixmap consumePixmap();

    public boolean disposePixmap();

    public void consumeCustomData(int var1);

    public int getWidth();

    public int getHeight();

    public Pixmap.Format getFormat();

    public boolean useMipMaps();

    public boolean isManaged();

    public static class Factory {
        public static TextureData loadFromFile(FileHandle file, boolean useMipMaps) {
            return Factory.loadFromFile(file, null, useMipMaps);
        }

        public static TextureData loadFromFile(FileHandle file, Pixmap.Format format, boolean useMipMaps) {
            if (file == null) {
                return null;
            }
            if (file.name().endsWith(".cim")) {
                return new FileTextureData(file, PixmapIO.readCIM(file), format, useMipMaps);
            }
            return new FileTextureData(file, new Pixmap(file), format, useMipMaps);
        }
    }

    public static enum TextureDataType {
        Pixmap,
        Custom;

    }
}

