/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.graphics;

import io.anuke.arc.math.Mathf;

public class Color {
    public static final Color white = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    public static final Color lightGray = new Color(-1077952513);
    public static final Color gray = new Color(0x7F7F7FFF);
    public static final Color darkGray = new Color(0x3F3F3FFF);
    public static final Color black = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    public static final Color clear = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    public static final float whiteFloatBits = white.toFloatBits();
    public static final float clearFloatBits = clear.toFloatBits();
    public static final Color blue = new Color(0.0f, 0.0f, 1.0f, 1.0f);
    public static final Color navy = new Color(0.0f, 0.0f, 0.5f, 1.0f);
    public static final Color royal = new Color(1097458175);
    public static final Color slate = new Color(1887473919);
    public static final Color sky = new Color(-2016482305);
    public static final Color cyan = new Color(0.0f, 1.0f, 1.0f, 1.0f);
    public static final Color teal = new Color(0.0f, 0.5f, 0.5f, 1.0f);
    public static final Color green = new Color(0xFF00FF);
    public static final Color acid = new Color(0x7FFF00FF);
    public static final Color lime = new Color(852308735);
    public static final Color forest = new Color(579543807);
    public static final Color olive = new Color(1804477439);
    public static final Color yellow = new Color(-65281);
    public static final Color gold = new Color(-2686721);
    public static final Color goldenrod = new Color(-626712321);
    public static final Color orange = new Color(-5963521);
    public static final Color brown = new Color(-1958407169);
    public static final Color tan = new Color(-759919361);
    public static final Color brick = new Color(-1306385665);
    public static final Color red = new Color(-16776961);
    public static final Color scarlet = new Color(-13361921);
    public static final Color coral = new Color(-8433409);
    public static final Color salmon = new Color(-92245249);
    public static final Color pink = new Color(-9849601);
    public static final Color magenta = new Color(1.0f, 0.0f, 1.0f, 1.0f);
    public static final Color purple = new Color(-1608453889);
    public static final Color violet = new Color(-293409025);
    public static final Color maroon = new Color(-1339006721);
    private static final float[] tmpHSV = new float[3];
    public float r;
    public float g;
    public float b;
    public float a;

    public Color() {
    }

    public Color(int rgba8888) {
        Color.rgba8888ToColor(this, rgba8888);
    }

    public Color(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.clamp();
    }

    public Color(float r, float g, float b) {
        this(r, g, b, 1.0f);
    }

    public Color(Color color) {
        this.set(color);
    }

    public static Color valueOf(String hex) {
        return Color.valueOf(new Color(), hex);
    }

    public static Color valueOf(Color color, String hex) {
        int offset = hex.charAt(0) == '#' ? 1 : 0;
        int r = Color.parseHex(hex, offset, offset + 2);
        int g = Color.parseHex(hex, offset + 2, offset + 4);
        int b = Color.parseHex(hex, offset + 4, offset + 6);
        int a = hex.length() - offset != 8 ? 255 : Color.parseHex(hex, offset + 6, offset + 8);
        return color.set((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
    }

    private static int parseHex(String string, int from, int to) {
        int total = 0;
        for (int i = from; i < to; ++i) {
            char c = string.charAt(i);
            total += Character.digit(c, 16) * (i == from ? 16 : 1);
        }
        return total;
    }

    public static float toFloatBits(int r, int g, int b, int a) {
        int color = a << 24 | b << 16 | g << 8 | r;
        return Color.intToFloatColor(color);
    }

    public static float toFloatBits(float r, float g, float b, float a) {
        int color = (int)(255.0f * a) << 24 | (int)(255.0f * b) << 16 | (int)(255.0f * g) << 8 | (int)(255.0f * r);
        return Color.intToFloatColor(color);
    }

    public static int toIntBits(int r, int g, int b, int a) {
        return a << 24 | b << 16 | g << 8 | r;
    }

    public static int alpha(float alpha) {
        return (int)(alpha * 255.0f);
    }

    public static int luminanceAlpha(float luminance, float alpha) {
        return (int)(luminance * 255.0f) << 8 | (int)(alpha * 255.0f);
    }

    public static int rgb565(float r, float g, float b) {
        return (int)(r * 31.0f) << 11 | (int)(g * 63.0f) << 5 | (int)(b * 31.0f);
    }

    public static int rgba4444(float r, float g, float b, float a) {
        return (int)(r * 15.0f) << 12 | (int)(g * 15.0f) << 8 | (int)(b * 15.0f) << 4 | (int)(a * 15.0f);
    }

    public static int rgb888(float r, float g, float b) {
        return (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
    }

    public static int rgba8888(float r, float g, float b, float a) {
        return (int)(r * 255.0f) << 24 | (int)(g * 255.0f) << 16 | (int)(b * 255.0f) << 8 | (int)(a * 255.0f);
    }

    public static int argb8888(float a, float r, float g, float b) {
        return (int)(a * 255.0f) << 24 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
    }

    public static int rgb565(Color color) {
        return (int)(color.r * 31.0f) << 11 | (int)(color.g * 63.0f) << 5 | (int)(color.b * 31.0f);
    }

    public static int rgba4444(Color color) {
        return (int)(color.r * 15.0f) << 12 | (int)(color.g * 15.0f) << 8 | (int)(color.b * 15.0f) << 4 | (int)(color.a * 15.0f);
    }

    public static int rgb888(Color color) {
        return (int)(color.r * 255.0f) << 16 | (int)(color.g * 255.0f) << 8 | (int)(color.b * 255.0f);
    }

    public static int rgba8888(Color color) {
        return (int)(color.r * 255.0f) << 24 | (int)(color.g * 255.0f) << 16 | (int)(color.b * 255.0f) << 8 | (int)(color.a * 255.0f);
    }

    public static int argb8888(Color color) {
        return (int)(color.a * 255.0f) << 24 | (int)(color.r * 255.0f) << 16 | (int)(color.g * 255.0f) << 8 | (int)(color.b * 255.0f);
    }

    public static void rgb565ToColor(Color color, int value) {
        color.r = (float)((value & 0xF800) >>> 11) / 31.0f;
        color.g = (float)((value & 0x7E0) >>> 5) / 63.0f;
        color.b = (float)(value & 0x1F) / 31.0f;
    }

    public static void rgba4444ToColor(Color color, int value) {
        color.r = (float)((value & 0xF000) >>> 12) / 15.0f;
        color.g = (float)((value & 0xF00) >>> 8) / 15.0f;
        color.b = (float)((value & 0xF0) >>> 4) / 15.0f;
        color.a = (float)(value & 0xF) / 15.0f;
    }

    public static void rgb888ToColor(Color color, int value) {
        color.r = (float)((value & 0xFF0000) >>> 16) / 255.0f;
        color.g = (float)((value & 0xFF00) >>> 8) / 255.0f;
        color.b = (float)(value & 0xFF) / 255.0f;
    }

    public static void rgba8888ToColor(Color color, int value) {
        color.r = (float)((value & 0xFF000000) >>> 24) / 255.0f;
        color.g = (float)((value & 0xFF0000) >>> 16) / 255.0f;
        color.b = (float)((value & 0xFF00) >>> 8) / 255.0f;
        color.a = (float)(value & 0xFF) / 255.0f;
    }

    public static void argb8888ToColor(Color color, int value) {
        color.a = (float)((value & 0xFF000000) >>> 24) / 255.0f;
        color.r = (float)((value & 0xFF0000) >>> 16) / 255.0f;
        color.g = (float)((value & 0xFF00) >>> 8) / 255.0f;
        color.b = (float)(value & 0xFF) / 255.0f;
    }

    public static void abgr8888ToColor(Color color, float value) {
        int c = Color.floatToIntColor(value);
        color.a = (float)((c & 0xFF000000) >>> 24) / 255.0f;
        color.b = (float)((c & 0xFF0000) >>> 16) / 255.0f;
        color.g = (float)((c & 0xFF00) >>> 8) / 255.0f;
        color.r = (float)(c & 0xFF) / 255.0f;
    }

    public static Color fromGray(float value) {
        return new Color(value, value, value);
    }

    public static Color fromRGB(int r, int g, int b) {
        return new Color((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public static int floatToIntColor(float value) {
        int intBits = Float.floatToRawIntBits(value);
        intBits |= (int)((float)(intBits >>> 24) * 1.003937f) << 24;
        return intBits;
    }

    public static float intToFloatColor(int value) {
        return Float.intBitsToFloat(value & 0xFEFFFFFF);
    }

    public Color rand() {
        return this.set(Mathf.random(), Mathf.random(), Mathf.random(), 1.0f);
    }

    public Color randHue() {
        this.fromHsv(Mathf.random(360.0f), 1.0f, 1.0f);
        this.a = 1.0f;
        return this;
    }

    public int rgba() {
        return Color.rgba8888(this);
    }

    public Color set(Color color) {
        this.r = color.r;
        this.g = color.g;
        this.b = color.b;
        this.a = color.a;
        return this;
    }

    public Color mul(Color color) {
        this.r *= color.r;
        this.g *= color.g;
        this.b *= color.b;
        this.a *= color.a;
        return this.clamp();
    }

    public Color mul(float value) {
        this.r *= value;
        this.g *= value;
        this.b *= value;
        return this.clamp();
    }

    public Color add(Color color) {
        this.r += color.r;
        this.g += color.g;
        this.b += color.b;
        return this.clamp();
    }

    public Color sub(Color color) {
        this.r -= color.r;
        this.g -= color.g;
        this.b -= color.b;
        return this.clamp();
    }

    public Color clamp() {
        if (this.r < 0.0f) {
            this.r = 0.0f;
        } else if (this.r > 1.0f) {
            this.r = 1.0f;
        }
        if (this.g < 0.0f) {
            this.g = 0.0f;
        } else if (this.g > 1.0f) {
            this.g = 1.0f;
        }
        if (this.b < 0.0f) {
            this.b = 0.0f;
        } else if (this.b > 1.0f) {
            this.b = 1.0f;
        }
        if (this.a < 0.0f) {
            this.a = 0.0f;
        } else if (this.a > 1.0f) {
            this.a = 1.0f;
        }
        return this;
    }

    public Color set(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        return this.clamp();
    }

    public Color set(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
        return this.clamp();
    }

    public Color set(int rgba) {
        Color.rgba8888ToColor(this, rgba);
        return this;
    }

    public float sum() {
        return this.r + this.g + this.b;
    }

    public Color add(float r, float g, float b, float a) {
        this.r += r;
        this.g += g;
        this.b += b;
        this.a += a;
        return this.clamp();
    }

    public Color add(float r, float g, float b) {
        this.r += r;
        this.g += g;
        this.b += b;
        return this.clamp();
    }

    public Color sub(float r, float g, float b, float a) {
        this.r -= r;
        this.g -= g;
        this.b -= b;
        this.a -= a;
        return this.clamp();
    }

    public Color sub(float r, float g, float b) {
        this.r -= r;
        this.g -= g;
        this.b -= b;
        return this.clamp();
    }

    public Color inv() {
        this.r = 1.0f - this.r;
        this.g = 1.0f - this.g;
        this.b = 1.0f - this.b;
        return this;
    }

    public Color mul(float r, float g, float b, float a) {
        this.r *= r;
        this.g *= g;
        this.b *= b;
        this.a *= a;
        return this.clamp();
    }

    public Color lerp(Color target, float t) {
        this.r += t * (target.r - this.r);
        this.g += t * (target.g - this.g);
        this.b += t * (target.b - this.b);
        this.a += t * (target.a - this.a);
        return this.clamp();
    }

    public Color lerp(float r, float g, float b, float a, float t) {
        this.r += t * (r - this.r);
        this.g += t * (g - this.g);
        this.b += t * (b - this.b);
        this.a += t * (a - this.a);
        return this.clamp();
    }

    public Color premultiplyAlpha() {
        this.r *= this.a;
        this.g *= this.a;
        this.b *= this.a;
        return this;
    }

    public Color shiftHue(float amount) {
        this.toHsv(tmpHSV);
        tmpHSV[0] = tmpHSV[0] + amount;
        this.fromHsv(tmpHSV);
        return this;
    }

    public Color shiftSaturation(float amount) {
        this.toHsv(tmpHSV);
        tmpHSV[0] = tmpHSV[0] + amount;
        this.fromHsv(tmpHSV);
        return this;
    }

    public Color shiftValue(float amount) {
        this.toHsv(tmpHSV);
        tmpHSV[0] = tmpHSV[0] + amount;
        this.fromHsv(tmpHSV);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Color color = (Color)o;
        return this.toIntBits() == color.toIntBits();
    }

    public int hashCode() {
        int result = this.r != 0.0f ? Float.floatToIntBits(this.r) : 0;
        result = 31 * result + (this.g != 0.0f ? Float.floatToIntBits(this.g) : 0);
        result = 31 * result + (this.b != 0.0f ? Float.floatToIntBits(this.b) : 0);
        result = 31 * result + (this.a != 0.0f ? Float.floatToIntBits(this.a) : 0);
        return result;
    }

    public float toFloatBits() {
        int color = (int)(255.0f * this.a) << 24 | (int)(255.0f * this.b) << 16 | (int)(255.0f * this.g) << 8 | (int)(255.0f * this.r);
        return Color.intToFloatColor(color);
    }

    public int toIntBits() {
        return (int)(255.0f * this.a) << 24 | (int)(255.0f * this.b) << 16 | (int)(255.0f * this.g) << 8 | (int)(255.0f * this.r);
    }

    public String toString() {
        StringBuilder value = new StringBuilder();
        this.toString(value);
        return value.toString();
    }

    public void toString(StringBuilder builder) {
        builder.append(Integer.toHexString((int)(255.0f * this.r) << 24 | (int)(255.0f * this.g) << 16 | (int)(255.0f * this.b) << 8 | (int)(255.0f * this.a)));
        while (builder.length() < 8) {
            builder.insert(0, "0");
        }
    }

    public Color fromHsv(float h, float s, float v) {
        float x = (h / 60.0f + 6.0f) % 6.0f;
        int i = (int)x;
        float f = x - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - s * f);
        float t = v * (1.0f - s * (1.0f - f));
        switch (i) {
            case 0: {
                this.r = v;
                this.g = t;
                this.b = p;
                break;
            }
            case 1: {
                this.r = q;
                this.g = v;
                this.b = p;
                break;
            }
            case 2: {
                this.r = p;
                this.g = v;
                this.b = t;
                break;
            }
            case 3: {
                this.r = p;
                this.g = q;
                this.b = v;
                break;
            }
            case 4: {
                this.r = t;
                this.g = p;
                this.b = v;
                break;
            }
            default: {
                this.r = v;
                this.g = p;
                this.b = q;
            }
        }
        return this.clamp();
    }

    public Color fromHsv(float[] hsv) {
        return this.fromHsv(hsv[0], hsv[1], hsv[2]);
    }

    public float[] toHsv(float[] hsv) {
        float min;
        float max = Math.max(Math.max(this.r, this.g), this.b);
        float range = max - (min = Math.min(Math.min(this.r, this.g), this.b));
        hsv[0] = range == 0.0f ? 0.0f : (max == this.r ? (60.0f * (this.g - this.b) / range + 360.0f) % 360.0f : (max == this.g ? 60.0f * (this.b - this.r) / range + 120.0f : 60.0f * (this.r - this.g) / range + 240.0f));
        hsv[1] = max > 0.0f ? 1.0f - min / max : 0.0f;
        hsv[2] = max;
        return hsv;
    }

    public static Color HSVtoRGB(float h, float s, float v, float alpha) {
        Color c = Color.HSVtoRGB(h, s, v);
        c.a = alpha;
        return c;
    }

    public static Color HSVtoRGB(float h, float s, float v) {
        Color c = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        Color.HSVtoRGB(h, s, v, c);
        return c;
    }

    public static Color HSVtoRGB(float h, float s, float v, Color targetColor) {
        int b;
        int g;
        int r;
        if (h == 360.0f) {
            h = 359.0f;
        }
        h = (float)Math.max(0.0, Math.min(360.0, (double)h));
        s = (float)Math.max(0.0, Math.min(100.0, (double)s));
        v = (float)Math.max(0.0, Math.min(100.0, (double)v));
        int i = Mathf.floor(h /= 60.0f);
        float f = h - (float)i;
        float p = (v /= 100.0f) * (1.0f - (s /= 100.0f));
        float q = v * (1.0f - s * f);
        float t = v * (1.0f - s * (1.0f - f));
        switch (i) {
            case 0: {
                r = Mathf.round(255.0f * v);
                g = Mathf.round(255.0f * t);
                b = Mathf.round(255.0f * p);
                break;
            }
            case 1: {
                r = Mathf.round(255.0f * q);
                g = Mathf.round(255.0f * v);
                b = Mathf.round(255.0f * p);
                break;
            }
            case 2: {
                r = Mathf.round(255.0f * p);
                g = Mathf.round(255.0f * v);
                b = Mathf.round(255.0f * t);
                break;
            }
            case 3: {
                r = Mathf.round(255.0f * p);
                g = Mathf.round(255.0f * q);
                b = Mathf.round(255.0f * v);
                break;
            }
            case 4: {
                r = Mathf.round(255.0f * t);
                g = Mathf.round(255.0f * p);
                b = Mathf.round(255.0f * v);
                break;
            }
            default: {
                r = Mathf.round(255.0f * v);
                g = Mathf.round(255.0f * p);
                b = Mathf.round(255.0f * q);
            }
        }
        targetColor.set((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, targetColor.a);
        return targetColor;
    }

    public static int[] RGBtoHSV(Color c) {
        return Color.RGBtoHSV(c.r, c.g, c.b);
    }

    public static int[] RGBtoHSV(float r, float g, float b) {
        float max;
        float min = Math.min(Math.min(r, g), b);
        float v = max = Math.max(Math.max(r, g), b);
        float delta = max - min;
        if (max == 0.0f) {
            float s = 0.0f;
            float h = 0.0f;
            return new int[]{Mathf.round(h), Mathf.round(s), Mathf.round(v)};
        }
        float s = delta / max;
        float h = delta == 0.0f ? 0.0f : (r == max ? (g - b) / delta : (g == max ? 2.0f + (b - r) / delta : 4.0f + (r - g) / delta));
        h *= 60.0f;
        if (h < 0.0f) {
            h += 360.0f;
        }
        return new int[]{Mathf.round(h), Mathf.round(s *= 100.0f), Mathf.round(v *= 100.0f)};
    }

    public Color cpy() {
        return new Color(this);
    }

    public Color lerp(Color[] colors, float s) {
        int l = colors.length;
        Color a = colors[(int)(s * (float)(l - 1))];
        Color b = colors[Mathf.clamp((int)(s * (float)(l - 1) + 1.0f), 0, l - 1)];
        float n = s * (float)(l - 1) - (float)((int)(s * (float)(l - 1)));
        float i = 1.0f - n;
        return this.set(a.r * i + b.r * n, a.g * i + b.g * n, a.b * i + b.b * n, 1.0f);
    }
}

