/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.graphics;

import io.anuke.arc.Core;
import io.anuke.arc.math.Matrix3;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.math.geom.Vector2;

public class Camera {
    private static final Vector2 tmpVector = new Vector2();
    public final Vector2 position = new Vector2();
    private final Matrix3 combined = new Matrix3();
    private final Matrix3 invProjectionView = new Matrix3();
    public float width;
    public float height;

    public void update() {
        this.combined.setOrtho(this.position.x - this.width / 2.0f, this.position.y - this.height / 2.0f, this.width, this.height);
        this.invProjectionView.set(this.combined).inv();
    }

    public void resize(float viewportWidth, float viewportHeight) {
        this.width = viewportWidth;
        this.height = viewportHeight;
        this.update();
    }

    public Matrix3 projection() {
        return this.combined;
    }

    public Vector2 unproject(Vector2 screenCoords, float viewportX, float viewportY, float viewportWidth, float viewportHeight) {
        float x = screenCoords.x;
        float y = screenCoords.y;
        screenCoords.x = 2.0f * (x -= viewportX) / viewportWidth - 1.0f;
        screenCoords.y = 2.0f * (y -= viewportY) / viewportHeight - 1.0f;
        screenCoords.mul(this.invProjectionView);
        return screenCoords;
    }

    public Vector2 unproject(Vector2 screenCoords) {
        this.unproject(screenCoords, 0.0f, 0.0f, Core.graphics.getWidth(), Core.graphics.getHeight());
        return screenCoords;
    }

    public Vector2 unproject(float screenX, float screenY) {
        this.unproject(tmpVector.set(screenX, screenY), 0.0f, 0.0f, Core.graphics.getWidth(), Core.graphics.getHeight());
        return tmpVector;
    }

    public Vector2 project(Vector2 worldCoords) {
        this.project(worldCoords, 0.0f, 0.0f, Core.graphics.getWidth(), Core.graphics.getHeight());
        return worldCoords;
    }

    public Vector2 project(float screenX, float screenY) {
        this.project(tmpVector.set(screenX, screenY), 0.0f, 0.0f, Core.graphics.getWidth(), Core.graphics.getHeight());
        return tmpVector;
    }

    public Vector2 project(Vector2 worldCoords, float viewportX, float viewportY, float viewportWidth, float viewportHeight) {
        worldCoords.mul(this.combined);
        worldCoords.x = viewportWidth * (worldCoords.x + 1.0f) / 2.0f + viewportX;
        worldCoords.y = viewportHeight * (worldCoords.y + 1.0f) / 2.0f + viewportY;
        return worldCoords;
    }

    public Rectangle bounds(Rectangle out) {
        return out.setSize(this.width, this.height).setCenter(this.position);
    }
}

