/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.files;

import io.anuke.arc.Files;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.ObjectSet;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.util.ArcAnnotate;
import io.anuke.arc.util.ArcRuntimeException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipFileHandle
extends FileHandle {
    private ZipFileHandle[] children = new ZipFileHandle[0];
    private ZipFileHandle parent;
    @ArcAnnotate.Nullable
    private final ZipEntry entry;
    private final ZipFile zip;

    public ZipFileHandle(FileHandle zipFileLoc) {
        super(new File(""), Files.FileType.Absolute);
        this.zip = null;
        this.entry = null;
        try {
            ZipFile zip = new ZipFile(zipFileLoc.file());
            Array<String> names = Array.with(Collections.list(zip.entries())).map(ZipEntry::getName);
            ObjectSet<String> paths = new ObjectSet<String>();
            for (String path : names) {
                paths.add(path);
                while (path.contains("/") && !path.equals("/") && path.substring(0, path.length() - 1).contains("/")) {
                    int index = path.endsWith("/") ? path.substring(0, path.length() - 1).lastIndexOf(47) : path.lastIndexOf(47);
                    path = path.substring(0, index);
                    paths.add(path.endsWith("/") ? path : path + "/");
                }
            }
            if (paths.contains("/")) {
                this.file = new File("/");
                paths.remove("/");
            }
            Array<ZipFileHandle> files = Array.with(paths).map((T s) -> zip.getEntry((String)s) != null ? new ZipFileHandle(zip.getEntry((String)s), zip) : new ZipFileHandle((String)s, zip));
            files.add(this);
            files.each(file -> {
                file.parent = files.find(other -> other.isDirectory() && other != file && file.path().startsWith(other.path()) && !file.path().substring(1 + other.path().length()).contains("/"));
            });
            files.each(file -> {
                file.children = (ZipFileHandle[])files.select(f -> f.parent == file).toArray(ZipFileHandle.class);
            });
            this.parent = null;
        }
        catch (IOException e) {
            throw new ArcRuntimeException(e);
        }
    }

    private ZipFileHandle(ZipEntry entry, ZipFile file) {
        super(new File(entry.getName()), Files.FileType.Absolute);
        this.entry = entry;
        this.zip = file;
    }

    private ZipFileHandle(String path, ZipFile file) {
        super(new File(path), Files.FileType.Absolute);
        this.entry = null;
        this.zip = file;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public FileHandle child(String name) {
        for (ZipFileHandle child : this.children) {
            if (!child.name().equals(name)) continue;
            return child;
        }
        return new FileHandle(new File(this.file, name)){

            @Override
            public boolean exists() {
                return false;
            }
        };
    }

    @Override
    public String name() {
        return this.file.getName();
    }

    @Override
    public FileHandle parent() {
        return this.parent;
    }

    @Override
    public FileHandle[] list() {
        return this.children;
    }

    @Override
    public boolean isDirectory() {
        return this.entry == null || this.entry.isDirectory();
    }

    @Override
    public InputStream read() {
        if (this.entry == null) {
            throw new RuntimeException("Not permitted.");
        }
        try {
            return this.zip.getInputStream(this.entry);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long length() {
        return this.isDirectory() ? 0L : this.entry.getSize();
    }
}

