/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.collection;

import io.anuke.arc.collection.Bits;

public class GridBits {
    private final Bits bits;
    private final int width;
    private final int height;

    public GridBits(int width, int height) {
        this.width = width;
        this.height = height;
        this.bits = new Bits(width * height);
    }

    public boolean get(int x, int y) {
        return this.bits.get(x + y * this.width);
    }

    public void set(int x, int y) {
        this.bits.set(x + y * this.width);
    }

    public void set(int x, int y, boolean b) {
        if (b) {
            this.bits.set(x + y * this.width);
        } else {
            this.bits.clear(x + y * this.width);
        }
    }

    public void clear() {
        this.bits.clear();
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }
}

